/*
 * Decompiled with CFR 0.152.
 */
package info.jinwoomin.nevernaver;

import info.jinwoomin.downloader.IDownloader;
import info.jinwoomin.downloader.SingleDownloader;
import info.jinwoomin.downloader.html.DefaultHtmlDownloader;
import info.jinwoomin.downloader.html.IHtmlDownloader;
import info.jinwoomin.downloader.html.IHtmlLineHandler;
import info.jinwoomin.log.AbstractLogabble;
import info.jinwoomin.nevernaver.NaverBlogPage;
import java.io.File;
import java.util.ResourceBundle;

public class NeverNaver
extends AbstractLogabble {
    private ResourceBundle bundle;
    private String outputFolder;
    private NaverBlogPage page;
    private int startPage;
    private int endPage;

    public String getOutputFolder() {
        return this.outputFolder;
    }

    public void setOutputFolder(String outputFolder) {
        this.outputFolder = outputFolder;
    }

    public void setEndPage(int endPage) {
        this.endPage = endPage;
    }

    public void setStartPage(int startPage) {
        this.startPage = startPage;
    }

    public void backup() {
        File file = new File(this.outputFolder);
        file.mkdir();
        this.page.setDownloader((IDownloader)new SingleDownloader());
        this.page.setHtmlDownloader((IHtmlDownloader)new DefaultHtmlDownloader((IHtmlLineHandler)this.page));
        this.logger.info("NeverNaver started.");
        for (int i = this.startPage; i <= this.endPage; ++i) {
            this.page.setOutputFolder(this.outputFolder + "/" + i);
            this.page.setPageIndex(i);
            this.page.backup();
        }
        this.logger.info("NeverNaver done.");
    }

    public void showUsage() {
        System.out.println("NeverNaver <userId> <category> <startPage> <endPage>");
    }

    public void run(String[] args) {
        if (args.length != 4) {
            this.showUsage();
            return;
        }
        this.bundle = ResourceBundle.getBundle("nevernaver");
        this.setOutputFolder(this.bundle.getString("output.folder"));
        this.page = new NaverBlogPage();
        this.page.setUserId(args[0]);
        this.page.setCategory(new Integer(args[1]));
        this.setStartPage(new Integer(args[2]));
        this.setEndPage(new Integer(args[3]));
        this.backup();
    }

    public static void main(String[] args) {
        NeverNaver app = new NeverNaver();
        app.run(args);
    }
}

