/*
 * Decompiled with CFR 0.152.
 */
package info.jinwoomin.nevernaver;

import info.jinwoomin.downloader.DownloaderUtils;
import info.jinwoomin.downloader.IDownloadable;
import info.jinwoomin.downloader.IDownloader;
import info.jinwoomin.downloader.html.IHtmlDownloadable;
import info.jinwoomin.downloader.html.IHtmlDownloader;
import info.jinwoomin.downloader.html.IHtmlLineHandler;
import info.jinwoomin.log.AbstractLogabble;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NaverBlogPage
extends AbstractLogabble
implements IDownloadable,
IHtmlDownloadable,
IHtmlLineHandler {
    private ResourceBundle bundle;
    private String outputFolder;
    private String postTime;
    private String title;
    private String categoryName;
    private String categoryId;
    private String pageId;
    private String userId;
    private int category;
    private int pageIndex;
    private IDownloader downloader;
    private IHtmlDownloader htmlDownloader;
    static final int STATE_BEFORE = 0;
    static final int STATE_CONTENT = 1;
    static final int STATE_AFTER = 2;
    private int state;
    private StringBuffer lineBuffer;

    public void setBundle(ResourceBundle bundle) {
        this.bundle = bundle;
    }

    public void setOutputFolder(String outputFolder) {
        this.outputFolder = outputFolder;
    }

    public void setCategory(int category) {
        this.category = category;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setPageIndex(int pageIndex) {
        this.pageIndex = pageIndex;
    }

    public void backup() {
        this.lineBuffer = new StringBuffer();
        try {
            URL url = new URL("http://blog.naver.com/post/postList.jsp?blogId=" + this.userId + "&categoryNo=" + this.category + "&cpage=" + this.pageIndex);
            this.htmlDownloader.setLogger(this.logger);
            this.htmlDownloader.setUrl(url);
            this.downloader.setLogger(this.logger);
            this.downloader.removeAllFiles();
            this.logger.info("page.url=[" + url + "]");
            this.state = 0;
            this.htmlDownloader.download();
            File file = new File(this.outputFolder + "/" + this.pageId);
            file.mkdir();
            this.downloader.download();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.logger.debug("linebuffer=[" + this.lineBuffer.toString() + "]");
        Properties props = new Properties();
        props.setProperty("categoryId", this.categoryId);
        props.setProperty("categoryName", this.categoryName);
        props.setProperty("pageId", this.pageId);
        props.setProperty("title", this.title);
        props.setProperty("postTime", this.postTime);
        try {
            props.storeToXML((OutputStream)new FileOutputStream(this.outputFolder + "/" + this.pageId + "/metainfo.xml"), "generated by NeverNaver", "UTF-8");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            String htmlFile = this.outputFolder + "/" + this.pageId + "/contents.html";
            this.logger.info("html.file=[" + htmlFile + "]");
            FileOutputStream fos = new FileOutputStream(htmlFile);
            PrintWriter pw = new PrintWriter(fos);
            pw.println(this.lineBuffer.toString());
            pw.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void setDownloader(IDownloader downloader) {
        this.downloader = downloader;
    }

    public void setHtmlDownloader(IHtmlDownloader htmlDownloader) {
        this.htmlDownloader = htmlDownloader;
    }

    private String match(String pattern, String src) {
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(src);
        if (m.find()) {
            this.logger.info("m.group(1)=" + m.group(1));
            return m.group(1);
        }
        return null;
    }

    public boolean handle(String line) {
        if (this.state == 0) {
            String matchResult = this.match(this.bundle.getString("pattern.categoryid"), line);
            if (matchResult != null) {
                this.categoryId = matchResult;
                this.logger.info("categoryId=" + this.categoryId);
            }
            if ((matchResult = this.match(this.bundle.getString("pattern.categoryname"), line)) != null) {
                this.categoryName = matchResult;
                this.logger.info("categoryName=" + this.categoryName);
            }
            if ((matchResult = this.match(this.bundle.getString("pattern.pageid"), line)) != null) {
                this.pageId = matchResult;
                this.logger.info("pageId=" + this.pageId);
            }
            if ((matchResult = this.match(this.bundle.getString("pattern.title"), line)) != null) {
                this.title = matchResult;
                this.logger.info("title=" + this.title);
            }
            if ((matchResult = this.match(this.bundle.getString("pattern.posttime"), line)) != null) {
                this.postTime = matchResult;
                this.logger.info("posttime=" + this.postTime);
            }
            if (line.indexOf(this.bundle.getString("start.line")) > -1) {
                this.state = 1;
            }
        } else if (this.state == 1) {
            if (line.indexOf(this.bundle.getString("end.line")) > -1) {
                this.state = 2;
            } else {
                int numOfPattern = new Integer(this.bundle.getString("pattern.num"));
                String resultLine = new String(line);
                for (int i = 1; i <= numOfPattern; ++i) {
                    Pattern p = Pattern.compile(this.bundle.getString("pattern." + i));
                    Matcher m = p.matcher(line);
                    while (m.find()) {
                        this.logger.debug("patter=[" + this.bundle.getString("pattern." + i) + "]");
                        this.logger.debug("found=[" + m.group(1) + "]");
                        try {
                            URL url = new URL(m.group(1));
                            this.downloader.addFile(url, this.outputFolder + "/" + this.pageId + "/" + DownloaderUtils.pickFilename((String)m.group(1)));
                        }
                        catch (MalformedURLException e) {
                            e.printStackTrace();
                        }
                        resultLine = resultLine.replace(m.group(1), DownloaderUtils.pickFilename((String)m.group(1)));
                    }
                }
                this.lineBuffer.append(resultLine + "\n");
            }
        }
        return false;
    }
}

