// SavDoc.h : interface of the CSavDoc class
//
// This is a part of the Microsoft Foundation Classes C++ library.
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
// This source code is only intended as a supplement to the
// Microsoft Foundation Classes Reference and related
// electronic documentation provided with the library.
// See these sources for detailed information regarding the
// Microsoft Foundation Classes product.

#include "drawobj.h"
#include "drawtool.h"
#include "summinfo.h"

class CSavView;
class CModel;

class CSavDoc : public COleDocument
{
protected: // create from serialization only
	CSavDoc();
	DECLARE_DYNCREATE(CSavDoc)

// Attributes
public:
	CDrawObjList* GetObjects() { return &m_objects; }
	const CSize& GetSize() const { return m_size; }
	void ComputePageSize();
	int GetMapMode() const { return m_nMapMode; }
	COLORREF GetPaperColor() const { return m_paperColor; }
	CSummInfo *m_pSummInfo;
	CModel* pModel;

// Operations
public:
	CDrawObj* ObjectAt(const CPoint& point);
	CDrawObj* ObjectAt(const CPoint& point, DrawShape nDrawShape);
	void Draw(CDC* pDC, CSavView* pView);
	void Add(CDrawObj* pObj);
	void Remove(CDrawObj* pObj);
	void UpdateModelinfo();

	//void ModifyArrowLine(CDrawObj* pObj, CRect& rect);
	
// Implementation
public:
	virtual ~CSavDoc();
	virtual void Serialize(CArchive& ar);   // overridden for document i/o
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:
	virtual BOOL OnNewDocument();
	virtual BOOL OnOpenDocument(LPCTSTR lpszPathName);
	virtual BOOL OnSaveDocument(LPCTSTR lpszPathName);

	CDrawObjList m_objects;
	CSize m_size;
	int m_nMapMode;
	COLORREF m_paperColor;

// Generated message map functions
protected:
	//{{AFX_MSG(CSavDoc)
	afx_msg void OnViewPaperColor();
	afx_msg void OnFileSummaryInfo();
	afx_msg void OnSetVariable();
	afx_msg void OnSetSpecification();
	afx_msg void OnVerify();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
