// drawobj.h - interface for CDrawObj and derivatives
//
// This is a part of the Microsoft Foundation Classes C++ library.
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
// This source code is only intended as a supplement to the
// Microsoft Foundation Classes Reference and related
// electronic documentation provided with the library.
// See these sources for detailed information regarding the
// Microsoft Foundation Classes product.


#ifndef __DRAWOBJ_H__
#define __DRAWOBJ_H__

class CSavView;
class CSavDoc;
class CState;

/////////////////////////////////////////////////////////////////////////////
// CDrawObj - base class for all 'drawable objects'

class CDrawObj : public CObject
{
protected:
	DECLARE_SERIAL(CDrawObj);
	CDrawObj();

// Constructors
public:
	CDrawObj(const CRect& position);

// Attributes
	CRect m_position;
	CSavDoc* m_pDocument;

	virtual CPoint getCenterPos() {
		return m_position.CenterPoint();
	}

	virtual int GetHandleCount();
	virtual CPoint GetHandle(int nHandle);
	CRect GetHandleRect(int nHandleID, CSavView* pView);
	virtual HCURSOR GetHandleCursor(int nHandle);
	virtual void SetLineColor(COLORREF color);
	virtual void SetFillColor(COLORREF color);

// Operations
	virtual void Draw(CDC* pDC);
	enum TrackerState { normal, selected, active };
	virtual void DrawTracker(CDC* pDC, TrackerState state);
	virtual void MoveTo(const CRect& positon, CSavView* pView = NULL);
	virtual int HitTest(CPoint point, CSavView* pView, BOOL bSelected);
	virtual BOOL Intersects(const CRect& rect);
	virtual void MoveHandleTo(int nHandle, CPoint point, CSavView* pView = NULL);
	virtual void OnOpen(CSavView* pView);
	virtual void OnEditProperties();
	virtual CDrawObj* Clone(CSavDoc* pDoc = NULL);
	virtual void Remove();
	void Invalidate();

// Implementation
public:
	virtual ~CDrawObj();
	virtual void Serialize(CArchive& ar);
#ifdef _DEBUG
	void AssertValid();
#endif

	// implementation data
protected:
	BOOL m_bPen;
	LOGPEN m_logpen;
	BOOL m_bBrush;
	LOGBRUSH m_logbrush;
};

// special 'list' class for this application (requires afxtempl.h)
typedef CTypedPtrList<CObList, CDrawObj*> CDrawObjList;

////////////////////////////////////////////////////////////////////////
// specialized draw objects

class CDrawRect : public CDrawObj
{
protected:
	DECLARE_SERIAL(CDrawRect);
	CDrawRect();

public:
	CDrawRect(const CRect& position);
	CDrawRect(const CRect& position, CDrawRect* line_from, CDrawRect* line_to);

	enum Shape { dummy1, text, ellipse, line };

	Shape getShape() { return m_nShape; }

// Implementation
public:
	virtual CPoint getCenterPos() {
		return CDrawObj::getCenterPos();
	}

	virtual void Serialize(CArchive& ar);
	virtual void Draw(CDC* pDC);
	virtual int GetHandleCount();
	virtual CPoint GetHandle(int nHandle);
	virtual HCURSOR GetHandleCursor(int nHandle);
	virtual void MoveHandleTo(int nHandle, CPoint point, CSavView* pView = NULL);
	virtual BOOL Intersects(const CRect& rect);
	virtual CDrawObj* Clone(CSavDoc* pDoc);

	//void drawModelInfo(CDC* pDC, CString& trace_model);
	void construct_node();
	CDrawRect* LineFrom() { return line_from; }
	CDrawRect* LineTo() { return line_to; }
	//
	//  ü Text  
	//
	CString _text;
	void setText(CString& _text) {
		this->_text = _text;
	}
	
	//
	//  ü Ellipse   ϳ node  Ÿ.
	//
	CState* Node();
	void SetNode(CState* node) { this->node = node; }
	void DrawLabel(CDC* pDC);
	
	//
	//  ü Line   ϳ transition  Ÿ.
	//
	CState* fromNode();
	CState* toNode();

	Shape m_nShape;

protected:
	//
	//  ü line  , line  ϴ ΰ 带 ؾѴ.
	//
	CDrawRect* line_from;
	CDrawRect* line_to;

	//
	//   带 Ų
	//
	CState* node;

	friend class CRectTool;
};

#endif // __DRAWOBJ_H__
