#include "stdafx.h"
#include ".\dag.h"

CState* const NO_EDGE = NULL;

CDag::CDag()
:r_nodes_count(0), b_nodes_count(0), 
 y_nodes_count(0), g_nodes_count(0), lsc(NULL)
{
	graph = new LGraph<CState*>(3,1);
}

CDag::~CDag()
{
	delete lsc;
	delete graph;
}

unsigned int CDag::create_node()
{
	return graph->NewVtx();
}

void CDag::remove_node(unsigned int id)
{
}

void CDag::create_edge(unsigned int from, unsigned int to)
{
	graph->SetEdge(from, NO_EDGE, to);
}

void CDag::remove_edge(unsigned int from, unsigned int to)
{
	graph->RmvEdge(from, to);
}

unsigned CDag::compute_scc()
{
	r_nodes_count=0;
	for (int i=0; i<100; i++)
		r_nodes[i] = 0;

	if (!lsc)
		lsc = new LStrongcon<CState*>(graph);
	lsc->RunAll();

	for (unsigned i=1; i<=graph->NumVertices(); i++) {
		bool findscc=false;
		unsigned group = lsc->Group(i);
		for (unsigned j=1; j<=graph->NumVertices(); j++) {
			if (i!=j && lsc->Group(j) == group) {
				findscc=true; break;
			}
		}
		//
		// ڱڽ  edge   ̰͵ SCC
		//
		if (!findscc && graph->EdgeWt(i,i)) {  
			findscc = true;
		}
		if (findscc) {
			for (int k=0; k<r_nodes_count; k++) {
				if (r_nodes[k] == i) continue;
			}
			r_nodes[r_nodes_count++] = i;
		}
	}

	return r_nodes_count;
}

//
// SCC nodes  ִ οִ  带 ã´ 
//
unsigned CDag::compute_rea_to_rgroup()
{
	for (unsigned i=0; i<r_nodes_count; i++) {
		compute_rea(r_nodes[i]);
	}

	return b_nodes_count;
}

//
// SCC nodes  ִ οִ  带 ã´ 
//
unsigned CDag::compute_rea_to_bgroup()
{
	for (unsigned i=0; i<b_nodes_count; i++) {
		compute_rea(b_nodes[i]);
	}

	return b_nodes_count;
}

//
// state_id   ִ ο ִ  带 ã´(SCC ׷ȿ ִ  )
//
unsigned CDag::compute_rea(unsigned state_id)
{
	for (unsigned i=1; i<=graph->NumVertices(); i++) {
		if (graph->EdgeWt(i, state_id) && !is_node_in_rgroup(i) && !is_node_in_bgroup(i)) {
			b_nodes[b_nodes_count++]=i;
			compute_rea(i);
		}
	}

	return b_nodes_count;
}

bool CDag::is_node_in_bgroup(unsigned state_id)
{
	for (unsigned i=0; i<this->b_nodes_count; i++) {
		if (state_id == b_nodes[i])
			return true;
	}

	return false;
}

bool CDag::is_node_in_rgroup(unsigned state_id)
{
	for (unsigned i=0; i<this->r_nodes_count; i++) {
		if (state_id == r_nodes[i])
			return true;
	}
	return false;
}

bool CDag::is_edge_exists(unsigned id1, unsigned id2)
{
	return graph->EdgeWt(id1, id2)?true:false;
}

void CDag::put_node_rgroup(unsigned state_id)
{
	for (int i=0; i<r_nodes_count; i++)
		if (r_nodes[i] == state_id) return;

	r_nodes[r_nodes_count++] = state_id;
}

void CDag::clear_all()
{
	for (int i=0; i<50; i++) {
		r_nodes[i]=0;
		b_nodes[i]=0;
		y_nodes[i]=0;
		g_nodes[i]=0;
	}
}
/*
void CDag::put_node_bgroup(unsigned state_id)
{
	for (int i=0; i<b_nodes_count; i++)
		if (b_nodes[i] == state_id) return;

	b_nodes[b_nodes_count++] = state_id;
}
*/

///////////////////////////////////////////////////////////////////
// lgraph.mth: A list-based graph class
// The template TYPE parameter in this file is meant mainly 
// as a numeric type of some kind. Also a vertex handle of
// 0 means "no vertex" or the "null vertex."
// Copyright(c) 1994 Azarona Software. All rights reserved.
///////////////////////////////////////////////////////////////////

template<class TYPE>
EdgeLink<TYPE>
::EdgeLink(unsigned av, const TYPE &x, EdgeLink<TYPE> *n)
// Constructs an edge link to the adjacent vertex with handle 
// av, and edge wt x. (The source vertex is implied.)
: EdgeParm<TYPE>(av, x), next(n)
{
}

template<class TYPE>
LGraph<TYPE>
::LGraph(unsigned nv_, int is_digraph_, const TYPE &no_edge_)
// Set up a list-based graph, with room to hold initially nv_ 
// vertices, with a default growth factor of dgf (eg: 4 means
// 4/8 or 50%). The is_digraph_ flag determines whether this 
// graph is directed or undirected. The no_edge_ value is
// what's passed back by the operator() if there is no edge.
: no_edge(no_edge_)
{
	is_digraph = is_digraph_;
	vertices = 0; nv_alloc = 0; // Be sure to do this so Realloc() works
	def_grow_factor = 4; // 4/8 = 50%
	Realloc(nv_);
}

template<class TYPE>
LGraph<TYPE>::LGraph(const LGraph<TYPE> &g)
// Copy constructor.
{
	vertices = 0; nv_alloc = 0; // Be sure to do this so Realloc() works
	Copy(g);
}

template<class TYPE>
LGraph<TYPE>::~LGraph()
// Deletes all vertices and edges in the graph
{
	Clear();
	delete[] vertices;
}

template<class TYPE>
void LGraph<TYPE>::operator=(const LGraph<TYPE> &g)
{
	if (this != &g) { // Trap copy to self
		Copy(g);
	}
}

template<class TYPE>
int LGraph<TYPE>::Realloc(unsigned n)
// Reallocates this graph to hold n vertices. The existing
// graph data, if any, is cleared first.
{
	Clear();
	delete[] vertices;

	// We'll emulate 1-based subscripting by allocating one more
	// than necessary, and then not using the 0th element

	vertices = new EdgeLink<TYPE> *[n+1];

	if (vertices) {
		nv_alloc = n;
		for (; n > 0; --n) vertices[n] = 0;
	}
	else nv_alloc = 0;
	nv = 0; ne = 0;
	return nv_alloc != 0;
}


template<class TYPE>
int LGraph<TYPE>::Copy(const LGraph<TYPE> &g)
// *** Internal routine ***.
// Clears this graph's data, resizes it to the size
// dictated by g, and then copies all of g's edges.
// Returns 1 upon success, else 0 if allocation failure.
{
	unsigned v, n = g.NumVertices();

	if (Realloc(n)) {
		is_digraph = 1; // So SetEdge() works right below
		nv = n; // Must do this before we start
		for (v = 1; v <= n; v++) {
			EdgeLink<TYPE> *el = g.AdjEdges(v);
			while(el) {
				// This is a somewhat expensive, but easy way...
				if (SetEdge(v, el->wt, el->adjvtx) == 0) return 0;
				el = el->next;
			}
		}
		no_edge = g.no_edge;
		is_digraph = g.is_digraph; // Now reflect our true nature
		def_grow_factor = g.def_grow_factor;
		return 1; // Success
	}
	return 0; // Couldn't do, man
}

template<class TYPE>
void LGraph<TYPE>::Clear()
// Clears all edges and vertices from the graph
{
	unsigned n = nv_alloc;
	for (; n > 0; --n) {
		RmvEdgeList(vertices[n]);
		vertices[n] = 0;
	}
	nv = 0; ne = 0;
}


template<class TYPE>
void LGraph<TYPE>::RmvEdgeList(EdgeLink<TYPE> *v)
// Deletes all edges in the list pointed to by v.
// (v is a dummy header.) Does nothing if v is 0.
{
	while(v) {
		EdgeLink<TYPE> *u = v->next;
		delete v;
		v = u;
		ne--;
	}
}

template<class TYPE>
int LGraph<TYPE>::Grow(unsigned ga)
// Grow the vertex table by adding ga entries. If ga == 0,
// then the default growth factor is used. If that's zero,
// then we can't grow. Return 1 if successful, else 0 if
// we can't grow or couldn't allocate memory.
{
	unsigned i;

	if (ga == 0) {
		if (def_grow_factor != 0) {
			long a = (long)nv_alloc * (long)def_grow_factor;
			ga = unsigned(a >> 3);      // (dgf*nva)/8
			if (ga == 0) ga = nv_alloc; // Used when nv_alloc small
		}
	}
	if (ga == 0) return 0; // Can't grow
	EdgeLink<TYPE> **new_tab = new EdgeLink<TYPE> *[nv_alloc + ga + 1];
	if (new_tab) {
		for (i = 1; i<=nv; i++) new_tab[i] = vertices[i];
		nv_alloc += ga;
		for (; i<=nv_alloc; i++) new_tab[i] = 0;
		delete[] vertices;
		vertices = new_tab;
		return 1;
	}
	return 0; // Couldn't grow
}

template<class TYPE>
unsigned LGraph<TYPE>::NewVtx()
// Reserves room for a new vertex in the graph, returning a 
// positive integer to use as a handle, with 0 being returned 
// if vertex couldn't be added to the graph. The vertex is
// initialized to not be connected to anybody.
{
	if (nv == nv_alloc) { // Graph is full, see if we can grow it
		if (Grow() == 0) return 0; // Nope, we're full for good
	}
	return ++nv; // NOTE: initialization handled at allocation time
}

template<class TYPE>
int LGraph<TYPE>::DetachVtx(unsigned v)
// Detaches all incoming and outgoing edges to the
// vertex with handle v. Returns 1 if successful, 
// else 0 if v is an invalid handle.
// NOTE: Does not destroy the vertex or otherwise
// free up it's handle.
{
#ifndef NO_RANGE_CHECK
	if (!ValidVtx(v)) return 0;
#endif
	// Walk through the edge list of each vertex,
	// and remove all edges involving v.
	for (unsigned i = 1; i<=nv; i++) {
		if (i == v) {
			RmvEdgeList(vertices[v]);
			vertices[v] = 0;
		}
		else RmvEdge(i, v);
	}
	return 1;
}

template<class TYPE>
int LGraph<TYPE>::SetDirEdge(unsigned a, const TYPE &x, unsigned b)
// *** For internal use only ***
// Creates a new directed edge going from vertex a to b, with
// edge wt x. If edge already exists, the wt
// is updated. Returns 1 if successful, or 0 if there
// an allocation error.
{
	EdgeLink<TYPE> *p = vertices[a];
	EdgeLink<TYPE> *q = 0;

	while(p) {
		if (p->adjvtx == b) {
			p->wt = x;
			return 1;
		}
		q = p;
		p = p->next;
	}

	// Edge not currently in the list, so add it
	p = new EdgeLink<TYPE>(b, x);
	if (p) {
		if (q == 0) vertices[a] = p; else q->next = p;
		ne++;
		return 1;
	}
	return 0;
}

template<class TYPE>
int LGraph<TYPE>::SetEdge(unsigned a, const TYPE &x, unsigned b)
// Creates a new edge going from vertex a to b, with
// edge wt x. If this is an undirected graph, then an edge
// from b to a is also added. If edge(s) already exist(s), the
// wt is updated. Returns 1 if successful, or 0 if a or b 
// is invalid or there is a allocation error.
{
#ifndef NO_RANGE_CHECK
	if (!ValidVtx(a) || !ValidVtx(b)) return 0;
#endif
	if (SetDirEdge(a, x, b) == 0) return 0; // Allocation error
	if (is_digraph) return 1;
	// We're undirected, so add edge going the other way
	return SetDirEdge(b, x, a);
}


template<class TYPE>
void LGraph<TYPE>::RmvDirEdge(unsigned a, unsigned b)
// *** For internal use only ***
// Deletes the edge from a to b, if it exists.
{
	EdgeLink<TYPE> *p = vertices[a];
	EdgeLink<TYPE> *q = 0;

	while(p) {
		if (p->adjvtx == b) {
			if (q == 0) {
				vertices[a] = p->next;
			}
			else q->next = p->next;
			delete p;
			ne--;
			return;
		}
		q = p;
		p = p->next;
	}

	return;
}

template<class TYPE>
void LGraph<TYPE>::RmvEdge(unsigned a, unsigned b)
// Deletes the edge from a to b, if it exists. If this
// is an undirected graph, then the edge from b to a
// is also deleted. Does nothing if the vertices are
// invalid, or no such edge(s) is/are found.
{
#ifndef NO_RANGE_CHECK
	if (!ValidVtx(a) || !ValidVtx(b)) return;
#endif
	RmvDirEdge(a, b);
	if (!is_digraph) RmvDirEdge(b, a);
}

template<class TYPE>
const TYPE *LGraph<TYPE>::EdgeWt(unsigned a, unsigned b) const
// Returns the wt of the edge between a and b.
// Returns 0 if none, or if either a or b is invalid.
// NOTE: There is a good reason for returning a constant 
// here. If this is an undirected graph, modifiying the edge
// wt this way would be bad news, for only one of the two
// copies of the wt would be updated. If you want to update
// the edge wt, use SetEdge().
{
	EdgeLink<TYPE> *p;

#ifndef NO_RANGE_CHECK
	if (!ValidVtx(a) || !ValidVtx(b)) return 0;
#endif

	p = vertices[a];
	while(p) {
		if (p->adjvtx == b) return &p->wt;
		p = p->next;
	}

	if (is_digraph) return 0; // Couldn't find

	// We're undirected, so look the other direction

	p = vertices[b];
	while(p) {
		if (p->adjvtx == a) return &p->wt;
		p = p->next;
	}

	return 0; // Really couldn't find
}

template<class TYPE>
const TYPE &LGraph<TYPE>::operator()(unsigned a, unsigned b) const
// This returns the edge wt between a and b, if they
// are connected. If they aren't connected, or either
// vertex is invalid, then no_edge is returned.
// NOTE: This routine is mostly for interface compatibility
// to make this graph data structure look like an adjacency 
// matrix. If you use the graph this way all the time, it
// would be horribly inefficient.
// NOTE: There is a good reason for returning a constant 
// here. If this is an undirected graph, modifiying the edge
// wt this way would be bad news, for only one of the two
// copies of the wt would be updated. Also, in the case of
// there being no edge, it wouldn't make sense to modifiy
// no_edge. If you want to update the edge, use SetEdge(). 
{
	const TYPE *p = EdgeWt(a, b);
	return (p) ? *p : no_edge;
}

template<class TYPE>
EdgeLink<TYPE> *LGraph<TYPE>::AdjEdges(unsigned v) const
// Returns a pointer to the edge list for vertex v,
// which may be 0. Also returns a 0 if v isn't a valid
// vertex.
{
#ifndef NO_RANGE_CHECK
	if (!ValidVtx(v)) return 0;
#endif
	return vertices[v];
}


template<class TYPE>
void LGraph<TYPE>::Valence(unsigned *in_deg, unsigned *out_deg) const
// If in_deg isn't 0, the in-degree of each vertex is computed.
// If out_deg isn't 0, the out-degree of each vertex is computed.
// This function exists because for adjacency-list graphs, it's
// just as easy to compute both of these attributes as it is one
// of them. (All edges must be walked.)
// ASSUMES in_deg and out_deg have room for nv items, (unless
// the pointers are 0), and are 1-based.
{
	unsigned v;

	if (in_deg)  for (v = 1; v <= nv; v++)  in_deg[v] = 0;
	if (out_deg) for (v = 1; v <= nv; v++) out_deg[v] = 0;
	for (v = 1; v <= nv; v++) {
		EdgeLink<TYPE> *el = AdjEdges(v);
		while(el) {
			if (in_deg) in_deg[el->adjvtx]++;
			if (out_deg) out_deg[v]++;
			el = el->next;
		}
	}
}



//////////////////////////////////////////////////////////////
// lstaq.mth: A very simple list-based stack + queue.
// Also makes a good singly-linked list class as well.
// Copyright(c) 1994 Azarona Software. All rights reserved.
/////////////////////////////////////////////////////////////

template<class TYPE>
LStaq<TYPE>::LStaq(const LStaq<TYPE> &s)
: head(0), tail(0)
{
	Copy(s);
}

template<class TYPE>
LStaq<TYPE>::~LStaq()
{
	Clear();
}

template<class TYPE>
void LStaq<TYPE>::Clear()
{
	LStaqNode<TYPE> *q;
	while(head) {
		q = head->next;
		delete head;
		head = q;
	}
	head = 0; tail = 0;
}

template<class TYPE>
int LStaq<TYPE>::Copy(const LStaq<TYPE> &s)
{
	Clear();
	LStaqNode<TYPE> *p = s.head;
	while(p) {
		LStaqNode<TYPE> *q = new LStaqNode<TYPE>(*p);
		if (q == 0) return 0;
		if (head == 0) head = q; else tail->next = q;
		tail = q;
		p = p->next;
	}
	return 1;
}

template<class TYPE>
int LStaq<TYPE>::AddFront(const TYPE &x)
{
	LStaqNode<TYPE> *p = new LStaqNode<TYPE>(x, head);
	if (p == 0) return 0;
	if (head == 0) tail = p;
	head = p;
	return 1;
}

template<class TYPE>
int LStaq<TYPE>::RmvFront(TYPE &x)
{
	if (head == 0) return 0;
	x = head->info;
	head = head->next;
	if (head == 0) tail = 0;
	return 1;
}

template<class TYPE>
int LStaq<TYPE>::RmvFront()
{
	if (head == 0) return 0;
	head = head->next;
	if (head == 0) tail = 0;
	return 1;
}

template<class TYPE>
int LStaq<TYPE>::AddBack(const TYPE &x)
{ 
	LStaqNode<TYPE> *p = new LStaqNode<TYPE>(x, 0);
	if (p == 0) return 0;
	if (head == 0) head = p; else tail->next = p;
	tail = p;
	return 1;
}

/////////////////////////////////////////////////////////////
// lstrngcn.mth: Algorithm to find the strongly connected 
// components of a list-based digraph.
// Copyright(c) 1994 Azarona Software. All rights reserved.
/////////////////////////////////////////////////////////////

template<class TYPE>
void LStrongcon<TYPE>::Dealloc()
{
	delete[] info;
}

template<class TYPE>
int LStrongcon<TYPE>::Realloc(unsigned n)
{
	Dealloc();
	info = new LStrongconInfo[n+1]; // We won't use info[0]
	return info != 0;
}

template<class TYPE>
LStrongcon<TYPE>::LStrongcon(LGraph<TYPE> *g_)
{
	g = g_; 
	info = 0;
	Realloc(g->NumVertices());
	Reset();
}

template<class TYPE>
LStrongcon<TYPE>::~LStrongcon()
{
	Dealloc();
}

template<class TYPE>
void LStrongcon<TYPE>::Reset()
{
	for (unsigned i = 1; i <= g->NumVertices(); i++) {
		info[i].num = 0; info[i].low = 0; info[i].group = 0;
	}
	tkt = 0;  grp_tkt = 0;
	stk.Clear();  
}

template<class TYPE>
void LStrongcon<TYPE>::Reset(LGraph<TYPE> *g_)
{
	g = g_;
	Realloc(g->NumVertices());
	Reset();
}

template<class TYPE>
void LStrongcon<TYPE>::RunAll()
// Does a full depth-first visit of graph g. Visits all vertices
// of all DFS spanning trees present in the graph. Starts with
// vertex 1.
{
	unsigned n = g->NumVertices();
	for (unsigned i = 1; i <= n; i++) {
		if (info[i].num == 0) Run(i);
	}
}

template<class TYPE>
unsigned LStrongcon<TYPE>::Run(unsigned u)
// Visits the vertices in the graph in depth-first order, starting
// with vertex u. Only examines those vertices that can be reached
// by u. Returns the lowest depth first number of any vertex
// reachable by u.
{
	unsigned w, x, m, min;

	info[u].num = ++tkt; // Record when we encountered the node
	min = tkt;   // Initial value of the low number
	stk.Push(u);

	EdgeLink<TYPE> *elink = g->AdjEdges(u);
	while(elink) {
		w = elink->adjvtx;
		if (info[w].num == 0) {
			m = Run(w);
		}
		else m = info[w].num;
		if (m < min) min = m;
		elink = elink->next;
	}

	if (min == info[u].num) {
		// We've got a complete group ready to process
		info[u].group = ++grp_tkt; // Give the group a number
		while(stk.Pop(x)) {
			info[x].group = grp_tkt;
			// Give the vertex a high number to prevent cross
			// links from being considered.
			info[x].num = g->NumVertices() + 1;
			if (x == u) break;
		}
	}

	return min;
}