#pragma once

#include "Spec.h"
#include <vector>

using namespace std;

class CState;
class CStateList;
class CLabel;
class CDag;
template<class TYPE> class LGraph;

class CLabel
{
public:
	CLabel(CString& name, bool istrue) {
		this->name = name;
		this->istrue = istrue;
	}
	~CLabel() {}

	CString& Name() { return name; }
	bool IsTrue() { return istrue; }

private:
	CString name;
	bool istrue;
};

class CState
{
public:
	enum Color { None, Yellow, Red, Blue, Green };

	CState(void);
	~CState();

	void addLabel(CLabel l);
	void delLabel(CLabel l);
	void modLabel(CLabel l1, CLabel l2);	
	bool hasLabel(CLabel l);
	void setid(unsigned int id) { this->id = id; }
	unsigned int getid() { return id; }
	void set_topo(Color c) { _topo = c; }
	Color get_topo() { return _topo; }

	vector<CLabel> labels;

private:
	unsigned int id;
	Color _topo;
};


class CTransition
{
public:
	CTransition(CState* from, CState* to) {
		this->from = from;
		this->to = to;
	}

	~CTransition() {}

	CState* From();
	CState* To();

private:
	CState* from;
	CState* to;
};


class CModel
{
public:
	CModel(void);
	virtual ~CModel(void);

	void createVar(CString name);
	void deleteVar(CString name);
	void modifyVar(CString from, CString to);
	bool isExistVar(CString name);
	void clearVar();

	CState* createState();
	void deleteState(CState* state);

	void createTransition(CState* s1, CState* s2);
	void deleteTransition(CState* s1, CState* s2);
	void deleteTransition(CState* s);

	//void findSCC(CStateList& list);
	bool is_transition_exist(CState* s1, CState* s2);

	void construct_dag();

	vector<CString>& getVariables();

	void trace();
	void trace(CString& str);

	CSpec& getSpecification();

	void find_satisfies_Spec(CString& f, vector<CState*>& states);

private:
	void add_variable_to_states(CString variable);
	void del_variable_from_states(CString variable);

	void find_satisfies_EX(CString& f, vector<CState*>& states);
	void find_satisfies_EU(CString& f, CString& g, vector<CState*>& states);
	void find_satisfies_EG(CString& f, vector<CState*>& states);
	unsigned int map_global_id(bool map[50][50], unsigned int local_id);
	unsigned int map_local_id(bool map[50][50], unsigned int global_id);

private:
	vector<CState*> states;
	vector<CTransition*> transitions;
	CDag* state_diagram;
	CSpec specification;
	vector<CString> variables;
};

class CModelBuilder
{
public:
	CModelBuilder();
	~CModelBuilder();

	static CModel* BuildModel();
};

