<?php

/**
 * 검색결과 API - 블로그 검색 클래스
 *
 * @category	OpenAPI
 * @package		Search
 * @author		Open Technology T/F
 * @copyright	Copyright (c) 2008 NHN Corporation. (http://www.nhncorp.com)
 * @version		0.1
 * @license		new BSD License
 */

class SearchBlog extends SearchAPI
{
	/**
	 * 정렬 옵션에 사용 가능한 항목
	 *
	 * @var array
	 */
	var $sort = array('sim', 'date');

	/**
	 * 생성자 - 부모 클래스의 생성자를 호출하고 target값을 'blog'로 설정
	 */
	function SearchBlog();
	{
		parent::SearchAPI();
		$this->params['target'] = 'blog';
	}

	/**
	 * 정렬 옵션을 설정
	 *
	 * @param $sort
	 */
	function setSort($sort)
	{
		if (in_array($sort, $this->sort) && is_string($sort))
			$this->params['sort'] = $sort;
	}

	/**
	 * 현재 설정된 정렬 옵션을 반환
	 *
	 * @return SearchBlog->sort|string
	 */
	function getSort()
	{
		return $this->params['sort'];
	}
}

?>
