<?php

/**
 * @category	OpenAPI
 * @package 	Common
 * @author		Open Technology Team
 * @copyright	Copyright (c) 2008 NHN Corporation. (http://www.nhncorp.com)
 * @license		new BSD License
 */

if (!defined('__API_INCLUDE_PATH__'))
	define('__API_INCLUDE_PATH__', (dirname(__FILE__) . '/'));

if (!version_compare('5', phpversion(), '<='))
	die('PHP5 이상에서만 사용 가능합니다.');
if (!extension_loaded('DOM'))
	die('DOM Extension이 설치되지 않았습니다.');

if (!@include_once('config.inc.php'))
	die('설정파일이 없습니다.');
if (!@include_once('common/rss_php/rss_php.php'))
	die('RSS-PHP를 로드하지 못했습니다.');

function getFeeds($url)
{
	$feed = new rss_php;
	$feed->load($url);

	return $feed->getValues();
}

function search($where, $query, $params = null)
{
	if (!is_string($where) || !$where)
		die('요청에 문제가 있습니다.');

	$req_file = 'search/' . $where . '.php';
	$req_class = 'Search' . $where;

	require_once('search.php');
	require_once($req_file);
		
	$api = new $req_class;
	$api->setParams($params);
	$url = $api->search($query);

	return getFeeds($url);
}

function searchextra($where, $query)
{
	if (!is_string($where) || !$where)
		die('요청에 문제가 있습니다.');
	
	$req_file = 'search-extra/' . $where . '.php';
	$req_class = 'SE_' . $where;

	require_once('search-extra.php');
	require_once($req_file);

	$api = new $req_class;
	$url = $api->search($query);

	return getFeeds($url);
}

function geocode($query)
{
}

?>
