#pragma once


// CAnimationControlDlg dialog

#include <string.h>
#include "afxcmn.h"

class CLittleMeshViewrDoc;

enum {
	STATE_PLAYONCE=0,
	STATE_LOOP_ONEANIMATION,
	STATE_ALLANIMATION,
	STATE_LOOP_ALLANIMATION,
	MAX_ANIMATIONLOOPSTATE,
};

class CAnimationControlDlg : public CDialog
{
	DECLARE_DYNAMIC(CAnimationControlDlg)
public:
	void	InitAnimationList(std::wstring* pAnimationNames, int nCount);
	void	ResetAnimationList();
	void	OnPlayingAnimationState(bool bState);
	void	SetAnimationTimeLength(float fTimeLength);
	void	SetCurrentAnimationTime(float fCurrentTime);
	bool	IsActive();
	char	GetLoopState();
	void	SetDialogControlsEnable(BOOL bEnable);

private:
	CLittleMeshViewrDoc*		m_pDocument;
	bool						m_bPlayStatePlayButton;
	char						m_cLoopState;
	std::wstring				m_strLoopStateString[MAX_ANIMATIONLOOPSTATE];
	float						m_fAnimationTimeSpeedValue;
	float						m_fPrevAnimationPlayTime;
	float						m_fAnimationTimeLength;
	int							m_nPrevTimeBarPosition;

public:
	CAnimationControlDlg(CWnd* pParent = NULL);   // standard constructor
	virtual ~CAnimationControlDlg();

// Dialog Data
	enum { IDD = IDD_ANIMATION_DIALOG };

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

	DECLARE_MESSAGE_MAP()
public:
	afx_msg void OnBnClickedQuickPlayanimationButton();
	afx_msg void OnBnClickedQuickStopanimationButton();
	afx_msg void OnCbnSelchangeQuickAnimationnameCombobox();
protected:
	virtual void OnCancel();
	virtual void OnOK();
public:
	afx_msg void OnLbnSelchangeAnimationnameList();
	afx_msg void OnBnClickedLoopingoptionButton();
//	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
//	afx_msg void OnShowWindow(BOOL bShow, UINT nStatus);
	virtual BOOL OnInitDialog();
	CSliderCtrl m_ctrlTimeBar;
	afx_msg void OnDeltaposAnimationspeedSpinbutton(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnNMCustomdrawAnimationtimeSlide(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnNMReleasedcaptureAnimationtimeSlide(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnBnClickedAddskeletonButton();
	afx_msg void OnBnClickedMotionblendingCheckbox();
};
