// LittleMeshViewr.h : main header file for the LittleMeshViewr application
//
#pragma once

#ifndef __AFXWIN_H__
	#error "include 'stdafx.h' before including this file for PCH"
#endif

#include "resource.h"       // main symbols

#include "Ogre.h"


#define OGRE_DEBUG_MEMORY_MANAGER 1

using namespace Ogre;


// CLittleMeshViewrApp:
// See LittleMeshViewr.cpp for the implementation of this class
//

class CLittleMeshViewrApp : public CWinApp
{
public:
	CLittleMeshViewrApp();


// Overrides
public:
	virtual BOOL InitInstance();

// Implementation
	afx_msg void OnAppAbout();
	DECLARE_MESSAGE_MAP()

private:
	DWORD	m_dwPrevFrameTime;

public:
	Ogre::Root*				m_pOgreRoot;
	Ogre::SceneManager*		m_pSceneManager;
	Ogre::Camera*			m_pCamera;
	Ogre::RenderWindow*		m_pRenderWindow;

	bool InitOgre();
	void SetupResources(String resourceFileName);
	Ogre::RenderSystem* SelectRenderSystem(Ogre::String searchString);
	void SetupRenderSystem(Ogre::RenderSystem *pRenderSystem);
	void SetupOgre(HWND hWnd, int nWidth, int nHeight);
	virtual int ExitInstance();
	virtual BOOL OnIdle(LONG lCount);
};

extern CLittleMeshViewrApp theApp;