// MainFrm.cpp : implementation of the CMainFrame class
//

#include "stdafx.h"
#include "LittleMeshViewr.h"

#include "MainFrm.h"
#include "LittleMeshViewrDoc.h"
#include "LittleMeshViewrView.h"
#include "ToolCameraManager.h"
#include "CameraGridSettingDlg.h"

#include <atlcore.h>

//#ifdef _DEBUG
//#define new DEBUG_NEW
//#endif


// CMainFrame

IMPLEMENT_DYNCREATE(CMainFrame, CFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CFrameWnd)
	ON_WM_CREATE()
	ON_COMMAND(ID_LOAD_MESH, &CMainFrame::OnLoadMesh)
	ON_COMMAND(ID_ADD_MESH, &CMainFrame::OnAddMesh)
	ON_COMMAND(ID_OPTION_GRIDSETTING, &CMainFrame::OnOptionGridsetting)
END_MESSAGE_MAP()

static UINT indicators[] =
{
	ID_SEPARATOR,           // status line indicator
	ID_INDICATOR_CAPS,
	ID_INDICATOR_NUM,
	ID_INDICATOR_SCRL,
};


// CMainFrame construction/destruction

CMainFrame::CMainFrame()
{
	// TODO: add member initialization code here
}

CMainFrame::~CMainFrame()
{
}


int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	if (!m_wndToolBar.CreateEx(this, TBSTYLE_FLAT, WS_CHILD | WS_VISIBLE | CBRS_TOP
		| CBRS_GRIPPER | CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC) ||
		!m_wndToolBar.LoadToolBar(IDR_MAINFRAME))
	{
		TRACE0("Failed to create toolbar\n");
		return -1;      // fail to create
	}

	if (!m_wndStatusBar.Create(this) ||
		!m_wndStatusBar.SetIndicators(indicators,
		  sizeof(indicators)/sizeof(UINT)))
	{
		TRACE0("Failed to create status bar\n");
		return -1;      // fail to create
	}

	// TODO: Delete these three lines if you don't want the toolbar to be dockable
	m_wndToolBar.EnableDocking(CBRS_ALIGN_ANY);
	EnableDocking(CBRS_ALIGN_ANY);
	DockControlBar(&m_wndToolBar);

	return 0;
}

BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	if( !CFrameWnd::PreCreateWindow(cs) )
		return FALSE;
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return TRUE;
}


// CMainFrame diagnostics

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CFrameWnd::Dump(dc);
}

#endif //_DEBUG


// CMainFrame message handlers




BOOL CMainFrame::OnCommand(WPARAM wParam, LPARAM lParam)
{
	// TODO: Add your specialized code here and/or call the base class

	return CFrameWnd::OnCommand(wParam, lParam);
}

void CMainFrame::OnLoadMesh()
{
	// TODO: Add your command handler code here

	// szFilters is a text string that includes two file name filters:
	// "*.my" for "MyType Files" and "*.*' for "All Files."
	//char szFilters[] = "Mesh Files (*.mesh)|*.mesh|All Files (*.*)|*.*||";
	wchar_t szFilters[128] = L"Mesh Files (*.mesh)|*.mesh|All Files (*.*)|*.*||";

	// Create an Open dialog; the default file name extension is ".my".
	CFileDialog fileDlg(TRUE, L"mesh", L"*.mesh", OFN_FILEMUSTEXIST|OFN_HIDEREADONLY|OFN_ENABLESIZING, szFilters, this);

	wchar_t szWorkingDir[256] = {0,};
	::GetCurrentDirectory(256,szWorkingDir);

	// Display the file dialog. When user clicks OK, fileDlg.DoModal() 
	// returns IDOK.
	CString fileName;
	if( fileDlg.DoModal() == IDOK )
	{
		fileName = fileDlg.GetFileName();

		::SetCurrentDirectory(szWorkingDir);

		// Implement opening and reading file in here.
		/*int len = 0;
		len = (fileName.GetLength()+1)*2;
		char* pstr      = (char*) new char[sizeof(char)*len];
		WideCharToMultiByte( 949, 0, fileName.GetBuffer(), -1, pstr, len, NULL, NULL);*/

		USES_CONVERSION;
		std::string strFileName = W2A(fileName.GetBuffer());
		CLittleMeshViewrDoc* pDocument = (CLittleMeshViewrDoc*)GetActiveDocument();
		pDocument->LoadMesh(strFileName.c_str());

		//delete [] pstr;

		//Change the window's title to the opened file's title.
		CString fileTitle = fileDlg.GetFileTitle();
		SetWindowText(fileTitle);
	}
	else
	{
		::SetCurrentDirectory(szWorkingDir);
	}
}

void CMainFrame::OnAddMesh()
{
	// TODO: Add your command handler code here

	CLittleMeshViewrDoc* pDocument = (CLittleMeshViewrDoc*)GetActiveDocument();
	if(false == pDocument->IsMainMeshLoaded())
	{
		MessageBox(L"Please load main mesh first.",L"AddMesh",MB_OK);
		return;
	}

	wchar_t szFilters[128] = L"Mesh Files (*.mesh)|*.mesh|All Files (*.*)|*.*||";
	CFileDialog fileDlg(TRUE, L"mesh", L"*.mesh", OFN_FILEMUSTEXIST|OFN_HIDEREADONLY|OFN_ENABLESIZING, szFilters, this);
	wchar_t szWorkingDir[256] = {0,};
	::GetCurrentDirectory(256,szWorkingDir);

	CString fileName;
	if( fileDlg.DoModal() == IDOK )
	{
		fileName = fileDlg.GetFileName();

		::SetCurrentDirectory(szWorkingDir);

		USES_CONVERSION;
		std::string strFileName = W2A(fileName.GetBuffer());
		pDocument->AddMesh(strFileName.c_str());
	}
	else
	{
		::SetCurrentDirectory(szWorkingDir);
	}
}

void CMainFrame::OnOptionGridsetting()
{
	// TODO: Add your command handler code here
	CCameraGridSettingDlg dlg;
	dlg.DoModal();
}
