#include "StdAfx.h"
#include "ToolAnimationManager.h"
#include "Ogre.h"
#include <atlcore.h>

using namespace Ogre;

CToolAnimationManager::CToolAnimationManager(void)
{
	m_pAnimationState = NULL;
	m_bPlaying = false;
	m_pMainEntity = NULL;
	m_bActive = false;
	m_fTimeSpeedFactor = 1.0f;
}

CToolAnimationManager::~CToolAnimationManager(void)
{
}

void CToolAnimationManager::SetMainEntity(const Ogre::Entity* pEntity)
{
	m_pMainEntity = pEntity;
}

// Create animation list from entity.
void CToolAnimationManager::CreateAnimationList()
{
	assert(m_pMainEntity && "Entity is NULL. Please check your code.");

	for(int i=0; i<MAX_ANIMATION_LIST; ++i)
	{
		m_strAnimationName[i].clear();
	}

	USES_CONVERSION;
	const char *pFirstAnimationName = NULL;
	unsigned short num_ani = m_pMainEntity->getSkeleton()->getNumAnimations();
	if(num_ani > 0)
	{
		m_bActive = true;
		for(unsigned short i=0; i<num_ani; ++i)
		{
			Ogre::Animation* pAnimation = m_pMainEntity->getSkeleton()->getAnimation(i);
			m_strAnimationName[i] = A2W(pAnimation->getName().c_str());
			if(0 == i)
			{
				pFirstAnimationName = pAnimation->getName().c_str();
			}
		}

		m_pAnimationState = m_pMainEntity->getAnimationState(pFirstAnimationName);
		m_pAnimationState->setLoop(false);
		m_pAnimationState->setEnabled(false);
	}
}

void CToolAnimationManager::GetAnimationNameList(std::wstring* pAnimationNames, int* pNameListCount)
{
	for(int i=0; i<MAX_ANIMATION_LIST; ++i)
	{
		if(m_strAnimationName[i].length() > 0)
		{
			pAnimationNames[i] = m_strAnimationName[i];
			*pNameListCount = i+1;
		}
	}
}

bool CToolAnimationManager::FrameProc(float fTimeSinceLastFrame)
{
	if(m_pAnimationState && m_bPlaying)
	{
		m_pAnimationState->addTime(fTimeSinceLastFrame*m_fTimeSpeedFactor);
		if(m_pAnimationState->getTimePosition() >= m_pAnimationState->getLength())
		{
			m_bPlaying = false;
			return true;
		}
	}

	return false;
}

void CToolAnimationManager::SetAnimationName(const char* szName)
{
	assert(m_pAnimationState && "Animation State is NULL.");

	m_pAnimationState->setEnabled(false);
	m_pAnimationState = m_pMainEntity->getAnimationState(szName);
	m_pAnimationState->setTimePosition(0.0);
	m_pAnimationState->setLoop(false);
}

void CToolAnimationManager::Play()
{
	if(m_pAnimationState->getTimePosition() >= m_pAnimationState->getLength())
	{
		m_pAnimationState->setEnabled(false);
		m_pAnimationState->setTimePosition(0.0);
	}

	m_pAnimationState->setEnabled(true);
	m_bPlaying = true;
}

void CToolAnimationManager::Pause()
{
	//m_pAnimationState->setEnabled(false);
	m_bPlaying = false;
}

void CToolAnimationManager::Stop()
{
	m_pAnimationState->setEnabled(false);
	m_pAnimationState->setTimePosition(0.0);
	m_bPlaying = false;
}

float CToolAnimationManager::GetAnimationTimeLength(const char* szAnimationName)
{
	Ogre::AnimationState* pState = m_pMainEntity->getAnimationState(szAnimationName);
	return (pState->getLength());
}

float CToolAnimationManager::GetCurrentPlayingAnimationTime()
{
	return (m_pAnimationState->getTimePosition());
}

bool CToolAnimationManager::IsActive()
{
	return m_bActive;
}

void CToolAnimationManager::Deactive()
{
	m_bActive = false;
}

void CToolAnimationManager::SetTimeSpeedFactor(float fFactor)
{
	m_fTimeSpeedFactor = fFactor;
}

void CToolAnimationManager::SetCurrentAnimationTimePosition(float fTimePosition)
{
	m_pAnimationState->setTimePosition(fTimePosition);
	if(false == m_pAnimationState->getEnabled())
	{
		m_pAnimationState->setEnabled(true);
	}
}

bool CToolAnimationManager::AddSkeletonFile(const char* szSkeletonFile)
{
	// See Ogre3D forum
	// http://www.ogre3d.org/phpBB2/viewtopic.php?p=217378&sid=ce193664e1d3d7c4af509e6f4e2718c6

	Ogre::SkeletonInstance* pSkelInst = m_pMainEntity->getSkeleton();
	assert(pSkelInst && "MainEntity's SkeletonInstance is NULL.");

	SkeletonPtr pSkeletonSearch = SkeletonManager::getSingleton().load(szSkeletonFile,
		ResourceGroupManager::DEFAULT_RESOURCE_GROUP_NAME );

	Skeleton::BoneHandleMap boneHandleMap;
	pSkeletonSearch->_buildMapBoneByHandle(pSkeletonSearch.getPointer(),boneHandleMap);
	pSkelInst->_mergeSkeletonAnimations(pSkeletonSearch.getPointer(),boneHandleMap);

	SkeletonManager::getSingleton().remove(szSkeletonFile);

	m_pMainEntity->getSkeleton()->_refreshAnimationState(
		m_pMainEntity->getAllAnimationStates());

	return true;
}
