#include "StdAfx.h"
#include "ToolCameraManager.h"
#include "LittleMeshViewr.h"
#include "Ogre.h"

using namespace Ogre;

CToolCameraManager::CToolCameraManager(void)
{
	m_fZoomOffset = 1.0f;
	m_fMoveOffsetPercent = 0.03f;
	m_fRotationOffsetPercent = 1.0f;
	m_fTotalOffsetValue = 1.0f;
	m_pCameraRootNode = NULL;
	m_pCameraObjectNode = NULL;
	InitCameraControlSystem();
}

CToolCameraManager::~CToolCameraManager(void)
{
}

void CToolCameraManager::InitCameraControlSystem()
{
	m_pCameraRootNode = theApp.m_pSceneManager->getRootSceneNode()->createChildSceneNode();

	m_pCameraObjectNode = m_pCameraRootNode->createChildSceneNode();
	m_pCameraObjectNode->attachObject(theApp.m_pCamera);
	m_pCameraObjectNode->setPosition(0,5,20);
}

void CToolCameraManager::ZoomCamera(bool bZoomInDirection)
{
	Ogre::Vector3 vecPos = m_pCameraObjectNode->getPosition();

	Ogre::Vector3 vecMove(0,0,0);
	if(bZoomInDirection)
	{
		vecMove.z = -(m_fZoomOffset * m_fTotalOffsetValue);
	}
	else
	{
		vecMove.z = (m_fZoomOffset * m_fTotalOffsetValue);
	}

	vecPos = vecPos + vecMove;
	m_pCameraObjectNode->setPosition(vecPos);
}

void CToolCameraManager::MoveCamera(float x, float y)
{
	x *= (m_fMoveOffsetPercent*m_fTotalOffsetValue);
	x *= -1;
	y *= (m_fMoveOffsetPercent*m_fTotalOffsetValue);

	Ogre::Vector3 vecPos = m_pCameraObjectNode->getPosition();

	Ogre::Vector3 vecMove(0,0,0);
	vecMove.x = x;
	vecMove.y = y;

	vecPos = vecPos + vecMove;
	m_pCameraObjectNode->setPosition(vecPos);
}

void CToolCameraManager::RotationCamera(int XRotation, int YRotation)
{
	float fRotationDelta = 0;

	if(XRotation != 0)
	{
		fRotationDelta = XRotation * (m_fRotationOffsetPercent);

		Ogre::Quaternion quatNode = m_pCameraRootNode->getOrientation();
		Ogre::Quaternion quatRotate(Ogre::Radian(Ogre::Degree(-fRotationDelta)),Ogre::Vector3(1,0,0));
		quatNode = quatNode * quatRotate;
		m_pCameraRootNode->setOrientation(quatNode);
	}

	if(YRotation != 0)
	{
		fRotationDelta = YRotation * (m_fRotationOffsetPercent);

		m_pCameraRootNode->rotate(Ogre::Vector3(0,1,0),
			Ogre::Radian(Ogre::Degree(-fRotationDelta)),
			Ogre::Node::TS_WORLD);
	}
}

void CToolCameraManager::ResetCameraPositionOrientation()
{
	m_pCameraRootNode->setPosition(0,0,0);
	m_pCameraRootNode->setOrientation(Ogre::Quaternion::IDENTITY);
	m_pCameraObjectNode->setPosition(0,5,20);
	m_pCameraObjectNode->setOrientation(Ogre::Quaternion::IDENTITY);
}

// default = 1.0f;
void CToolCameraManager::SetInputOffsetValue(float fFactor)
{
	m_fTotalOffsetValue = fFactor;
}

float CToolCameraManager::GetInputOffsetValue()
{
	return m_fTotalOffsetValue;
}
