#pragma once

// forward declaration
namespace Ogre
{
	class SceneNode;
};


class CToolCameraManager
{
public:
	CToolCameraManager(void);
	virtual ~CToolCameraManager(void);

	void	InitCameraControlSystem();
	// ZoomIn (bZoomInDirection == true)
	// ZoomOut (bZoomInDirection == false)
	void	ZoomCamera(bool bZoomInDirection);
	void	MoveCamera(float x, float y);
	void	RotationCamera(int XRotation, int YRotation);
	void	ResetCameraPositionOrientation();
	void	SetInputOffsetValue(float fFactor);
	float	GetInputOffsetValue();

private:
	float		m_fZoomOffset;
	float		m_fMoveOffsetPercent;
	float		m_fRotationOffsetPercent;
	float		m_fTotalOffsetValue;

	Ogre::SceneNode*	m_pCameraRootNode;
	Ogre::SceneNode*	m_pCameraObjectNode;
};
