/**
 * 
 * @author Hahm Myung Sun (hms1475@gmail.com)
 *
 * Copyright (c) 2011 JinoTech (http://www.jinotech.com) 
 * Licensed under the LGPL v3.0 license (http://www.gnu.org/licenses/lgpl.html).
 */
///////////////////////////////////////////////////////////////////////////////
/////////////////////////
///////////////////////////////////////////////////////////////////////////////
JinoControllerGuest = function (map){
	this.map = map;
	this.nodeEditor = null;
	document.onkeydown = function(evt){
		evt = evt || window.event;		
		if(jMap.work.hasFocus())
			return false;		
		return true;
	};
	this.map.mousemove(this.mouseMove);
	this.map.mousedown(this.mouseDown);
	this.map.mouseup(this.mouseUp);
	this.map.work.onkeydown = this.keyPress;
	this.map.work.ondragenter = function(e){
		e = e || window.event;
		if (e.preventDefault)
			e.preventDefault();
		else
			e.returnValue= false;
	};
	this.map.work.ondragover = function(e) {
		e = e || window.event;
		if (e.preventDefault)
			e.preventDefault();
		else
			e.returnValue= false;
	};
	this.map.work.ondrop = function(e){
		e = e || window.event;
		if (e.preventDefault)
			e.preventDefault();
		else
			e.returnValue= false;		
	};
}
JinoControllerGuest.prototype.type= "JinoControllerGuest";
JinoControllerGuest.prototype.keyPress = function(evt) {
	if ( STAT_NODEEDIT ) return true;
	evt = evt || window.event;
	var code = evt.keyCode;
	switch( code ) {
		case 37:	
			var selected = jMap.getSelecteds().getLastElement();
			if(selected.isRootNode()) {
				var children = selected.getChildren();
				for(var i=0; i < children.length; i++){
					if (children[i].position == "left") {
						children[i].focus(true);
						jMap.fireActionListener(ACTIONS.ACTION_NODE_SELECTED, children[i], "key_selected");
						break;
					}											
				}
			} else if(selected.isLeft()) {
				if(selected.folded) {
					selected.setFoldingExecute(false);
					jMap.layoutManager.updateTreeHeightsAndRelativeYOfDescendants(selected);				
					jMap.layoutManager.updateTreeHeightsAndRelativeYOfAncestors(selected);
					jMap.layoutManager.layout(true);
					return false;
				}
				var children = selected.getChildren();
				if(children.length > 0){
					children[0].focus(true);
					jMap.fireActionListener(ACTIONS.ACTION_NODE_SELECTED, children[0], "key_selected");
				}
			} else {
				selected.getParent().focus(true);
				jMap.fireActionListener(ACTIONS.ACTION_NODE_SELECTED, selected.getParent(), "key_selected");
			}
		break;
		case 38:	
			var selected = jMap.getSelecteds().getLastElement();
			if (selected.isRootNode()) {
			} else {				
				var children = selected.getParent().getChildren();
				if(selected.getIndexPos() > 0){
					children[selected.getIndexPos() - 1].focus(true);
					jMap.fireActionListener(ACTIONS.ACTION_NODE_SELECTED, children[selected.getIndexPos() - 1], "key_selected");
				}				
			}			
		break;
		case 39:	
			var selected = jMap.getSelecteds().getLastElement();
			if(selected.isRootNode()) {
				var children = selected.getChildren();
				for(var i=0; i < children.length; i++){
					if (children[i].position == "right") {
						children[i].focus(true);
						jMap.fireActionListener(ACTIONS.ACTION_NODE_SELECTED, children[i], "key_selected");
						break;
					}											
				}
			} else if(selected.isLeft()) {
				selected.getParent().focus(true);
				jMap.fireActionListener(ACTIONS.ACTION_NODE_SELECTED, selected.getParent(), "key_selected");
			} else {
				if(selected.folded) {
					selected.setFoldingExecute(false);
					jMap.layoutManager.updateTreeHeightsAndRelativeYOfDescendants(selected);				
					jMap.layoutManager.updateTreeHeightsAndRelativeYOfAncestors(selected);
					jMap.layoutManager.layout(true);
					return false;
				}
				var children = selected.getChildren();
				if(children.length > 0){
					children[0].focus(true);
					jMap.fireActionListener(ACTIONS.ACTION_NODE_SELECTED, children[0], "key_selected");
				}
			}			
		break;
		case 40:	
			var selected = jMap.getSelecteds().getLastElement();
			if (selected.isRootNode()) {
			} else {				
				var children = selected.getParent().getChildren();
				if(children.length > selected.getIndexPos() + 1){
					children[selected.getIndexPos() + 1].focus(true);
					jMap.fireActionListener(ACTIONS.ACTION_NODE_SELECTED, children[selected.getIndexPos() + 1], "key_selected");
				}
			}
		break;
		case 70:	
			if (evt.ctrlKey){				
				var txt = 'Find : '+
					      '<input type="text" id="jino_input_search_text"'+ 
					      'name="jino_input_search_text" value="" />'+
						  '<br /><br />'+
						  '<input type="checkbox" id="jino_check_search_ignorecase"'+
						  'name="jino_check_search_ignorecase" value="" checked>ignorecase'+
						  '<input type="checkbox" id="jino_check_search_wholeword"'+
						  'name="jino_check_search_wholeword" value="">wholeword';
				function callbackform_search(v,m,f){
					if (v) {
						var searchText = f.jino_input_search_text;
						var isIgnorecase = f.jino_check_search_ignorecase;
						var isWholeword = f.jino_check_search_wholeword;
						var nodes = jMap.findNode(searchText, isWholeword, isIgnorecase, jMap.getSelecteds().getLastElement());
						for(var i=0; i < nodes.length; i++){
							var node = nodes[i].node;
							var currentNode = node;
							while(!currentNode.isRootNode()){		
								currentNode = currentNode.getParent();								
								currentNode.folded && currentNode.setFoldingExecute(false);		
							}
							node.focus(false);
						}
						jMap.layoutManager.updateTreeHeightsAndRelativeYOfWholeMap();
						jMap.layoutManager.layout(true);
					}
					jMap.work.focus();
				}
				var re = $.prompt(txt,{
				      callback: callbackform_search,
					  persistent : false,
					  focusTarget : 'jino_input_search_text',
					  top : '30%',
				      buttons: { Find: true }
				});
			}
		break;
		case 71:	
			if ( evt.ctrlKey ) {
				if(AL_GOOGLE_SEARCHER == null) {
					SET_GOOGLE_SEARCHER(true);
				} else {
					SET_GOOGLE_SEARCHER(false);
				}
			} else if ( evt.shiftKey ) {				
			} else {				
			}
		break;
		case 32:	
			var selected = jMap.getSelecteds().getLastElement();
			selected.setFoldingExecute(!selected.folded);
			jMap.layoutManager.updateTreeHeightsAndRelativeYOfDescendants(selected);				
			jMap.layoutManager.updateTreeHeightsAndRelativeYOfAncestors(selected);
			jMap.layoutManager.layout(true);
		break;
	}
	return false;
}
JinoControllerGuest.prototype.mouseMove = function(e){
	var targ;
	if (!e) var e = window.event;
	if (e.target) targ = e.target;
	else if (e.srcElement) targ = e.srcElement;
	if (targ.nodeType == 3) 
		targ = targ.parentNode;
	if(targ.id == 'nodeEditor') return true;
	var dx = e.clientX - DRAG_POS.x;
	var dy = e.clientY - DRAG_POS.y;
	DRAG_POS.x = e.clientX;
	DRAG_POS.y = e.clientY;
	if(jMap.DragPaper){		
		this.work.scrollTop -= dy;		
		this.work.scrollLeft -= dx;		
	}
	return false;
}
JinoControllerGuest.prototype.mouseDown = function(e){
	var targ;
	if (!e) var e = window.event;
	if (e.target) targ = e.target;
	else if (e.srcElement) targ = e.srcElement;
	if (targ.nodeType == 3) 
		targ = targ.parentNode;
	if(targ.id == 'nodeEditor') return true;
	if(STAT_NODEEDIT) jMap.controller.stopNodeEdit(true);
	DRAG_POS.x = e.clientX;
	DRAG_POS.y = e.clientY;
	if (targ.id == 'paper_mapview') {
		jMap.DragPaper = true;
	}
	else if(targ.id == 'jinomap') {
		if( targ.offsetLeft <= e.clientX && e.clientX < targ.clientWidth + targ.offsetLeft
		  && targ.offsetTop <= e.clientY && e.clientY < targ.clientHeight + targ.offsetTop) {
			jMap.DragPaper = true;
		}
	}
}
JinoControllerGuest.prototype.mouseUp = function(e){
	e = e || window.event;	
	jMap.DragPaper = false;
	jMap.positionChangeNodes = false;
//	jMap.movingNode = false;
	//return false;
}
