/**
 * 
 * @author Hahm Myung Sun (hms1475@gmail.com)
 *
 * Copyright (c) 2011 JinoTech (http://www.jinotech.com) 
 * Licensed under the LGPL v3.0 license (http://www.gnu.org/licenses/lgpl.html).
 */
///////////////////////////////////////////////////////////////////////////////
/////////////////////////
///////////////////////////////////////////////////////////////////////////////
jNodeControlleriPhone = function(){
	jNodeControlleriPhone.superclass.call(this);
}
extend(jNodeControlleriPhone, jNodeController);
jNodeControlleriPhone.prototype.type = "jNodeControlleriPhone";
jNodeControlleriPhone.prototype.mousedown = function(e){
	(e.originalEvent || e).preventDefault();	
	var selectedNodes = jMap.getSelecteds();
	if (e.ctrlKey){
		if(selectedNodes.contains(this))
			this.blur();
		else this.focus(false);	
	} 
	else{
		if(!selectedNodes.contains(this)) {
			this.focus(true);
		}
	}
//	for (var i = 0, ii = e.targetTouches && e.targetTouches.length; i < ii; i++) {
//		console.log(i + " : " + e.targetTouches[i]);
//	}	
//	for(var a in (e.originalEvent || e).targetTouches[0])
//		console.log( a + " : " + (e.originalEvent || e).targetTouches[0][a])
//		
//	console.log("---------------------------------------------------------------------------------------------------")
//	
//	for(var a in (e.originalEvent || e))
//		console.log( a + " : " + (e.originalEvent || e).targetTouches[0][a])
//	if (this.isFoldingHit((e.originalEvent || e).targetTouches[0])) {
//		
//		this.setFolding(!this.folded);
//		jMap.layoutManager.updateTreeHeightsAndRelativeYOfDescendants(this);				
//		jMap.layoutManager.updateTreeHeightsAndRelativeYOfAncestors(this);
//		jMap.layoutManager.layout(true);
//	}
//	jMap.fireActionListener(ACTIONS.ACTION_NODE_SELECTED, this, e);
}
jNodeControlleriPhone.prototype.mouseup = function(e){
	(e.originalEvent || e).preventDefault();
	if (jMap.movingNode && !jMap.movingNode.removed) {
		var srcNodes = jMap.positionChangeNodes;
		var targNode = this;
		if (srcNodes && !srcNodes.contains(targNode)) {
			jMap.movingNode.connection && jMap.movingNode.connection.line.remove();
			jMap.movingNode.remove();
			for (var i = 0; i < srcNodes.length; i++) {
				if (srcNodes[i].hadChildren(targNode)) {
					removeGradient(targNode);
					//targNode.body.animate({"fill-opacity": 0}, 500);
					jMap.positionChangeNodes = false;
					return;
				}
			}
			var offsetX = (e.offsetX) ? e.offsetX : e.layerX - this.getLocation().x;
			var widthHalf = this.body.getBBox().width / 2;
			//var pos = (this.isLeft()) ? (offsetX > widthHalf) : (offsetX < widthHalf);
			var isleftPos = (offsetX < widthHalf);
			var toChild = function() {
				var moveData = new Array;
				for (var i = 0; i < srcNodes.length; i++) {
					moveData.push(copyNodes(srcNodes[i], true));
					srcNodes[i].remove();
				}
				for (var i = 0; i < moveData.length; i++) {
					var position = null;
					if (targNode.isRootNode()) 
						position = isleftPos ? "left" : "right";
					moveData[i].preposition = position;	
					targNode.folded && targNode.setFoldingExecute(!targNode.folded);
					pasteNodes(moveData[i], targNode, null, position);
				}
				var jsonMoveData = JSON.stringify(moveData);
				jMap.fireActionListener(ACTIONS.ACTION_NODE_PASTE, targNode, jsonMoveData);
			}
			var toSibling = function() {
				var moveData = new Array;
				for (var i = 0; i < srcNodes.length; i++) {
					moveData.push(copyNodes(srcNodes[i], true));
					srcNodes[i].remove();
				}
				var index = 0;
				for (var i = 0; i < moveData.length; i++) {
					var position = null;
					if (targNode.getParent().isRootNode()) 
						position = targNode.position;
					moveData[i].preposition = position;	
					index = targNode.getIndexPos();
					moveData[i].preindex = index;	
					pasteNodes(moveData[i], targNode.parent, index, position);
				}
				var jsonMoveData = JSON.stringify(moveData);
				jMap.fireActionListener(ACTIONS.ACTION_NODE_PASTE, targNode.parent, jsonMoveData, index);
			}
			if (srcNodes) {
				if (targNode.isRootNode()) {
					toChild();
				} else {
					switch(jMap.layoutManager.type) {
						case "jMindMapLayout" :
							if(this.isLeft()){
								isleftPos? toChild():toSibling();
							} else {
								isleftPos? toSibling():toChild();
							}	
							break;
						case "jTreeLayout" :
							isleftPos? toSibling():toChild();
							break;
						default :			
					}
				}
			}
			removeGradient(targNode);
			jMap.layoutManager.updateTreeHeightsAndRelativeYOfWholeMap();
			//		jMap.layoutManager.updateTreeHeightsAndRelativeYOfDescendants(targNode.isRootNode()? targNode : targNode.parent);
			jMap.layoutManager.layout(true);
			targNode.focus(true);
		}
		jMap.positionChangeNodes = false;
	}
}
jNodeControlleriPhone.prototype.mousemove = function(e){
	(e.originalEvent || e).preventDefault();
}
jNodeControlleriPhone.prototype.click = function(e){
	(e.originalEvent || e).preventDefault();
	if (this.isFoldingHit(e)) {
		this.setFolding(!this.folded);
		jMap.layoutManager.updateTreeHeightsAndRelativeYOfDescendants(this);				
		jMap.layoutManager.updateTreeHeightsAndRelativeYOfAncestors(this);
		jMap.layoutManager.layout(true);
	}
	jMap.fireActionListener(ACTIONS.ACTION_NODE_SELECTED, this, e);
}
