/**
 * 
 * @author Hahm Myung Sun (hms1475@gmail.com)
 *
 * Copyright (c) 2011 JinoTech (http://www.jinotech.com) 
 * Licensed under the LGPL v3.0 license (http://www.gnu.org/licenses/lgpl.html).
 */
var preventDefault = function () {
    this.returnValue = false;
},
preventTouch = function () {
    return this.originalEvent.preventDefault();
},
stopPropagation = function () {
    this.cancelBubble = true;
},
stopTouch = function () {
    return this.originalEvent.stopPropagation();
},
addEvent = (function () {
    if (document.addEventListener) {
        return function (obj, type, fn, element) {
            var realName = supportsTouch && touchMap[type] ? touchMap[type] : type;
            var f = function (e) {
                if (supportsTouch && touchMap.hasOwnProperty(type)) {
                    for (var i = 0, ii = e.targetTouches && e.targetTouches.length; i < ii; i++) {
                        if (e.targetTouches[i].target == obj) {
                            var olde = e;
                            e = e.targetTouches[i];
                            e.originalEvent = olde;
                            e.preventDefault = preventTouch;
                            e.stopPropagation = stopTouch;
                            break;
                        }
                    }
                }
                return fn.call(element, e);
            };
            obj.addEventListener(realName, f, false);
            return function () {
                obj.removeEventListener(realName, f, false);
                return true;
            };
        };
    } else if (document.attachEvent) {
        return function (obj, type, fn, element) {
            var f = function (e) {
                e = e || win.event;
                e.preventDefault = e.preventDefault || preventDefault;
                e.stopPropagation = e.stopPropagation || stopPropagation;
                return fn.call(element, e);
            };
            obj.attachEvent("on" + type, f);
            var detacher = function () {
                obj.detachEvent("on" + type, f);
                return true;
            };
            return detacher;
        };
    }
})();
////////////////////////
/**
 * 
 * @param {jNode} node
 * @param {bool} copyid : 아이디도 같이 복사
 */
function copyNodes(node, copyid){
	var data = {};
	var bodyAttr = node.body.attr();
	delete bodyAttr.scale;
	delete bodyAttr.translation;
	delete bodyAttr["fill-opacity"];	
	delete bodyAttr.gradient;
	bodyAttr.fill = node.background_color
	bodyAttr.stroke = node.edge.color;
	bodyAttr["stroke-width"] = node.stroke_width;
	data.body = bodyAttr;
	var textAttr = node.text.attr();
	delete textAttr.scale;
	delete textAttr.translation;
	data.text = textAttr;
	var folderAttr = node.folderShape.attr();
	delete folderAttr.scale;
	delete folderAttr.translation;
	delete folderAttr["fill-opacity"];
	data.folderShape = folderAttr;
	data.hyperlink = node.hyperlink && node.hyperlink.attr().href;
	data.img = node.img && node.img.attr().src;
	data.note = node.note;
	data.background_color = node.background_color;
	data.color = node.color;
	data.folded = node.folded;
	//data.id = node.id;				
	data.plainText = node.plainText;
	data.link = node.link;
	//data.position = node.position;	
	data.style = node.style;
	data.created = node.created;
	data.modified = node.modified;
	//data.hgap = node.hgap;
	//data.vgap = node.vgap;
	//data.vshift = node.vshift;
	//data.SHIFT = node.SHIFT;
	//data.relYPos = node.relYPos;
	//data.treeWidth = node.treeWidth;
	//data.treeHeight = node.treeHeight;
	//data.leftTreeWidth = node.leftTreeWidth;
	//data.rightTreeWidth = node.rightTreeWidth;
	//data.upperChildShift = node.upperChildShift;
	data.edge = node.edge;
	data.stroke_width = node.stroke_width;
	data.fontSize = node.fontSize;
	if(node.foreignObjEl){		
		data.foreignObject_plainHtml = node.foreignObjEl.plainHtml;
		data.foreignObject_width = node.foreignObjEl.getAttribute("width");
		data.foreignObject_height = node.foreignObjEl.getAttribute("height");
	}
	if(copyid) data.id = node.id;
	data.child = new Array;
	if(node.getChildren().length > 0) {
		var children = node.getChildren();
		for(var i = 0; i < children.length; i++) {
			data.child.push(copyNodes(children[i], copyid));
		}
	}
	return data;
}
function pasteNodes(data, /*jNode*/parentNode, index, position){
	if(data.body.removed) return;
	var id;
	if(!parentNode) parentNode = jMap.getSelecteds().getLastElement();	
	if(data.id) id = data.id;
	var newNode = jMap.createNodeWithCtrlExecute(parentNode, "", id, index, position);
	parentNode.folded && parentNode.setFoldingExecute(parentNode.folded);
	newNode.body.attr(data.body);
	newNode.text.attr(data.text);
	newNode.folderShape.attr(data.folderShape);	
	data.hyperlink && newNode.setHyperlinkExecute(data.hyperlink);
	data.img && newNode.setImageExecute(data.img);
	newNode.note = data.note;
	newNode.background_color = data.background_color;
	newNode.color = data.color;
	newNode.folded = data.folded;
	//newNode.id = data.id;				
	newNode.plainText = data.plainText;
	newNode.link = data.link;
	//newNode.position = data.position;	
	newNode.style = data.style;
	newNode.created = data.created;
	newNode.modified = data.modified;
	//newNode.hgap = data.hgap;
	//newNode.vgap = data.vgap;
	//newNode.vshift = data.vshift;
	//newNode.SHIFT = data.SHIFT;
	//newNode.relYPos = data.relYPos;
	//newNode.treeWidth = data.treeWidth;
	//newNode.treeHeight = data.treeHeight;
	//newNode.leftTreeWidth = data.leftTreeWidth;
	//newNode.rightTreeWidth = data.rightTreeWidth;
	//newNode.upperChildShift = data.upperChildShift;
	newNode.edge = data.edge;
	newNode.stroke_width = data.stroke_width;
	newNode.fontSize = data.fontSize;
	if(data.foreignObject_plainHtml){		
		newNode.setForeignObjectExecute(data.foreignObject_plainHtml, 
				data.foreignObject_width, data.foreignObject_height);
	}
	if(data.child.length > 0){
		for(var i=0; i < data.child.length; i++){
			pasteNodes(data.child[i], newNode);
		}
	}
	jMap.setSaved(false);
	return newNode;
}
function F_CheckKey(evt, codes) {
	evt = (evt) ? evt:window.event;
	code = (evt.keyCode)? evt.keyCode:evt.charCode;
	for ( var i=0; i<codes.length; i++ ) {
		if ( codes[i] == code ) {
			return true;
		}
	}
	return false;
}
///////////////////////////////////////////////////////////////////////////////
/////////////////////////
///////////////////////////////////////////////////////////////////////////////
JinoController = function (map){
	this.map = map;
	this.nodeEditor = null;
	document.onkeydown = function(evt){
		evt = evt || window.event;		
		if(jMap.work.hasFocus())
			return false;		
		return true;
	};
	this.setNodeEditor(map.nodeEditorHandle[0]);
	this.map.mousemove(this.mousemove);
	this.map.mousedown(this.mousedown);
	this.map.mouseup(this.mouseup);
	this.map.work.onkeydown = this.keyDown;
	this.map.work.ondragenter = function(e){
		e = e || window.event;
		if (e.preventDefault)
			e.preventDefault();
		else
			e.returnValue= false;
	};
	this.map.work.ondragover = function(e) {
		e = e || window.event;
		if (e.preventDefault)
			e.preventDefault();
		else
			e.returnValue= false;
	};
	this.map.work.ondrop = function(e){
		e = e || window.event;
		if (e.preventDefault)
			e.preventDefault();
		else
			e.returnValue= false;		
	};
	//this.map.setSessionTimeout();
}
JinoController.prototype.type= "JinoController";
JinoController.prototype.keyDown = function(evt) {
	if ( STAT_NODEEDIT ) return true;
	evt = evt || window.event;
	var ctrl = null; 
    if (evt) ctrl = evt.ctrlKey; 
    else if (evt && document.getElementById) ctrl=(Event.META_MASK || Event.CTRL_MASK)
    else if (evt && document.layers) ctrl=(evt.metaKey || evt.ctrlKey);
    var alt = evt.altKey
	var code = evt.keyCode;
	switch( code ) {
		case 35:	
			if (alt) {
				jMap.controller.unfoldingAllAction();
			}
		break;
		case 36:	
			if (alt) {
				jMap.controller.foldingAllAction();
			}
		break;
		case 37:	
			if (ctrl){
				ScaleAnimate.prevShow(30);
				return false;
			}
			var selected = jMap.getSelecteds().getLastElement();
			switch(jMap.layoutManager.type) {
				case "jMindMapLayout" :
					if(selected.isRootNode()) {
						var children = selected.getChildren();
						for(var i=0; i < children.length; i++){
							if (children[i].position == "left") {
								children[i].focus(true);
								jMap.fireActionListener(ACTIONS.ACTION_NODE_SELECTED, children[i], "key_selected");
								break;
							}											
						}
					} else if(selected.isLeft()) {
						jMap.controller.childNodeFocusAction(selected);
					} else {
						jMap.controller.parentNodeFocusAction(selected);
					}
					break;
				case "jTreeLayout" :
					jMap.controller.prevSiblingNodeFocusAction(selected);					
					break;
				default :
			}
		break;
		case 38:	
			if (ctrl){
				ScaleAnimate.tempRotate(jMap.getSelecteds().getLastElement());
				return false;
			}
			var selected = jMap.getSelecteds().getLastElement();
			switch(jMap.layoutManager.type) {
				case "jMindMapLayout" :
					if (selected.isRootNode()) {
					} else {
						jMap.controller.prevSiblingNodeFocusAction(selected);
					}
					break;
				case "jTreeLayout" :
					jMap.controller.parentNodeFocusAction(selected);
					break;
				default :
			}
		break;
		case 39:	
			if (ctrl){
				ScaleAnimate.nextShow(30);
				return false;
			}
			var selected = jMap.getSelecteds().getLastElement();
			switch(jMap.layoutManager.type) {
				case "jMindMapLayout" :
					if(selected.isRootNode()) {
						var children = selected.getChildren();
						for(var i=0; i < children.length; i++){
							if (children[i].position == "right") {
								children[i].focus(true);
								jMap.fireActionListener(ACTIONS.ACTION_NODE_SELECTED, children[i], "key_selected");
								break;
							}											
						}
					} else if(selected.isLeft()) {
						jMap.controller.parentNodeFocusAction(selected);				
					} else {
						jMap.controller.childNodeFocusAction(selected);
					}
					break;
				case "jTreeLayout" :
					jMap.controller.nextSiblingNodefocusAction(selected);
					break;
				default :
			}
		break;
		case 40:	
			var selected = jMap.getSelecteds().getLastElement();
			switch(jMap.layoutManager.type) {
				case "jMindMapLayout" :
					if (selected.isRootNode()) {
					} else {
						jMap.controller.nextSiblingNodefocusAction(selected);
					}
					break;
				case "jTreeLayout" :
					jMap.controller.childNodeFocusAction(selected);
					break;
				default :
			}
		break;
		case 49:	
			if (ctrl){
				NodeColorMix(jMap.rootNode);
			}
		break;
		case 50:	
			if (ctrl){
//				SlideshareService.show();
			}
		break;
		case 51:	
			if (ctrl){
//				SlideshareService.searchTag("mobile", 3);
			}
		break;
		case 52:	
			if (ctrl){
//				SlideshareService.next(5);
			}
		break;
		case 53:	
			if (ctrl){
//				SlideshareService.prev(2);
			}
		break;
		case 54:	
			if (ctrl){
			}
		break;
		case 55:	
			if (ctrl){
			}
		break;
		case 65:	
			if (ctrl){
			}
		break;
		case 67:	
			if (ctrl) {
				jMap.controller.copyAction();
			}
		break;		
		case 70:	
			if (ctrl){				
				jMap.controller.findNodeAction();
			}
		break;
		case 71:	
			if ( ctrl ) {
				if(AL_GOOGLE_SEARCHER == null) {
					SET_GOOGLE_SEARCHER(true);
				} else {
					SET_GOOGLE_SEARCHER(false);
				}
			} else if ( evt.shiftKey ) {				
			} else {				
			}
		break;
		case 75:	
			if (ctrl) {
				jMap.controller.insertHyperAction();
			}
			if (alt) {
				jMap.controller.insertImageAction();
			}			
		break;
		case 77:	
		break;
		case 78:	
			if (ctrl) {
				location.href="/mindmap/new.do";
			}
		break;
		case 80:	
			if (ctrl) {
				if(ScaleAnimate.isShowMode())
					ScaleAnimate.endShowMode();
				else
					ScaleAnimate.startShowMode(30, 20);
			}
		break;
		case 81:	
			if (ctrl) {
				window.open("/viewqueue.do?page="+location.pathname);
			}
		break;
		case 83:	
			if ( ctrl ) {
				if(!jMap.isSaved()) {
					saveMap();
				}
			} else if ( evt.shiftKey ) {				
			} else {				
			}
		break;
		case 88:	
			if (ctrl) {
				jMap.controller.cutAction();
			}		
		break;
		case 86:	
			if (ctrl) {
				jMap.controller.pasteAction();
			}				
		break;
		case 89:	
			if (ctrl){
				jMap.historyManager.redo();
			}
		break;
		case 90:	
			if (ctrl){
				jMap.historyManager.undo();
			}
		break;
		case 113:	
			jMap.controller.editNodeAction();
		break;		
		case 13:	
			jMap.controller.insertSiblingAction();
		break;
		case 27:	
			if ( ctrl ) {				
			} else if ( evt.shiftKey ) {				
			} else {				
			}
		break;
		case 32:	
			jMap.controller.foldingAction();
		break;
		case 8:		
		case 46:	
			jMap.controller.deleteAction();
		break;
		case 9:		
		case 45:	
			jMap.controller.insertAction();
		break;
		case 107:		
			//jMap.scale(jMap.scaleTimes + 0.1);
		break;
		case 109:		
			//jMap.scale(jMap.scaleTimes - 0.1);
		break;
	}
	return false;
}
JinoController.prototype.mousemove = function(e){
	var targ;
	if (!e) var e = window.event;
	if (e.target) targ = e.target;
	else if (e.srcElement) targ = e.srcElement;
	if (targ.nodeType == 3) 
		targ = targ.parentNode;
	if(targ.id == 'nodeEditor') return true;
	if(jMap.DragPaper && jMap._enableDragPaper){
		var dx = e.clientX - DRAG_POS.x;
		var dy = e.clientY - DRAG_POS.y;
		DRAG_POS.x = e.clientX;
		DRAG_POS.y = e.clientY;
		this.work.scrollTop -= dy;		
		this.work.scrollLeft -= dx;		
	}
//	
//	if (jMap && jMap.movingNode) {
//		
//		//for(var n=0; n < jMap.getSelecteds().length; n++){
//			//MoveWithChildNode(jMap.getSelecteds()[n], dx, dy);
//		//}
//		
////		jMap.movingShape.translate(dx, dy);
//		
//		var targetNode = jMap.movingNode;
//		if(targetNode.isLeft()) dx = -dx;
//		targetNode.hgap = parseInt(targetNode.hgap) + dx;
//		targetNode.vshift = parseInt(targetNode.vshift) + dy;
//		
//		jMap.layoutManager.updateTreeHeightsAndRelativeYOfAncestors(targetNode);
//		jMap.layoutManager.layout(true);
//		
//		//var loc = targetNode.getLocation();
//		//MoveWithChildNode(jMap.getSelecteds().getLastElement(), dx, dy);
	return false;
}
JinoController.prototype.MoveWithChildNode = function(node, dx, dy){
    node.translate(dx, dy);	
	for (var i = node.children.length; i--;) {
		MoveWithChildNode(node.children[i], dx, dy);
    }
}
JinoController.prototype.mousedown = function(e){
	var targ;
	if (!e) var e = window.event;
	if (e.target) targ = e.target;
	else if (e.srcElement) targ = e.srcElement;
	if (targ.nodeType == 3) 
		targ = targ.parentNode;
	if(targ.id == 'nodeEditor') return true; 
	if(STAT_NODEEDIT) jMap.controller.stopNodeEdit(true);
	if (targ.id == 'paper_mapview') {
		DRAG_POS.x = e.clientX;
		DRAG_POS.y = e.clientY;
		jMap.DragPaper = true;
		//oOkmContextMenu && oOkmContextMenu.cancel();
		jMap.controller.blurAll();
	}
	else if(targ.id == 'jinomap') {
		if( targ.offsetLeft <= e.clientX && e.clientX < targ.clientWidth + targ.offsetLeft
		  && targ.offsetTop <= e.clientY && e.clientY < targ.clientHeight + targ.offsetTop) {
			DRAG_POS.x = e.clientX;
			DRAG_POS.y = e.clientY;
			jMap.DragPaper = true;
		}
		//oOkmContextMenu && oOkmContextMenu.cancel();
		jMap.controller.blurAll();
	}
}
JinoController.prototype.mouseup = function(e){
	e = e || window.event;	
	jMap.DragPaper = false;
	jMap.positionChangeNodes = false;
//	jMap.movingNode = false;
	//return false;
}
/**
 * 노드 편집시 키 이벤트
 * @param {Event} evt
 */
JinoController.prototype.nodeEditKeyDown = function(evt){
	evt = evt || window.event;
/*	
	var ctrl = null; 
    if (evt) ctrl = evt.ctrlKey; 
    else if (evt && document.getElementById) ctrl=(Event.META_MASK || Event.CTRL_MASK)
    else if (evt && document.layers) ctrl=(evt.metaKey || evt.ctrlKey);
    var alt = evt.altKey
	var code = evt.keyCode;
*/
	if (F_CheckKey(evt,[27])) {					
		if(J_NODE_CREATING){
			var node = null;	
			var parentNode = null;		
			while (node = jMap.getSelecteds().pop()) {
				parentNode = node.getParent();								
				node.remove();
			}
			J_NODE_CREATING.focus(true);
			jMap.layoutManager.updateTreeHeightsAndRelativeYOfAncestors(parentNode);
			jMap.layoutManager.layout(true);
		}
		jMap.controller.stopNodeEdit(false);
	} else if (F_CheckKey(evt,[13])) {			
		if (BrowserDetect.browser == "Firefox" && jMap.keyEnterHit++ == 0) {
			return false;
		}
		if (evt.shiftKey) {
			var oInput = jMap.controller.nodeEditor;		
			oInput.style.height = oInput.offsetHeight + 9 + "px";
			return true;			
		}		
		jMap.controller.stopNodeEdit(true);
		return false;
	}
	return true;
}
JinoController.prototype.setNodeEditor = function(el) {
	this.nodeEditor = el;
	if ( this.nodeEditor ) {
		this.nodeEditor.style.display = "none";
		this.nodeEditor.onkeypress = this.nodeEditKeyDown;
		//this.nodeEditor.onkeydown = this.nodeEditKeyDown;
	}
}
JinoController.prototype.startNodeEdit = function(node){
	if ( this.nodeEditor == undefined || this.nodeEditor == null ) {
		return false;
	}
	var hGap = TEXT_HGAP * jMap.scaleTimes;
	var vGap = TEXT_VGAP * jMap.scaleTimes;
	if(STAT_NODEEDIT) this.stopNodeEdit(true);
	STAT_NODEEDIT = true;
	this.nodeEditor.setAttribute("nodeID", node.id);
	var oInput = this.nodeEditor;
	oInput.style.fontFamily = node.text.attr()['font-family'];
	oInput.style.fontSize = node.text.attr()['font-size'] * jMap.scaleTimes +"px";
	if(node.isLeft()) oInput.style.textAlign = "right";
	else oInput.style.textAlign = "left";	
	//oInput.style.fontStyle = ( node.font.italic == "true" )? "italic":"normal";
	//oInput.style.fontWeight = ( node.font.bold == "true" )? "bold":"normal";
	//oInput.style.color = ( node.color == "" )? "#"+NODE_FONT_COLOR:"#"+node.color;
	var width = node.body.getBBox().width * jMap.scaleTimes - hGap;
	//if(width < 70) width = 70;
	var height = node.body.getBBox().height * jMap.scaleTimes - vGap;
	var left = node.body.getBBox().x * jMap.scaleTimes + hGap / 4;
	var top = node.body.getBBox().y * jMap.scaleTimes + vGap / 4;
	oInput.style.display = "";
	oInput.style.width = width + "px";
	oInput.style.height = height + vGap + "px";
	oInput.style.left = left + "px";
	oInput.style.top = top - vGap/4 + "px";
	oInput.style.zIndex = 999;	
	oInput.style.isleft = node.isLeft();
	oInput.value = node.getText();
	oInput.focus();
	/*
	if ( org == CARET_ORG_START ) {
		this.setCaretPos(oInput, 0);
	} else if ( org == CARET_ORG_END ) {
		this.setCaretPos(oInput, node.text.length);
	} else {
		oInput.select();
	}
	this.panelD.onmousedown = null;
	*/
	return true;
}
JinoController.prototype.stopNodeEdit = function(res) {
	STAT_NODEEDIT = false;
	J_NODE_CREATING = false;
	jMap.work.focus();
	if ( this.nodeEditor == undefined || this.nodeEditor == null ) {
		return null;
	}
	if ( res == false ) {
		this.nodeEditor.style.display = "none";
		return null;
	}
	var nodeID = this.nodeEditor.getAttribute("nodeID");
	if ( nodeID == undefined || nodeID == null || nodeID == "") {
		this.nodeEditor.style.display = "none";
		return null;
	}
	var node = this.map.getNodeById(nodeID);
	if ( node == undefined || node == null ) {
		this.nodeEditor.style.display = "none";
		return null;
	}
	this.nodeEditor.style.display = "none";
	this.nodeEditor.setAttribute("nodeID", "");
	var oInput = this.nodeEditor;
	var val = JinoUtil.trimStr(oInput.value);
	if ( val == node.getText() ) return null;
	node.setText(val);
	jMap.layoutManager.updateTreeHeightsAndRelativeYOfAncestors(node);
	jMap.layoutManager.layout(true);
	return node;
}
JinoController.prototype.blurAll = function(){
	var selectedNodes = jMap.getSelecteds();
	for(var i = selectedNodes.length-1; i >= 0; i--) {
		selectedNodes[i].blur();
	}
}
////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////
JinoController.prototype.copyAction = function(){
	var selectedNodes = jMap.getSelecteds();
	var copyData = new Array;
	for(var i = 0; i < selectedNodes.length; i++)										
		copyData.push(copyNodes(selectedNodes[i], false));					
	var jsonCopyData = JSON.stringify(copyData);
	CLIPBOARD_DATA = jsonCopyData;
}
JinoController.prototype.cutAction = function(selectedNodes){
	var map = jMap;
	if(!selectedNodes) selectedNodes = map.getSelecteds();
	var copyData = new Array;
	for (var i = 0; i < selectedNodes.length; i++) {
		copyData.push(copyNodes(selectedNodes[i], true));
		selectedNodes[i].remove();
	}
	var jsonCopyData = JSON.stringify(copyData);
	CLIPBOARD_DATA = jsonCopyData;
	var parentNode = selectedNodes[0].parent;
	map.layoutManager.updateTreeHeightsAndRelativeYOfAncestors(parentNode);
	map.layoutManager.layout(true);
	return parentNode;
}
JinoController.prototype.pasteAction = function(selected){
	var map = jMap;
	if(!selected) selected = map.getSelecteds().getLastElement();
	selected.folded && selected.setFoldingExecute(!selected.folded);
	var backToJS = JSON.parse(CLIPBOARD_DATA);
	var pastedNodes = new Array;
	for (var i = 0; i < backToJS.length; i++) 
		pastedNodes.push(pasteNodes(backToJS[i], selected));
	//
	var copyData = new Array;
	for (var i = 0; i < pastedNodes.length; i++) 
		copyData.push(copyNodes(pastedNodes[i], true));
	var jsonCopyData = JSON.stringify(copyData);
	map.fireActionListener(ACTIONS.ACTION_NODE_PASTE, selected, jsonCopyData);
	////////////////////////////
	map.layoutManager.updateTreeHeightsAndRelativeYOfWholeMap();
	map.layoutManager.layout(true);
}
JinoController.prototype.deleteAction = function(){
	var node = null;
	var parentNode = null;
	var indexPos = -1;
	while (node = jMap.getSelecteds().pop()) {
		parentNode = node.getParent();
		indexPos = node.getIndexPos();
		node.remove();
	}
	if (parentNode) {
		jMap.layoutManager.updateTreeHeightsAndRelativeYOfAncestors(parentNode);
		jMap.layoutManager.layout(true);
	}
	if (indexPos != -1) {
		if (parentNode.getChildren().length <= 0) {
			parentNode.focus();
		} else {
			if (parentNode.getChildren().length > indexPos) {
				parentNode.getChildren()[indexPos].focus();
			} else {
				parentNode.getChildren()[parentNode.getChildren().length - 1].focus();
			}
		}
	}
}
JinoController.prototype.editNodeAction = function(){
	jMap.getSelecteds().getLastElement() &&
		jMap.controller.startNodeEdit(jMap.getSelecteds().getLastElement());
}
JinoController.prototype.insertAction = function(){
	var node = jMap.getSelecteds().getLastElement();
	if (node) {
		J_NODE_CREATING = node;
		node.folded && node.setFoldingExecute(false);
		var newNode = jMap.createNodeWithCtrl(node);
		newNode.focus(true);
		jMap.layoutManager.updateTreeHeightsAndRelativeYOfAncestors(node);
		jMap.layoutManager.layout(true);
		newNode.setTextExecute("");
		jMap.controller.startNodeEdit(newNode);
	}
}
JinoController.prototype.insertSiblingAction = function(){
	if (BrowserDetect.browser == "Firefox") {
		jMap.keyEnterHit = 0;
	}
	var selectedNode = jMap.getSelecteds().getLastElement();
	var node = selectedNode && selectedNode.parent;
	if (node) {
		J_NODE_CREATING = selectedNode;
		node.folded && node.setFoldingExecute(false);
		var index = selectedNode.getIndexPos() + 1;
		var position = null;
		if (selectedNode.position && selectedNode.getParent().isRootNode()) 
			position = selectedNode.position;
		var newNode = jMap.createNodeWithCtrl(node, null, null, index, position);		
		newNode.focus(true);
		jMap.layoutManager.updateTreeHeightsAndRelativeYOfAncestors(newNode);
		jMap.layoutManager.layout(true);
		newNode.setTextExecute("");
		jMap.controller.startNodeEdit(newNode);
	}
}
JinoController.prototype.insertHyperAction = function(){
	var selected = jMap.getSelecteds().getLastElement();
	var urlText = selected.hyperlink && selected.hyperlink.attr().href;
	urlText = urlText || "http://";
	var txt = '<center>Insert HyperLink</center><br />URL:<br />' +
	'<input type="text" id="jino_input_url"' +
	'name="jino_input_url" value=' +
	urlText +
	' />';
	function callbackform_hyper(v, m, f){
		if (v) {
			selected.setHyperlink(f.jino_input_url);
			jMap.layoutManager.updateTreeHeightsAndRelativeYOfAncestors(selected);
			jMap.layoutManager.layout(true);
		}
		jMap.work.focus();
	}
	var re = $.prompt(txt, {
		callback: callbackform_hyper,
		persistent: false,
		focusTarget: 'jino_input_url',
		top: '30%',
		buttons: {
			Ok: true
		}
	});
}
JinoController.prototype.insertImageAction = function(){
	var selected = jMap.getSelecteds().getLastElement();
	var urlImg = selected.img && selected.img.attr().src;
	urlImg = urlImg || "http://";
	var txt = '<center>Insert Image</center><br />URL:<br />' +
	'<input type="text" id="jino_input_img_url"' +
	'name="jino_input_img_url" value=' +
	urlImg +
	' />';
	function callbackform_img(v, m, f){
		if (v) {
			selected.setImage(f.jino_input_img_url);
			jMap.layoutManager.updateTreeHeightsAndRelativeYOfAncestors(selected);
			jMap.layoutManager.layout(true);
		}
		jMap.work.focus();
	}
	var re = $.prompt(txt, {
		callback: callbackform_img,
		persistent: false,
		focusTarget: 'jino_input_img_url',
		top: '30%',
		buttons: {
			Ok: true
		}
	});
}
JinoController.prototype.findNodeAction = function(){
	var txt = 'Find : ' +
	'<input type="text" id="jino_input_search_text"' +
	'name="jino_input_search_text" value="" />' +
	'<br /><br />' +
	'<input type="checkbox" id="jino_check_search_ignorecase"' +
	'name="jino_check_search_ignorecase" value="" checked>ignorecase' +
	'<input type="checkbox" id="jino_check_search_wholeword"' +
	'name="jino_check_search_wholeword" value="">wholeword';
	function callbackform_search(v, m, f){
		if (v) {
			var searchText = f.jino_input_search_text;
			var isIgnorecase = f.jino_check_search_ignorecase;
			var isWholeword = f.jino_check_search_wholeword;
			var nodes = jMap.findNode(searchText, isWholeword, isIgnorecase, jMap.getSelecteds().getLastElement());
			for (var i = 0; i < nodes.length; i++) {
				var node = nodes[i].node;
				var currentNode = node;
				while (!currentNode.isRootNode()) {
					currentNode = currentNode.getParent();
					currentNode.folded && currentNode.setFoldingExecute(false);
				}
				node.focus(false);
			}
			jMap.layoutManager.updateTreeHeightsAndRelativeYOfWholeMap();
			jMap.layoutManager.layout(true);
		}
		jMap.work.focus();
	}
	var re = $.prompt(txt, {
		callback: callbackform_search,
		persistent: false,
		focusTarget: 'jino_input_search_text',
		top: '30%',
		buttons: {
			Find: true
		}
	});
}
JinoController.prototype.foldingAction = function(){
	var selected = jMap.getSelecteds().getLastElement();
	selected.setFolding(!selected.folded);
	jMap.layoutManager.updateTreeHeightsAndRelativeYOfDescendantsAndAncestors(selected);
	jMap.layoutManager.layout(true);
}
JinoController.prototype.foldingAllAction = function(){
	var selected = jMap.getSelecteds().getLastElement();
	selected.setFoldingAll(true);
	jMap.layoutManager.updateTreeHeightsAndRelativeYOfWholeMap();
	jMap.layoutManager.layout(true);
}
JinoController.prototype.unfoldingAllAction = function(){
	var selected = jMap.getSelecteds().getLastElement();
	selected.setFoldingAll(false);
	jMap.layoutManager.updateTreeHeightsAndRelativeYOfWholeMap();
	jMap.layoutManager.layout(true);
}
JinoController.prototype.parentNodeFocusAction = function(selected){
	selected.getParent().focus(true);
	jMap.fireActionListener(ACTIONS.ACTION_NODE_SELECTED, selected.getParent(), "key_selected");
}
JinoController.prototype.childNodeFocusAction = function(selected){
	if(selected.folded) {
		selected.setFoldingExecute(false);
		jMap.layoutManager.updateTreeHeightsAndRelativeYOfDescendantsAndAncestors(selected);				
		jMap.layoutManager.layout(true);
		return false;
	}
	var children = selected.getChildren();
	if(children.length > 0){
		children[0].focus(true);
		jMap.fireActionListener(ACTIONS.ACTION_NODE_SELECTED, children[0], "key_selected");
	}
}
JinoController.prototype.prevSiblingNodeFocusAction = function(selected){
	var prevSiblingNode = selected.prevSibling();
	if(prevSiblingNode){
		var parentNode = prevSiblingNode.getParent();
		if(parentNode.folded) {
			parentNode.setFoldingExecute(false);
			jMap.layoutManager.updateTreeHeightsAndRelativeYOfDescendantsAndAncestors(parentNode);				
			jMap.layoutManager.layout(true);
		}				
		prevSiblingNode.focus(true);
		jMap.fireActionListener(ACTIONS.ACTION_NODE_SELECTED, prevSiblingNode, "key_selected");
	}
}
JinoController.prototype.nextSiblingNodefocusAction = function(selected){
	var nextSiblingNode = selected.nextSibling();
	if(nextSiblingNode){
		var parentNode = nextSiblingNode.getParent();
		if(parentNode.folded) {
			parentNode.setFoldingExecute(false);
			jMap.layoutManager.updateTreeHeightsAndRelativeYOfDescendantsAndAncestors(parentNode);				
			jMap.layoutManager.layout(true);
		}				
		nextSiblingNode.focus(true);
		jMap.fireActionListener(ACTIONS.ACTION_NODE_SELECTED, nextSiblingNode, "key_selected");
	}
}
JinoController.prototype.nodeStructureFromText = function(node){
	if(!node) node = jMap.getSelecteds().getLastElement();
	var txt = '다음 텍스트를 노드로 생성합니다.<br/><center><textarea id="okm_node_structure_textarea" name="okm_node_structure_textarea" ' +
				'onkeydown="return $.prompt.interceptTabs(event, this);" cols="65" rows="10">' +
				'</textarea></center>';
	function callbackform_structure(v, m, f){
		if (v) {
			var stText = f.okm_node_structure_textarea;
			node.folded && node.setFoldingExecute(false);
			jMap.createNodeFromText(node, stText);
			jMap.layoutManager.updateTreeHeightsAndRelativeYOfDescendantsAndAncestors(node);
			jMap.layoutManager.layout(true);
		}
		jMap.work.focus();
	}
	var re = $.prompt(txt, {
		callback: callbackform_structure,
		persistent: false,
		focusTarget: 'okm_node_structure_textarea',
		top: '30%',
		enterToOk: false,
		buttons: {
			Insert: true
		}
	});
}
JinoController.prototype.nodeStructureToText = function(node){
	if(!node) node = jMap.getSelecteds().getLastElement();
	var text = jMap.createTextFromNode(node, "\t");
	var txt = '다음은 노드의 구조입니다.<br/><center><textarea id="okm_node_structure_textarea" name="okm_node_structure_textarea" ' +
				'onkeydown="return $.prompt.interceptTabs(event, this);" cols="65" rows="10">' +
				text + 
				'</textarea></center>';
	var re = $.prompt(txt, {
		persistent: false,
		focusTarget: 'okm_node_structure_textarea',
		top: '30%',
		buttons: {
			Close: true
		}
	});
}
JinoController.prototype.nodeStructureFromXml = function(node){
	if(!node) node = jMap.getSelecteds().getLastElement();
	var txt = '다음 XML을 노드로 생성합니다.<br/><center><textarea id="okm_node_structure_textarea" name="okm_node_structure_textarea" ' +
				'onkeydown="return $.prompt.interceptTabs(event, this);" cols="65" rows="10">' +
				'</textarea></center>';
	function callbackform_structure(v, m, f){
		if (v) {
			var xmlStr = f.okm_node_structure_textarea;
			xmlStr = xmlStr.replace(/<foreignObject([^>]*)\">/ig, "<foreignObject$1\">\n<![CDATA[\n");
			xmlStr = xmlStr.replace(/<\/foreignObject>/ig, "\n]]>\n</foreignObject>");
			if (window.DOMParser) {
				var parser = new DOMParser();
				xmlDoc = parser.parseFromString(xmlStr,"text/xml");
			} else { 
				xmlDoc = new ActiveXObject("Microsoft.XMLDOM");
				xmlDoc.async="false";
				xmlDoc.loadXML(xmlStr);
			}
			node.folded && node.setFoldingExecute(false);
			var nodeElements = xmlDoc.childNodes;
			for(var i = 0; i < nodeElements.length; i++) {
				if(nodeElements.item(i).nodeType == 1 /*NodeTypes.ELEMENT_NODE*/) {
					var element = nodeElements.item(i);	
					element.removeAttribute("POSITION");	
					element.removeAttribute("ID");			
					var text = element.getAttribute("TEXT");
					var id = element.getAttribute("ID");
					var childNode = jMap.createNodeWithCtrl(node, text, id);
					jMap.initNodeAttrs(childNode, element);	
					jMap.initChildNodes(childNode, element);
				}
			}
			jMap.initFolding(node);
			jMap.layoutManager.updateTreeHeightsAndRelativeYOfDescendantsAndAncestors(node);
			jMap.layoutManager.layout(true);
		}
		jMap.work.focus();
	}
	var re = $.prompt(txt, {
		callback: callbackform_structure,
		persistent: false,
		focusTarget: 'okm_node_structure_textarea',
		top: '30%',
		enterToOk: false,
		buttons: {
			Insert: true
		}
	});
}
JinoController.prototype.nodeStructureToXml = function(node){
	if(!node) node = jMap.getSelecteds().getLastElement();
	var text = node.toXML();
	var txt = '다음은 노드의 구조입니다.<br/><center><textarea id="okm_node_structure_textarea" name="okm_node_structure_textarea" ' +
				'onkeydown="return $.prompt.interceptTabs(event, this);" cols="65" rows="10">' +
				text + 
				'</textarea></center>';
	var re = $.prompt(txt, {
		persistent: false,
		focusTarget: 'okm_node_structure_textarea',
		selectText: 'okm_node_structure_textarea',
		top: '30%',		
		buttons: {
			Close: true
		}
	});
}
JinoController.prototype.nodeTextColorAction = function(node){
	if(!node) node = jMap.getSelecteds().getLastElement();
	var txt = '<center>Text Color</center><br />' +
	'<div style="height:130px;">' + 
	'<input type="text" style="width:220px;" class="color" id="jino_input_textcolor"' +
	'name="jino_input_textcolor" />' +
	'</div>' + 
	'<script type="text/javascript">' +
	'var myPicker = new jscolor.color(document.getElementById("jino_input_textcolor"), {});' +
	'myPicker.hash = true;' +
	'myPicker.pickerFaceColor = "transparent";' +
	'myPicker.pickerFace = 5;' +
	'myPicker.pickerBorder = 0;' +
	'myPicker.pickerInsetColor = "black";' +
	//'myPicker.showPicker();' +
	'myPicker.fromString("' + node.getTextColor() + '");' +
	//'myPicker.pickerPosition = "top"' +
	'</script>';
	function callbackform_color(v, m, f){
		if (v) {
			node.setTextColor(f.jino_input_textcolor);
		}
		jMap.work.focus();
	}
	var re = $.prompt(txt, {
		callback: callbackform_color,
		persistent: true,
		focusTarget: 'jino_input_textcolor',
		prefix:'jqicolor',
		top: '30%',
		buttons: {
			Ok: true
		}
	});
}
JinoController.prototype.nodeBackgroundColorAction = function(node){
	if(!node) node = jMap.getSelecteds().getLastElement();
	var txt = '<center>Background Color</center><br />' +
	'<div style="height:130px;">' + 
	'<input type="text" style="width:220px;" class="color" id="jino_input_bgcolor"' +
	'name="jino_input_bgcolor" />' +
	'</div>' + 
	'<script type="text/javascript">' +
	'var myPicker = new jscolor.color(document.getElementById("jino_input_bgcolor"), {});' +
	'myPicker.hash = true;' +
	'myPicker.pickerFaceColor = "transparent";' +
	'myPicker.pickerFace = 5;' +
	'myPicker.pickerBorder = 0;' +
	'myPicker.pickerInsetColor = "black";' +
	//'myPicker.showPicker();' +
	'myPicker.fromString("' + node.getBackgroundColor() + '");' +
	//'myPicker.pickerPosition = "top"' +
	'</script>';
	function callbackform_color(v, m, f){
		if (v) {
			node.setBackgroundColor(f.jino_input_bgcolor);
		}
		jMap.work.focus();
	}
	var re = $.prompt(txt, {
		callback: callbackform_color,
		persistent: true,
		focusTarget: 'jino_input_bgcolor',
		prefix:'jqicolor',
		top: '30%',
		buttons: {
			Ok: true
		}
	});
}
JinoController.prototype.deleteArrowlinkAction = function(node){
	if(!node) node = jMap.getSelecteds().getLastElement();
	for (var i = 0; i < node.arrowlinks.length; i++) {		
		node.removeArrowLink(node.arrowlinks[i]);
	}
}
JinoController.prototype.screenFocusAction = function(node){
	if(!node) node = jMap.getSelecteds().getLastElement();
	if(!node) node = jMap.getRootNode();
	node.screenFocus();
}
