/**
 * 
 * @author Hahm Myung Sun (hms1475@gmail.com)
 *
 * Copyright (c) 2011 JinoTech (http://www.jinotech.com) 
 * Licensed under the LGPL v3.0 license (http://www.gnu.org/licenses/lgpl.html).
 */
///////////////////////////////////////////////////////////////////////////////
////////////////////////
///////////////////////////////////////////////////////////////////////////////
JinoControlleriPhone = function(map){
	JinoControlleriPhone.superclass.call(this, map);
	if ("onorientationchange" in window) {
	    document.body.onorientationchange = this.updateOrientation;
	} else {
	    window.onresize = this.updateOrientation;
	}
}
extend(JinoControlleriPhone, JinoController);
JinoControlleriPhone.prototype.type = "JinoControlleriPhone";
JinoControlleriPhone.prototype.updateOrientation = function(e){
	resize();
}
JinoControlleriPhone.prototype.mousemove = function(e){
	(e.originalEvent || e).preventDefault();
	var targ;
	if (!e) var e = window.event;
	if (e.target) targ = e.target;
	else if (e.srcElement) targ = e.srcElement;
	if (targ.nodeType == 3) 
		targ = targ.parentNode;
	if(targ.id == 'nodeEditor') return true;
	var dx = e.clientX - DRAG_POS.x;
	var dy = e.clientY - DRAG_POS.y;
	DRAG_POS.x = e.clientX;
	DRAG_POS.y = e.clientY;
	if(jMap.DragPaper){		
		this.work.scrollTop -= dy;		
		this.work.scrollLeft -= dx;		
	}
}
JinoControlleriPhone.prototype.mousedown = function(e){
	(e.originalEvent || e).preventDefault();
	if(supportsTouch && (e.originalEvent || e).touches.length == 2){
		var selectedNode = jMap.getSelecteds().getLastElement();
		if(selectedNode){
			selectedNode.setFolding(!selectedNode.folded);
			jMap.layoutManager.updateTreeHeightsAndRelativeYOfDescendants(selectedNode);				
			jMap.layoutManager.updateTreeHeightsAndRelativeYOfAncestors(selectedNode);
			jMap.layoutManager.layout(true);			
		}		
	}
	var targ;
	if (!e) var e = window.event;
	if (e.target) targ = e.target;
	else if (e.srcElement) targ = e.srcElement;
	if (targ.nodeType == 3) 
		targ = targ.parentNode;
	if(targ.id == 'nodeEditor') return true; 
	if(STAT_NODEEDIT) jMap.controller.stopNodeEdit(true);
	DRAG_POS.x = e.clientX;
	DRAG_POS.y = e.clientY;
	if (targ.id == 'paper_mapview') {
		jMap.DragPaper = true;
	}
	else if(targ.id == 'jinomap') {
		if( targ.offsetLeft <= e.clientX && e.clientX < targ.clientWidth + targ.offsetLeft
		  && targ.offsetTop <= e.clientY && e.clientY < targ.clientHeight + targ.offsetTop) {
			jMap.DragPaper = true;
		}
	}
}
JinoControlleriPhone.prototype.mouseup = function(e){
	(e.originalEvent || e).preventDefault();
	jMap.DragPaper = false;
	jMap.positionChangeNodes = false;
//	jMap.movingNode = false;
	//return false;
}
