/**
 * 
 * @author Hahm Myung Sun (hms1475@gmail.com)
 *
 * Copyright (c) 2011 JinoTech (http://www.jinotech.com) 
 * Licensed under the LGPL v3.0 license (http://www.gnu.org/licenses/lgpl.html).
 */
///////////////////
var HGAP = 20;
var VGAP = 5;
var TEXT_HGAP = 10;
var TEXT_VGAP = 10;
var FOLDER_RADIUS = 4;
var PERCEIVE_WIDTH = 30;				
var NODE_SELECTED_COLOR = "#E02405";	
var NODE_DROP_FOCUS_COLOR = "#808080";	
var NODE_DEFALUT_COLOR = "#F4F4F4"		
var EDGE_DEFALUT_COLOR = "#808080";		
//var MOVING_SHAPE_COLOR = "#5c8edb"		
var NODE_CORNER_ROUND = 5;
var NODE_MOVING_IGNORE = 5;				
var NODE_FONT_SIZE_ENUM = ['30', '18', '12'];	
//////////////////////////////////////////////////
var events = "click dblclick mousedown mousemove mouseout mouseover mouseup touchstart touchmove touchend orientationchange touchcancel gesturestart gesturechange gestureend dragstart dragenter dragexit drop".split(" ");
var supportsTouch = "createTouch" in document,
	touchMap = {
		mousedown: "touchstart",
	    mousemove: "touchmove",
	    mouseup: "touchend",
	    click: "click"
	};
var RAPHAEL = null;
var STAT_NODEEDIT = false;
var CLIPBOARD_DATA = "";
var DRAG_POS = {x:0, y:0};
//var PAPER_DRAG_POS = {x:0, y:0};
var J_NODE_CREATING = false;
var ACTIONS = {	ACTION_NEW_NODE : "action_NewNode",				
				ACTION_NODE_REMOVE : "action_NodeRemove",		
				ACTION_NODE_EDITED : "action_NodeEdited",		
				ACTION_NODE_SELECTED : "action_NodeSelected",	
				ACTION_NODE_FOLDING : "action_NodeFolding",		
				ACTION_NODE_MOVED : "action_NodeMoved",			
				ACTION_NODE_HYPER : "action_NodeHyper",			
				ACTION_NODE_IMAGE : "action_NodeImage",			
				ACTION_NODE_PASTE : "action_NodePaste",			
				ACTION_NODE_UNDO : "action_NodeUndo",			
				ACTION_NODE_REDO : "action_NodeRedo",			
				ACTION_NODE_FOREIGNOBJECT : "action_NodeForeignObject"	
			  };
//iPhone, iPod Agent 찾기
var ISMOBILE = ((navigator.userAgent.match(/iPhone/i)) || (navigator.userAgent.match(/iPad/i)) || (navigator.userAgent.match(/iPod/i)));
///////////////////////////////////////////////////////////////////////////////
/////////////////////////
///////////////////////////////////////////////////////////////////////////////
JinoMap = function (work, w, h, mode){
	RAPHAEL = Raphael(work, w, h);
	RAPHAEL.canvas.id = "paper_mapview";
	this.selectedNodes = new Array();	
	this.DragPaper = false;				
	this.positionChangeNodes = false;	
//	this.movingNode = false;			
	this.isSavedFlag = true;			
	this.indexColor = 0;				
	this.mouseRightClicked = false;		
	this.scaleTimes = 1.0;
	this._enableDragPaper = true;		
	this.mode = mode || 0;	
	this.Listeners = new Array();	
//	this.movingShape = null;
	this.statusBar = null;
	this.tootipHandle = $('<div style="position:absolute" id="jinomap_tooltip"></div>').appendTo($('#jinomap')).hide();
	this.nodeEditorHandle = $('<textarea id="nodeEditor" value="" style="position:absolute;top:0px;left:0px;width:100px;height:0px;overflow:hidden;display:none" />').appendTo($('#jinomap'));
	this.nodes = new Array();
	this.arrowlinks = new Array();
	this.work = $('#'+work)[0];
	if(ISMOBILE)	this.controller = this.mode? new JinoControlleriPhone(this) : new JinoControlleriPhone(this);
	else				this.controller = this.mode? new JinoController(this) : new JinoControllerGuest(this);
	this.layoutManager = new jMindMapLayout(this);
	this.historyManager = new UndoRedoManager();
	this.nodeEditorHandle.textGrow({
	  pad: 25, min_limit: 70, max_limit: 1000
	});
	this.work.focused = false;
    this.work.hasFocus = function() {
        return this.focused;
    };
    this.work.onfocus=function() {
        this.focused=true;
    };
    this.work.onblur=function() {
        this.focused=false;
    };
    if(Raphael.svg){
		this.groupEl = document.createElementNS("http://www.w3.org/2000/svg", "g");
    	this.groupEl.style.webkitTapHighlightColor = "rgba(0,0,0,0)";
		//this.groupEl.setAttribute("transform", "scale("+jMap.scaleTimes+")");		
		RAPHAEL.canvas && RAPHAEL.canvas.appendChild(this.groupEl);
	}
//	if(Raphael.vml){
//		this.groupEl = createNode("group");		
//		RAPHAEL.canvas.appendChild(this.groupEl);
//	}
}
JinoMap.prototype.type= "JinoMap";
for (var i = events.length; i--;) {
    (function (eventName) {
        JinoMap.prototype[eventName] = function (fn) {
            if (Raphael.is(fn, "function")) {
                this.events = this.events || [];
                this.events.push({name: eventName, f: fn, unbind: addEvent(this.work, eventName, fn, this)});
            }
            return this;
        };
        JinoMap.prototype["un" + eventName] = function (fn) {
            var events = this.events,
                l = events.length;
            while (l--) if (events[l].name == eventName && events[l].f == fn) {
                events[l].unbind();
                events.splice(l, 1);
                !events.length && delete this.events;
                return this;
            }
            return this;
        };
    })(events[i]);
}
JinoMap.prototype.deleteNodeById = function(id) {
	delete this.nodes[id];
}
JinoMap.prototype.getNodeById = function(id) {
	return this.nodes[id];
}
/**
 * 
 * @param {String} id	: 검사할 id
 * @return	: true - 써도 OK, false - 쓰지 말것.
 */
JinoMap.prototype.checkID = function(id){
	if(!id) return false;
	for(var iid in this.nodes) {
		if(iid == id) return false;		
	}	
	return true;
}
JinoMap.prototype.getRootNode = function(){
	return this.rootNode;
}
JinoMap.prototype.addActionListener = function(eventName, fn){
	var al = {name: eventName, f: fn};
	this.Listeners.push(al);
	return al;	
}
JinoMap.prototype.removeActionListener = function(al){
	this.Listeners.remove(al);
}
JinoMap.prototype.fireActionListener = function(){
	if(arguments.length < 1) return;
	var eventName = Array.prototype.slice.call(arguments, 0, 1)[0];	
	var arg = Array.prototype.slice.call(arguments, 1);
	var listeners = this.Listeners,
		l = listeners.length;
	while (l--) if(listeners[l].name == eventName) {
		listeners[l].f.apply(this, arg);
	}
}
/**
 * @param {String} text : 검색 문자열
 * @param {bool} wholeword : 온전한 단어(완전 매칭)
 * @param {bool} ignorecase : 대소문자 구분
 * @param {jNode} node : 검색 시작 노드	
 * @param {Array} finds : 검색된 노드들의 집합
 * 
 * @return : parm으로 넣은 finds과 같은것이 리턴되는데
 * 			리턴 구조는.. return.node 및 return.match 를 갖는다.
 */
JinoMap.prototype.findNode = function(text, wholeword, ignorecase, node, finds){
	if(!finds) finds = new Array();
	var searchNode = node || this.rootNode;
	var op = "g";
	var re = /\\/g;
	var matchText = text.replace(re, "");
	re = /([\*\+\$\|\?\(\)\{\}\^\[\]])/g;
	matchText = matchText.replace(re, "\\$1");	
	if(wholeword){
		if(matchText.substr(0, 1) != "^") matchText = "^"+matchText;
		if(matchText.substr(matchText.length-1, 1) != "$") matchText = matchText+"$";		
	} 
	if(ignorecase) op = op + "i";
	var regexp = new RegExp(matchText, op);
	var match = regexp.exec(searchNode.getText());
	match && finds.push({
		node: searchNode,
		match: match
	});
	if(searchNode.getChildren().length > 0) {
		var children = searchNode.getChildren();
		for(var i = 0; i < children.length; i++) {
			this.findNode(text, wholeword, ignorecase, children[i], finds);
		}
	}
	return finds;
}
/**
 * 새로운 맵 작성
 * @return : 루트 노드 (jNode)
 */
JinoMap.prototype.newMap = function(){
	if(this.rootNode) RAPHAEL.clear();
	this.rootNode = this.createNodeWithCtrl(null, "newMap");	
	this.rootNode.focus(true);
	this.layoutManager.updateTreeHeightsAndRelativeYOfWholeMap();
	return this.rootNode;
}
JinoMap.prototype.getSelecteds = function() {
	return this.selectedNodes;
}
JinoMap.prototype.getSelected = function() {
	return this.getSelecteds().getLastElement();	
}
JinoMap.prototype.isSaved = function() {
	return this.isSavedFlag;
}
JinoMap.prototype.setSaved = function(isSaved) {
	this.isSavedFlag = isSaved;
	//this.resetSessionTimeout();
}
JinoMap.prototype.setLayoutManager = function(layoutManager) {
	this.layoutManager = layoutManager;
	this.changeLineOfWholeMap(this.getRootNode());
	this.layoutManager.updateTreeHeightsAndRelativeYOfWholeMap();
}
JinoMap.prototype.changeLineOfWholeMap = function(node) {	
	if(node.connection){
		node.connection.remove();			
		switch(this.layoutManager.type) {
			case "jMindMapLayout" :
				node.connection = node.parent && new jLineBezier(node.parent, node);
				break;
			case "jTreeLayout" :
				node.connection = node.parent && new jLinePolygonal(node.parent, node);
				break;
			default :			
		}
		if(node.hided) node.connection.hide();		
	}
	var endNodes = new Array();
	for (var i = 0; i < node.arrowlinks.length; i++) {
		endNodes.push(node.arrowlinks[i].destinationNode);
		node.removeArrowLink(node.arrowlinks[i]);
	}
	for (var i = 0; i < endNodes.length; i++) {
		var arrowlink = null;
		switch(jMap.layoutManager.type) {
			case "jMindMapLayout" :
				arrowlink = new CurveArrowLink(endNodes[i]);
				break;
			case "jTreeLayout" :
				arrowlink = new RightAngleArrowLink(endNodes[i]);
				break;
			default :
		}
		node.addArrowLink(arrowlink);
	}
	if(node.hided) node.hide();	
	if(node.getChildren().length > 0) {
		var children = node.getChildren();
		for(var i = 0; i < children.length; i++) {
			this.changeLineOfWholeMap(children[i]);			
		}
	}
}
JinoMap.prototype.getLayoutManager = function() {
	return this.layoutManager;
}
/**
 * 상태바 만드는거 테스트...
 */
JinoMap.prototype.showBlinkStatusBar = function(text) {
	if (!this.statusBar || this.statusBar.removed) {
		this.statusBar = this.body = RAPHAEL.text();
		this.statusBar.attr({'font-size': 12, /*'font-weight': 'bold',*/ 'text-anchor': 'start', fill: '#000', opacity: 0});		
	}
	this.statusBar.attr({text: text,
							x: this.work.scrollLeft + 15,
							y: this.work.scrollTop + this.work.offsetHeight - 30});
	this.statusBar.animate({opacity: 1}, 500, function(){
		this.animate({opacity: 0}, 500);
	});
	this.aaa = $('<div style="position:absolute" id="aaa">aaaa</div>').appendTo($('#jinomap')); 
}
JinoMap.prototype.createNodeWithCtrl = function(parentNode, text, id, index, position){
	var undo = null;
	var newNode = this.createNodeWithCtrlExecute(parentNode, text, id, index, position); 
	var redo = jMap.historyManager.extractNode(newNode);
	jMap.historyManager.addToHistory(undo, redo);
	jMap.fireActionListener(ACTIONS.ACTION_NEW_NODE, newNode, index);
	jMap.setSaved(false);
	return newNode; 
}
JinoMap.prototype.createNodeWithCtrlExecute = function(parentNode, text, id, index, position){
	var newNode = new jRect(parentNode, text, id, index, position);
	newNode.controller = this.mode? new jNodeController() : new jNodeControllerGuest();
//	newNode.controller = new jNodeControlleriPhone();
	newNode.addEventController(newNode.controller);
	newNode.drag(newNode.controller.move,
					newNode.controller.dragger,
					newNode.controller.up);
	if(typeof NodeColorMix !== 'undefined'){
		if (newNode.isRootNode()) {
			newNode.setBackgroundColor(rootColor);
			newNode.setTextColor(rootTextColor);
		} else if (newNode.getParent().isRootNode()) {
			jMap.indexColor = jMap.indexColor % iColor.length;
			color = iColor[jMap.indexColor];
			jMap.indexColor++;			
			newNode.setBackgroundColor(color);
			newNode.setEdgeColor(NodeColorUtil.darker(Raphael.getRGB(color), darkFactor), 8);
		}
		else {
			var parentColor = Raphael.getRGB(newNode.getParent().background_color);
			var color = NodeColorUtil.randomer(Raphael.getRGB(NodeColorUtil.brighter(parentColor, fadeFactor)), randFactor);
			newNode.setBackgroundColor(color);
			newNode.setEdgeColor(NodeColorUtil.darker(Raphael.getRGB(color), darkFactor), 2);
		}
	}		
	return newNode;
}
JinoMap.prototype.createNodeFromText = function(node, text, separate){
	var lines = text.split("\n");
	var currentNode = node;
	var targetNode = node;
	var targetDeep = 0;
	var sep = separate;
	for(var i=0; i < lines.length; i++){
		if(!separate){
			sep = (lines[i].charAt(0) == '\t')? '\t' : '    ';			
		}		
		var tabs = lines[i].split(sep);
		var deep = tabs.length;
		var nodeText = tabs[deep-1];
		while(true){
			if(targetDeep == deep-1){
				targetNode = this.createNodeWithCtrl(targetNode, nodeText);
				targetDeep = deep;
				break;
			}
			if(!targetNode.getParent()) break;
			targetNode = targetNode.getParent();
			targetDeep = targetDeep-1;
		}
	}
}
JinoMap.prototype.createTextFromNode = function(node, separate, text, depth){	
	depth = depth?depth:0;
	text = text?text:"";
	var whiteSize = "";
	for(var i = 0; i < depth; i++){		
		whiteSize = whiteSize + separate;
	}	
	text = text + whiteSize + node.getText() + "\n";
	if(node.getChildren().length > 0) {
		var children = node.getChildren();
		depth++;
		for(var i = 0; i < children.length; i++) {
			text = this.createTextFromNode(children[i], separate, text, depth);			
		}
	}
	return text;
}
JinoMap.prototype.setSessionTimeout = function(){
	if(!this.mode) return null;
	this.sessionTimeout = setTimeout(function(){
		if(ISMOBILE){
			alert("서비스 이용이 없어 자동 로그아웃 되었습니다.\n다시 로그인 하시기 바랍니다.");
			location.replace(jMap.contextPath+"/user/logout.do");
		}
		var callSessionTimeout = function(v, m, f) {
			if(v == 'logout') {
				location.replace(jMap.contextPath+"/user/logout.do");
			}
			else if(v == 'extension') {	
				var req = false;
			    if(window.XMLHttpRequest && !(window.ActiveXObject)) {
			    	try {
						req = new XMLHttpRequest();
			        } catch(e) {
						req = false;
			        }
			    } else if(window.ActiveXObject) {
			       	try {
			        	req = new ActiveXObject("Msxml2.XMLHTTP");
			      	} catch(e) {
			        	try {
			          		req = new ActiveXObject("Microsoft.XMLHTTP");
			        	} catch(e) {
			          		req = false;
			        	}
					}
			    }
				if(req) {
					req.onreadystatechange = function () {
						if (req.readyState == 4) {
							var xmlDoc = false;
							if (req.status == 200) {
								console.log(req.responseText);
							} else {
							}
						}
					}
					req.open("GET", "/okmindmap/", true);
					req.send(null);
				}
				jMap.resetSessionTimeout();				
			}
//			else {
//				location.replace(jMap.contextPath+"/user/logout.do");
//			}
		}
		var txt = '<center><font color="#ff0000">Timeout</font></center><br />' +
		'서비스 이용이 없어 자동 로그아웃 되었습니다.<br />' +
		'OK버튼을 눌러 다시 로그인 하시기 바랍니다.<br />';
		var re = $.prompt(txt, {
			callback: callSessionTimeout,
			persistent: true,
			top: '30%',
			buttons: {
				'OK': 'logout'
				//'Extension': 'extension',
				//'End': 'end'
			}
		});
	}, 1500000);	
}
JinoMap.prototype.resetSessionTimeout = function(){
	if(!this.mode) return null;
	clearTimeout(this.sessionTimeout);
	this.setSessionTimeout();
}
/**
 * 확대 축소
 * 
 *  @times : 비율 - 1을 기준으로 1.0이하 축소, 1.0이상 확대
 *  @frames : 프레임수. 프레임이 1이상 이라면 애니메이션 되는것 처럼 보임.
 */
JinoMap.prototype.scale = function(times, frames){
	if (Raphael.svg) {
		if(!frames) frames = 1;
		var selected = this.getSelected();
		var oldTimes = this.getViewScale(this.scaleTimes);
		var newTimes = this.getViewScale(times);
		var tic = (newTimes - oldTimes) / frames;
		var rt = oldTimes;
		var o = new TimeLine(30, frames);
		o.onframe = function(){
			rt = rt + tic;
	/*
			console.log(" ");
			console.log(t);
			var i = Math.floor(t);
			var d = Math.floor( (t*10)%10 );
			var dd = Math.floor( (t*100)%10 );
			var ddd = Math.floor( (t*1000)%10 );
			var rt = 0;
			if(1 < t)
				rt = 1/Math.pow(10, i-1)-(i+d-1)/Math.pow(10,i) - (dd*0.001)  - (ddd*0.0001);
			else
				rt = 2-t;
			console.log(rt);
			*/
			var canvasSize = RAPHAEL.getSize();
			var x = (1.0 - rt) * (canvasSize.width / 2); //2581.5;
			var y = (1.0 - rt) * (canvasSize.height / 2); //1397;
			var w = canvasSize.width * rt; 
			var h = canvasSize.height * rt;
//			x = x - ( (1.0 - t) * (canvasSize.width / 2 - selected.getLocation().x) );
//			y = y - ( (1.0 - t) * (canvasSize.height / 2 - selected.getLocation().y) );	
			var viewbox = x+" "+y+" "+w+" "+h;
			RAPHAEL.canvas.setAttribute("viewBox", viewbox);
		};
		o.onstart = function(){
		};
		o.onstop = function(){
		};
		o.start();
		this.scaleTimes = times;
	}	
}
JinoMap.prototype.getViewScale = function(t){
	//t = Math.round(t*1000)/1000.0;
	var i = Math.floor(t);
	var d = Math.floor( (t*10)%10 );
//	var dd = Math.floor( (t*100)%10 );
//	var ddd = Math.floor( (t*1000)%10 );
	var rt = 0;
	if(1 < t)
		rt = 1/Math.pow(10, i-1)-(i+d-1)/Math.pow(10,i);
	else{
		var bb = function(b) {
			var c = 0;
			while(b < 1) {		
			b = b * 10;
			c = c + 1;
			}
			var d = Math.round(11 - b - c)/10;
			return c + d;
		}
		rt = bb(parseFloat(t));
	}
	return rt;
}
/**
 * 확대 축소. transform의 scale 값으로 변경
 * 
 *  @times : 비율 - 1을 기준으로 1.0이하 축소, 1.0이상 확대
 *  @frames : 프레임수. 프레임이 1이상 이라면 애니메이션 되는것 처럼 보임.
 */
JinoMap.prototype.scaleFromTransform = function(times, frames){
	if (Raphael.svg) {
		if(!frames) frames = 1;
		var oldTimes = this.scaleTimes;
		var newTimes = times;
		var tic = (newTimes - oldTimes) / frames;
		var t = oldTimes;		
		var o = new TimeLine(30, frames);
		o.onframe = function(){
			t = t + tic;
			jMap.scaleApply(t, jMap.getSelecteds().getLastElement());
			//var work = jMap.work;
			//work.scrollLeft = Math.round( ( (work.scrollWidth*t) - work.offsetWidth) / 2 );
			//work.scrollTop = Math.round( ( (work.scrollHeight*t) - work.offsetHeight) / 2 );
		};
		o.onstart = function(){
		};
		o.onstop = function(){
		};
		o.start();
		this.scaleTimes = newTimes;
	}
}
JinoMap.prototype.scaleApply = function(times, node){
	node.groupEl.setAttribute("transform", "scale(" + times + ")");
	node.connection && node.connection.line.node.setAttribute("transform", "scale(" + times + ")");
	if(node.getChildren().length > 0) {
		var children = node.getChildren();
		for(var i = 0; i < children.length; i++) {
			this.scaleApply(times, children[i]);			
		}
	}
}
JinoMap.prototype.enableDragPaper = function(bool){
	this._enableDragPaper = bool;
}
/**
 * Test 함수..
 * @param {jNode} node
 */
JinoMap.prototype.travelNodes = function(node){
	if(node.getChildren().length > 0) {
		var children = node.getChildren();
		for(var i = 0; i < children.length; i++) {
			this.travelNodes(children[i]);			
		}
	}
}
/////////////////////////////////////////////////////
//노드를 가르키고 있는 ArrowLink들을 반환한다.
JinoMap.prototype.getArrowLinks = function(node) {
	var alinks = new Array();
	var nodeId = node.id;
	for(var i = 0; i < this.arrowlinks.length; i++) {
		if(this.arrowlinks[i].destination == nodeId) {
			alinks.push(this.arrowlinks[i]);
		}
	}
	return alinks;
}
/**
 * Node 내부에서 사용하는 함수
 * Private!
 */
JinoMap.prototype.addArrowLink = function(arrowlink) {
	this.arrowlinks.push(arrowlink);
}
/**
 * Node 내부에서 사용하는 함수
 * Private!
 */
JinoMap.prototype.removeArrowLink = function(arrowlink) {
	this.arrowlinks.remove(arrowlink);
}
