/**
 * 
 * @author Hahm Myung Sun (hms1475@gmail.com)
 *
 * Copyright (c) 2011 JinoTech (http://www.jinotech.com) 
 * Licensed under the LGPL v3.0 license (http://www.gnu.org/licenses/lgpl.html).
 */
var removeGradient = function(node){
	bodyAttr = node.body.attr();
	delete bodyAttr.gradient;
	node.body.attr({fill: node.background_color, stroke: node.edge.color});
}
///////////////////////////////////////////////////////////////////////////////
/////////////////////////
///////////////////////////////////////////////////////////////////////////////
jNodeController = function(){}
jNodeController.prototype.type= "jNodeController";
jNodeController.prototype.mousedown = function(e){
	var selectedNodes = jMap.getSelecteds();
	if(e.button == 2){
		jMap.mouseRightClicked = true;
		jMap.mouseRightSelectedNode = this;
	}
	if (e.ctrlKey){
		if(selectedNodes.contains(this))
			this.blur();
		else this.focus(false);	
	} 
	else{
		if(!selectedNodes.contains(this)) {
			this.focus(true);
		}
	}
	//e.preventDefault && e.preventDefault();
}
jNodeController.prototype.mouseup = function(e){
	e = e || window.event;
	if(jMap.mouseRightClicked) {
		var mouseRightSelectedNode = jMap.mouseRightSelectedNode;
		jMap.mouseRightClicked = false;
		//this.blur();
		if(mouseRightSelectedNode == this) return;
//		var arrow = new ArrowLink(this);
		var arrowlink = null;
		switch(jMap.layoutManager.type) {
			case "jMindMapLayout" :
				arrowlink = new CurveArrowLink(this);
				break;
			case "jTreeLayout" :
				arrowlink = new RightAngleArrowLink(this);
				break;
			default :
		}
		mouseRightSelectedNode.addArrowLink(arrowlink);
		jMap.layoutManager.layout(true);
	}
	if (jMap.movingNode && !jMap.movingNode.removed) {
		var srcNodes = jMap.positionChangeNodes;
		var targNode = this;
		if (srcNodes && !srcNodes.contains(targNode)) {
			jMap.movingNode.connection && jMap.movingNode.connection.line.remove();
			jMap.movingNode.remove();
			for (var i = 0; i < srcNodes.length; i++) {
				if (srcNodes[i].hadChildren(targNode)) {
					removeGradient(targNode);
					//targNode.body.animate({"fill-opacity": 0}, 500);
					jMap.positionChangeNodes = false;
					return;
				}
			}
			var offsetX = (e.offsetX) ? e.offsetX : e.layerX - this.getLocation().x;
			var widthHalf = this.body.getBBox().width / 2;
			//var pos = (this.isLeft()) ? (offsetX > widthHalf) : (offsetX < widthHalf);
			var isleftPos = (offsetX < widthHalf);
			var toChild = function() {
				var moveData = new Array;
				for (var i = 0; i < srcNodes.length; i++) {
					moveData.push(copyNodes(srcNodes[i], true));
					srcNodes[i].remove();
				}
				for (var i = 0; i < moveData.length; i++) {
					var position = null;
					if (targNode.isRootNode()) 
						position = isleftPos ? "left" : "right";
					moveData[i].preposition = position;	
					targNode.folded && targNode.setFoldingExecute(!targNode.folded);
					pasteNodes(moveData[i], targNode, null, position);
				}
				var jsonMoveData = JSON.stringify(moveData);
				jMap.fireActionListener(ACTIONS.ACTION_NODE_PASTE, targNode, jsonMoveData);
			}
			var toSibling = function() {
				var moveData = new Array;
				for (var i = 0; i < srcNodes.length; i++) {
					moveData.push(copyNodes(srcNodes[i], true));
					srcNodes[i].remove();
				}
				var index = 0;
				for (var i = 0; i < moveData.length; i++) {
					var position = null;
					if (targNode.getParent().isRootNode()) 
						position = targNode.position;
					moveData[i].preposition = position;	
					index = targNode.getIndexPos();
					moveData[i].preindex = index;	
					pasteNodes(moveData[i], targNode.parent, index, position);
				}
				var jsonMoveData = JSON.stringify(moveData);
				jMap.fireActionListener(ACTIONS.ACTION_NODE_PASTE, targNode.parent, jsonMoveData, index);
			}
			if (srcNodes) {
				if (targNode.isRootNode()) {
					toChild();
				} else {
					switch(jMap.layoutManager.type) {
						case "jMindMapLayout" :
							if(this.isLeft()){
								isleftPos? toChild():toSibling();
							} else {
								isleftPos? toSibling():toChild();
							}	
							break;
						case "jTreeLayout" :
							isleftPos? toSibling():toChild();
							break;
						default :			
					}
				}
			}
			removeGradient(targNode);
			jMap.layoutManager.updateTreeHeightsAndRelativeYOfWholeMap();
			//		jMap.layoutManager.updateTreeHeightsAndRelativeYOfDescendants(targNode.isRootNode()? targNode : targNode.parent);
			jMap.layoutManager.layout(true);
			targNode.focus(true);
		}
		jMap.positionChangeNodes = false;
	}
}
jNodeController.prototype.mousemove = function(e){
	e = e || window.event;
	if(!jMap.positionChangeNodes && this.isFoldingHit(e) && !this.isRootNode() && !this.getChildren().isEmpty()) {
		document.body.style.cursor = "url('/images/folding_blue.png'),default";
		//document.body.style.cursor = "crosshair";
	} else {
		document.body.style.cursor = "auto";
	}
}
jNodeController.prototype.mouseover = function(e){
	e = e || window.event;
//		if (this.note) {
//			
//			this.t = this.note;
//			this.title = '';
//			this.alt = '';
//						
//			jMap.tootipHandle.html(this.t).fadeIn('fast');
//		}
	if (jMap.positionChangeNodes && !jMap.getSelecteds().contains(this)) {
		if(jMap.movingNode && !jMap.movingNode.removed){
			jMap.movingNode.hide();
			jMap.movingNode.connection && jMap.movingNode.connection.line.hide();
		}
		var offsetX = (e.offsetX)? e.offsetX : e.layerX - this.getLocation().x;		
		var widthHalf = this.body.getBBox().width/2;
		if (jMap.positionChangeNodes) {
			//			   270
			//	  -------------------
			//	0 |					| 180
			//	  -------------------
			//			   90
			var angleLeft = 0;
			var angleRight = 0;
			switch(jMap.layoutManager.type) {
				case "jMindMapLayout" :
					if(this.isRootNode()) {
						angleLeft = 0;
						angleRight = 180;
					} else {
						angleLeft = (this.isLeft())? 0 : 270;
						angleRight = (this.isLeft())? 270 : 180;
					}
					break;
				case "jTreeLayout" :
					if(this.isRootNode()) {
						angleLeft = 180;
						angleRight = 180;
					} else {
						angleLeft = 0;	
						angleRight = 90;	
					}
					break;
				default :			
			}
			//var pos = (this.isLeft())? (offsetX > widthHalf) : (offsetX < widthHalf);
			if(offsetX < widthHalf)	
				//this.body.attr({gradient: angleRight + "-#ffffff-"+NODE_DROP_FOCUS_COLOR, stroke: NODE_DROP_FOCUS_COLOR});
				this.body.attr({gradient: angleLeft + "-" + NODE_DROP_FOCUS_COLOR + "-#ffffff", stroke: NODE_DROP_FOCUS_COLOR});
			else
				//this.body.attr({gradient: angleLeft + "-#ffffff-"+NODE_DROP_FOCUS_COLOR, stroke: NODE_DROP_FOCUS_COLOR});
				this.body.attr({gradient: angleRight + "-" + NODE_DROP_FOCUS_COLOR + "-#ffffff", stroke: NODE_DROP_FOCUS_COLOR});
	    }		
	}
	if(jMap.mouseRightClicked){		
		this.focus(false);
	}
}
jNodeController.prototype.mouseout = function(e){
	document.body.style.cursor = "auto";
//		if (this.t) {
	if(jMap.movingNode && !jMap.movingNode.removed){
		jMap.movingNode.show();
		jMap.movingNode.connection && jMap.movingNode.connection.line.show();
	}
	if (jMap.positionChangeNodes && !jMap.getSelecteds().contains(this)) {
		removeGradient(this);			
    }
	if(jMap.mouseRightClicked) {
		if(jMap.mouseRightSelectedNode == this) return;
		this.blur();
	}
}
jNodeController.prototype.click = function(e){
	var targ;
	if (!e) var e = window.event;
	if (e.target) targ = e.target;
	else if (e.srcElement) targ = e.srcElement;
	if (targ.nodeType == 3) 
		targ = targ.parentNode;
	if (this.isFoldingHit(e) && targ.nodeName != "image") {
		this.setFolding(!this.folded);
		jMap.layoutManager.updateTreeHeightsAndRelativeYOfDescendants(this);				
		jMap.layoutManager.updateTreeHeightsAndRelativeYOfAncestors(this);
		jMap.layoutManager.layout(true);
	}
	jMap.fireActionListener(ACTIONS.ACTION_NODE_SELECTED, this, e);
}
jNodeController.prototype.dblclick = function(e){		
	jMap.controller.startNodeEdit(this);
}
jNodeController.prototype.dragstart = function(e){
	e = e || window.event;
	if (e.preventDefault)
		e.preventDefault();
	else
		e.returnValue= false;
}
jNodeController.prototype.dragenter = function(e){
	e = e || window.event;
	if (e.preventDefault)
		e.preventDefault();
	else
		e.returnValue= false;
	this.focus(true);
}
jNodeController.prototype.dragexit = function(e){
	e = e || window.event;
	if (e.preventDefault)
		e.preventDefault();
	else
		e.returnValue= false;
	this.blur();
//	var selectedNodes = jMap.getSelecteds();
//	var node = null;
//	while(node = selectedNodes.pop())
//		node.body.animate({fill: node.background_color,
//								stroke: node.edge.color,
//								"stroke-width": node.stroke_width}, 300);					
}
jNodeController.prototype.drop = function(e){
	e = e || window.event;
	if (e.preventDefault)
		e.preventDefault();
	else
		e.returnValue= false;
	var droptext = e.dataTransfer.getData('TEXT') || e.dataTransfer.getData('text/plain');	
	var urlText = e.dataTransfer.getData('URL');
	var isUpdateLayout = false;
	if(droptext.substr(0,7) == "http://"){
		urlText = urlText || droptext;
		if(urlText){
			this.setFoldingExecute(false);
			var newNode = jMap.createNodeWithCtrl(this, urlText);
			newNode.setHyperlink(urlText);
			isUpdateLayout = true;
		}
	} else {
		jMap.createNodeFromText(this, droptext);
		isUpdateLayout = true;
	}
	if(isUpdateLayout) {
		jMap.layoutManager.updateTreeHeightsAndRelativeYOfDescendantsAndAncestors(this);
		jMap.layoutManager.layout(true);
	}
}
///////////////////////
jNodeController.prototype.dragger = function () {
}
jNodeController.prototype.move = function (dx, dy, x, y) {
	if(jMap.mouseRightClicked) return;
	if(!jMap.movingNode || jMap.movingNode.removed && !jMap.mouseRightClicked){
		var selectedNodes = jMap.getSelecteds();	
		jMap.positionChangeNodes = selectedNodes;
		jMap.movingNode = RAPHAEL.rect();
		var mNode = jMap.movingNode;		
		mNode.ox = this.body.type == "rect" ? this.body.attr("x") : this.body.attr("cx");
	    mNode.oy = this.body.type == "rect" ? this.body.attr("y") : this.body.attr("cy");
		var bodyAttr = this.body.attr();						
		delete bodyAttr.scale;
		delete bodyAttr.translation;
		delete bodyAttr.gradient;	
		bodyAttr["fill-opacity"] = .2;
		bodyAttr.fill = this.background_color
		bodyAttr.stroke = this.edge.color;
		mNode.attr(bodyAttr);
		mNode.toBack();
		/*
		if(!this.isRootNode()){			
			mNode.edge_width = this.edge.width;
			mNode.connection = JinoUtil.connectionShadow(this.parent.body, mNode, this.connection.line.attr().stroke, this.isLeft()? true : false);
			mNode.connection.line.attr({fill: this.connection.line.attr().fill, "fill-opacity":.2, "stroke-opacity":.2});
		}
		*/
	}
	var mNode = jMap.movingNode;
//	mNode.setLocation(mNode.ox + dx, mNode.oy + dy);	
	var att = mNode.type == "rect" ? {x: mNode.ox + dx, y: mNode.oy + dy} : {cx: mNode.ox + dx, cy: mNode.oy + dy};
	mNode.attr(att);
	//mNode.connection && JinoUtil.connectionShadow(mNode.connection, null, null, this.isLeft()? true : false);
}
jNodeController.prototype.up = function (dx, dy, x, y) {
	if(jMap.movingNode && !jMap.movingNode.removed){
		jMap.movingNode.connection && jMap.movingNode.connection.line.remove();
		jMap.movingNode.remove();
		var testMovePosX = (dx>0)?dx:-dx;
		var testMovePosY = (dy>0)?dy:-dy;
		if(testMovePosX > NODE_MOVING_IGNORE || testMovePosY > NODE_MOVING_IGNORE)
			this.relativeCoordinate(dx, dy);
	}
}
///////////////////////
