/**
 * 
 * @author Hahm Myung Sun (hms1475@gmail.com)
 *
 * Copyright (c) 2011 JinoTech (http://www.jinotech.com) 
 * Licensed under the LGPL v3.0 license (http://www.gnu.org/licenses/lgpl.html).
 */
///////////////////////////////////////////////////////////////////////////////
//////////////////////////////
///////////////////////////////////////////////////////////////////////////////
jRect = function(parentNode, text, id, index, position){
	jRect.superclass.call(this, parentNode, text, id, index, position);
}
extend(jRect, jMindMapNode);
jRect.prototype.type = "jRect";
/**
 * 필요한 Raphael Element를 만든다.
 */
jRect.prototype.initElements = function() {
	this.body = RAPHAEL.rect();		
	this.text = RAPHAEL.text();		
	this.folderShape = RAPHAEL.circle(0, 0, FOLDER_RADIUS);
	this.wrapElements(this.body, this.text, this.folderShape);		
}
jRect.prototype.create = function(){
//	this.connection = this.parent && jMap.layoutManager.connection(this.parent.body, this.body, "#000", this.isLeft());	
	this.connection = null;
	switch(jMap.layoutManager.type) {
		case "jMindMapLayout" :
			this.connection = this.parent && new jLineBezier(this.parent, this);
			break;
		case "jTreeLayout" :
			this.connection = this.parent && new jLinePolygonal(this.parent, this);
			break;
		default :			
	}
	///////////////////////////////////////////////////
	var body = this.body;
	var text = this.text;
	var folderShape = this.folderShape;
	body.attr({r: NODE_CORNER_ROUND, rx: NODE_CORNER_ROUND, ry: NODE_CORNER_ROUND});
	this.setBackgroundColor(NODE_DEFALUT_COLOR);
	this.setEdgeColor(EDGE_DEFALUT_COLOR, 1);
	//var fontSize = this.fontSize;
	var fontWeight = 400;
	var fontFamily = 'Arial, Gulim, 굴림';
	var fontColor = '#000';
	if(!this.getParent()) {
		this.fontSize = NODE_FONT_SIZE_ENUM[0];
		fontWeight = 'bold';
	} else if(this.getParent() && this.getParent().isRootNode()) {
		this.fontSize = NODE_FONT_SIZE_ENUM[1];
		fontWeight = 'bold';
	} else {
		this.fontSize = NODE_FONT_SIZE_ENUM[2];
		fontWeight = 'normal';	
	}
	if(this.isRootNode()) {
		text.attr({'font-family': fontFamily, 'font-size': this.fontSize, "font-weight": fontWeight, fill: fontColor});
	} else {
		text.attr({'font-family': fontFamily, 'font-size': this.fontSize, "font-weight": fontWeight, 'text-anchor': 'start', fill: fontColor});
	}
	this.setTextExecute(this.plainText);
	///////////////////////////////////////////////////
}
jRect.prototype.getSize = function(){
	return {width:this.body.getBBox().width, height:this.body.getBBox().height};
}
jRect.prototype.setSize = function(width, height){
	this.body.attr({
		width: width,
		height: height
	});
}
/**
 * 노도의 좌표를 반환
 */
jRect.prototype.getLocation = function(){
	return {x:this.body.getBBox().x, y:this.body.getBBox().y};
}
jRect.prototype.setLocation = function(x, y){
	var body = this.body;
	if(x && !y){
		body.attr({x: x});
	} else if(!x && y) {
		body.attr({y: y});
	} else {
		body.attr({x: x, y: y});
	}
	this.updateNodeShapesPos();
}
/**
 * 노드의 크기를 계산한다.
 */
jRect.prototype.CalcBodySize = function(){
	var width = 0;
	var height = 0;
	var hGap = TEXT_HGAP;
	var vGap = TEXT_VGAP;
	var tempText = false;
	if (this.getText() == "") {
		this.text.attr({
			text: "_"
		});
		var tempText = true;
	}	
	width += this.text.getBBox().width;
	height += this.text.getBBox().height;	
	if (tempText) {
		this.text.attr({
			text: ""
		});		
	}	
	if (this.img) {		
		width = (width < this.img.getBBox().width) ? this.img.getBBox().width : width;
		height += this.img.getBBox().height;
	}
	if (this.foreignObjEl) {
		var foWidth = parseInt(this.foreignObjEl.getAttribute("width"));
		var foHeight = parseInt(this.foreignObjEl.getAttribute("height"));
		width = (width < foWidth) ? foWidth : width;
		height += foHeight;
	}
	if(this.hyperlink)
		width += this.hyperlink.getBBox().width + hGap/2 ;
	this.setSize(
		width + hGap,	
		height + vGap	
	);
	this.updateNodeShapesPos();
}
/**
 * 노드가 갖고 있는 여러 도형들(body, text, folderShape...)의 위치를 재정렬 한다.
 */
jRect.prototype.updateNodeShapesPos = function(){
	var hGap = TEXT_HGAP;
	var vGap = TEXT_VGAP;
	var currentHeightPos = 0;	
	var body = this.body;
	var text = this.text;
	var folderShape = this.folderShape;
	var img = this.img;
	var hyperlink = this.hyperlink;
	var foreignObj = this.foreignObjEl;	
	var x = body.getBBox().x;
	var y = body.getBBox().y;
	var fold_x = 0
	var fold_y = 0;
	switch(jMap.layoutManager.type) {
		case "jMindMapLayout" :
			fold_x = this.isLeft()? x : x + this.body.getBBox().width;
			fold_y = y + this.body.getBBox().height / 2;
			break;
		case "jTreeLayout" :
			fold_x = x + this.body.getBBox().width / 2;
			fold_y = y + this.body.getBBox().height;
			break;
		default :			
	}
	this.folderShape.attr({cx: fold_x, cy: fold_y});
	if (img) {
		var img_x = x + hGap/2;
		var img_y = y + vGap/2;
		if(this.isRootNode()) {
			img_x += (body.getBBox().width / 2) - (img.getBBox().width / 2) - hGap / 2;
		}
		img.attr({x: img_x, y: img_y});
		currentHeightPos += img.getBBox().height;
	}
	if (foreignObj) {
		var ob_x = x + hGap/2;
		var ob_y = y + currentHeightPos + vGap/2;		
		currentHeightPos += parseInt(foreignObj.getAttribute("height"));
		foreignObj.setAttribute("x", ob_x);
		foreignObj.setAttribute("y", ob_y);
	}
	if (text) {
		var text_x = x + hGap/2;
		var text_y = y + (vGap + text.getBBox().height) / 2; //this.body.getBBox().height / 2;
		if(this.isRootNode()) {
			text_x += body.getBBox().width / 2 - hGap / 2;
		}
		text_y += currentHeightPos;	
		text.attr({x: text_x, y: text_y});
	}	
	if (hyperlink) {
		var hyper_x = x + hGap;
		var text_width = text.getBBox().width;		
		if(img) hyper_x += (text_width > img.getBBox().width)? text_width : img.getBBox().width;
		else hyper_x += text_width;
		var hyper_y = y + text.getBBox().height / 2;
		hyper_y += img && img.getBBox().height / 2;
		hyperlink && hyperlink.attr({x: hyper_x, y: hyper_y});
	}
//	this.connection && jMap.layoutManager.connection(this.connection, null, null, this.isLeft());
	this.connection && this.connection.updateLine();
}
jRect.prototype.getInputPort = function(){
	var body = this.body.getBBox();    
	var body_width = 0;
	var body_height = 0;
	if(isFinite(body.width) && !isNaN(body.width)){
		body_width = body.width;
	}
	if(isFinite(body.height) && !isNaN(body.height)){
		body_height = body.height;
	}
	switch(jMap.layoutManager.type) {
		case "jMindMapLayout" :
			if(this.isRootNode()) {
				return {x: body.x + body_width / 2, y: body.y + body_height / 2};
			}
			if (this.isLeft()) {
				return {x: body.x + body_width + 1, y: body.y + body_height / 2};
			} else {
				return {x: body.x - 1, y: body.y + body_height / 2};
			}
			break;	
		case "jTreeLayout" :
			if(this.isRootNode()) return {x: body.x + body_width / 2, y: body.y + body_height};
			return {x: body.x + body_width / 2, y: body.y};
			break;	
		default :			
	}
}
jRect.prototype.getOutputPort = function(){
	var body = this.body.getBBox();    
	var body_width = 0;
	var body_height = 0;
	if(isFinite(body.width) && !isNaN(body.width)){
		body_width = body.width;
	}
	if(isFinite(body.height) && !isNaN(body.height)){
		body_height = body.height;
	}
	switch(jMap.layoutManager.type) {
		case "jMindMapLayout" :
			if(this.isRootNode()) {
				return {x: body.x + body_width / 2, y: body.y + body_height / 2};
			}
			if (this.isLeft()) {
				return {x: body.x - 1, y: body.y + body_height / 2};
			} else {
				return {x: body.x + body_width + 1, y: body.y + body_height / 2};
			}
			break;	
		case "jTreeLayout" :
			return {x: body.x + body_width / 2, y: body.y + body_height};
			break;	
		default :			
	}
}
jRect.prototype.toString = function () {
    return "jRect";
}
