/**
 * 
 * @author Hahm Myung Sun (hms1475@gmail.com)
 *
 * Copyright (c) 2011 JinoTech (http://www.jinotech.com) 
 * Licensed under the LGPL v3.0 license (http://www.gnu.org/licenses/lgpl.html).
 */

///////////////////////////////////////////////////////////////////////////////
/////////////////////////// jNodeControllerGuest ///////////////////////////////////
///////////////////////////////////////////////////////////////////////////////

jNodeControllerGuest = function(){}

jNodeControllerGuest.prototype.type= "jNodeControllerGuest";


jNodeControllerGuest.prototype.mousedown = function(e){
	var selectedNodes = jMap.getSelecteds();
	
	// 노드 하일라이팅
	if (e.ctrlKey) this.focus(false);	// control키 조합시 중복 선택
	else{
		if(!selectedNodes.contains(this)) {
			this.focus(true);
		}
	}
}

jNodeControllerGuest.prototype.mouseup = function(e){
	e = e || window.event;
}

jNodeControllerGuest.prototype.mousemove = function(e){
	e = e || window.event;
	
	// 폴딩되는 노드라면 커서 모양 변경
	if(!jMap.positionChangeNodes && this.isFoldingHit(e) && !this.isRootNode() && !this.getChildren().isEmpty()) {
		document.body.style.cursor = "url('/images/folding_blue.png'),default";
		//document.body.style.cursor = "crosshair";
	} else {
		document.body.style.cursor = "auto";
	}
	
}

jNodeControllerGuest.prototype.mouseover = function(e){
	e = e || window.event;
}

jNodeControllerGuest.prototype.mouseout = function(e){
	document.body.style.cursor = "auto";
}

jNodeControllerGuest.prototype.click = function(e){
	// 노드의 끝쪽 부분을 클릭하면 폴딩 및 언폴딩	
	if (this.isFoldingHit(e)) {
		// Folding & unFolding
		this.setFoldingExecute(!this.folded);
		jMap.layoutManager.updateTreeHeightsAndRelativeYOfDescendants(this);				
		jMap.layoutManager.updateTreeHeightsAndRelativeYOfAncestors(this);
		jMap.layoutManager.layout(true);
	}
}

jNodeControllerGuest.prototype.dblclick = function(e){}

jNodeControllerGuest.prototype.dragstart = function(e){
	e = e || window.event;
	if (e.preventDefault)
		e.preventDefault();
	else
		e.returnValue= false;
}

jNodeControllerGuest.prototype.dragenter = function(e){
	e = e || window.event;
	if (e.preventDefault)
		e.preventDefault();
	else
		e.returnValue= false;
}

jNodeControllerGuest.prototype.dragexit = function(e){
	e = e || window.event;
	if (e.preventDefault)
		e.preventDefault();
	else
		e.returnValue= false;
}

jNodeControllerGuest.prototype.drop = function(e){
	e = e || window.event;
	if (e.preventDefault)
		e.preventDefault();
	else
		e.returnValue= false;
}


///////////////////////// extend ////////////////////////////////////
jNodeControllerGuest.prototype.dragger = function () {}
jNodeControllerGuest.prototype.move = function (dx, dy, x, y) {}
jNodeControllerGuest.prototype.up = function (dx, dy, x, y) {}
///////////////////////// extend 끝////////////////////////////////////


