/**
 * 
 * @author Hahm Myung Sun (hms1475@gmail.com)
 *
 * Copyright (c) 2011 JinoTech (http://www.jinotech.com) 
 * Licensed under the LGPL v3.0 license (http://www.gnu.org/licenses/lgpl.html).
 */

///////////////////////////////////////////////////////////////////////////////
////////////////////////////////// jLine //////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////

/**
 * @param {jNode} node1	: 부모 Node
 * @param {jNode} node2	: 자신 Node
 */
jLine = function (node1, node2){
	this.node1 = node1;
	this.node2 = node2;
	
	var color = "#000";
    this.line = RAPHAEL.path().attr({stroke: color, fill: "none"});	
	
	// 전역 그룹이 설정되어 있다면
	if(jMap.groupEl){
		jMap.groupEl.appendChild(this.line.node);
	}
	
	this.line.toBack();
	
	this.draw();
}

jLine.prototype.type= "jLine";

jLine.prototype.updateLine = function(){
	this.draw();
}

jLine.prototype.getWidth = function(){
	var width = parseInt(this.node2.edge.width);
	if (isNaN(width)) width = 0;
	return width;
}

jLine.prototype.getColor = function(){
	return this.node2.edge.color;
}

jLine.prototype.show = function(){
	this.line.show();
}

jLine.prototype.hide = function(){
	this.line.hide();
}

jLine.prototype.remove = function(){
	this.line.remove();
}


// interface
jLine.prototype.draw = function() {}


