// PadDraw2.h : Declaration of the CPadDraw2

#ifndef __PADDRAW2_H_
#define __PADDRAW2_H_

#include "resource.h"       // main symbols
#include <atlctl.h>
#include "PadRecog2CP.h"
#include "engin/RecogMain.h"
#include "inc/mip/mippro.h"

#include <vector>
#include <string>
using namespace std;

#define TIMERID_RECOG_START		0x0001
#define TIMERID_PAD_POLLING		0x0002

#define DIRECT_SIGNPAD			0x01		// е LCD
#define DIRECT_CONTROL			0x02		// Ʈ ȭ鿡

#define PAD_LINE_WIDTH			2			// е  ȭ Ī 
#define PAD_OUT_COLOR			RGB(0, 0, 255)

/////////////////////////////////////////////////////////////////////////////
// CPadDraw2
class ATL_NO_VTABLE CPadDraw2 : 
	public CComObjectRootEx<CComSingleThreadModel>,
	public IDispatchImpl<IPadDraw2, &IID_IPadDraw2, &LIBID_PADRECOG2Lib>,
	public CComControl<CPadDraw2>,
	public IPersistStreamInitImpl<CPadDraw2>,
	public IOleControlImpl<CPadDraw2>,
	public IOleObjectImpl<CPadDraw2>,
	public IOleInPlaceActiveObjectImpl<CPadDraw2>,
	public IViewObjectExImpl<CPadDraw2>,
	public IOleInPlaceObjectWindowlessImpl<CPadDraw2>,
	public ISupportErrorInfo,
	public IConnectionPointContainerImpl<CPadDraw2>,
	public IPersistStorageImpl<CPadDraw2>,
	public ISpecifyPropertyPagesImpl<CPadDraw2>,
	public IQuickActivateImpl<CPadDraw2>,
	public IDataObjectImpl<CPadDraw2>,
	public IProvideClassInfo2Impl<&CLSID_PadDraw2, &DIID__IPadDraw2Events, &LIBID_PADRECOG2Lib>,
	public IPropertyNotifySinkCP<CPadDraw2>,
	public CComCoClass<CPadDraw2, &CLSID_PadDraw2>,
	public CProxy_IPadDraw2Events< CPadDraw2 >,
	public IObjectSafetyImpl< CPadDraw2, INTERFACESAFE_FOR_UNTRUSTED_CALLER | INTERFACESAFE_FOR_UNTRUSTED_DATA>
{
public:
	CPadDraw2();
	~CPadDraw2();
	/*
	{
		m_bWindowOnly = TRUE;
	}
	*/


DECLARE_REGISTRY_RESOURCEID(IDR_PADDRAW2)

DECLARE_PROTECT_FINAL_CONSTRUCT()

BEGIN_COM_MAP(CPadDraw2)
	COM_INTERFACE_ENTRY(IPadDraw2)
	COM_INTERFACE_ENTRY(IDispatch)
	COM_INTERFACE_ENTRY(IViewObjectEx)
	COM_INTERFACE_ENTRY(IViewObject2)
	COM_INTERFACE_ENTRY(IViewObject)
	COM_INTERFACE_ENTRY(IOleInPlaceObjectWindowless)
	COM_INTERFACE_ENTRY(IOleInPlaceObject)
	COM_INTERFACE_ENTRY2(IOleWindow, IOleInPlaceObjectWindowless)
	COM_INTERFACE_ENTRY(IOleInPlaceActiveObject)
	COM_INTERFACE_ENTRY(IOleControl)
	COM_INTERFACE_ENTRY(IOleObject)
	COM_INTERFACE_ENTRY(IPersistStreamInit)
	COM_INTERFACE_ENTRY2(IPersist, IPersistStreamInit)
	COM_INTERFACE_ENTRY(ISupportErrorInfo)
	COM_INTERFACE_ENTRY(IConnectionPointContainer)
	COM_INTERFACE_ENTRY(ISpecifyPropertyPages)
	COM_INTERFACE_ENTRY(IQuickActivate)
	COM_INTERFACE_ENTRY(IPersistStorage)
	COM_INTERFACE_ENTRY(IDataObject)
	COM_INTERFACE_ENTRY(IProvideClassInfo)
	COM_INTERFACE_ENTRY(IProvideClassInfo2)
	COM_INTERFACE_ENTRY_IMPL(IConnectionPointContainer)
	COM_INTERFACE_ENTRY(IObjectSafety)
END_COM_MAP()

BEGIN_PROP_MAP(CPadDraw2)
	PROP_DATA_ENTRY("_cx", m_sizeExtent.cx, VT_UI4)
	PROP_DATA_ENTRY("_cy", m_sizeExtent.cy, VT_UI4)
	// Example entries
	// PROP_ENTRY("Property Description", dispid, clsid)
	// PROP_PAGE(CLSID_StockColorPage)
END_PROP_MAP()

BEGIN_CONNECTION_POINT_MAP(CPadDraw2)
	CONNECTION_POINT_ENTRY(IID_IPropertyNotifySink)
	CONNECTION_POINT_ENTRY(DIID__IPadDraw2Events)
END_CONNECTION_POINT_MAP()

BEGIN_MSG_MAP(CPadDraw2)
	CHAIN_MSG_MAP(CComControl<CPadDraw2>)
	DEFAULT_REFLECTION_HANDLER()
	MESSAGE_HANDLER(WM_TIMER, OnTimer)
	MESSAGE_HANDLER(WM_LBUTTONDOWN, OnLButtonDown)
	MESSAGE_HANDLER(WM_CREATE, OnCreate)
	MESSAGE_HANDLER(WM_DESTROY, OnDestroy)
	MESSAGE_HANDLER(WM_LBUTTONUP, OnLButtonUP)
	MESSAGE_HANDLER(WM_MOUSEMOVE, OnMouseMove)
END_MSG_MAP()
// Handler prototypes:
//  LRESULT MessageHandler(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
//  LRESULT CommandHandler(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled);
//  LRESULT NotifyHandler(int idCtrl, LPNMHDR pnmh, BOOL& bHandled);



// ISupportsErrorInfo
	STDMETHOD(InterfaceSupportsErrorInfo)(REFIID riid)
	{
		static const IID* arr[] = 
		{
			&IID_IPadDraw2,
		};
		for (int i=0; i<sizeof(arr)/sizeof(arr[0]); i++)
		{
			if (InlineIsEqualGUID(*arr[i], riid))
				return S_OK;
		}
		return S_FALSE;
	}

// IViewObjectEx
	DECLARE_VIEW_STATUS(VIEWSTATUS_SOLIDBKGND | VIEWSTATUS_OPAQUE)

// IPadDraw2
private:
	LONG m_nActMode;				// Է  (1 : SignPad, 2 : Mouse)
	BOOL m_bLBDown;					// 콺  ư ȴ  
	POINT m_tPrevPos;				// 콺  ġ 

	// -------------- SignPad  -----------------------------------------
	BOOL m_bExistSignpad;			// е尡 ִ 
	BOOL m_bOpenedSignpad;			// е Ʈ Open 
	BOOL m_bStartSign;				//  ۵Ǿ 
	string m_strModelName;			// е 𵨸
	string m_strVersion;			// е 
	LONG m_nSignpadModel; 
	LONG m_nComPort;				// е Ʈ
	LONG m_nLanguage;				// е忡  (1: ѱ, 2: )
	LONG m_nPadLineWith;			// е  β

	LONG m_nPadWidth;				// е  ũ
	LONG m_nPadHeight;				// е  ũ
	
	// -------------- ν  --------------------------------------------
	WORD m_result[11];				// ν 
	DWORD m_nRecogMode;				// ν 
	BYTE m_szRam[200*1024];			// νĿ   
	LONG m_nStrokeCnt;				// ȹ īƮ 
	RECT m_writingRect;				// Է  

	LONG m_nRecogWaitTime;			// ν  ð(ȹ    üũ)

	vector <POINT> m_vecStroke;			// ȹ ġ ͸ ϱ  ̳( )
	vector <POINT> m_FilteredStroke;	// ȹ ġ ͸ ϱ  ̳( )

	//--------------  Ÿ ----------------------------------------------------
	string m_strTempPath;			// Ʈ ӽ 
	HDC m_hMemDC;					// ޸ DC 
	HBITMAP m_hBM;					// Ʈ ڵ(޸ DC(h_MemDC) Ǵ Ʈ)

	BOOL m_bDisplayCharAtCtrl;		// е忡 ǥ ڸ Ʈѿ  ǥ 

	char m_szFont[255];				// Ʈ
	BOOL m_bNeedCleanMore;
	LONG m_nDrawScope;				// ڸ Է  ̴ (0x01 : Ʈ ȭ, 0x02 : е)
	LONG m_nShowScope;				// ڸ ǥҶ  (0x01 : Ʈ ȭ, 0x02 : е)

	//------------- ü ------------------
	SIZE m_nOrder[20];				//ȹ ۰  ȣ
	int m_nAllPts;					//Էµ 
	int	m_nCountStroke;				//ȹ(е忡   콺 Ŭ(Up)  )
	int m_nPts[20];					//ȹ ̷ 
	POINT m_AllVecStroke[20][1000];	//ȹ
	//-----------------------------------------
	

public:
	STDMETHOD(get_Name)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_Name)(/*[in]*/ long newVal);
	STDMETHOD(testmodule)();
	STDMETHOD(get_DrawScope)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_DrawScope)(/*[in]*/ long newVal);
	STDMETHOD(get_ShowScope)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_ShowScope)(/*[in]*/ long newVal);
	STDMETHOD(SetFont)(BSTR strVal);
	STDMETHOD(StartInputWithHanja)(BSTR strVal);
	STDMETHOD(StartInputWithClear)();
	STDMETHOD(get_RecogWaitTime)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_RecogWaitTime)(/*[in]*/ long newVal);
	STDMETHOD(ClearLCDDisplay)();
	STDMETHOD(FinishInput)();
	STDMETHOD(StartInput)();
	STDMETHOD(Restart)();
	STDMETHOD(ShowHanja)(BSTR strVal);
	STDMETHOD(get_RecogResult)(/*[out, retval]*/ BSTR *pVal);

	HRESULT OnDraw(ATL_DRAWINFO& di);
	LRESULT OnLButtonDown(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
	LRESULT OnLButtonUP(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
	LRESULT OnMouseMove(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
	LRESULT OnCreate(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
	LRESULT OnDestroy(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
	LRESULT OnTimer(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
	BOOL	DoRecog_DUMMY(void);
	void	DoRecogByBNNetwork();

private:
	VOID ClearStrokeBuffer();
	BOOL OpenSignpad();
	BOOL CloseSignPad();

	BOOL StartSignpad();
	BOOL FinishSignpad();

	BOOL ReadSignPadData(BOOL bInputEnd);
	VOID ClearView();	
	VOID MakeBitmapFile(HDC hDCBitmap, HBITMAP hbmBitmap, WORD BitCount);
	
	
//public:
//	BOOL DoRecog_DUMMY;
//	~CPadDraw();
//	void ClearView();
//	void ReadSignPadData();
//
//	HRESULT OnDraw(ATL_DRAWINFO& di);
//	LRESULT OnTimer(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
//	LRESULT OnLButtonDown(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
//	LRESULT OnCreate(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
//	LRESULT OnDestroy(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
//	LRESULT OnLButtonUP(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
//	LRESULT OnMouseMove(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);

	//   ĭ(0, 1, 2, 3....nSkip) ǳ  
	BOOL StrokeFilter_1(const vector<POINT> & src, vector<POINT> & result, int nSkip)
	{
		int i, nLast;

		if(src.size() == 0) return TRUE;

		//ǳ 鼭 Ʈ Ѵ.
		for(i=0; i<src.size(); i=i+nSkip)
		{
			result.push_back(src[i]);
			nLast = i;
		}

		// Ʈ ߰Ѵ.
		if( ((src.size()-1) != nLast) && (i > 1) )
		{
			result.push_back(src[src.size()-1]);
		}
		
		return TRUE;
	}


	//ġ X Y ѹθ Ѵٸ 
	BOOL StrokeFilter_2(const vector<POINT> & src, vector<POINT> & result)
	{
		int i, nDiff;

		//////////////////////////////////
		//CString strTemp;
		//strTemp.Format(_T("src.size() = %d\n"), src.size());
		//TRACE(strTemp);
		//////////////////////////////////

		if(src.size() == 0) return TRUE;

		for(i=0;i<src.size()-1;i++)		//  Ʈ ˻ ʿ 
		{
			result.push_back(src[i]);

			nDiff = abs(src[i].x - src[i+1].x) +  abs(src[i].y - src[i+1].y);
			if(nDiff == 1)
			{
				i++;
			}
		}
		
		return TRUE;
	}


	//  ϴ 
	BOOL StrokeFilter_3(const vector<POINT> & src, vector<POINT> & result)
	{
		/*
		int i, j;

		vector<POINT> arrType;

		for(i=1;i<src.size()-1;i++)
		{
				
		}
		*/
		return TRUE;
	}

	BOOL AddPoint_DUMMY(POINT pt)
	{
		return TRUE;
	}

	BOOL EndStroke_DUMMY()
	{
		return TRUE;
	}

};
extern CRecogMain theRecog;

#endif //__PADDRAW2_H_
