// RecogCore.h: interface for the CRecogCore class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_RECOGCORE_H__31C4F11B_63D9_40D9_9F95_DE2010ACD39D__INCLUDED_)
#define AFX_RECOGCORE_H__31C4F11B_63D9_40D9_9F95_DE2010ACD39D__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
#include "..\Define.h"
class CRecogCore  
{
public:
	CRecogCore();
	virtual ~CRecogCore();

	int BNNum;

	int m_path[MAXSTROKENUM][MAXSAMNUM][MAXSTROKENUM];
	float m_dis[MAXSTROKENUM][MAXSAMNUM];
	BOOL m_flag[MAXSTROKENUM][MAXSAMNUM];


	void	EndDIC();
	BOOL	LoadDic();
	BOOL	LoadBN(DigitBN* pBN,FILE* file);
	BOOL	SaveBN(DigitBN *pBN, FILE *file);

	BOOL	deleteBN(DigitBN *pBN);
	BOOL	InitBN(DigitBN *pBN,int strokeNum,int charId);
	BOOL	CreateParentLink(DigitBN *pBN);

	float	FowordStroke(DigitBN *pBN, int StrokeId);
	float	FowordBN(DigitBN *pBN);

	BOOL	SetDataInBN(DigitBN *pBN,OVR_POINT* pPts,int* pSelNo,int SelNum);
	void	SetDataInStroke(DigitBN *pBN, int StrokeId,OVR_POINT* pPts,int st,int ed);
	void	SetEndDataInStroke(DigitBN *pBN, int StrokeId,OVR_POINT* pPts,int st,int ed);

	
	float	GetStrokeSegByDynamicProgram(DigitBN *pBN,OVR_POINT* pPts,
											int* pSamNo,int& SamNum);

	DigitBN*  m_BN;

};

#endif // !defined(AFX_RECOGCORE_H__31C4F11B_63D9_40D9_9F95_DE2010ACD39D__INCLUDED_)
