// Code.cpp: implementation of the CCode class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "kssm.h" // KSC5601 ->  ڵ ȯǥ
#include "ksc5601.h" //  -> KSC5601 ڵ ȯǥ
#include "cjz.h"


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CCode::CCode()
{

}

CCode::~CCode()
{

}
// convert KSC5601 to C,J,Z
/*
________________________________________________________________
  
Function Name	: GetKoreanType
	
Purpose			: Էµ ڵκ ġĢ ˾Ƴ°
		
Input			:
	code		: ڵ

Output			: No	

Return Value	: ġĢȣ ( 0 ~ 5 )
dl
Description		: 

Ref Journal		: "Bayesian Network Modeling of Hangul Characters for On-line Handwriting Recognition"  
					Sung-Jung Cho*, Jin H. Kim   ICDAR (2003), pp. 207-211 vol.1
	
date			: 2009/06/5
________________________________________________________________
*/
int CCode::GetKoreanType(WORD code)
{
	int type;
	int CJZid[3];
	int r = Code2CJZid(code, CJZid);
	if(r== -1){
		return -1;
	}
	if(r == 2 ){
		type =toJungType[CJZid[1]];
		
	}else{ // r == 3
		type =toJungType[CJZid[1]]+3;
	}
	return type;
}
/*
________________________________________________________________
  
Function Name	: GetJungType
	
Purpose			: Էµ ߼Idκ ߼( ߼/ ߼/߼) ˾Ƴ°
		
Input			:
	Jid			: ߼Id

Output			: No	

Return Value	: ߼(0: ߼,1: ߼,2:߼)

Description		: No

Ref Journal		: No
	
date			: 2009/06/5
________________________________________________________________
*/
int CCode::GetJungType(int Jid)
{
	if(Jid == -1) return -1;
	int type =toJungType[Jid];
	return type;
}
/*
________________________________________________________________
  
Function Name	: GetKoreanType
	
Purpose			: Էµ  ȣκ ġĢ ˾Ƴ°
		
Input			:
	CJZid		: ȣ

Output			: No	

Return Value	: ġĢȣ

Description		: 

Ref Journal		: "Bayesian Network Modeling of Hangul Characters for On-line Handwriting Recognition"  
					Sung-Jung Cho*, Jin H. Kim   ICDAR (2003), pp. 207-211 vol.1
	
date			: 2009/06/5
________________________________________________________________
*/
int CCode::GetKoreanType(int CJZid[3])
{
	int type;
	if(CJZid[0]== -1 || CJZid[1] == -1){
		return -1;
	}
	if(CJZid[2]== -1 ){
		type =toJungType[CJZid[1]];
		
	}else{ // r == 3
		type =toJungType[CJZid[1]]+3;
	}
	return type;
}
/*
________________________________________________________________
  
Function Name	: GetCJZNum
	
Purpose			: Էµ Idκ ڸ𰳼 
		
Input			:
	CJZid		: ȣ

Output			: No	

Return Value	: ڸ𰳼

Description		:  '' Id -1,

Ref Journal		: No
	
			  
date			: 2009/06/5
________________________________________________________________
*/
int CCode::GetCJZNum(int CJZid[3])
{
	int num = 0;
	if(CJZid[0]== -1 || CJZid[1] == -1){
		return 1;
	}
	if(CJZid[2]== -1 ){
		num = 2;
		
	}else{ // r == 3
		num = 3;
	}
	return num;
}

// convert KSC5601 to C,J,Z
/*
________________________________________________________________
  
Function Name	: Code2CJZid
	
Purpose			: Էµ ڵκ Id 
		
Input			:
	code		: ڵ

Output			: 
	CJZid		:  Id	

Return Value	: ڸ𰳼

Description		:  '' Id -1,

Ref Journal		: No
	
date			: 2009/06/5
________________________________________________________________
*/
int CCode::Code2CJZid(WORD code, int CJZid[3])
{
	int len = 0;
	unsigned int msb, lsb;
	WORD codekssm;
	lsb = HIBYTE(code); msb = LOBYTE(code);
	codekssm = toKSSM[msb-0xb0][lsb-0xa1];
	CJZid[0] = toCId[CHO_SUNG(codekssm)];
	CJZid[1] = toJId[JUNG_SUNG(codekssm)];
	CJZid[2] = toZId[ZONG_SUNG(codekssm)];
	if(CJZid[0]== -1 || CJZid[1] == -1){
		return -1;
	}
	if(CJZid[2]== -1 ){
		return 2;
	}
	return 3;
}
// convert C,J,Z to KSC5601
/*
________________________________________________________________
  
Function Name	: CJZid2Code
	
Purpose			: Էµ Idκ ڵ带 
		
Input			:
	CJZid		: Id		

Output			: 
	code		: ڵ

Return Value	:  ڵ尡 2350߿  TRUE, FALSE

Description		: 

Ref Journal		: No
	
date			: 2009/06/5
________________________________________________________________
*/
BOOL CCode::CJZid2Code(int CJZid[3],WORD& code )
{
	int len = 0;
	WORD codekssm=0x0001;
	codekssm = codekssm<<5;
	code = NONCODE;
	if(CJZid[0]== -1 || CJZid[1] == -1){
		return FALSE;
	}
	codekssm += toCkssm[CJZid[0]];
	codekssm = codekssm<<5;
	codekssm += toJkssm[CJZid[1]];
	codekssm = codekssm<<5;
	if(CJZid[2] == -1)
		codekssm += 0x01;
	else
		codekssm += toZkssm[CJZid[2]];

	int index = codekssm-0x8861;
	if(index>19286 ||index<0  )return FALSE;
	code = toKSC5601[index];
	if(code == NONCODE) return FALSE;
	unsigned int msb, lsb;
	lsb = LOBYTE(code); msb = HIBYTE(code);
	code = MAKEWORD(msb,lsb);
	return TRUE;
}

/*
________________________________________________________________
  
Function Name	: CJZid2CJZCode
	
Purpose			: Էµ Idκ ׿   ڵ带 
		
Input			:
	CJZid		: Id		

Output			: 
	CJZcd		: ڵ

Return Value	: No

Description		: 

Ref Journal		: No
	
date			: 2009/06/5
________________________________________________________________
*/
void CCode::CJZid2CJZCode(int CJZid[3],WORD CJZcd[3] )
{
	if(CJZid[0]!=-1)
		CJZcd[0] = toChok5601[CJZid[0]];
	else
		CJZcd[0] = SPACETWO;
	if(CJZid[1]!=-1)
		CJZcd[1] = toJungk5601[CJZid[1]];
	else
		CJZcd[1] = SPACETWO;
	if(CJZid[2]!=-1)
		CJZcd[2] = toZongk5601[CJZid[2]];
	else
		CJZcd[2] = SPACETWO;
	return ;
}
/*
________________________________________________________________
  
Function Name	: Cid2CCode
	
Purpose			: Էµ ʼIdκ ׿  ʼ ڵ带 
		
Input			:
	Cid			: ʼId		

Output			: No	

Return Value	: ʼڵ

Description		: 

Ref Journal		: No
	
date			: 2009/06/5
________________________________________________________________
*/
WORD CCode::Cid2CCode(int Cid )
{
	WORD CCd;
	if(Cid>= 0 && Cid < CHONum)
		CCd = toChok5601[Cid];
	else
		CCd = SPACETWO;
	return CCd;
}
/*
________________________________________________________________
  
Function Name	: Jid2JCode
	
Purpose			: Էµ ߼Idκ ׿  ߼ ڵ带 
		
Input			:
	Jid			: ߼Id		

Output			: No	

Return Value	: ߼ڵ

Description		: 

Ref Journal		: No
	
date			: 2009/06/5
________________________________________________________________
*/
WORD CCode::Jid2JCode(int Jid )
{
	WORD JCd;
	if(Jid>= 0 && Jid < JUNGNum)
		JCd = toJungk5601[Jid];
	else
		JCd = SPACETWO;
	return JCd;
}
/*
________________________________________________________________
  
Function Name	: Zid2ZCode
	
Purpose			: Էµ Idκ ׿   ڵ带 
		
Input			:
	Zid			: Id		

Output			: No	

Return Value	: ڵ

Description		: 

Ref Journal		: No
	
date			: 2009/06/5
________________________________________________________________
*/
WORD CCode::Zid2ZCode(int Zid )
{
	WORD ZCd;
	if(Zid>= 0 && Zid < ZONGNum)
		ZCd = toZongk5601[Zid];
	else
		ZCd = SPACETWO;
	return ZCd;
}
/*
________________________________________________________________
  
Function Name	: Sid2SCode
	
Purpose			: Էµ  Ǵ Idκ ׿  ڵ带 
		
Input			:
	SymId		:  Ǵ Id		

Output			: No	

Return Value	:  Ǵ ڵ

Description		: 

Ref Journal		: No
	
date			: 2009/06/5
________________________________________________________________
*/
WORD CCode::Sid2SCode(int SymId )
{
	static char TwoCode[]="£ãģţƣǣȣɣʣˣ̣ͣΣϣУѣңӣԣգ֣ףأ٣ڣ";
	WORD SCd;
	if(SymId>= 0 && SymId < SymbolNum)
		SCd = MAKEWORD(TwoCode[SymId*2],TwoCode[SymId*2+1]);
	else
		SCd = SPACETWO;
	return SCd;
}

/*
________________________________________________________________
  
Function Name	: MakeKoreanCodeTable
	
Purpose			: 2350  ڵǥ
		
Input			: No		

Output			: No	

Return Value	: 2350  ڵǥ

Description		: 

Ref Journal		: No
	
date			: 2009/06/5
________________________________________________________________
*/
WORD* CCode::MakeKoreanCodeTable()
{
	WORD * code = (WORD*)malloc(KNum*sizeof(WORD));
	int i=0;
	for (char msb = (char)0xb0; msb <= (char) 0xc8; msb++){
		for (char lsb = (char)0xa1; lsb <= (char) 0xfe; lsb++){
			code[i++] = MAKEWORD(msb,lsb);
		}
	}

	return code;
}

/*
________________________________________________________________
  
Function Name	: Half2TwoCode
	
Purpose			: ݰ   Ǵ ڵ带 ޾Ƽ  ڵ ȯ
		
Input			: 
	b			: ݰڵ	

Output			: 
	w			: ȯ ڵ

Return Value	: ȯ̸ TRUE,̸ FALSE

Description		: 

Ref Journal		: No
	
date			: 2009/06/5
________________________________________________________________
*/
BOOL CCode::Half2TwoCode(char b,WORD& w)
{
	static char HalfCode[]="0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
	static char TwoCode[]="£ãģţƣǣȣɣʣˣ̣ͣΣϣУѣңӣԣգ֣ףأ٣ڣ";
	int i=0;
	BOOL flag = FALSE;
	for (i = 0; i < SymbolNum; i++){
		if(HalfCode[i] == b){
			flag = TRUE;
			w = MAKEWORD(TwoCode[i*2],TwoCode[i*2+1]);
			break;
		}
	}
	return flag;
}

