// RecogCore.cpp: implementation of the CJamoBNCore class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "RecogCore.h"
#include <math.h>

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CJamoBNCore::CJamoBNCore()
{
}

CJamoBNCore::~CJamoBNCore()
{
}
/*
________________________________________________________________
  
Function Name	: CreateParentLink
	
Purpose			: ڸ ִ  鿡 Ͽ  θ踦 Ѵ.
		
Input			: 
	pBN			: ڸ	

Output			: No	

Return Value	: ̸ TRUE,̸ FALSE

Description		:  Լ ̽ɵ 3̶  ڸ  ȹ ִ
				  9  Ͽ  θ踦 Ѵ.				  

Ref Journal		: No
	
date			: 2009/06/5
________________________________________________________________
*/
BOOL CJamoBNCore::CreateParentLink(JAMOBN *pBN)
{
	int StrkNum = pBN->StrokeNum;
	if(StrkNum<1)return FALSE;
	int i,j,st;
	StrokeModel* pStroke,*pPreStroke;
	PointModel* pPoint;
	for(i=0;i<pBN->StrokeNum;i++){
		pStroke = &(pBN->pStroke[i]);
		pStroke->Prop = 0;
		pStroke->ThDis = MAXDIS;
		if(i==0 ){
			st=0;
			for(j=st;j<WSRS;j++){
				pStroke->pPoint[j] = (PointModel*)malloc(sizeof(PointModel));
			}
		}
		else{
			st=1;
			for(j=st;j<WSRS;j++){
				pStroke->pPoint[j] = (PointModel*)malloc(sizeof(PointModel));
			}
			pPreStroke = &(pBN->pStroke[i-1]);
			pStroke->pPoint[0] = pPreStroke->pPoint[WSRS-1];
		}
		///////////// 0  //////////////////
		pPoint = pStroke->pPoint[0];
		if(i==0){
			pPoint->countParents = 0;
			pPoint->W[0] = (float*)malloc(sizeof(float));
			pPoint->W[1] = (float*)malloc(sizeof(float));
		}
		///////////// 1  //////////////////
		pPoint = pStroke->pPoint[1];
		pPoint->countParents = 2;
		pPoint->parent = (PointModel**)malloc(pPoint->countParents*sizeof(PointModel*));
		pPoint->parent[0] = pStroke->pPoint[0];
		pPoint->parent[1] = pStroke->pPoint[2];
		pPoint->W[0] = (float*)malloc((pPoint->countParents*2+1)*sizeof(float));
		pPoint->W[1] = (float*)malloc((pPoint->countParents*2+1)*sizeof(float));
		///////////// 2  //////////////////
		pPoint = pStroke->pPoint[2];
		pPoint->countParents = 2;
		pPoint->parent = (PointModel**)malloc(pPoint->countParents*sizeof(PointModel*));
		pPoint->parent[0] = pStroke->pPoint[0];
		pPoint->parent[1] = pStroke->pPoint[4];
		pPoint->W[0] = (float*)malloc((pPoint->countParents*2+1)*sizeof(float));
		pPoint->W[1] = (float*)malloc((pPoint->countParents*2+1)*sizeof(float));
		///////////// 3  //////////////////
		pPoint = pStroke->pPoint[3];
		pPoint->countParents = 2;
		pPoint->parent = (PointModel**)malloc(pPoint->countParents*sizeof(PointModel*));
		pPoint->parent[0] = pStroke->pPoint[2];
		pPoint->parent[1] = pStroke->pPoint[4];
		pPoint->W[0] = (float*)malloc((pPoint->countParents*2+1)*sizeof(float));
		pPoint->W[1] = (float*)malloc((pPoint->countParents*2+1)*sizeof(float));
		///////////// 4  //////////////////
		pPoint = pStroke->pPoint[4];
		pPoint->countParents = 2;
		pPoint->parent = (PointModel**)malloc(pPoint->countParents*sizeof(PointModel*));
		pPoint->parent[0] = pStroke->pPoint[0];
		pPoint->parent[1] = pStroke->pPoint[WSRS-1];
		pPoint->W[0] = (float*)malloc((pPoint->countParents*2+1)*sizeof(float));
		pPoint->W[1] = (float*)malloc((pPoint->countParents*2+1)*sizeof(float));
		///////////// 5  //////////////////
		pPoint = pStroke->pPoint[5];
		pPoint->countParents = 2;
		pPoint->parent = (PointModel**)malloc(pPoint->countParents*sizeof(PointModel*));
		pPoint->parent[0] = pStroke->pPoint[4];
		pPoint->parent[1] = pStroke->pPoint[6];
		pPoint->W[0] = (float*)malloc((pPoint->countParents*2+1)*sizeof(float));
		pPoint->W[1] = (float*)malloc((pPoint->countParents*2+1)*sizeof(float));
		///////////// 6  //////////////////
		pPoint = pStroke->pPoint[6];
		pPoint->countParents = 2;
		pPoint->parent = (PointModel**)malloc(pPoint->countParents*sizeof(PointModel*));
		pPoint->parent[0] = pStroke->pPoint[4];
		pPoint->parent[1] = pStroke->pPoint[WSRS-1];
		pPoint->W[0] = (float*)malloc((pPoint->countParents*2+1)*sizeof(float));
		pPoint->W[1] = (float*)malloc((pPoint->countParents*2+1)*sizeof(float));
		///////////// 7  //////////////////
		pPoint = pStroke->pPoint[7];
		pPoint->countParents = 2;
		pPoint->parent = (PointModel**)malloc(pPoint->countParents*sizeof(PointModel*));
		pPoint->parent[0] = pStroke->pPoint[6];
		pPoint->parent[1] = pStroke->pPoint[WSRS-1];
		pPoint->W[0] = (float*)malloc((pPoint->countParents*2+1)*sizeof(float));
		pPoint->W[1] = (float*)malloc((pPoint->countParents*2+1)*sizeof(float));
		///////////// 8  //////////////////
		pPoint = pStroke->pPoint[8];
		pPoint->countParents = i+1;
		pPoint->parent = (PointModel**)malloc(pPoint->countParents*sizeof(PointModel*));
		for(j=0;j<pPoint->countParents;j++){
			pPreStroke = &(pBN->pStroke[j]);
			pPoint->parent[j] = pPreStroke->pPoint[0];
		}
		pPoint->W[0] = (float*)malloc((pPoint->countParents*2+1)*sizeof(float));
		pPoint->W[1] = (float*)malloc((pPoint->countParents*2+1)*sizeof(float));
	}
	return TRUE;
}
/*
________________________________________________________________
  
Function Name	: deleteBN
	
Purpose			: ڸ Ҵ ޸  .
		
Input			: 
	pBN			: ڸ	

Output			: No	

Return Value	: ̸ TRUE,̸ FALSE

Description		: 

Ref Journal		: No
	
date			: 2009/06/5
________________________________________________________________
*/
BOOL CJamoBNCore::deleteBN(JAMOBN *pBN)
{
	int StrkNum = pBN->StrokeNum;
	if(StrkNum<1)return FALSE;
	int i,j,st;
	StrokeModel* pStroke;
	PointModel* pPoint;
	for(i=0;i<pBN->StrokeNum;i++){
		pStroke = &(pBN->pStroke[i]);

		if(i==0 )st=0;
		else st=1;
		for(j=st;j<WSRS;j++){
			pPoint = pStroke->pPoint[j];
			if(pPoint->countParents>0)free(pPoint->parent);
			free(pPoint->W[0]);
			free(pPoint->W[1]);
			free(pStroke->pPoint[j]);
		}
	}
	free(pBN->pStroke);
	return TRUE;
}
/*
________________________________________________________________
  
Function Name	: InitBN
	
Purpose			: ȹ ڸId,׸ ׷ȣκ ϳ ڸ .
		
Input			: 
	pBN			: ڸ	
	strokeNum	: ȹ
	JamoId		: ڸId
	GrpId		: ׷Id

Output			: No	

Return Value	: ̸ TRUE,̸ FALSE

Description		: 

Ref Journal		: No
	
date			: 2009/06/5
________________________________________________________________
*/
BOOL CJamoBNCore::InitBN(JAMOBN *pBN,int strokeNum,int JamoId,int GrpId)
{
	if(strokeNum < 1) return FALSE;
	pBN->JamoId = JamoId;
	pBN->GrpId = GrpId;
	pBN->StrokeNum = strokeNum;
	pBN->ThDis = MAXDIS;
	pBN->pStroke = (StrokeModel*)malloc(pBN->StrokeNum*sizeof(StrokeModel));//new StrokeModel[pBN->StrokeNum];
	BOOL b = CreateParentLink(pBN);
	return b;
}
/*
________________________________________________________________
  
Function Name	: LoadBN
	
Purpose			: Ϸκ ڸ Ѵ. 
		
Input			: 
	pBN			: ڸ	
	file		: о̷ ڸ ִ ϱü	

Output			: No	

Return Value	: 缺̸ TRUE,̸ FALSE

Description		: 

Ref Journal		: No
	
date			: 2009/06/5
________________________________________________________________
*/
BOOL CJamoBNCore::LoadBN(JAMOBN *pBN, FILE *file)
{
	StrokeModel* pStroke;
	PointModel* pPoint;
	int i,j,st,paNum;
	fread(&(pBN->JamoId),sizeof(int),1,file);
	fread(&(pBN->GrpId),sizeof(int),1,file);
	fread(&(pBN->StrokeNum),sizeof(int),1,file);
	fread(&(pBN->ThDis),sizeof(float),1,file);

	if(pBN->StrokeNum < 1) return FALSE;
	pBN->pStroke = (StrokeModel*)malloc(pBN->StrokeNum*sizeof(StrokeModel));

	CreateParentLink(pBN);
	for(i=0;i<pBN->StrokeNum;i++){
		pStroke = &(pBN->pStroke[i]);
		fread(&(pStroke)->Prop,sizeof(int),1,file);
		fread(&(pStroke->ThDis),sizeof(float),1,file);

		if(i==0 )st=0;
		else st=1;
		for(j=st;j<WSRS;j++){
			pPoint = pStroke->pPoint[j];
			fread(pPoint->ramda,sizeof(float),2,file);
			fread(pPoint->matrix,sizeof(float),2*2,file);
			paNum = pPoint->countParents;
			fread(pPoint->W[0],sizeof(float),(paNum*2+1),file);
			fread(pPoint->W[1],sizeof(float),(paNum*2+1),file);
			memset(pPoint->P,0,sizeof(float)*2);


		}
	}
	return TRUE;
}
/*
________________________________________________________________
  
Function Name	: LoadBN
	
Purpose			: ڸ Ͽ Ѵ. 
		
Input			: 
	pBN			: ڸ	
	file		: Ϸ ϱü	

Output			: No	

Return Value	: ̸ TRUE,̸ FALSE

Description		: 

Ref Journal		: No
	
date			: 2009/06/5
________________________________________________________________
*/
BOOL CJamoBNCore::SaveBN(JAMOBN *pBN, FILE *file)
{
	StrokeModel* pStroke;
	PointModel* pPoint;
	int i,j,st,paNum;
	if(pBN->StrokeNum < 1) return FALSE;
	fwrite(&(pBN->JamoId),sizeof(int),1,file);
	fwrite(&(pBN->GrpId),sizeof(int),1,file);
	fwrite(&(pBN->StrokeNum),sizeof(int),1,file);
	fwrite(&(pBN->ThDis),sizeof(float),1,file);

	for(i=0;i<pBN->StrokeNum;i++){
		pStroke = &(pBN->pStroke[i]);
		fwrite(&(pStroke->Prop),sizeof(int),1,file);
		fwrite(&(pStroke->ThDis),sizeof(float),1,file);
		if(i==0 )st=0;
		else st=1;
		for(j=st;j<WSRS;j++){
			pPoint = pStroke->pPoint[j];
			fwrite(pPoint->ramda,sizeof(float),2,file);
			fwrite(pPoint->matrix,sizeof(float),2*2,file);
			paNum = pPoint->countParents;
			fwrite(pPoint->W[0],sizeof(float),(paNum*2+1),file);
			fwrite(pPoint->W[1],sizeof(float),(paNum*2+1),file);
		}
	}
	return TRUE;
}
/*
________________________________________________________________
  
Function Name	: ForwardBN
	
Purpose			: ڸ Ȯ 
		
Input			: 
	pBN			: ڸ	
	deep		: ̽ɵ

Output			: No	

Return Value	: ڸ Ȯ

Description		:  ڸ ִ  ȹ Ȯ  Ȯ ȴ.
				  δ αȮ ̿Ͽ  ȴ.

Ref Journal		: "Bayesian network modeling of strokes and their relationships for on-line handwriting 
					recognition"   Sung-Jung Cho*, Jin H. Kim   Pattern Recognition 37(2004) 253-264p
	
date			: 2009/06/5
________________________________________________________________
*/
float CJamoBNCore::ForwardBN(JAMOBN *pBN,int deep)
{
	float dis=0.0f;
	int StrkNum = pBN->StrokeNum;
	if(StrkNum<1)return MAXDIS;
	int i;
	for(i=0;i<pBN->StrokeNum;i++){
		dis += ForwardStroke(pBN,i,deep);
	}
	return dis;
}
/*
________________________________________________________________
  
Function Name	: ForwardStroke
	
Purpose			: ȹ Ȯ 
		
Input			: 
	pBN			: ڸ	
	StrokeId	: Ϸ ȹȣ 
	deep		: ̽ɵ

Output			: No	

Return Value	: ȹ Ȯ

Description		:  ڸ  StrokeId° ȹ Ȯ ȴ.
				  ̶ ȹ Ȯ  ȹ ִ   Ȯ 
				   ȴ.
				  δ αȮ ̿Ͽ  ȴ.

Ref Journal		: "Bayesian network modeling of strokes and their relationships for on-line handwriting 
					recognition"   Sung-Jung Cho*, Jin H. Kim   Pattern Recognition 37(2004) 253-264p
	
date			: 2009/06/5
________________________________________________________________
*/
float CJamoBNCore::ForwardStroke(JAMOBN *pBN, int StrokeId,int deep)
{
	int StrkId = StrokeId;
	StrokeModel* pStroke = &(pBN->pStroke[StrkId]);
	PointModel* pPoint;
	int i,j,st;
	if(StrkId == 0) st = 0;
	else st = 1;
	float dis=0.0f;
	int ParNum;
	float mean[2],scala[2];

	for(i=st;i<WSRS;i++){
		if(deep==2 && i%2 != 0)continue;
		if(deep==1 && i%4 != 0)continue;
		pPoint = pStroke->pPoint[i];
		ParNum = pPoint->countParents;
		memset(&mean,0,sizeof(float)*2);
		for (j=0;j<ParNum;j++) {
			mean[0] += pPoint->W[0][j*2]*pPoint->parent[j]->P[0] + pPoint->W[0][j*2+1]*pPoint->parent[j]->P[1];
			mean[1] += pPoint->W[1][j*2]*pPoint->parent[j]->P[0] + pPoint->W[1][j*2+1]*pPoint->parent[j]->P[1];
		}
		mean[0] += pPoint->W[0][ParNum*2];
		mean[1] += pPoint->W[1][ParNum*2];

		mean[0] = pPoint->P[0] - mean[0];
		mean[1] = pPoint->P[1] - mean[1];
		
		scala[0] = pPoint->matrix[0][0]*mean[0] + pPoint->matrix[0][1]*mean[1];
		scala[1] = pPoint->matrix[1][0]*mean[0] + pPoint->matrix[1][1]*mean[1];

		dis += scala[0]*scala[0]/pPoint->ramda[0];
		dis += scala[1]*scala[1]/pPoint->ramda[1];
	}
	return dis;
}
/*
________________________________________________________________
  
Function Name	: SetDataInBN
	
Purpose			: Էµ  迭 ڸ   Ų.
		
Input			: 
	pBN			: ڸ	
	pPts		: Է 迭 
	pSelNo		: ȹ ȣ 迭
	SelNum		: ȣ

Output			: No	

Return Value	: ̸ TRUE, ̸ FALSE

Description		: Էµ  迭 ڸ  ȹ鿡 ʷ Ų.
				   ȹ鿡 ʷ Ųٴ ǹ̴ ȹ ̷  
				   ǥ Ѵٴ ǹ̴.

Ref Journal		: "Bayesian network modeling of strokes and their relationships for on-line handwriting 
					recognition"   Sung-Jung Cho*, Jin H. Kim   Pattern Recognition 37(2004) 253-264p
	
date			: 2009/06/5
________________________________________________________________
*/
BOOL CJamoBNCore::SetDataInBN(JAMOBN *pBN,REC_POINT* pPts,int* pSelNo,int SelNum)
{
	if(SelNum!=pBN->StrokeNum+1) return FALSE;
	int i,st,ed;
	for(i=0;i<pBN->StrokeNum;i++){
		st = pSelNo[i];
		ed = pSelNo[i+1];
		SetDataInStroke(pBN,i,pPts,st,ed);
	}
	return TRUE;
}
/*
________________________________________________________________
  
Function Name	: SetDataInStroke
	
Purpose			: Էµ  迭 ȹ   Ų.
		
Input			: 
	pBN			: ڸ	
	StrokeId	: ڸpBN ָϴ ȹȣ
	pPts		: Է 迭 
	st			: Է 迭 ȹ ȣ
	ed			: Է 迭 ȹ ȣ
	deep		: ̽ɵ

Output			: No	

Return Value	: ̸ TRUE, ̸ FALSE

Description		: Էµ  迭 ȹ  鿡 ʷ Ų.				  

Ref Journal		: "Bayesian network modeling of strokes and their relationships for on-line handwriting 
					recognition"   Sung-Jung Cho*, Jin H. Kim   Pattern Recognition 37(2004) 253-264p
	
date			: 2009/06/5
________________________________________________________________
*/
void CJamoBNCore::SetDataInStroke(JAMOBN *pBN, int StrokeId,REC_POINT* pPts,int st,int ed,int deep)
{
	int StrkId = StrokeId;
	StrokeModel* pStroke = &(pBN->pStroke[StrkId]);
	PointModel* pPoint;
	int i,no,nst;
	int len = (ed-st);
	int nodes = (WSRS-1);
	if(StrokeId == 0 ) nst=0;
	else nst = 1;
	for(i=nst;i<WSRS-1;i++){
		if(deep==2 && i%2!=0)continue;
		pPoint = pStroke->pPoint[i];
		no = st + (len*i)/nodes;// +0.5f);
 		memcpy(pPoint->P,&pPts[no],sizeof(float)*2);
	}
	pPoint = pStroke->pPoint[WSRS-1];
 	memcpy(pPoint->P,&pPts[ed],sizeof(float)*2);

}
/*
________________________________________________________________
  
Function Name	: SetEndDataInStroke
	
Purpose			: Էµ  迭 ȹ  Ų.
		
Input			: 
	pBN			: ڸ	
	StrokeId	: ڸpBN ָϴ ȹȣ
	pPts		: Է 迭 
	st			: Է 迭 ȹ ȣ
	ed			: Է 迭 ȹ ȣ	

Output			: No	

Return Value	: No

Description		:  Լ 귮Ҹ ؼ  Լ̴.

Ref Journal		: "Bayesian network modeling of strokes and their relationships for on-line handwriting 
					recognition"   Sung-Jung Cho*, Jin H. Kim   Pattern Recognition 37(2004) 253-264p
	
date			: 2009/06/5
________________________________________________________________
*/
void CJamoBNCore::SetEndDataInStroke(JAMOBN *pBN, int StrokeId,REC_POINT* pPts,int st,int ed)
{
	StrokeModel* pStroke = &(pBN->pStroke[StrokeId]);
	PointModel* pPoint;
	pPoint = pStroke->pPoint[0];
	memcpy(pPoint->P,&pPts[st],sizeof(float)*2);
	pPoint = pStroke->pPoint[WSRS-1];
	memcpy(pPoint->P,&pPts[ed],sizeof(float)*2);
}
/*
________________________________________________________________
  
Function Name	: ForwardBN
	
Purpose			: Էµ  迭 ڸ սŰ°.
		
Input			: 
	pBN			: ڸ	
	pPts		: Է 迭 
	pSamProp	: Up-Down
	pSamNo		: ǥȭȣ 迭
	SamNum		: ǥȭ
	deep		: ̽ɵ

Output			: 
	Mistake		:  迭 ȹӼ  ʴ  	

Return Value	: Ȯ

Description		: ȹ Ȯ ִ Ǵ ȹθ  ̶ Ȯ ȯѴ.

Ref Journal		: "Bayesian network modeling of strokes and their relationships for on-line handwriting 
					recognition"   Sung-Jung Cho*, Jin H. Kim   Pattern Recognition 37(2004) 253-264p
	
date			: 2009/06/5
________________________________________________________________
*/
float CJamoBNCore::ForwardBN(JAMOBN *pBN,REC_POINT* pPts,int* pSamProp,int* pSamNo,int SamNum,int& Mistake,int deep)
{
	int i,t,b,k,bb,st,ed;
	int StrkNum = pBN->StrokeNum;
	if(SamNum<StrkNum+1) return MAXDIS;

	float minDis,tempDis,Thdis = 300.0f;
	float minStrokeDis,StrokeDis;

	float (*dis)[MAXSAMNUM];
	BOOL (*flag)[MAXSAMNUM];
	int	(*path)[MAXSAMNUM][MAXSTROKENUM];
	dis = m_dis;
	flag = m_flag;
	path = m_path;
	memset(flag,0,sizeof(BOOL)*StrkNum*MAXSAMNUM);
	dis[0][0] = 0;
	path[0][0][0] = pSamNo[0];
	dis[StrkNum-1][SamNum-1] = MAXDIS;
	for(t=1;t<SamNum;t++){
		st = max(t-(SamNum-StrkNum),0);
		if(t != SamNum-1) ed = min(t,StrkNum-1);
		else 
			ed=StrkNum;
		for(i=st;i<ed;i++){
			if(i==0){
				SetDataInStroke(pBN,0,pPts,pSamNo[0],pSamNo[t],deep);
				minDis = ForwardStroke(pBN,0,deep);

				if(t != SamNum-1 && minDis > pBN->ThDis) //Ÿ ſ ū   //////////////
					continue;
				dis[0][t] = minDis;
				path[0][t][0] = 0;
				path[0][t][1] = t;
				flag[0][t] = TRUE;
				continue;
			}
			minDis = MAXDIS;
			bb=-1;
			for (b=1;b<t;b++) {
				if(flag[i-1][b] == FALSE) continue;
				for(k=0;k<i;k++)
					SetEndDataInStroke(pBN,k,pPts,pSamNo[path[i-1][b][k]],pSamNo[path[i-1][b][k+1]]);
				SetDataInStroke(pBN,i,pPts,pSamNo[b],pSamNo[t],deep);
				StrokeDis = ForwardStroke(pBN,i,deep);

				tempDis	= StrokeDis + dis[i-1][b];
				if(minDis>tempDis) {
					bb = b;
					minDis = tempDis;
					minStrokeDis = StrokeDis;
				}
			}
			if(bb==-1)continue;
			if(t != SamNum-1) {

				if(minDis>=pBN->ThDis) //Ÿ ſ ū   //////////////
					continue;
			}
			dis[i][t] = minDis;
			memcpy(path[i][t],path[i-1][bb],sizeof(int)*(i+1));
			path[i][t][i+1] = t;
			flag[i][t] = TRUE;
		}
	}

	float rdis = dis[StrkNum-1][SamNum-1];
	Mistake=0;
	if(flag[StrkNum-1][SamNum-1] == TRUE){
		for(i=0;i<StrkNum;i++)
		{
			st = path[StrkNum-1][SamNum-1][i];
			ed = path[StrkNum-1][SamNum-1][i+1];
			if(pBN->pStroke[i].Prop == 0){
				for(int j=st;j<ed;j++){
					if(pSamProp[j] == UP_Flag){
						Mistake++;break;
					}
				}
			}
			if(pBN->pStroke[i].Prop == 2){
				if(pSamProp[st] == UP_Flag){
					Mistake++;
				}
			}
			if(pBN->pStroke[i].Prop == 3){
				if(pSamProp[ed] == DOWN_Flag){
					Mistake++;
				}
			}
		}
		return rdis;
	}else
		return MAXDIS;
}



