#ifndef AEHELPERS_H
#define AEHELPERS_H
#endif

/*AEBuildAppleEvent

Constructs an entire Apple event in a single call.

OSStatus AEBuildAppleEvent (
   AEEventClass theClass,
   AEEventID theID,
   DescType addressType,
   const void * addressData,
   long addressLength,
   short returnID,
   long transactionID,
   AppleEvent * result,
   AEBuildError * error,
   const char * paramsFmt,
   ...
);
Parameters
theClass

The event class for the resulting Apple event. See AEEventClass.
theID

The event id for the resulting Apple event. See AEEventID.
addressType

The address type for the addressing information described in the next two parameters: usually one of typeApplSignature, typeProcessSerialNumber, or typeKernelProcessID. See DescType.
addressData

A pointer to the address information.
addressLength

The number of bytes pointed to by the addressData parameter.
returnID

The return ID for the created Apple event. If you pass a value of kAutoGenerateReturnID, the Apple Event Manager assigns the created Apple event a return ID that is unique to the current session. If you pass any other value, the Apple Event Manager assigns that value for the ID.
transactionID

The transaction ID for this Apple event. A transaction is a sequence of Apple events that are sent back and forth between the client and server applications, beginning with the clients initial request for a service. All Apple events that are part of a transaction must have the same transaction ID. You can specify the kAnyTransactionID constant if the Apple event is not one of a series of interdependent Apple events.
result

A pointer to a descriptor where the resulting descriptor should be stored. See AppleEvent for a description of the data type.
error

A pointer to an AEBuildError structure where additional information about any errors that occur will be saved. This is an optional parameter and you can pass NULL if this information is not required. See AEBuildError for a description of the data type.
paramsFmt

An AEBuild format string describing the AppleEvent record to be created. The format of these strings is described in Technical Note TN2106, AEBuild*, AEPrint*, and Friends. That technote also describes possible error return codes for syntax errors in the format string.
Return Value

A numeric result code indicating the success of the call. A value of AEBuildSyntaxNoErr (zero) means the call succeeded. You can use the error parameter to discover information about other errors. See Apple Event Manager Result Codes.
Discussion

IMPORTANT: Following the parameters described above, the AEBuildAppleEvent function takes a variable number of parameters as specified by the format string provided in the paramsFmt parameter.

This function and related AEBuild routines (including AEBuildDesc and AEBuildParameters, and the variable-argument versions, vAEBuildAppleEvent, vAEBuildDesc, and vAEBuildParameters) provide a very simple translation service for converting specially formatted strings into complex Apple event descriptors. Normally, creating complex Apple event descriptors requires a large number of calls to Apple event Manager routines to build up the descriptor piece by piece. The AEBuildAppleEvent function and related routines allow you to consolidate all of the calls required to construct a complex Apple event descriptor into a single system call that creates the desired structure as directed by a format string that you provide.

In many ways, the AEBuild routines are very much like the standard C library's printf suite of routines. The syntax for the format string that you provide is very simple and allows for the substitution of data items into the Apple event descriptors being created.

The AEBuildAppleEvent function is similar to AECreateAppleEvent, but in addition to creating the Apple event, it also constructs the parameters for the event from the last three arguments. You can use AEBuildAppleEvent to build an entire Apple event, or AEBuildParameters to add additional parameters to an existing Apple event.

The syntax of the formatting string for an entire Apple event (as passed to AEBuildAppleEvent) is almost identical to that used to represent the contents of an Apple event, without the curly braces. The event is defined as a sequence of name-value pairs, with optional parameters preceded with a tilde (~) character. The syntax is described in Technical Note TN2106, AEBuild*, AEPrint*, and Friends.

It is important to note that the identifier for the direct parameter in an Apple event, specified by the constant keyDirectObject, is four minus signs ('----'). The minus sign has special meaning in AEBuild strings, and it should always be enclosed in single quotes when it is used to identify the direct parameter for an Apple event in a descriptor string.
Version Notes

Prior to Mac OS X version 10.3, AEBuildAppleEvent would fail if you supplied a data parameter with size greater than 32767 bytes.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
AEHelpers.h*/
OSStatus AEBuildAppleEvent (
   AEEventClass theClass,
   AEEventID theID,
   DescType addressType,
   const void * addressData,
   long addressLength,
   short returnID,
   long transactionID,
   AppleEvent * result,
   AEBuildError * error,
   const char * paramsFmt,
   int A, //hys
   int  B//hys
);

