#ifndef MACTYPES_H
#define  MACTYPES_H
#endif

#ifndef OSTYPES_H
#include <libkern/OSTypes.h>
#endif

#ifndef _SYS_TYPES_H
#include <sys/types.h>
#endif

/*Str255

Abst_Str255

typedef unsigned char Str255;
Availability
Available in Mac OS X v10.0 and later.*/
typedef unsigned char Str255;

/*OSStatus

A numeric code used in Carbon to indicate the return status of a function.

typedef SInt32 OSStatus;
Discussion

The system software sometimes uses error codes to inform an application that a requested service is not possible. Many functions return a result code of type OSStatus that indicates whether the function completed successfully, and if not, what the reason for failure was.

If you want to use OSStatus to define error codes for your application, Apple recommends that you use values in the range 1000 through 9999 inclusive. Values outside of this range are reserved by Apple for internal use.
Availability
Available in Mac OS X v10.0 and later.*/

typedef SInt32 OSStatus;

/*StrFileName	Recent Changes
Printable View
Page History
Edit Page


Apple's Documentation 

 typedef Str255 StrFileName;


Pages that refer to StrFileName:*/
 typedef Str255 StrFileName;

/*OSType-to-String Conversions

You can use the functions UTCreateStringForOSType and UTGetOSTypeFromString to convert an OSType data type to or from a CFString object (CFStringRef data type). These functions are discussed in Uniform Type Identifiers Overview and defined in the UTType.h header file, which is part of the Launch Services framework.

When you use four-character literals, keep in mind that abcd != 'abcd'. Rather 'abcd' == 0x61626364. You must treat 'abcd' as an integer and not string data, as 'abcd' is a shortcut for a 32-bit integer. (A FourCharCode data type is a UInt32 data type.) The compiler does not swap this for you. You can use the shift operator if you need to deal with individual characters.

For example, if you currently print an OSType or FourCharCode type using the standard C printf-style semantics, useprintf("%c%c%c%c", (char) (val >> 24), (char) (val  >> 16),
                    (char) (val >> 8), (char) val)


instead of the following:printf("%4.4s", (const char*) &val)*/
typedef UInt32 FourCharCode; //hys
/*GetScrap

Reads data from the scrap.

Unsupported

SInt32 GetScrap (
   Handle hDest,
   ResType theType,
   SInt32 *offset
);
Parameters
hDest

A handle to the memory location where the function should place the data from the scrap. The function makes a copy of the data in memory and sets the handle specified by the hDest parameter to refer to this copy, resizing the handle if necessary. If you specify NULL in this parameter, the function does not read in the data but does return the offset of the data in the scrap and the number of bytes of the requested scrap data type if the requested type exists in the scrap.
theType

The scrap format type of the data you wish to read from the scrap.
offset

On return, a pointer to the location of the data in the scrap. This value is expressed as an offset (in bytes) from the beginning of the scrap. The returned value for the offset parameter is valid only if the Translation Manager isnt available if the Translation Manager is available, then the value of offset is undefined.
Return Value

The length (in bytes) of the data or a negative function result that indicates the error. If the function returns noTypeErr, then the data in the scrap isnt available in the scrap format type requested by your application. 
Discussion

Your application can use this function multiple times to read different formats of the same data from the scrap. If more than one format of the same scrap format type exists in the scrap, the function returns the first occurrence of that format type that it finds. For example, if data of type 'TEXT', 'PICT', and 'TEXT' exist on the scrap, and your application requests the data in the scrap with scrap format type 'TEXT', the function returns the first data of type 'TEXT' that it finds.

If your application supports more than one scrap format type, your application should attempt to read its preferred scrap format type first. If your application doesnt prefer one scrap format type over any other type, it should try reading each of the scrap format types that it supports and use the type that returns the lowest offset. The scrap format type with the lowest offset indicates that this format type was written before any of the others and therefore was preferred by the application that wrote it. 

If you request a scrap format type that isnt in the scrap and the Translation Manager is available, the Scrap Manager uses the Translation Manager to convert the data of a scrap format type that does exist in the scrap into the scrap format type requested by your application. For example, if the SurfWriter application requests data from the scrap in the 'SURF' scrap format type, and the data in the scrap is available in the format types 'TEXT', 'PICT', and 'SDBS' (SurfDBs private scrap format type), the Scrap Manager uses the Translation Manager to convert any one of the scrap format types 'TEXT', 'PICT', or 'SDBS' into the 'SURF' scrap format type. The Translation Manager looks for a translator that can perform one of these translations. If such a translator is available (for example, a translator that can translate the 'SDBS' scrap format type into the 'SURF' scrap format type), the Translation Manager uses the translator to translate the data in the scrap into the requested scrap format type. If the translation is successful, the Scrap Manager returns to your application the data from the scrap in the requested scrap format type.

The scrap format type is a four-character sequence that defines the type of data.typedef FourCharCode ResType;


The standard scrap format types are
'TEXT': a series of ASCII characters 
'PICT': a QuickDraw picture, which is a saved sequence of QuickDraw commands that can be displayed using the DrawPicture function 

Optional scrap format types include
'styl': a series of bytes that have the same format as a TextEdit 'styl' resource and that describe styled text data 
'snd ': a series of bytes that have the same format as an 'snd ' resource and that define a sound 
'movv': a series of bytes that have the same format as an 'movv' resource and that define a movie 

Your application should support the 'TEXT' and 'PICT' scrap format types and should optionally support any other scrap format types (such as 'snd ') that are appropriate to your application.

In general, when your application writes data to the scrap, the Scrap Manager appends the data to the scrap in the following format: the first 4 bytes are the scrap type format; the next 4 bytes are the length of the following data in bytes; and the remaining n bytes (where n is an even number) are the data.

If your application uses TextEdit to handle text in its documents, use TextEdit functions to implement the paste operation and to copy data from the scrap to the TextEdit scrap. If your application uses the Dialog Manager to handle editable text items in your applications dialog boxes and a dialog box is the frontmost window, use the Dialog Manager function DialogPaste to copy data from the scrap to the current editable text item. 
Special Considerations

This function may move or purge memory blocks in the application heap. Your application should not call this function at interrupt time.
Availability
Not available in CarbonLib. Not available in Mac OS X.
Carbon Porting Notes

You should instead use the functions GetScrapFlavorSize and GetScrapFlavorData.
Declared In
Scrap.h*/
typedef FourCharCode ResType;

/*NumVersion ϰ?ϡMacTypes.h (Universal Interfaces 3.1 êƪު) Ϊ誦ƪު
struct NumVersion {
               /* 'vers' ꫽??ݻ */
    //UInt8      majorRev;       /* ??ݻ - BCD */
    //UInt8      minorAndBugRev; /* ?? 2 3 ݻ - BCD
                                 // ЫȪ */
    //UInt8      stage;          /* ӫͭ?:
                                  //dev, alpha, beta, final */
  //  UInt8      nonRelRev;      /* Ϋ?٫ */
//};
//typedef struct NumVersion      NumVersion;*/

struct NumVersion {
               /* 'vers' ꫽??ݻ */
    UInt8      majorRev;       /* ??ݻ - BCD */
    UInt8      minorAndBugRev; /* ?? 2 3 ݻ - BCD
                                  ЫȪ */
    UInt8      stage;          /* ӫͭ?:
                                  dev, alpha, beta, final */
    UInt8      nonRelRev;      /* Ϋ?٫ */
};
typedef struct NumVersion      NumVersion;


 /*        Point

Defines the position of a point.

struct Point {
   short    v;
   short    h;
};
Fields
v
Discussion

The vertical coordinate of the point.
h
Discussion

The horizontal coordinate of the point.
Programming Info
C interface file: MacTypes.h*/
struct Point {
   short    v;
   short    h;
};
typedef struct Point Point;

/*StringPtr

Abst_StringPtr

typedef unsigned char * StringPtr;
Availability
Available in Mac OS X v10.0 and later.*/
typedef unsigned char * StringPtr;

/*OSErr

Abst_OSErr

typedef SInt16 OSErr;
Availability
Available in Mac OS X v10.0 and later.*/
typedef SInt16 OSErr;
/*OSStatus

Abst_OSStatus

typedef SInt32 OSStatus;
Availability
Available in Mac OS X v10.0 and later.*/
typedef SInt32 OSStatus;



/*Size

Abst_Size

typedef long Size;
Availability
Available in Mac OS X v10.0 and later.*/
typedef long Size;
