#ifndef OC_CFDICTIONARY_H
#define OC_CFDICTIONARY_H 1
#endif


/*CFMutableDictionaryRef

A reference to a mutable dictionary object.

typedef struct __CFDictionary *CFMutableDictionaryRef;
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct __CFDictionary *CFMutableDictionaryRef;

/*Data Types
CFMutableDictionaryRef

A reference to a mutable dictionary object.

typedef struct __CFDictionary *CFMutableDictionaryRef;
Availability
Available in Mac OS X v10.0 and later.*/

typedef struct __CFDictionary *CFMutableDictionaryRef;

/*CFDictionarySetValue

Sets the value corresponding to a given key.

void CFDictionarySetValue (
   CFMutableDictionaryRef theDict,
   const void *key,
   const void *value
);
Parameters
theDict

The dictionary to modify. If this parameter is a fixed-capacity dictionary and it is full before this operation, and the key does not exist in the dictionary, the behavior is undefined. 
key

The key of the value to set in theDict. If a key which matches key is already present in the dictionary, only the value for the key is changed ("add if absent, replace if present"). If no key matches key, the key-value pair is added to the dictionary.

If a key-value pair is added, both key and value are retained by the dictionary, using the retain callback provided when theDict was created. key must be of the type expected by the key retain callback. 
value

The value to add to or replace in theDict. value is retained using the value retain callback provided when theDict was created, and the previous value if any is released. value must be of the type expected by the retain and release callbacks.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/

void CFDictionarySetValue (
   CFMutableDictionaryRef theDict,
   const void *key,
   const void *value
);

