#include <mach/i386/kern_return.h>
#include <mach/port.h>
#include <IOKit/IOKitLib.h>
#include <IOKit/IOTypes.h>
#include <CoreFoundation/CoreFoundation.h>
#include <mach/machine/kern_return.h>

/* Returns the Mach port used to initiate communication with the I/O Kit. 
kern_return_t IOMasterPort(
    mach_port_t bootstrapPort, 
    mach_port_t *masterPort );  
Parameters
bootstrapPort
Pass MACH_PORT_NULL for the default.
masterPort
The master port is returned.
Return Value

A kern_return_t error code. 
Discussion 

Functions that don't specify an existing object require the I/O Kit master port to be passed. This function obtains that port.*/

kern_return_t IOMasterPort(mach_port_t bootstrapPort,  mach_port_t *masterPort) {
//TODO
};


/*IOServiceGetMatchingServices


Look up registered IOService objects that match a matching dictionary. 
kern_return_t IOServiceGetMatchingServices( 
    mach_port_t masterPort, 
    CFDictionaryRef matching, 
    io_iterator_t *existing );  
Parameters
masterPort
The master port obtained from IOMasterPort. Pass kIOMasterPortDefault to look up the default master port.
matching
A CF dictionary containing matching information, of which one reference is always consumed by this function. (Note that prior to the Tiger release there was a small chance that the dictionary might not be released if there was an error attempting to serialize the dictionary). IOKitLib can construct matching dictionaries for common criteria with helper functions such as IOServiceMatching, IOServiceNameMatching, IOBSDNameMatching, IOOpenFirmwarePathMatching.
existing
An iterator handle is returned on success, and should be released by the caller when the iteration is finished.
Return Value

A kern_return_t error code. 
Discussion 

This is the preferred method of finding IOService objects currently registered by the I/O Kit (that is, objects that have had their registerService methods invoked). To find IOService objects that aren't yet registered, use an iterator as created by IORegistryEntryCreateIterator. IOServiceAddMatchingNotification can also supply this information and install a notification of new IOService objects. The matching information used in the matching dictionary may vary depending on the class of service being looked up.*/

kern_return_t IOServiceGetMatchingServices( mach_port_t masterPort, CFDictionaryRef matching, io_iterator_t *existing ){
//TODO
};


/* IOIteratorNext

Returns the next object in an iteration. 
io_object_t IOIteratorNext( 
    io_iterator_t iterator );  
Parameters
iterator
An I/O Kit iterator handle.
Return Value

If the iterator handle is valid, the next element in the iteration is returned, otherwise zero is returned. The element should be released by the caller when it is finished. 
Discussion 

This function returns the next object in an iteration, or zero if no more remain or the iterator is invalid.*/
io_object_t IOIteratorNext( io_iterator_t iterator ){
//TODO
};

/*IORegistryEntryCreateCFProperty


Creates a CF representation of a registry entry's property. 
CFTypeRef IORegistryEntryCreateCFProperty( 
    io_registry_entry_t entry, 
    CFStringRef key, 
    CFAllocatorRef allocator, 
    IOOptionBits options );  
Parameters
entry
The registry entry handle whose property to copy.
key
A CFString specifying the property name.
allocator
The CF allocator to use when creating the CF container.
options
No options are currently defined.
Return Value

A CF container is created and returned the caller on success. The caller should release with CFRelease. 
Discussion 

This function creates an instantaneous snapshot of a registry entry property, creating a CF container analogue in the caller's task. Not every object available in the kernel is represented as a CF container; currently OSDictionary, OSArray, OSSet, OSSymbol, OSString, OSData, OSNumber, OSBoolean are created as their CF counterparts.*/

CFTypeRef IORegistryEntryCreateCFProperty( 
    io_registry_entry_t entry, 
    CFStringRef key, 
    CFAllocatorRef allocator, 
    IOOptionBits options ){
//TODO
};  


/* IOObjectRelease


Releases an object handle previously returned by IOKitLib. 
kern_return_t IOObjectRelease( 
    io_object_t object );  
Parameters
object
The I/O Kit object to release.
Return Value

A kern_return_t error code. 
Discussion 

All objects returned by IOKitLib should be released with this function when access to them is no longer needed. Using the object after it has been released may or may not return an error, depending on how many references the task has to the same object in the kernel.*/

kern_return_t IOObjectRelease( io_object_t object ){
//TODO 
};  



/*IOServiceMatching


Creates a matching dictionary that specifies an IOService class match. 
CFMutableDictionaryRef IOServiceMatching( 
    const char *name );  
Parameters
name
The class name, as a const C string. Class matching is successful on IOService objects of this class or any subclass.
Return Value

The matching dictionary created, is returned on success, or zero on failure. The dictionary is commonly passed to IOServiceGetMatchingServices or IOServiceAddMatchingNotification which will consume a reference, otherwise it should be released with CFRelease by the caller. 
Discussion 

A very common matching criteria for an IOService object is based on its class. IOServiceMatching will create a matching dictionary that specifies any IOService object of a class, or its subclasses. The class is specified by C string name.*/
CFMutableDictionaryRef IOServiceMatching( 
    const char *name ){
//TODO 
};  

/*kIOMasterPortDefault


The default Mach port used to initiate communication with the I/O Kit. 
extern const mach_port_t kIOMasterPortDefault;  
Discussion 

When specifying a master port to I/O Kit functions, the NULL argument indicates "use the default". This is a synonym for NULL, if you'd rather use a named constant.*/
const mach_port_t kIOMasterPortDefault = MACH_PORT_NULL; //hys
