#ifndef MACTYPES_H
#include <CarbonCore/MacTypes.h>
#endif

#ifndef NAVIGATION_H
#include <NavigationServices/Navigation.h>
#endif


/*NavGetDefaultDialogCreationOptions

Determines the default attributes or behavior for dialogs. 

OSStatus NavGetDefaultDialogCreationOptions (
   NavDialogCreationOptions * outOptions
);
Parameters
outOptions

A pointer to a NavDialogCreationOptions structure that you provide. On return, Navigation Services fills out the structure with default dialog configuration values.
Return Value

A result code. See Navigation Services Result Codes.
Discussion

This function gives you a simple way to initialize a NavDialogCreationOptions structure and set default options before creating a Navigation Services dialog. After you create the NavDialogCreationOptions structure, you can change the configuration options before you call one of the dialog creation functions. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X 10.0 and later.
Declared In
Navigation.h*/
OSStatus NavGetDefaultDialogCreationOptions (NavDialogCreationOptions * outOptions){
//TODO
};


/*NewNavObjectFilterUPP

Creates a new universal procedure pointer to your application-defined filter function.

NavObjectFilterUPP NewNavObjectFilterUPP (
   NavObjectFilterProcPtr userRoutine
);
Parameters
userRoutine

A pointer to your filter function. 
Return Value

On return, a universal procedure pointer (UPP) to the filter function. See the description of the NavObjectFilterUPP data type.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Declared In
Navigation.h*/
NavObjectFilterUPP NewNavObjectFilterUPP (NavObjectFilterProcPtr userRoutine){
//TODO
};


/*NavCreateChooseFileDialog

Creates a Choose File dialog, which prompts the user to select a single file as the target of an operation.

OSStatus NavCreateChooseFileDialog (
   const NavDialogCreationOptions * inOptions,
   NavTypeListHandle inTypeList,
   NavEventUPP inEventProc,
   NavPreviewUPP inPreviewProc,
   NavObjectFilterUPP inFilterProc,
   void * inClientData,
   NavDialogRef * outDialog
);
Parameters
inOptions

A pointer to a structure specifying options that control the appearance and behavior of the dialog. 
inTypeList

A structure specifying a creator signature and a list of file types to show in the Choose File dialog.
inEventProc

A Universal Procedure Pointer (UPP) to your applications event-handling function. You are strongly advised to create and register an event-handling function, as described in NavEventProcPtr. You must have an event-handling function in order to create modeless or window-modal (sheet) dialogs. Specify NULL in this parameter if you do not implement an event-handling function.
inPreviewProc

A Universal Procedure Pointer (UPP) to your applications preview function. You may specify NULL if you dont need to register a preview function. For more information on preview functions, see NavPreviewProcPtr.
inFilterProc

A Universal Procedure Pointer (UPP) to your applications filter function. You may specify NULL if you dont need to register a filter function. For more information on filter functions, see NavObjectFilterProcPtr.
inClientData

A pointer to an application-defined value that is passed back to all callback functions. You can use this value to provide context information, for example. You may pass NULL in this parameter. 
outDialog

On successful creation of a Choose File dialog, A pointer to a Navigation Services dialog reference that you can pass to the NavDialogRun function. 
Return Value

A result code. See Navigation Services Result Codes. A result code.
Discussion

Once you have successfully created the Choose File dialog, you display it by calling the NavDialogRun function. After the user interacts with the dialog, you can obtain information about the dialog session by calling the NavDialogGetReply function. When you are finished with the dialog, you should dispose of it by calling the NavDialogDispose function.

This function replaces the NavChooseFile function and adds support for Unicode and new window modalities.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X 10.0 and later.
Declared In
Navigation.h*/
OSStatus NavCreateChooseFileDialog (
   const NavDialogCreationOptions * inOptions,
   NavTypeListHandle inTypeList,
   NavEventUPP inEventProc,
   NavPreviewUPP inPreviewProc,
   NavObjectFilterUPP inFilterProc,
   void * inClientData,
   NavDialogRef * outDialog){
//TODO
};

/*NavDialogRun

Displays a previously created dialog.

OSStatus NavDialogRun (
   NavDialogRef inDialog
);
Parameters
inDialog

A reference to a previously created Navigation Services dialog. 
Return Value

A result code. See Navigation Services Result Codes.
Discussion

You must create a dialog before displaying it. To create a dialog, call one of the NavCreate...Dialog functions described in Choosing Files, Folders and Volumes and Saving Files. If you specify an application-modal or system-modal dialog, the NavDialogRun function returns after the dialog is dismissed. If you specify a window-modal dialog (sheet) or a modeless dialog, the NavDialogRun function returns immediately; in order to know when the dialog has been dismissed, you must supply an event-handling function and watch for the kNavCBUserAction event. 

After the user interacts with the dialog, you can obtain information about the dialog session by calling the NavDialogGetReply function. 
Version Notes

On Mac OS 9 and earlier, all Navigation Services dialogs are modal, even if a window-modal or modeless dialog is requested. However, the kNavCBUserAction event is still sent to your event-handling function. It is possible to use a single programming model on both Mac OS 9 and on Mac OS X, provided you assume that the NavDialogRun function returns immediately after displaying the dialog.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X 10.0 and later.
Declared In
Navigation.h*/
OSStatus NavDialogRun (NavDialogRef inDialog){
//TODO
};

/*NavDialogGetReply

Reports the results of a dialog session (unless cancelled or programmatically terminated).

OSStatus NavDialogGetReply (
   NavDialogRef inDialog,
   NavReplyRecord * outReply
);
Parameters
inDialog

A reference to a previously created dialog. 
outReply

A pointer to a reply record you allocate to be filled out by Navigation Services. 
Return Value

A result code. See Navigation Services Result Codes.
Discussion

Call this function when you obtain a value other than kNavUserActionCancel or kNavUserActionNone from the NavDialogGetUserAction function. Upon completion of the NavDialogGetReply function, Navigation Services fills out the specified reply record with information about the dialog session. When you are finished with the reply record, remember to dispose of it by calling the NavDisposeReply function. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X 10.0 and later.
Declared In
Navigation.h*/
OSStatus NavDialogGetReply (
   NavDialogRef inDialog,
   NavReplyRecord * outReply){
//TODO
};


/*NavDisposeReply

Releases the memory allocated for a NavReplyRecord structure after your application has finished using the structure.

OSErr NavDisposeReply (
   NavReplyRecord * reply
);
Parameters
reply

A pointer to a structure of type NavReplyRecord that your application has created.
Return Value

A result code. See Navigation Services Result Codes.
Discussion

If your application calls a Navigation Services function that uses a structure of type NavReplyRecord, you must use the NavDisposeReply function afterward to release the memory allotted for the NavReplyRecord structure. 
Availability
Available in CarbonLib 1.0 and later when Navigation Services 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Navigation.h*/
OSErr NavDisposeReply (
   NavReplyRecord * reply){
//TODO
};

/*NavDialogDispose

Disposes of a dialog reference.

void NavDialogDispose (
   NavDialogRef inDialog
);
Parameters
inDialog

A Navigation Services dialog reference previously obtained by your application. 
Discussion

Use this function to dispose of a dialog reference when you are completely finished with its associated dialog. You may call NavDialogDispose from within your application-defined event-handling function.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X 10.0 and later.
Declared In
Navigation.h*/
void NavDialogDispose (NavDialogRef inDialog){
//TODO
};


