#ifndef CONTROLS_H
#define CONTROLS_H
#endif

#ifndef CONTROLDEFINITIONS_H
#include <HIToolbox/ControlDefinitions.h>
#endif

#ifndef MENUS_H
#include <HIToolbox/Menus.h>
#endif

#ifndef MACWINDOWS_H
#include <HIToolbox/MacWindows.h>
#endif

#ifndef HYS_H
#include <OC_Cocoa/hys.h>
#endif


/*ControlRef

typedef struct OpaqueControlRef * ControlRef;
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OpaqueControlRef * ControlRef;

/*ControlPartCode

typedef SInt16 ControlPartCode;
Availability
Available in Mac OS X v10.0 and later.*/
typedef SInt16 ControlPartCode;

/*ControlID

struct ControlID {
   OSType signature;
   SInt32 id;
};
typedef struct ControlID ControlID;
typedef ControlID HIViewID;
Availability
Available in Mac OS X v10.0 and later.*/
struct ControlID {
   OSType signature;
   SInt32 id;
};
typedef struct ControlID ControlID;
typedef ControlID HIViewID;


/*Static Text Control Data Tag Constants

enum {
   kControlStaticTextStyleTag = kControlFontStyleTag,
   kControlStaticTextTextTag = 'text',
   kControlStaticTextTextHeightTag = 'thei',
   kControlStaticTextTruncTag = 'trun',
   kControlStaticTextCFStringTag = 'cfst',
   kControlStaticTextIsMultilineTag = 'stim'
};
Constants
kControlStaticTextTextTag

Gets or sets text in a static text control. 

Data type returned or set: character buffer.

Available with Appearance Manager 1.0 and later.
kControlStaticTextTextHeightTag

Gets the height of text in a static text control. Available with Appearance Manager 1.0 and later.

Data type returned or set:SInt16

Available in Mac OS X v10.0 and later.
kControlStaticTextTruncTag

Gets or sets the controls text truncation style. Truncation will not occur unless kControlStaticTextIsMultilineTag is set to false. 

Data type returned or set: TruncCode. The value truncEnd indicates that characters are truncated off the end of the string; the value truncMiddle indicates that characters are truncated from the middle of the string. Default is a value of -1, which indicates that no truncation occurs and the text is wrapped instead.

Available with Appearance Manager 1.1 (Mac OS 8.5) and later.

Available in Mac OS X v10.0 and later.
kControlStaticTextCFStringTag

Gets or sets the controls current text. When setting the text, the control retains the string, so you may release the string after calling SetControlData. If the string you set is mutable, the control will make a copy of the string, so any changes to the string after calling SetControlData will not affect the control. When retrieving the text, the control retains the string before returning it to you, so you must release the string after you are done with it. 

Data type returned or set: CFStringRef

Available in CarbonLib 1.5 and later, and Mac OS X v10.0 and later.

Available in Mac OS X v10.0 and later.
kControlStaticTextIsMultilineTag

Gets or sets a flag specifying whether the control draws its text in multiple lines if the text is too wide for the control bounds. If false, the control always draws the text in a single line. 

Data type returned or set: Boolean

Available in Mac OS X v10.1 and later.
Discussion

You can use the control data tag constants to set or obtain data that is associated with a control. The control data tag constants are passed in the inTagName parameters of SetControlData and GetControlData to specify the piece of data in a control that you wish to set or get. You can also pass these constants in the inTagName parameter of GetControlDataSize if you wish to determine the size of variable-length control data. These constants can also be used by custom control definition functions that return the feature bit kControlSupportsDataAccess in response to a kControlMsgGetFeatures message. 

The data that your application sets or obtains can be of various types, dependent upon the control. Therefore, the descriptions of the control data tag constants list the data types for the information that you can set in the inData parameter to the SetControlData function and that you can get in the inBuffer parameter to the GetControlData function.*/
enum {
   kControlStaticTextStyleTag = kControlFontStyleTag,
   kControlStaticTextTextTag = 'text',
   kControlStaticTextTextHeightTag = 'thei',
   kControlStaticTextTruncTag = 'trun',
   kControlStaticTextCFStringTag = 'cfst',
   kControlStaticTextIsMultilineTag = 'stim'
};

/*ControlRef

typedef struct OpaqueControlRef * ControlRef;
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OpaqueControlRef * ControlRef;

/*SetControlData

Sets control-specific data.

OSErr SetControlData (
   ControlRef inControl,
   ControlPartCode inPart,
   ResType inTagName,
   Size inSize,
   const void * inData
);
Parameters
inControl

A handle to the control for which data is to be set. 
inPart

The part code of the control part for which data is to be set; see Control Meta Part Code Constants, Control Part Code Constants, and Control State Part Code Constants. Passing kControlEntireControl indicates that either the control has no parts or the data is not tied to any specific part of the control. 
inTagName

A constant representing the control-specific data you wish to set see the data tag constants in the Control Manager Constants section. 
inSize

The size (in bytes) of the data pointed to by the inData parameter. For variable-length control data, pass the value returned in the outMaxSize parameter of GetControlDataSize in the inSize parameter. The number of bytes must match the actual data size. 
inData

A pointer to a buffer allocated by your application. This buffer contains the data that you are sending to the control. After calling SetControlData, your application is responsible for disposing of this buffer, if necessary, as information is copied by control.
Return Value

A result code. See Control Manager Result Codes. The result code errDataNotSupported indicates that the inTagName parameter is not valid.
Discussion

The SetControlData function sets control-specific data represented by the value in the inTagName parameter to the data pointed to by the inData parameter. SetControlData could be used, for example, to switch a progress indicator from a determinate to indeterminate state. For a list of the control attributes that can be set, see the data tag constants in the Control Manager Constants section. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
OSErr SetControlData (
   ControlRef inControl,
   ControlPartCode inPart,
   ResType inTagName,
   Size inSize,
   const void * inData
);

/*GetControlByID

Finds a control in a window by its unique ID.

OSStatus GetControlByID (
   WindowRef inWindow,
   const ControlID * inID,
   ControlRef * outControl
);
Parameters
inWindow

The window to query.
inID

The control ID.
outControl

A pointer to a value of type ControlRef that, on output, is filled in with the control reference for the control specified by inID. For a description of this data type, see ControlRef.
Return Value

A result code. See Control Manager Result Codes.
Discussion

As of Mac OS X v10.3, this function is superseded by the HIViewFindByID function, which is preferred over the GetControlByID function. The first parameter to the HIViewFindByID function is a view and not a window, so you can start the search at any point in the hierarchy.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h 
GetControlClickActivation*/
OSStatus GetControlByID (
   WindowRef inWindow,
   const ControlID * inID,
   ControlRef * outControl
);

/*GetControl32BitValue

Obtains the current setting of a control.

SInt32 GetControl32BitValue (
   ControlRef theControl
);
Parameters
theControl

A handle to the control whose current setting you wish to obtain. 
Return Value

The current setting of the control. 
Discussion

Your application may use the GetControl32BitValue function to obtain a 32-bit value previously set with the function SetControl32BitValue.

If your application uses a 32-bit control value, it should not attempt to obtain this value by calling the pre–Mac OS 8.5 function GetControlValue because the 16-bit value that is returned does not accurately reflect the current 32-bit control value.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
SInt32 GetControl32BitValue (
   ControlRef theControl
);

/*SetControl32BitMaximum

Changes the maximum setting of a control and, if appropriate, redraws it accordingly.

void SetControl32BitMaximum (
   ControlRef theControl,
   SInt32 newMaximum
);
Parameters
theControl

A handle to the control whose maximum setting you wish to change. For a description of this data type, see “ControlRef”.
newMaximum

The new maximum setting of the control. In general, to avoid unpredictable behavior, do not set the maximum control value lower than the current minimum value. 
Discussion

Your application may use the SetControl32BitMaximum function to set a 32-bit value as the maximum setting for a control.

If your application uses a 32-bit control maximum value, it should not attempt to obtain this value by calling the pre–Mac OS 8.5 function GetControlMaximum because the 16-bit value that is returned does not accurately reflect the current 32-bit control value. Instead, use the function GetControl32BitMaximum.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
void SetControl32BitMaximum (
   ControlRef theControl,
   SInt32 newMaximum
);

/*GetControlPopupMenuHandle

Gets the menu handle for a pop-up control.

MenuRef GetControlPopupMenuHandle (
   ControlRef control
);
Parameters
control

The pop-up control to query.
Return Value

See the Menu Manager documentation for a description of the MenuRef data type.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
MenuRef GetControlPopupMenuHandle (
   ControlRef control
);