#ifndef HIVIEW_H
#define HIVIEW_H
#endif

#ifndef CONTROLS_H
#include <HIToolbox/Controls.h>
#endif

/*HIViewRef

Define an HIView reference.

typedef ControlRef HIViewRef;
Availability
Available in Mac OS X v10.2 and later.*/
typedef ControlRef HIViewRef;

/*HIViewGetBounds

Obtains the local bounds of a view. 

OSStatus HIViewGetBounds (
   HIViewRef inView,
   HIRect* outRect
);
Parameters
inView

The view whose local bounds are to be obtained.
outRect

The local bounds of the view.
Return Value

An operating system result code.
Discussion

The local bounds are the coordinate system that is completely view-relative. A views top left coordinate starts out at 0, 0. Most operations use local coordinates. Note, however, that the frame is used to move a view, not local coordinates.
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus HIViewGetBounds (
   HIViewRef inView,
   HIRect* outRect
);

/*HIViewSetNeedsDisplay

Marks a view as needing or not needing to be redrawn.

OSStatus HIViewSetNeedsDisplay (
   HIViewRef inView,
   Boolean inNeedsDisplay
);
Parameters
inView

The view to mark as dirty (needing to be redrawn) or clean (not needing to be redrawn).
inNeedsDisplay

A Boolean whose value is true to mark the view as dirty or false to mark it as clean.
Return Value

An operating system result code.
Discussion

If the view is not visible or is obscured completely by other views, no action is taken.
Availability
Available in Mac OS X v10.2 and later.*/

OSStatus HIViewSetNeedsDisplay (
   HIViewRef inView,
   Boolean inNeedsDisplay
);

/*HIViewFindByID

Obtains a view by its ID. 

OSStatus HIViewFindByID (
   HIViewRef inStartView,
   HIViewID inID,
   HIViewRef * outControl
);
Parameters
inStartView

The view to start searching at. 
inID

The ID of the view you are looking for. 
outControl

Receives the control if found. 
Return Value

An operating system result code.
Discussion

Allows you to find a particular view by its ID. The HIViewID type used by this function is identical to the ControlID type used by the Control Manager.
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus HIViewFindByID (
   HIViewRef inStartView,
   HIViewID inID,
   HIViewRef * outControl
);

/*HIViewGetRoot

Obtains the root view for a window. 

HIViewRef HIViewGetRoot (
   WindowRef inWindow
);
Parameters
inWindow

The window to get the root for.
Return Value

The root view for the window, or NULL if an invalid window is passed.
Discussion

Note that the root view is not the same as the Control Manager root control.
Availability
Available in Mac OS X v10.2 and later.*/
HIViewRef HIViewGetRoot (
   WindowRef inWindow
);