#ifndef IBCARBONRUNTIME_H
#define IBCARBONRUNTIME_H
#endif

/* IBNibRef

A reference to a nib file.

typedef struct OpaqueIBNibRef * IBNibRef;
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OpaqueIBNibRef * IBNibRef;

/*CreateNibReference

Creates a reference to a nib file in the current bundle.

OSStatus CreateNibReference (
   CFStringRef inNibName,
   IBNibRef * outNibRef
);
Parameters
inNibName

A CFStringRef that represents the name of a nib file you created for your application, but without the nib extension. See the Base Services documentation for a description of the CFStringRef data type. You can use the Core Foundation function CFSTR to convert a string to a CFString. 
outNibRef

On output, points to a nib reference. You pass the nib reference to Interface Builder Services functions that unarchive objects from a nib file.
Return Value

A result code. See Runtime Errors.
Discussion

Use this function if the nib file is located in the current bundle. Use the function CreateNibReferenceWithCFBundle if the nib file is located in a framework or other bundle that is not the current bundle. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X 10.0 and later.
Declared In
IBCarbonRuntime.h*/

OSStatus CreateNibReference (
   CFStringRef inNibName,
   IBNibRef * outNibRef
);

/*SetMenuBarFromNib

Unarchives a menu bar from a nib file, then makes the menu bar available in your application.

OSStatus SetMenuBarFromNib (
   IBNibRef inNibRef,
   CFStringRef inName
);
Parameters
inNibRef

A reference to the nib file that contains the menu bar you want to unarchive. You obtain this reference by calling the function CreateNibReference or CreateNibReferenceWithCFBundle.
inName

A CFStringRef that denotes the menu bar you want to unarchive. This is the name you supplied to the menu bar in the Instances pane of Interface Builder. (The default name is MainMenu.) See the Base Services documentation for a description of the CFStringRef data type. You can use the Core Foundation function CFSTR to convert a string to a CFString.
Return Value

A result code. See Runtime Errors.
Discussion

The function SetMenuBarFromNib makes the menu bar visible and selectable by the user when your application opens. If you dont want the menu bar to be visible and selectable when it is unarchived, use the function CreateMenuBarFromNib. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X 10.0 and later.
Declared In
IBCarbonRuntime.h*/
OSStatus SetMenuBarFromNib (
   IBNibRef inNibRef,
   CFStringRef inName
);

/*CreateWindowFromNib

Unarchives a window from a nib file.

OSStatus CreateWindowFromNib (
   IBNibRef inNibRef,
   CFStringRef inName,
   WindowRef *outWindow
);
Parameters
inNibRef

A reference to the nib file that contains the window you want to unarchive. You obtain this reference by calling the function CreateNibReference or CreateNibReferenceWithCFBundle.
inName

A CFStringRef that denotes the window you want to unarchive. This is the name you supplied to the window in the Instances pane of Interface Builder. See the Base Services documentation for a description of the CFStringRef data type. You can use the Core Foundation function CFSTR to convert a string to a CFString. 
outWindow

On output, points to the window unarchived from the nib file.
Return Value

A result code. See Runtime Errors.
Discussion

You need to call the Window Manager function ShowWindow to make the unarchived window visible. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X 10.0 and later.
Declared In
IBCarbonRuntime.h*/

OSStatus CreateWindowFromNib (
   IBNibRef inNibRef,
   CFStringRef inName,
   WindowRef *outWindow
);

/*DisposeNibReference

Disposes of a nib reference.

void DisposeNibReference (
   IBNibRef inNibRef
);
Parameters
inNibRef

A nib reference you created by calling the function CreateNibReference or CreateNibReferenceWithCFBundle.
Return Value
Discussion

You should call the function DisposeNibReference immediately after you have finished unarchiving objects (windows, menus, menu bar, and so forth) from the nib file associated with the nib reference. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X 10.0 and later.
Declared In
IBCarbonRuntime.h*/
void DisposeNibReference (
   IBNibRef inNibRef
);