#ifndef MACTYPES_H
#include <CarbonCore/MacTypes.h>
#endif

#ifndef COMPONENTS_H
#include <CarbonCore/Components.h>
#endif

#ifndef FILES_H
#include <CarbonCore/Files.h>
#endif

#ifndef CORESERVICE_H
#include <CoreService/CoreService.h>
#endif

#ifndef HYS_H
#include <OC_Cocoa/hys.h>
#endif

/*CloseComponent

Terminates your applications connection to a component. 

OSErr CloseComponent (
   ComponentInstance aComponentInstance
);
Parameters
aComponentInstance

The connection you wish to close. Your application obtains the component instance from the OpenComponent function or the OpenDefaultComponent function. You can use a component identifier here, but you must coerce the data type appropriately. 
Return Value

A result code. See Component Manager Result Codes.
Discussion

This function closes only a single connection. If your application has several connections to a single component, you must call it once for each connection. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/
OSErr CloseComponent (
   ComponentInstance aComponentInstance
){
//TODO
};


/*DisposeHandle

Releases memory occupied by a relocatable block.

void DisposeHandle (
   Handle h
);
Parameters
h

A handle to a relocatable block. 
Discussion

The DisposeHandle function releases the memory occupied by the relocatable block whose handle is h. It also frees the handles master pointer for other uses.

Do not use DisposeHandle to dispose of a handle obtained from the Resource Manager (for example, by a previous call to GetResource), use ReleaseResource instead. If, however, you have called DetachResource on a resource handle, you should dispose of the storage by calling DisposeHandle.

Call the function MemError to get the result code. See Memory Manager Result Codes.
Special Considerations

After a call to DisposeHandle, all handles to the released block become invalid and should not be used again. Any subsequent calls to DisposeHandle using an invalid handle might crash your application.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/
void DisposeHandle (Handle h){
//TODO
};

/*BlockZero


void BlockZero (
   void * destPtr,
   Size byteCount
);
Parameters
destPtr
byteCount
Special Considerations

Beginning in Mac OS X v10.4, the BlockZero function is inlined to a direct call to the POSIX bzero function. For more information, see the header file MacMemory.h.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/
void BlockZero (
   void * destPtr,
   Size byteCount){
//TODO
};


/*Gestalt

Obtains information about the operating environment.

OSErr Gestalt (
   OSType selector,
   long * response
);
Parameters
selector

The selector code for the information you need. You can provide any of the four-character sequences defined in Gestalt Manager Constants.
response

On input, Gestalt interprets this parameter as an address at which it is to place the result returned by the selector function. Gestalt ignores any information already at this address. 

On return, a pointer to the requested information whose format depends on the selector code specified in the selector parameter. Note that the Gestalt function returns the response from all selectors in a long word, which occupies 4 bytes. When not all 4 bytes are needed, the significant information appears in the low-order byte or bytes.
Return Value

A result code. See Gestalt Manager Result Codes.
Discussion

The Apple-defined selector codes fall into two categories: environmental selectors, which supply specific environmental information you can use to control the behavior of your application, and informational selectors, which cant supply information you can use to determine what hardware or software features are available. You can use one of the selector codes defined by Apple or a selector code defined by a third-party product.

Selectors with the suffix Attr return a 32-bit response value in which the individual bits represent specific attributes. The constants listed for these response values represent bit numbers. 
Special Considerations

When passed one of the Apple-defined selector codes, the Gestalt function does not move or purge memory and therefore may be called even at interrupt time. However, selector functions associated with non-Apple selector codes might move or purge memory, and third-party software can alter the Apple-defined selector functions. Therefore, it is safest always to assume that Gestalt could move or purge memory.
Version Notes

The ROMVersion and machineType selectors are not supported in Carbon.

In general, the Gestalt function returns a different result when called from a Carbon application running in Mac OS X than it returns when called from a Classic application in Mac OS X, because these are different environments. For example, Carbon does not use a ROM, so calling Gestalt from a Carbon application on a beige G3 Macintosh computer and passing the ROMVersion selector returns a different result than Gestalt returns for a Classic application on the same computer.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Gestalt.h*/
OSErr Gestalt (OSType selector,long * response){
//TODO
};


/*FSOpenIterator

Creates a catalog iterator that can be used to iterate over the contents of a directory or volume.

OSErr FSOpenIterator (
   const FSRef * container,
   FSIteratorFlags iteratorFlags,
   FSIterator * iterator
);
Parameters
container

A pointer to an FSRef for the directory to iterate. The set of items to iterate over can either be the objects directly contained in the directory, or all items directly or indirectly contained in the directory (in which case, the specified directory is the root of the subtree to iterate). See FSRef for a description of the FSRef data type.
iteratorFlags

A set of flags which controls whether the iterator iterates over subtrees or just the immediate children of the container. See Iterator Flags for a description of the flags defined for this parameter.

Iteration over subtrees which do not originate at the root directory of a volume are not currently supported, and passing the kFSIterateSubtree flag in this parameter returns errFSBadIteratorFlags. To determine whether subtree iterators are supported, check that the bSupportsSubtreeIterators bit returned by PBHGetVolParmsSync or PBHGetVolParmsAsync is set.
iterator

On return, a pointer to the new FSIterator. You can pass this iterator to the FSGetCatalogInfoBulk or FSCatalogSearch functions and their parameter block-based counterparts.

The iterator is automatically initialized so that the next use of the iterator returns the first item. The order that items are returned in is volume format dependent and may be different for two different iterators created with the same container and flags.

See FSIterator for a description of the FSIterator data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

Catalog iterators must be closed when you are done using them, whether or not you have iterated over all the items. Iterators are automatically closed upon process termination, just like open files. However, you should use the FSCloseIterator function, or one of the related parameter block functions, PBCloseIteratorSync and PBCloseIteratorAsync , to close an iterator to free up any system resources allocated to the iterator.

Before calling this function, you should check that it is present, by calling the Gestalt function. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSOpenIterator (
   const FSRef * container,
   FSIteratorFlags iteratorFlags,
   FSIterator * iterator){
//TODO
};


/*FSGetCatalogInfoBulk

Returns information about one or more objects from a catalog iterator. This function can return information about multiple objects in a single call.

OSErr FSGetCatalogInfoBulk (
   FSIterator iterator,
   ItemCount maximumObjects,
   ItemCount * actualObjects,
   Boolean * containerChanged,
   FSCatalogInfoBitmap whichInfo,
   FSCatalogInfo * catalogInfos,
   FSRef * refs,
   FSSpec * specs,
   HFSUniStr255 * names
);
Parameters
iterator

The iterator to use. You can obtain a catalog iterator with the function FSOpenIterator, or with one of the related parameter block calls, PBOpenIteratorSync and PBOpenIteratorAsync. Currently, the iterator must be created with the kFSIterateFlat option. See FSIterator for a description of the FSIterator data type.
maximumObjects

The maximum number of items to return for this call. 
actualObjects

On return, a pointer to the actual number of items found for this call.
containerChanged

On return, a pointer to a value indicating whether or not the container’s contents have changed since the previous FSGetCatalogInfoBulk call. If true, the contents have changed. Objects may still be returned, even though the container has changed. If so, note that if the container has changed, then the total set of items returned may be incorrect: some items may be returned multiple times, and some items may not be returned at all.

This parameter is optional if you don’t want this information returned, pass a NULL pointer. 

On versions of Mac OS X prior to 10.2, this parameter is unset. On Mac OS X version 10.2, this parameter is always set to false. To find out whether the container has changed since the last call to FSGetCatalogInfoBulk, check the modification date of the container.
whichInfo

A bitmap specifying the catalog information fields to return for each item. If you don’t wish any catalog information returned, pass the constant kFSCatInfoNone in this parameter. For a description of the bits in this parameter, see Catalog Information Bitmap Constants.
catalogInfos

A pointer to an array of catalog information structures; one for each returned item. On input, the catalogInfos parameter should point to an array of maximumObjects catalog information structures.

This parameter is optional; if you do not wish any catalog information returned, pass NULL here.

refs

A pointer to an array of FSRef structures; one for each returned item. On input, this parameter should to point to an array of maximumObjectsFSRef structures. 

This parameter is optional; if you do not wish any FSRef structures returned, pass NULL here.
specs

A pointer to an array of FSSpec structures; one for each returned item. On input, this parameter should to point to an array of maximumObjectsFSSpec structures. 

This parameter is optional; if you do not wish any FSSpec structures returned, pass NULL here.
names

A pointer to an array of names; one for each returned item. If you want the Unicode name for each item found, set this parameter to point to an array of maximumObjectsHFSUniStr255 structures. Otherwise, set it to NULL. 
Return Value

A result code. See “File Manager Result Codes”. When all of the iterator’s objects have been returned, the call will return errFSNoMoreItems.
Discussion

The FSGetCatalogInfoBulk call may complete and return noErr with fewer than maximumObjects items returned. This may be due to various reasons related to the internal implementation. In this case, you may continue to make FSGetCatalogInfoBulk calls using the same iterator.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSGetCatalogInfoBulk (
   FSIterator iterator,
   ItemCount maximumObjects,
   ItemCount * actualObjects,
   Boolean * containerChanged,
   FSCatalogInfoBitmap whichInfo,
   FSCatalogInfo * catalogInfos,
   FSRef * refs,
   FSSpec * specs,
   HFSUniStr255 * names){
//TODO
};

/*GetDateTime

Obtains the current date-time information, expressed as the number of seconds elapsed since midnight, January 1, 1904. (Deprecated in Mac OS X v10.4. Use CFAbsoluteTimeGetCurrent instead.)

void GetDateTime (
   unsigned long * secs
);
Parameters
secs

On return, the number of seconds elapsed since midnight, January 1, 1904. 
Discussion

The low-memory copy of the date and time information is also accessible through the global variable Time.

If an application disables interrupts for longer than a second, the date-time information returned by the GetDateTime function might not be exact. The GetDateTime function is intended to provide fairly accurate time information, but not scientifically precise data. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
DateTimeUtils.h*/
void GetDateTime ( unsigned long * secs){
//TODO
};


/*SecondsToDate

Converts a number of seconds elapsed since midnight, January 1, 1904 to a date and time. (Deprecated in Mac OS X v10.4. Use the CFCalendarRef data type and the functions that operate on it instead.)

void SecondsToDate (
   unsigned long secs,
   DateTimeRec * d
);
Parameters
secs

The number of seconds elapsed since midnight, January 1, 1904. 
d

On return, the fields of the date-time structure that contain the date and time corresponding to the value indicated in the s parameter. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
DateTimeUtils.h*/
void SecondsToDate (unsigned long secs,DateTimeRec * d){
//TODO
};


/*FSMakeFSRefUnicode

Constructs an FSRef for a file or directory, given a parent directory and a Unicode name. 

OSErr FSMakeFSRefUnicode (
   const FSRef * parentRef,
   UniCharCount nameLength,
   const UniChar * name,
   TextEncoding textEncodingHint,
   FSRef * newRef
);
Parameters
parentRef

A pointer to the FSRef of the parent directory of the file or directory for which to create a new FSRef. See FSRef for a description of the FSRef data type.
nameLength

The length of the file or directory name. 
name

A pointer to the Unicode name for the file or directory. The name must be a leaf name; partial or full pathnames are not allowed. If you have a partial or full pathname in Unicode, you will have to parse it yourself and make multiple calls to FSMakeFSRefUnicode. 
textEncodingHint

The suggested text encoding to use when converting the Unicode name of the file or directory to some other encoding. If you pass the constant kTextEncodingUnknown, the File Manager will use a default value. 
newRef

On return, if the function returns a result of noErr, a pointer to the new FSRef.
Return Value

A result code. See “File Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSMakeFSRefUnicode (
   const FSRef * parentRef,
   UniCharCount nameLength,
   const UniChar * name,
   TextEncoding textEncodingHint,
   FSRef * newRef){
//TODO
};

/*FSCloseIterator

Closes a catalog iterator. 

OSErr FSCloseIterator (
   FSIterator iterator
);
Parameters
iterator

The catalog iterator to be closed. FSCloseIterator releases memory and other system resources used by the iterator, making the iterator invalid. See FSIterator for a description of the FSIterator data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

This function releases memory and other system resources used by the iterator. The iterator becomes invalid. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSCloseIterator (FSIterator iterator){
//TODO
};


/*FSCloseFork

Closes an open fork.

OSErr FSCloseFork (
   SInt16 forkRefNum
);
Parameters
forkRefNum

The reference number of the fork to close. After the call to this function, the reference number in this parameter is invalid. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The FSCloseFork function causes all data written to the fork to be written to disk, in the same manner as the FSFlushFork function, before it closes the fork. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSCloseFork (SInt16 forkRefNum){
//TODO
};


/*FSReadFork

Reads data from an open fork.

OSErr FSReadFork (
   SInt16 forkRefNum,
   UInt16 positionMode,
   SInt64 positionOffset,
   ByteCount requestCount,
   void * buffer,
   ByteCount * actualCount
);
Parameters
forkRefNum

The reference number of the fork to read from. You should have previously opened this fork using the FSOpenFork call, or one of the corresponding parameter block calls, PBOpenForkSync and PBOpenForkAsync. 
positionMode

A constant specifying the base location within the fork for the start of the read. See Position Mode Constants for a description of the constants which you can use to specify the base location.

The caller can also use this parameter to hint to the File Manager whether the data being read should or should not be cached. Caching reads appropriately can be important in ensuring that your program access files efficiently. 

If you add the forceReadMask constant to the value you pass in this parameter, this tells the File Manager to force the data to be read directly from the disk. This is different from adding the noCacheMask constant since forceReadMask tells the File Manager to flush the appropriate part of the cache first, then ignore any data already in the cache. However, data that is read may be placed in the cache for future reads. The forceReadMask constant is also passed to the device driver, indicating that the driver should avoid reading from any device caches.

See Cache Constants for further description of the constants that you can use to indicate your preference for caching the read.

positionOffset

The offset from the base location for the start of the read. 
requestCount

The number of bytes to read. 
buffer

A pointer to the buffer where the data will be returned. 
actualCount

On return, a pointer to the number of bytes actually read. The value pointed to by the actualCount parameter should be equal to the value in the requestCount parameter unless there was an error during the read operation.

This parameter is optional; if you don’t want this information returned, set actualCount to NULL.
Return Value

A result code. See “File Manager Result Codes”. If there are fewer than requestCount bytes from the specified position to the logical end-of-file, then all of those bytes are read, and eofErr is returned.
Discussion

FSReadFork reads data starting at the position specified by the positionMode and positionOffset parameters. The function reads up to requestCount bytes into the buffer pointed to by the buffer parameter and sets the fork’s current position to the byte immediately after the last byte read (that is, the initial position plus actualCount).

To verify that data previously written has been correctly transferred to disk, read it back in using the forceReadMask constant in the positionMode parameter and compare it with the data you previously wrote.

When reading data from a fork, it is important to pay attention to that way that your program accesses the fork, because this can have a significant performance impact. For best results, you should use an I/O size of at least 4KB and block align your read requests. On Mac OS X, you should align your requests to 4KB boundaries; on the traditional Mac OS, byte-alignments beyond 512-bytes are irrelevant, but 4KB aligned requests will perform well on current and future versions. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSReadFork (
   SInt16 forkRefNum,
   UInt16 positionMode,
   SInt64 positionOffset,
   ByteCount requestCount,
   void * buffer,
   ByteCount * actualCount){
//TODO
};


/*FSOpenFork

Opens any fork of a file or directory for streaming access.

OSErr FSOpenFork (
   const FSRef * ref,
   UniCharCount forkNameLength,
   const UniChar * forkName,
   SInt8 permissions,
   SInt16 * forkRefNum
);
Parameters
ref

A pointer to an FSRef specifying the file or directory owning the fork to open. See FSRef for a description of the FSRef data type.
forkNameLength

The length of the fork name in Unicode characters. 
forkName

A pointer to the Unicode name of the fork to open. You can obtain the string constants for the data fork and resource fork names using the FSGetDataForkName and FSGetResourceForkName functions. All volume formats should support data and resource forks; other named forks may be supported by some volume formats. 
permissions

A constant indicating the type of access which you wish to have to the fork via the returned fork reference. This parameter is the same as the permission parameter passed to the FSpOpenDF and FSpOpenRF functions. For a description of the types of access which you can request, see File Access Permission Constants. 
forkRefNum

On return, a pointer to the fork reference number for accessing the open fork. 
Return Value

A result code. See “File Manager Result Codes”. On some file systems, FSOpenFork will return the error eofErr if you try to open the resource fork of a file for which no resource fork exists with read-only access.
Discussion

When you use this function to open a file on a local volume and pass in a permissions value of fsCurPerm, fsWrPerm, or fsRdWrPerm , Mac OS X does not guarantee exclusive file access. Before making any assumptions about the underlying file access, you should always check to see whether the Supports Exclusive Locks feature is available. If this feature is not available, your application cannot know whether another application has access to the same file. For more information, see ADC Technical Note TN2037. 

To access named forks or forks larger than 2GB, you must use the FSOpenFork function or one of the corresponding parameter block calls: PBOpenForkSync and PBOpenForkAsync. To determine if the FSOpenFork function is present, call the Gestalt function. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSOpenFork (
   const FSRef * ref,
   UniCharCount forkNameLength,
   const UniChar * forkName,
   SInt8 permissions,
   SInt16 * forkRefNum){
//TODO
};


/*OpenDefaultComponent

Opens a connection to a registered component of the component type and subtype specified by your application. 

ComponentInstance OpenDefaultComponent (
   OSType componentType,
   OSType componentSubType
);
Parameters
componentType

The type of the component. All components of a particular type support a common set of interface functions. Use this parameter to search for components of a given type. 
componentSubType

The subtype of the component. Different subtypes of a component type may support additional features or provide interfaces that extend beyond the standard functions for a given component type. For example, the subtype of an image compressor component indicates the compression algorithm employed by the compressor.

Your application can use the componentSubType parameter to perform a more specific lookup operation than is possible using only the componentType parameter. For example, you may want your application to use only components of a certain component type ('draw') that also have a specific subtype ('oval'). Set this parameter to 0 to select a component with any subtype value.
Return Value

A component instance that identifies the connection opened to the component which matches your search criteria. You must supply this component instance whenever you call the functions provided by the component. When you close the component, you must also supply this component instance to the CloseComponent function.

If more than one component in the list of registered components meets the search criteria, the function opens the first one that it finds in its list. If it cannot open the specified component, it returns NULL.

See the description of the ComponentInstance data type.
Discussion

Your application must open a component before it can call any component functions. This function searches for a component by type and subtype. You do not have to supply a component description structure or call the FindNextComponent function to use this function. If you want to exert more control over the selection process, you can use the FindNextComponent and OpenComponent functions. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/
ComponentInstance OpenDefaultComponent (
   OSType componentType,
   OSType componentSubType){
//TODO
};


/*FSGetCatalogInfo

Returns catalog information about a file or directory. You can use this function to map an FSRef to an FSSpec.

OSErr FSGetCatalogInfo (
   const FSRef * ref,
   FSCatalogInfoBitmap whichInfo,
   FSCatalogInfo * catalogInfo,
   HFSUniStr255 * outName,
   FSSpec * fsSpec,
   FSRef * parentRef
);
Parameters
ref

A pointer to an FSRef specifying the file or directory for which to retrieve information. See FSRef for a description of the FSRef data type. 
whichInfo

A bitmap specifying the catalog information fields to return. If you don’t want any catalog information, set whichInfo to the constant kFSCatInfoNone. See Catalog Information Bitmap Constants for a description of the bits in this parameter.
catalogInfo

On return, a pointer to a catalog information structure containing the information about the file or directory. Only the information specified in the whichInfo parameter is returned. If you don’t want any catalog information, pass NULL here. See FSCatalogInfo for a description of the FSCatalogInfo data type.
outName

On return, a pointer to the Unicode name of the file or directory is returned here. This parameter is optional; if you do not wish the name returned, pass NULL here. See HFSUniStr255 for a description of the HFSUniStr255 data type.
fsSpec

On return, a pointer to the FSSpec for the file or directory. This parameter is optional; if you do not wish the FSSpec returned, pass NULL here. See FSSpec for a description of the FSSpec data type.
parentRef

On return, a pointer to the FSRef for the object's parent directory. This parameter is optional; if you do not wish the parent directory returned, pass NULL here.

If the object specified in the ref parameter is a volume’s root directory, then the FSRef returned here will not be a valid FSRef, since the root directory has no parent object.
Return Value

A result code. See “File Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSGetCatalogInfo (
   const FSRef * ref,
   FSCatalogInfoBitmap whichInfo,
   FSCatalogInfo * catalogInfo,
   HFSUniStr255 * outName,
   FSSpec * fsSpec,
   FSRef * parentRef){
//TODO
};

/*FSOpenResFile

Opens a resource file using a file system reference (FSRef).

short FSOpenResFile (
   const FSRef * ref,
   SInt8 permission
);
Availability
Available in CarbonLib 1.1 and later when running Mac OS 9.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/
short FSOpenResFile (
   const FSRef * ref,
   SInt8 permission){
//TODO
};


/*CloseResFile

Closes a resource fork before your application terminates.

void CloseResFile (
   short refNum
);
Parameters
refNum

The file reference number for the resource fork to close. If this parameter does not contain a file reference number for a file whose resource fork is open, the function does nothing, and the ResError function returns the result code resFNotFound. If the value of this parameter is 0, it represents the System file and is ignored. You cannot close the System file’s resource fork. 
Discussion

This function performs four tasks. First, it updates the file by calling the UpdateResFile function. Second, it releases the memory occupied by each resource in the resource fork by calling the DisposeHandle function. Third, it releases the memory occupied by the resource map. The fourth task is to close the resource fork.

When your application terminates, the Resource Manager automatically closes every resource fork open to your application except the System file’s resource fork. You need to call this function only if you want to close a resource fork before your application terminates.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/
void CloseResFile (short refNum){
//TODO
};


/*Get1IndResource

Returns a handle to a resource of a given type in the current resource file.

Handle Get1IndResource (
   ResType theType,
   short index
);
Parameters
theType

A resource type.
index

An integer ranging from 1 to the number of resources of a given type returned by the Count1Resources function, which is the number of resources of that type in the current resource file.
Return Value

A handle to a resource of the given type. If you call Get1IndResource repeatedly over the entire range of the index, it returns handles to all resources of the given type in the current resource file. If you provide an index that is either 0 or negative, the function returns NULL, and the ResError function returns the result code resNotFound. If the given index is larger than the value returned by Count1Resources, Get1IndResource returns NULL, and ResError returns the result code resNotFound. If the resource to be read won’t fit into memory, the function returns NULL, and ResError returns the appropriate result code.
Discussion

The function reads the resource data into memory if it’s not already there, unless you’ve called the SetResLoad function with the load parameter set to FALSE. If you’ve called SetResLoad with the load parameter set to FALSE and the data isn’t already in memory, Get1IndResource returns an empty handle (that is, a handle whose master pointer is set to NULL). This can also happen if you read resource data for a purgeable resource into memory and then call SetResLoad with the load parameter set to FALSE. If the resource data is later purged and you call the Get1IndResource function, the function returns an empty handle. You should test for an empty handle in these situations. To make the handle a valid handle to resource data in memory, you can call the MacLoadResource function.
Special Considerations

This function may move or purge memory blocks in the application heap. Your application should not call this function at interrupt time.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/
Handle Get1IndResource (ResType theType,short index){
//TODO
};


/*DetachResource

Sets the value of a resource’s handle in the resource map in memory to NULL while keeping the resource data in memory.

void DetachResource (
   Handle theResource
);
Parameters
theResource

A handle to the resource which you wish to detach. If this parameter doesn’t contain a handle to a resource or if the resource’s resChanged attribute is set, the function does nothing. To determine whether either of these errors occurred, call the ResError function. 
Discussion

After this call, the Resource Manager no longer recognizes the handle as a handle to a resource. However, this function does not release the memory used for the resource data, and the master pointer is still valid. Thus, you can access the resource data directly by using the handle.

If your application subsequently calls a Resource Manager function to get the released resource, the Resource Manager assigns a new handle.You can use DetachResource if you want to access the resource data directly without using Resource Manager functions. You can also use the DetachResource function to keep resource data in memory after closing a resource fork.

To copy a resource and install an entry for the duplicate in the resource map, call DetachResource, then call the AddResource function using a different resource ID. 
Special Considerations

Do not use this function to detach a System resource that might be shared by several applications.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/
void DetachResource (Handle theResource){
//TODO
};


/*NewHandle

Allocates a new relocatable memory block of a specified size in the current heap zone.

Handle NewHandle (
   Size byteCount
);
Parameters
byteCount

The requested size, in bytes, of the relocatable block. Maximum size is 2 GB, the maximum size for variables of type Size.
Return Value

A handle to the new block. If NewHandle cannot allocate a block of the requested size, it returns NULL. 
Discussion

The NewHandle function pursues all available avenues to create a block of the requested size, including compacting the heap zone, increasing its size, and purging blocks from it. If all of these techniques fail and the heap zone has a grow-zone function installed, NewHandle calls the function. Then NewHandle tries again to free the necessary amount of memory, once more compacting and purging the heap zone if necessary. If NewHandle still cannot allocate memory, NewHandle calls the grow-zone function again, unless that function had returned 0, in which case NewHandle gives up and returns NULL.

If the NewHandle function succeeds in creating the requested block, this new block is unlocked and unpurgeable.

If you allocate a relocatable block that you plan to lock for long periods of time, you can prevent heap fragmentation by allocating the block as low as possible in the heap zone. To do this, see the description of the function ReserveMem.

If you plan to lock a relocatable block for short periods of time, you might want to move it to the top of the heap zone to prevent heap fragmentation. For more information, see the description of the function MoveHHi.

Call the function MemError to get the result code. See “Memory Manager Result Codes”.

Because NewHandle allocates memory, you should not call it at interrupt time.

Do not try to manufacture your own handles without this function by simply assigning the address of a variable of type Ptr to a variable of type Handle. The resulting “fake handle” would not reference a relocatable block and could cause a system crash. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/
Handle NewHandle (Size byteCount){
//TODO
};


/*GetHandleSize

Returns the logical size of the relocatable block corresponding to a handle.

Size GetHandleSize (
   Handle h
);
Parameters
h

A handle to a relocatable block. 
Return Value

The logical size, in bytes, of the relocatable block whose handle is h. In case of error, the function return 0. 
Discussion

Call the function MemError to get the result code. See “Memory Manager Result Codes”.

You should not call GetHandleSize at interrupt time because the heap might be in an inconsistent state. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/
Size GetHandleSize (  Handle h){
//TODO
};

