//#ifndef COREFOUNDATION_H
//#include <CoreFoundation/CoreFoundation.h>
//#endif

#ifndef OSTYPES_H
#include <libkern/OSTypes.h>
#endif


#ifndef CFBUNDLE_H
#include <CoreFoundation/CFBundle.h>
#endif

#ifndef CFARRAY_H
#include <CoreFoundation/CFArray.h>
#endif

#ifndef CFBASE_H
#include <CoreFoundation/CFBase.h>
#endif

#ifndef __TYPES_H
#include <CoreFoundation/Types.h>
#endif

#ifndef CFSTRING_H
#include <CoreFoundation/CFString.h>
#endif

#ifndef CFMESSAGEPORT_H
#include <CoreFoundation/CFMessagePort.h>
#endif

#ifndef CFRUNLOOP_H
#include <CoreFoundation/CFRunLoop.h>
#endif

#ifndef OC_CFDICTIONARY_H
#include <OC_CoreFoundation/CFDictionary.h>
#endif

#ifndef CFDATE_H
#include <CoreFoundation/CFDate.h>
#endif

#ifndef CFNUMBER_H
#include <CoreFoundation/CFNumber.h>
#endif

#ifndef OC_CFBASEH
#include <OC_CoreFoundation/CFBase.h>
#endif

/* CFStringGetCString

Copies the character contents of a string to a local C string buffer after converting the characters to a given encoding.

Boolean CFStringGetCString (
   CFStringRef theString,
   char *buffer,
   CFIndex bufferSize,
   CFStringEncoding encoding
);
Parameters
theString

The string whose contents you wish to access. 
buffer

The C string buffer into which to copy the string. The buffer must be at least bufferSize bytes in length. On return, the buffer contains the converted characters. If there is an error in conversion, the buffer contains only partial results.
bufferSize

The length of the local buffer in bytes (accounting for the NULL-terminator byte). 
encoding

The string encoding to which the character contents of theString should be converted. 
Return Value

true upon success or false if the conversion fails or the provided buffer is too small. 
Discussion

This function is useful when you need your own copy of a strings character data as a C string. You also typically call it as a backup when a prior call to the CFStringGetCStringPtr function fails. 
Availability
Available in Mac OS X v10.0 and later.
CFString.h */



Boolean CFStringGetCString (CFStringRef theString,char *buffer,CFIndex bufferSize,CFStringEncoding encoding){
//TODO
};

/*CFMessagePortCreateRemote

Returns a CFMessagePort object connected to a remote port.

CFMessagePortRef CFMessagePortCreateRemote (
   CFAllocatorRef allocator, 
   CFStringRef name
);
Parameters
allocator

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
name

The name of the remote message port to which to connect. 
Return Value

The new CFMessagePort object, or NULL on failure. If a message port has already been created for the remote port, the pre-existing object is returned. Ownership follows the Create Rule.
Availability
Available in Mac OS X v10.0 and later.*/
CFMessagePortRef CFMessagePortCreateRemote (CFAllocatorRef allocator, CFStringRef name){
//TODO
};

/*CFMessagePortCreateLocal

Returns a local CFMessagePort object.

CFMessagePortRef CFMessagePortCreateLocal (
   CFAllocatorRef allocator, 
   CFStringRef name, 
   CFMessagePortCallBack callout, 
   CFMessagePortContext *context, 
   Boolean *shouldFreeInfo
);
Parameters
allocator

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
name

The name with which to register the port. name can be NULL. 
callout

The callback function invoked when a message is received on the message port. 
context

A structure holding contextual information for the message port. The function copies the information out of the structure, so the memory pointed to by context does not need to persist beyond the function call. 
shouldFreeInfo

A flag set by the function to indicate whether the info member of context should be freed. The flag is set to true on failure or if a local port named name already exists, false otherwise. shouldFreeInfo can be NULL. 
Return Value

The new CFMessagePort object, or NULL on failure. If a local port is already named name, the function returns that port instead of creating a new object; the context and callout parameters are ignored in this case. Ownership follows the Create Rule.
Availability
Available in Mac OS X v10.0 and later.*/
CFMessagePortRef CFMessagePortCreateLocal (CFAllocatorRef allocator, CFStringRef name, CFMessagePortCallBack callout, CFMessagePortContext *context, Boolean *shouldFreeInfo){
//TODO
};

/*CFDataGetBytePtr

Returns a read-only pointer to the bytes of a CFData object.

const UInt8 *CFDataGetBytePtr (
   CFDataRef theData
);
Parameters
theData

The CFData object to examine. 
Return Value

A read-only pointer to the bytes associated with theData.
Discussion

This function is guaranteed to return a pointer to a CFData object's internal bytes. CFData, unlike CFString, does not hide its internal storage.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
const UInt8 *CFDataGetBytePtr (CFDataRef theData){
//TODO
};

/*CFRunLoopStop

Forces a CFRunLoop object to stop running.

void CFRunLoopStop (
   CFRunLoopRef rl
);
Parameters
rl

The run loop to stop.
Discussion

This function forces rl to stop running and return control to the function that called CFRunLoopRun or CFRunLoopRunInMode for the current run loop activation. If the run loop is nested with a callout from one activation starting another activation running, only the innermost activation is exited.
Availability
Available in Mac OS X v10.0 and later.*/
void CFRunLoopStop (CFRunLoopRef rl){};

/*CFRunLoopGetCurrent

Returns the CFRunLoop object for the current thread.

CFRunLoopRef CFRunLoopGetCurrent ();
Return Value

Current threads run loop. Ownership follows the Get Rule.
Discussion

Each thread has exactly one run loop associated with it.
Availability
Available in Mac OS X v10.0 and later.*/
CFRunLoopRef CFRunLoopGetCurrent (){
//TODO
};

/*CFRunLoopRun

Runs the current threads CFRunLoop object in its default mode indefinitely.

void CFRunLoopRun ();
Discussion

The current threads run loop runs in the default mode (see "Default Run Loop Mode") until the run loop is stopped with CFRunLoopStop or all the sources and timers are removed from the default run loop mode.

Run loops can be run recursively. You can call CFRunLoopRun from within any run loop callout and create nested run loop activations on the current threads call stack.
Availability
Available in Mac OS X v10.0 and later.*/
void CFRunLoopRun (){
//TODO
};

/*CFDataCreate

Creates an immutable CFData object using data copied from a specified byte buffer.

CFDataRef CFDataCreate (
   CFAllocatorRef allocator,
   const UInt8 *bytes,
   CFIndex length
);
Parameters
allocator

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator.
bytes

A pointer to the byte buffer that contains the raw data to be copied into theData. 
length

The number of bytes in the buffer (bytes). 
Return Value

A new CFData object, or NULL if there was a problem creating the object. Ownership follows the Create Rule.
Discussion

You must supply a count of the bytes in the buffer. This function always copies the bytes in the provided buffer into internal storage. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFDataRef CFDataCreate (CFAllocatorRef allocator,const UInt8 *bytes,CFIndex length){
//TODO
};

/*CFRunLoopSourceInvalidate

Invalidates a CFRunLoopSource object, stopping it from ever firing again.

void CFRunLoopSourceInvalidate (
   CFRunLoopSourceRef source
);
Parameters
source

The run loop source to invalidate.
Discussion

Once invalidated, source will never fire and call its perform callback function again. This function automatically removes source from all the run loop modes in which it was registered. If source is a version 0 source, this function calls its cancel callback function as it is removed from each run loop mode. The memory for source is not deallocated unless the run loop held the only reference to source.
Availability
Available in Mac OS X v10.0 and later.*/
void CFRunLoopSourceInvalidate (CFRunLoopSourceRef source){
//TODO
};

/*CFRunLoopAddSource

Adds a CFRunLoopSource object to a run loop mode.

void CFRunLoopAddSource (
   CFRunLoopRef rl, 
   CFRunLoopSourceRef source, 
   CFStringRef mode
);
Parameters
rl

The run loop to modify. 
source

The run loop source to add. 
mode

The run loop mode to which to add source. Use the constant kCFRunLoopCommonModes to add source to the set of objects monitored by all the common modes. 
Discussion

If source is a version 0 source, this function calls the schedule callback function specified in the context structure for source. See CFRunLoopSourceContext for more details.

A run loop source can be registered in multiple run loops and run loop modes at the same time. When the source is signaled, whichever run loop that happens to detect the signal first will fire the source.

If rl already contains source in mode, this function does nothing.
Availability
Available in Mac OS X v10.0 and later.*/
void CFRunLoopAddSource (CFRunLoopRef rl, CFRunLoopSourceRef source, CFStringRef mode){
//TODO
};

/*CFMessagePortCreateRunLoopSource

Creates a CFRunLoopSource object for a CFMessagePort object.

CFRunLoopSourceRef CFMessagePortCreateRunLoopSource (
   CFAllocatorRef allocator, 
   CFMessagePortRef ms, 
   CFIndex order
);
Parameters
allocator

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
ms

The message port for which to create a run loop source. 
order

A priority index indicating the order in which run loop sources are processed. order is currently ignored by CFMessagePort object run loop sources. Pass 0 for this value. 
Return Value

The new CFRunLoopSource object for ms. Ownership follows the Create Rule.
Discussion

The run loop source is not automatically added to a run loop. To add the source to a run loop, use CFRunLoopAddSource.
Availability
Available in Mac OS X v10.0 and later.*/
CFRunLoopSourceRef CFMessagePortCreateRunLoopSource (CFAllocatorRef allocator, CFMessagePortRef ms, CFIndex order){
//TODO
};

/*CFMessagePortSendRequest

Sends a message to a remote CFMessagePort object.

SInt32 CFMessagePortSendRequest (
   CFMessagePortRef remote, 
   SInt32 msgid, 
   CFDataRef data, 
   CFTimeInterval sendTimeout, 
   CFTimeInterval rcvTimeout, 
   CFStringRef replyMode, 
   CFDataRef *returnData
);
Parameters
remote

The message port to which data should be sent.
msgid

An arbitrary integer value that you can send with the message.
data

The data to send to remote.
sendTimeout

The time to wait for data to be sent.
rcvTimeout

The time to wait for a reply to be returned.
replyMode

The run loop mode in which the function should wait for a reply. If the message is a oneway (so no response is expected), then replyMode should be NULL. If replyMode is non-NULL, the function runs the run loop waiting for a reply, in that mode. replyMode can be any string name of a run loop mode, but it should be one with input sources installed. You should use the kCFRunLoopDefaultMode constant unless you have a specific reason to use a different mode.
returnData

Upon return, contains a CFData object containing the reply data. Ownership follows the Create Rule. 
Return Value

Error code indicating success or failure. See CFMessagePortSendRequest Error Codes for the possible return values.
Availability
Available in Mac OS X v10.0 and later.*/
SInt32 CFMessagePortSendRequest (
   CFMessagePortRef remote, 
   SInt32 msgid, 
   CFDataRef data, 
   CFTimeInterval sendTimeout, 
   CFTimeInterval rcvTimeout, 
   CFStringRef replyMode, 
   CFDataRef *returnData){
//TODO
};

/*CFBooleanGetValue

Returns the value of a CFBoolean object as a standard C type Boolean.

Boolean CFBooleanGetValue (
   CFBooleanRef boolean
);
Parameters
boolean

The boolean to examine. 
Return Value

The value of boolean. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
Boolean CFBooleanGetValue (CFBooleanRef boolean){
//TODO
};

/*CFDictionaryGetValue

Returns the value associated with a key.

const void *CFDictionaryGetValue (
   CFDictionaryRef theDict,
   const void *key
);
Parameters
theDict

The dictionary examine.
key

The key for which to find a match in theDict. The key hash and equal callbacks provided when the dictionary was created are used to compare. If the hash callback was NULL, the key is treated as a pointer and converted to an integer. If the equal callback was NULL, pointer equality (in C, ==) is used. If key, or any of the keys in theDict, is not understood by the equal callback, the behavior is undefined. 
Return Value

The value associated with key in theDict, or NULL if no key-value pair matching key exists. Since NULL is also a valid value in some dictionaries, use CFDictionaryGetValueIfPresent to distinguish between a value that is not found, and a NULL value. If the value is a Core Foundation object, ownership follows the Get Rule.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
const void *CFDictionaryGetValue (
   CFDictionaryRef theDict,
   const void *key){
//TODO
};

/*CFURLGetFileSystemRepresentation

Fills a buffer with the file system's native string representation of a given URL's path.

Boolean CFURLGetFileSystemRepresentation (
   CFURLRef url,
   Boolean resolveAgainstBase,
   UInt8 *buffer,
   CFIndex maxBufLen
);
Parameters
url

The CFURL object whose native file system representation you want to obtain. 
resolveAgainstBase

Pass true to return an absolute path name. 
buffer

A pointer to a character buffer. On return, the buffer holds the native file system's representation of url. The buffer is null-terminated. This parameter must be at least maxBufLen in size for the file system in question to avoid failures for insufficiently large buffers.
maxBufLen

The maximum number of characters that can be written to buffer.
Return Value

true if successful, false if an error occurred. 
Discussion

No more than maxBufLen bytes are written to buffer. If url requires more than maxBufLen bytes to represent itself, including the terminating null byte, this function returns false. To avoid this possible failure, you should pass a buffer with size of at least the maximum path length for the file system in question.
Availability
Available in CarbonLib v1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
CFURL.h*/

Boolean CFURLGetFileSystemRepresentation (
   CFURLRef url,
   Boolean resolveAgainstBase,
   UInt8 *buffer,
   CFIndex maxBufLen){
//TODO 
};

/*CFStringCompare

Compares one string with another string.

CFComparisonResult CFStringCompare (
   CFStringRef theString1,
   CFStringRef theString2,
   CFOptionFlags compareOptions
);
Parameters
theString1

The first string to use in the comparison. 
theString2

The second string to use in the comparison.
compareOptions

Flags that select different types of comparisons, such as localized comparison, case-insensitive comparison, and non-literal comparison. If you want the default comparison behavior, pass 0. See String Comparison Flags for the available flags.
Return Value

A CFComparisonResult value that indicates whether theString1 is equal to, less than, or greater than theString2. 
Discussion

You can affect how the comparison proceeds by specifying one or more option flags in compareOptions. Not all comparison options are currently implemented. 
Availability
Available in Mac OS X v10.0 and later.
*/
CFComparisonResult CFStringCompare (
   CFStringRef theString1,
   CFStringRef theString2,
   CFOptionFlags compareOptions){
//TODO
};

/*CFDictionarySetValue

Sets the value corresponding to a given key.

void CFDictionarySetValue (
   CFMutableDictionaryRef theDict,
   const void *key,
   const void *value
);
Parameters
theDict

The dictionary to modify. If this parameter is a fixed-capacity dictionary and it is full before this operation, and the key does not exist in the dictionary, the behavior is undefined. 
key

The key of the value to set in theDict. If a key which matches key is already present in the dictionary, only the value for the key is changed ("add if absent, replace if present"). If no key matches key, the key-value pair is added to the dictionary.

If a key-value pair is added, both key and value are retained by the dictionary, using the retain callback provided when theDict was created. key must be of the type expected by the key retain callback. 
value

The value to add to or replace in theDict. value is retained using the value retain callback provided when theDict was created, and the previous value if any is released. value must be of the type expected by the retain and release callbacks.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later. */

void CFDictionarySetValue (CFMutableDictionaryRef theDict,const void *key,const void *value){
//TODO
};

/*CFDataGetBytes

Copies the byte contents of a CFData object to an external buffer.

void CFDataGetBytes (
   CFDataRef theData,
   CFRange range,
   UInt8 *buffer
);
Parameters
theData

The CFData object to examine. 
range

The range of bytes in theData to get. To get all of the contents, pass CFRangeMake(0,CFDataGetLength(theData)). 
buffer

A pointer to the byte buffer of length range.length that is allocated on the stack or heap. On return, the buffer contains the requested range of bytes. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
void CFDataGetBytes (CFDataRef theData,CFRange range,UInt8 *buffer){
//TODO
};

/*CFDataGetLength

Returns the number of bytes contained by a CFData object.

CFIndex CFDataGetLength (
   CFDataRef theData
);
Parameters
theData

The CFData object to examine. 
Return Value

An index that specifies the number of bytes in theData. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFIndex CFDataGetLength (CFDataRef theData){
//TODO
};

/*CFPreferencesCopyAppValue

Obtains a preference value for the specified key and application.

CFPropertyListRef CFPreferencesCopyAppValue (
   CFStringRef key,
   CFStringRef applicationID
);
Parameters
key

The preference key whose value to obtain. 
applicationID

The identifier of the application whose preferences to search, typically kCFPreferencesCurrentApplication. Do not pass NULL or kCFPreferencesAnyApplication. Takes the form of a Java package name, com.foosoft.
Return Value

The preference data for the specified key and application. The data is returned as a Core Foundation Property List data type. Use the function CFGetTypeID to determine the values type. If no value was located, returns NULL. Ownership follows the Create Rule.
Discussion

Note that values returned from this function are immutable, even if you have recently set the value using a mutable object.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFPropertyListRef CFPreferencesCopyAppValue ( CFStringRef key,CFStringRef applicationID){
//TODO
};


/*CFPreferencesAppSynchronize

Writes to permanent storage all pending changes to the preference data for the application, and reads the latest preference data from permanent storage.

Boolean CFPreferencesAppSynchronize (
   CFStringRef applicationID
);
Parameters
applicationID

The ID of the application whose preferences to write to storage, typically kCFPreferencesCurrentApplication. Do not pass NULL or kCFPreferencesAnyApplication. Takes the form of a Java package name, com.foosoft.
Return Value

true if synchronization was successful, otherwise false. 
Discussion

Calling the function CFPreferencesSetAppValue is not in itself sufficient for storing preferences. The CFPreferencesAppSynchronize function writes to permanent storage all pending preference changes for the application. Typically you would call this function after multiple calls to CFPreferencesSetAppValue. Conversely, preference data is cached after it is first read. Changes made externally are not automatically incorporated. The CFPreferencesAppSynchronize function reads the latest preferences from permanent storage.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
Boolean CFPreferencesAppSynchronize ( CFStringRef applicationID){
//TODO
};



/*CFPreferencesSetAppValue

Adds, modifies, or removes a preference.

void CFPreferencesSetAppValue (
   CFStringRef key,
   CFPropertyListRef value,
   CFStringRef applicationID
);
Parameters
key

The preference key whose value you wish to set. 
value

The value to set for the specified key and application. Pass NULL to remove the specified key from the applications preferences. 
applicationID

The ID of the application whose preferences you wish to create or modify, typically kCFPreferencesCurrentApplication. Do not pass NULL or kCFPreferencesAnyApplication. Takes the form of a Java package name, com.foosoft.
Discussion

New preference values are stored in the standard application preference location, ~/Library/Preferences/. When called with kCFPreferencesCurrentApplication, modifications are performed in the preference domain Current User, Current Application, Any Host. If you need to create preferences in some other domain, use the low-level function CFPreferencesSetValue.

You must call the CFPreferencesAppSynchronize function in order for your changes to be saved to permanent storage. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
void CFPreferencesSetAppValue (CFStringRef key,CFPropertyListRef value,CFStringRef applicationID){
//TODO
};

/*CFStringReplaceAll

Replaces all characters of a CFMutableString object with other characters.

void CFStringReplaceAll (
   CFMutableStringRef theString,
   CFStringRef replacement
);
Parameters
theString

The string to modify. If this value is not a CFMutableString object, an assertion is raised. 
replacement

The replacement string to put into theString.
Discussion

The character buffer of theString is resized according to the length of the new characters.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
void CFStringReplaceAll (CFMutableStringRef theString,   CFStringRef replacement){
//TODO
};

/*CFStringGetSystemEncoding

Returns the default encoding used by the operating system when it creates strings.

CFStringEncoding CFStringGetSystemEncoding ();
Return Value

The default string encoding. 
Discussion

This function returns the default text encoding used by the OS when it creates strings. In Mac OS X, this encoding is determined by the user's preferred language setting. The preferred language is the first language listed in the International pane of the System Preferences.

In most situations you will not want to use this function, however, because your primary interest will be your application's default text encoding. The application encoding is required when you create a CFStringRef from strings stored in Resource Manager resources, which typically use one of the Mac encodings such as MacRoman or MacJapanese.

To get your application's default text encoding, call the GetApplicationTextEncoding Carbon function.
Availability
Available in Mac OS X v10.0 and later.*/
CFStringEncoding CFStringGetSystemEncoding (){
//TODO
};

/*CFStringGetCStringPtr

Quickly obtains a pointer to a C-string buffer containing the characters of a string in a given encoding.

const char *CFStringGetCStringPtr (
   CFStringRef theString,
   CFStringEncoding encoding
);
Parameters
theString

The string whose contents you wish to access. 
encoding

The string encoding to which the character contents of theString should be converted. 
Return Value

A pointer to a C string or NULL if the internal storage of theString does not allow this to be returned efficiently. 
Discussion

This function either returns the requested pointer immediately, with no memory allocations and no copying, in constant time, or returns NULL. If the latter is the result, call an alternative function such as the CFStringGetCString function to extract the characters.

Whether or not this function returns a valid pointer or NULL depends on many factors, all of which depend on how the string was created and its properties. In addition, the function result might change between different releases and on different platforms. So do not count on receiving a non-NULL result from this function under any circumstances. 
Availability
Available in Mac OS X v10.0 and later.*/
const char *CFStringGetCStringPtr (
   CFStringRef theString,
   CFStringEncoding encoding){
//.TODO
};



/*CFStringAppend

Appends the characters of a string to those of a CFMutableString object.

void CFStringAppend (
   CFMutableStringRef theString,
   CFStringRef appendedString
);
Parameters
theString

The string to which appendedString is appended. If theString is not a CFMutableString object, an assertion is raised.
appendedString

The string to append. 
Discussion

This function reallocates the backing store of theString to accommodate the new length.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
void CFStringAppend (
   CFMutableStringRef theString,
   CFStringRef appendedString){
//TODO
};

/*CFStringCreateMutableCopy

Creates a mutable copy of a string.

CFMutableStringRef CFStringCreateMutableCopy (
   CFAllocatorRef alloc,
   CFIndex maxLength,
   CFStringRef theString
);
Parameters
alloc

The allocator to use to allocate memory for the new string. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
maxLength

The maximum number of Unicode characters that can be stored by the returned object. Pass 0 if there should be no character limit. Note that initially the returned object still has the same length as the string argument; this parameter simply specifies what the maximum size is. CFString might try to optimize its internal storage by paying attention to this value. 
theString

A string to copy. 
Return Value

A string that has the same contents as theString. Returns NULL if there was a problem copying the object. Ownership follows the Create Rule.
Discussion

The returned mutable string is identical to the original string except for (perhaps) the mutability attribute. You can add character data to the returned string with any of the CFStringAppend... functions, and you can insert, delete, replace, pad, and trim characters with the appropriate CFString functions. If the maxLength parameter is greater than 0, any attempt to add characters beyond this limit results in a run-time error. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/CFMutableStringRef CFStringCreateMutableCopy (
   CFAllocatorRef alloc,
   CFIndex maxLength,
   CFStringRef theString){
//TODO
};


/*CFStringInsert

Inserts a string at a specified location in the character buffer of a CFMutableString object.

void CFStringInsert (
   CFMutableStringRef str,
   CFIndex index,
   CFStringRef insertedStr
);
Parameters
str

The string to be modified. If this value is not a CFMutableString object, an assertion is raised. 
index

The index of the character in str after which the new characters are to be inserted. If the index is out of bounds, an assertion is raised. 
insertedStr

The string to insert into str. 
Discussion

To accommodate the new characters, this function moves any existing characters to the right of the inserted characters the appropriate number of positions. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
void CFStringInsert (
   CFMutableStringRef str,
   CFIndex index,
   CFStringRef insertedStr){
//TODO
};

/*CFArrayGetValueAtIndex

Retrieves a value at a given index.

const void *CFArrayGetValueAtIndex (
   CFArrayRef theArray,
   CFIndex idx
);
Parameters
theArray

The array to examine. 
idx

The index of the value to retrieve. If the index is outside the index space of theArray (0 to N-1 inclusive (where N is the count of theArray), the behavior is undefined. 
Return Value

The value at the idx index in theArray. If the return value is a Core Foundation Object, ownership follows the Get Rule.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
const void *CFArrayGetValueAtIndex (CFArrayRef theArray,CFIndex idx){
//TODO
};

/*CFURLCopyPath

Returns the path portion of a given URL.

CFStringRef CFURLCopyPath (
   CFURLRef anURL
);
Parameters
anURL

The CFURL object to examine. 
Return Value

The path of anURL, or NULL if the URL cannot be decomposed (doesn't conform to RFC 1808). Ownership follows the Create Rule.
Discussion

This function does not resolve the URL against its base and replaces all percent escape sequences. This function's return value includes any leading slash (giving the path the normal POSIX appearance), if present. If this behavior is not appropriate, use CFURLCopyStrictPath whose return value omits any leading slash. You may also want to use the function CFURLCopyFileSystemPath, which returns the URL's path as a file system path for the given path style. If the path is to be passed to file system calls, you may also want to use the function CFURLGetFileSystemRepresentation, which returns a C string.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
CFURL.h*/
CFStringRef CFURLCopyPath (CFURLRef anURL){
//TODO
};



/*CFStringCreateMutable

Creates an empty CFMutableString object.

CFMutableStringRef CFStringCreateMutable (
   CFAllocatorRef alloc,
   CFIndex maxLength
);
Parameters
alloc

The allocator to use to allocate memory for the new string. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
maxLength

The maximum number of Unicode characters that can be stored by the returned string. Pass 0 if there should be no character limit. Note that initially the string still has a length of 0; this parameter simply specifies what the maximum size is. CFMutableString might try to optimize its internal storage by paying attention to this value. 
Return Value

A new empty CFMutableString object or NULL if there was a problem creating the object. Ownership follows the Create Rule.
Discussion

This function creates an empty (that is, content-less) CFMutableString object. You can add character data to this object with any of the CFStringAppend... functions, and thereafter you can insert, delete, replace, pad, and trim characters with the appropriate CFString functions. If the maxLength parameter is greater than 0, any attempt to add characters beyond this limit results in a run-time error. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFMutableStringRef CFStringCreateMutable (CFAllocatorRef alloc,CFIndex maxLength){
//TODO
};

/*CFBundleRef CFBundleGetMainBundle ();

CFBundleGetVersionNumber

Returns a bundles version number.

UInt32 CFBundleGetVersionNumber (
   CFBundleRef bundle
);
Parameters
bundle

The bundle to examine. The bundles version number can be number or a string of the standard form 2.5.3d5. 
Return Value

A Mac OS vers resource style version number. If the bundles version number is a number, it is interpreted as the unsigned long integer format defined by the vers resource on Mac OS 9. If it is a string, it is automatically converted to the numeric representation, where the major version number is restricted to 2 BCD digits (in other words, it must be in the range 0-99) and the minor and bug fix version numbers are each restricted to a single BCD digit (0-9). See Technical Note TN1132 for more details.
Discussion

This function is only supported for the Mac OS vers resource style version numbers. Where other version number styles?namely X, or X.Y, or X.Y.Z?are used, you can use CFBundleGetValueForInfoDictionaryKey with the key kCFBundleVersionKey to extract the version number as a string from the bundles information dictionary.

Some version numbers of the form X, X.Y, and X.Y.Z may work with this function, if X <= 99, Y <= 9, and Z <= 9. Thus a version number 76.5.4 will work, but 76.12 will not work.
Availability
Available in CarbonLib v1.1 and later.
Available in Mac OS X v10.0 and later.*/
UInt32 CFBundleGetVersionNumber ( CFBundleRef bundle){
//TODO
};

/*CFBundleGetMainBundle

Returns an applications main bundle.

CFBundleRef CFBundleGetMainBundle ();
Return Value

A CFBundle object representing the applications main bundle, or NULL if it is not possible to create a bundle. Ownership follows the Get Rule.
Discussion

CFBundle creates a main bundle whenever it possibly can, even for unbundled apps. There are a few situations in which it is not possible, so you should check the return value against NULL, but this happens only in exceptional circumstances.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFBundleRef CFBundleGetMainBundle (){
//TODO
};


/*CFBundleCopyResourcesDirectoryURL

Returns the location of a bundles Resources directory.

CFURLRef CFBundleCopyResourcesDirectoryURL (
   CFBundleRef bundle
);
Parameters
bundle

The bundle to examine. 
Return Value

A CFURL object describing the location of bundles resources directory, or NULL if it could not be found. Ownership follows the Create Rule.
Discussion

In general, you should never need to use this function. Use CFBundleCopyResourceURL and similar functions instead. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFURLRef CFBundleCopyResourcesDirectoryURL (
   CFBundleRef bundle){
//TODO
};


/*CFStringGetBytes

Fetches a range of the characters from a string into a byte buffer after converting the characters to a specified encoding.

CFIndex CFStringGetBytes (
   CFStringRef theString,
   CFRange range,
   CFStringEncoding encoding,
   UInt8 lossByte,
   Boolean isExternalRepresentation,
   UInt8 *buffer,
   CFIndex maxBufLen,
   CFIndex *usedBufLen
);
Parameters
theString

The string upon which to operate. 
range

The range of characters in theString to process. The specified range must not exceed the length of the string.
encoding

The string encoding of the characters to copy to the byte buffer. 
lossByte

A character (for example, '?') that should be substituted for characters that cannot be converted to the specified encoding. Pass 0 if you do not want lossy conversion to occur. 
isExternalRepresentation

true if you want the result to be in an “external representation” format. In such a format, it may contain a byte order marker (BOM) specifying endianness and this function might have to perform byte swapping. 
buffer

The byte buffer into which the converted characters are written. The buffer can be allocated on the heap or stack. Pass NULL if you do not want conversion to take place but instead want to know if conversion will succeed (the function result is greater than 0) and, if so, how many bytes are required (usedBufLen).
maxBufLen

The size of buffer and the maximum number of bytes that can be written to it. 
usedBufLen

On return, the number of converted bytes actually in buffer. You may pass NULL if you are not interested in this information.
Return Value

The number of characters converted. 
Discussion

This function is the basic encoding-conversion function for CFString objects. As with the other functions that get the character contents of CFString objects, it allows conversion to a supported 8-bit encoding. Unlike most of those other functions, it also allows “lossy conversion.” The function permits the specification of a “loss byte” in a parameter; if a character cannot be converted this character is substituted and conversion proceeds. (With the other functions, conversion stops at the first error and the operation fails.)

Because this function takes a range and returns the number of characters converted, it can be called repeatedly with a small fixed size buffer and different ranges of the string to do the conversion incrementally.

This function also handles any necessary manipulation of character data in an “external representation” format. This format makes the data portable and persistent (disk-writable); in Unicode it often includes a BOM (byte order marker) that specifies the endianness of the data.

The CFStringCreateExternalRepresentation function also handles external representations and performs lossy conversions. The complementary function CFStringCreateWithBytes creates a string from the characters in a byte buffer.
Availability
Available in Mac OS X v10.0 and later.*/
CFIndex CFStringGetBytes (
   CFStringRef theString,
   CFRange range,
   CFStringEncoding encoding,
   UInt8 lossByte,
   Boolean isExternalRepresentation,
   UInt8 *buffer,
   CFIndex maxBufLen,
   CFIndex *usedBufLen){
//TODO
};


/*CFStringGetLength

Returns the number (in terms of UTF-16 code pairs) of characters in a string.

CFIndex CFStringGetLength (
   CFStringRef theString
);
Parameters
theString

The string to examine. 
Return Value

The number (in terms of UTF-16 code pairs) of characters stored in theString. 
Availability
Available in Mac OS X v10.0 and later.*/
CFIndex CFStringGetLength (CFStringRef theString){
//TODO
};


/*CFStringHasPrefix

Determines if the character data of a string begin with a specified sequence of characters.

Boolean CFStringHasPrefix (
   CFStringRef theString,
   CFStringRef prefix
);
Parameters
theString

The string to search. 
prefix

The prefix to search for.
Return Value

true if theString begins with prefix, false if otherwise. 
Availability
Available in Mac OS X v10.0 and later.*/
Boolean CFStringHasPrefix (
   CFStringRef theString,
   CFStringRef prefix){
//TODO
};


/*CFURLCreateCopyAppendingPathComponent

Creates a copy of a given URL and appends a path component.

CFURLRef CFURLCreateCopyAppendingPathComponent (
   CFAllocatorRef allocator,
   CFURLRef url,
   CFStringRef pathComponent,
   Boolean isDirectory
);
Parameters
allocator

The allocator to use to allocate memory for the new CFURL object. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
url

The CFURL object to which to append a path component. 
pathComponent

The path component to append to url. 
isDirectory

A Boolean value that specifies whether the string is treated as a directory path when resolving against relative path components. Pass true if the new component indicates a directory, false otherwise. 
Return Value

A copy of url appended with pathComponent. Ownership follows the Create Rule.
Discussion

The isDirectory argument specifies whether or not the new path component points to a file or a to directory. Note that the URL syntax for a directory and for a file at otherwise the same location are slightly different—directory URLs must end in “/”. If you have the URL http://www.apple.com/foo/ and you append the path component bar, then if isDirectory is YES then the resulting URL is http://www.apple.com/foo/bar/, whereas if isDirectory is NO then the resulting URL is http://www.apple.com/foo/bar. This difference is particularly important if you resolve another URL against this new URL. file.html relative to http://www.apple.com/foo/bar is http://www.apple.com/foo/file.html, whereas file.html relative to http://www.apple.com/foo/bar/ is http://www.apple.com/foo/bar/file.html.
Availability
Available in CarbonLib v1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
CFURL.h*/
CFURLRef CFURLCreateCopyAppendingPathComponent (
   CFAllocatorRef allocator,
   CFURLRef url,
   CFStringRef pathComponent,
   Boolean isDirectory){
//TODO
};


/*CFURLGetFSRef

Converts a given URL to a file or directory object.

Boolean CFURLGetFSRef (
   CFURLRef url,
   FSRef *fsRef
);
Parameters
url

The CFURL object to convert to a file or directory object.
fsRef

Upon return, contains the file or directory object representing url.
Return Value

true if the conversion was successful, otherwise false.
Special Considerations

The function cannot create an FSRef object if the path specified by url contains an alias. The function can, however, traverse symbolic links.
Availability
Available in CarbonLib v1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
CFURL.h*/
Boolean CFURLGetFSRef (
   CFURLRef url,
   FSRef *fsRef){
//TODO
};


/*CFURLCreateFromFSRef

Creates a URL from a given directory or file.

CFURLRef CFURLCreateFromFSRef (
   CFAllocatorRef allocator,
   const FSRef *fsRef
);
Parameters
allocator

The allocator to use to allocate memory for the new CFURL object. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
fsRef

The file or directory representing the URL. 
Return Value

A new CFURL object. Ownership follows the Create Rule.
Availability
Available in CarbonLib v1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
CFURL.h*/
CFURLRef CFURLCreateFromFSRef (
   CFAllocatorRef allocator,
   const FSRef *fsRef){
//TODO
};