#ifndef DATETIMEUTILS_H
#define DATETIMEUTILS_H



#ifndef CONDITIONALMACROS_H
#include <CarbonCore/ConditionalMacros.h>
#endif

#ifndef MACTYPES_H
#include <CarbonCore/MacTypes.h>
#endif

#ifndef UTCUTILS_H
#include <CarbonCore/UTCUtils.h>
#endif

#ifndef CFDATE_H
#include <CoreFoundation/CFDate.h>
#endif



#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif


/*DateTimeRec

struct DateTimeRec {
   short year;
   short month;
   short day;
   short hour;
   short minute;
   short second;
   short dayOfWeek;
};
typedef struct DateTimeRec DateTimeRec;
Fields
year

The year, ranging from 1904 to 2040. Note that to indicate the year 1984, this field would store the integer 1984, not just 84. This field accepts input of 0 or negative values, but these values produce unpredictable results in the year, month, and day fields when you use the SecondsToDate and DateToSeconds functions. In addition, using SecondsToDate and DateToSeconds with year values greater than 2040 causes a wraparound to 1904 plus the number of years over 2040. For example, setting the year to 2045 returns a value of 1909, and the other fields in this record return unpredictable results.
month

The month of the year, where 1 represents January, and 12 represents December. Values greater than 12 cause a wraparound to a future year and month. This field accepts input of 0 or negative values, but these values produce unpredictable results in the year, month, and day fields when you use the SecondsToDate and DateToSeconds functions.
day

The day of the month, ranging from 1 to 31. Values greater than the number of days in a given month cause a wraparound to a future month and day. This feature is useful for working with leap years. For example, the 366th day of January in 1992 (1992 was a leap year) evaluates as December 31, 1992, and the 367th day of that year evaluates as January 1, 1993. 

This field accepts 0 or negative values, but when you use the SecondsToDate and DateToSeconds procedures, a value of 0 in this field returns the last day of the previous month. For example, a month value of 2 and a day value of 0 return 1 and 31, respectively. 

Using SecondsToDate and DateToSeconds with a negative number in this field subtracts that number of days from the last day in the previous month. For example, a month value of 5 and a day value of ?1 return 4 for the month and 29 for the day a month value of 2 and a day value of ?15 return 1 and 16, respectively.
hour

The hour of the day, ranging from 0 to 23, where 0 represents midnight and 23 represents 11:00 P.M. Values greater than 23 cause a wraparound to a future day and hour. This field accepts input of negative values, but these values produce unpredictable results in the month, day, hour, and minute fields you use the SecondsToDate and DateToSeconds procedures.
minute

The minute of the hour, ranging from 0 to 59. Values greater than 59 cause a wraparound to a future hour and minute. When you use the SecondsToDate and DateToSeconds procedures, a negative value in this field has the effect of subtracting that number from the beginning of the given hour. For example, an hour value of 1 and a minute value of ?10 return 0 hours and 50 minutes. However, if the negative value causes the hour value to be less than 0, for example hour = 0, minute = ?61, unpredictable results occur.
second

The second of the minute, ranging from 0 to 59. Values greater than 59 cause a wraparound to a future minute and second. When you use the SecondsToDate and DateToSeconds procedures, a negative value in this field has the effect of subtracting that number from the beginning of the given minute. For example, a minute value of 1 and a second value of ?10 returns 0 minutes and 50 seconds. However, if the negative value causes the hour value to be less than 0, for example hour = 0, minute = 0, and second = ?61, unpredictable results occur.
dayOfWeek

The day of the week, where 1 indicates Sunday and 7 indicates Saturday. This field accepts 0, negative values, or values greater than 7. When you use the SecondsToDate and DateToSeconds procedures, you get correct values because this field is automatically calculated from the values in the year, month, and day fields.
Discussion

The date-time record describes the date-time information as a date and time. The Date, Time, and Measurement Utilities use a date-time record to read and write date-time information to and from the system. 

The date-time record can be used to hold date and time values only for a Gregorian calendar. The long date-time record, LongDateRec, can be used for a Gregorian calendar as well as other calendar systems. 
Availability
Available in Mac OS X v10.0 and later.*/

struct DateTimeRec {
   short year;
   short month;
   short day;
   short hour;
   short minute;
   short second;
   short dayOfWeek;
};
typedef struct DateTimeRec DateTimeRec;

/*GetDateTime

Obtains the current date-time information, expressed as the number of seconds elapsed since midnight, January 1, 1904. (Deprecated in Mac OS X v10.4. Use CFAbsoluteTimeGetCurrent instead.)

void GetDateTime (
   unsigned long * secs
);
Parameters
secs

On return, the number of seconds elapsed since midnight, January 1, 1904. 
Discussion

The low-memory copy of the date and time information is also accessible through the global variable Time.

If an application disables interrupts for longer than a second, the date-time information returned by the GetDateTime function might not be exact. The GetDateTime function is intended to provide fairly accurate time information, but not scientifically precise data. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
DateTimeUtils.h*/
void GetDateTime (
   unsigned long * secs
);

/*SecondsToDate

Converts a number of seconds elapsed since midnight, January 1, 1904 to a date and time. (Deprecated in Mac OS X v10.4. Use the CFCalendarRef data type and the functions that operate on it instead.)

void SecondsToDate (
   unsigned long secs,
   DateTimeRec * d
);
Parameters
secs

The number of seconds elapsed since midnight, January 1, 1904. 
d

On return, the fields of the date-time structure that contain the date and time corresponding to the value indicated in the s parameter. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
DateTimeUtils.h*/
void SecondsToDate (
   unsigned long secs,
   DateTimeRec * d
);

#ifdef __cplusplus
}
#endif

#endif