#ifndef MACERRORS_H
#define MACERRORS_H

#ifndef CONDITIONALMACROS_H
#include <CarbonCore/ConditionalMacros.h>
#endif

#include <HYS/CarbonCore/MacErrors.h>
#include <AvailabilityMacros.h>



#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*File Manager Result Codes

The most common result codes returned by File Manager are listed below.Result Code	Value	Description
dirFulErr	-33	
File directory full
dskFulErr	-34	
Disk or volume full
nsvErr	-35	
Volume not found
ioErr	-36	
I/O error.
bdNamErr	-37	
Bad filename or volume name
fnOpnErr	-38	
File not open.
eofErr	-39	
Logical end-of-file reached.
posErr	-40	
Attempt to position mark before the start of the file.
mFulErr	-41	
Memory full (open) or file won't fit (load)
tmfoErr	-42	
Too many files open
fnfErr	-43	
File or directory not found; incomplete pathname
wPrErr	-44	
Volume is locked through hardware
fLckdErr	-45	
File is locked. 
vLckdErr	-46	
Volume is locked through software
fBsyErr	-47	
One or more files are open

File is busy

Directory is not empty.
dupFNErr	-48	
Duplicate filename and version

Destination file already exists

File found instead of folder
opWrErr	-49	
File already open for writing
paramErr	-50	
Invalid value passed in a parameter. Your application passed an invalid parameter for dialog options.
rfNumErr	-51	
Invalid reference number
gfpErr	-52	
Error during GetFPos, PBGetFPosSync or PBGetFPosAsync
volOffLinErr	-53	
Volume is offline
permErr	-54	
Attempt to open locked file for writing

Permissions error
volOnLinErr	-55	
Volume already online
nsDrvErr	-56	
No such drive
noMacDskErr	-57	
Not a Macintosh disk
extFSErr	-58	
Volume belongs to an external file system
fsRnErr	-59	
Problem during rename
badMDBErr	-60	
Bad master directory block
wrPermErr	-61	
Read/ write permission doesn’t allow writing.
lastDskErr	-64	
noDriveErr	-64	
Drive not installed
firstDskErr	-84	
dirNFErr	-120	
Directory not found or incomplete pathname
tmwdoErr	-121	
Too many working directories open
badMovErr	-122	
Attempt to move
wrgVolTypErr	-123	
Volume does not support Desktop Manager

Not an HFS volume
volGoneErr	-124	
Server volume has been disconnected
fsDSIntErr	-127	
non-hardware internal file system error
fsmFFSNotFoundErr	-431	
Foreign File system does not exist - new Pack2 could return this error too
fsmBusyFFSErr	-432	
File system is busy, cannot be removed
fsmBadFFSNameErr	-433	
Name length not 1 <= length <= 31
fsmBadFSDLenErr	-434	
FSD size incompatible with current FSM vers
fsmDuplicateFSIDErr	-435	
FSID already exists on InstallFS
fsmBadFSDVersionErr	-436	
FSM version incompatible with FSD
fsmNoAlternateStackErr	-437	
no alternate stack for HFS CI
fsmUnknownFSMMessageErr	-438	
unknown message passed to FSM
driverHardwareGoneErr	-503	
disk driver's hardware was disconnected
fidNotFound	-1300	
File ID not found
fidExists	-1301	
File ID already exists
notAFileErr	-1302	
Specified file is a directory
diffVolErr	-1303	
Files on different volumes
catChangedErr	-1304	
Catalog has changed and catalog position record may be invalid
sameFileErr	-1306	
Can’t exchange a file with itself
badFidErr	-1307	
File ID is dangling or doesn’t match with the file number
notARemountErr	-1308	
_Mount allows only remounts and doesn’t get one
fileBoundsErr	-1309	
File’s EOF, offset, mark or size is too big
fsDataTooBigErr	-1310	
File or volume is too big for system
volVMBusyErr	-1311	
Can’t eject because volume is in use by VM
badFCBErr	-1327	
FCBRecPtr is not valid
errFSUnknownCall	-1400	
Selector is not recognized by this file system
errFSBadFSRef	-1401	
An FSRef parameter was invalid. There are several possible causes:

The parameter was not optional, but the pointer was NULL.

The volume reference number contained within the FSRef does not match a currently mounted volume. This can happen if the volume was unmounted after the FSRef was created.

Some other private field inside the FSRef contains a value that could never be valid. If the field value could be valid, but doesn’t happen to match the existing volume or in-memory structures, a “not found” error would be returned instead.
errFSBadForkName	-1402	
A supplied fork name was invalid (i.e., was syntactically illegal for the given volume). For example, the fork name might contain characters that cannot be stored on the given volume (such as a colon on HFS volumes).

Some volume formats do not store fork names in Unicode. These volume formats will attempt to convert the Unicode name to the kind of encoding used by the volume format. If the name could not be converted, errFSBadForkName is returned.

Some volume formats only support a limited set of forks, such as the data and resource forks on HFS volumes. For those volumes, if any other fork name is passed, this error is returned.
errFSBadBuffer	-1403	
A non-optional buffer pointer was NULL , or its size was invalid for the type of data it was expected to contain. In a protected memory system, this could also mean the buffer space is not part of the address space for the calling process.
errFSBadForkRef	-1404	
A file reference number does not correspond to a fork opened with the FSOpenFork, PBOpenForkSync , or PBOpenForkAsync functions. This could be because that fork has already been closed. Or, you may have passed a referece number created with older APIs (e.g., by the PBHOpenDF functions). A value of zero is never a valid file reference number.
errFSBadInfoBitmap	-1405	
A FSCatalogInfoBitmap or FSVolumeInfoBitmap has one or more reserved or undefined bits set. This error code can also be returned if a defined bit is set, but the corresponding FSCatalogInfo or FSVolumeInfo field cannot be operated on with that call (for example, trying to use FSSetCatalogInfo to set the valence of a directory).
errFSMissingCatInfo	-1406	
A FSCatalogInfo pointer is NULL , but is not optional. Or, the FSCatalogInfo is optional and NULL, but the corresponding FSCatalogInfoBitmap is not zero (that is,the bitmap says that one or more of the FSCatalogInfo fields is being passed, but the supplied pointer was NULL).
errFSNotAFolder	-1407	
A parameter was expected to identify a folder, but it identified some other kind of object (e.g., a file) instead. This implies that the specified object exists, but is of the wrong type. For example, one of the parameters to FSCreateFileUnicode is an FSRef of the directory where the file will be created; if the FSRef actually refers to a file, this error is returned.
errFSForkNotFound	-1409	
An attempt to specify a fork of a given file or directory, but that particular fork does not exist.
errFSNameTooLong	-1410	
A file or fork name was too long. This means that the given name could never exist; this is different from a “file not found” or errFSForkNotFound error.
errFSMissingName	-1411	
A required file or fork name parameter was a NULL pointer, or the length of a filename was zero.
errFSBadPosMode	-1412	
Reserved or invalid bits in a positionMode field were set. For example, the FSReadFork call does not support newline mode, so setting the newline bit or a newline character in the positionMode parameter would cause this error.
errFSBadAllocFlags	-1413	
Reserved or invalid bits were set in an FSAllocationFlags parameter. 
errFSNoMoreItems	-1417	
There are no more items to return when enumerating a directory or searching a volume. Note that FSCatalogSearch returns this error, whereas the PBCatSearch functions would return eofErr.
errFSBadItemCount	-1418	
The maximumObjects parameter to FSGetCatalogInfoBulk or FSCatalogSearch was zero.
errFSBadSearchParams	-1419	
The search criteria to FSCatalogSearch are invalid or inconsistent.
errFSRefsDifferent	-1420	
The two FSRef structures passed to FSCompareFSRefs are for different files or directories. Note that a volume format may be able to compare the FSRef structures without searching for the files or directories, so this error may be returned even if one or both of the FSRef structures refers to non-existent objects.
errFSForkExists	-1421	
An attempt to create a fork, but that fork already exists.
errFSBadIteratorFlags	-1422	
The flags passed to FSOpenIterator are invalid.
errFSIteratorNotFound	-1423	
The value of an FSIterator parameter does not correspond to any currently open iterator.
errFSIteratorNotSupported	-1424	
The iterator flags or container of an FSIterator are not supported by that call. For example, in the initial release, the FSCatalogSearch call only supports an iterator whose container is in the volume’s root directory and whose flags are kFSIterateSubtree (i.e., an iterator for the entire volume’s contents). Similarly, in the initial release, FSGetCatalogInfoBulk only supports an iterator whose flags are kFSIterateFlat.
errFSQuotaExceeded	-1425	
The user’s quota of disk blocks has been exhausted
afpAccessDenied	-5000	
User does not have the correct access to the file

Directory cannot be shared
afpAuthContinue	-5001	
Further information required to complete AFPLogin call
afpBadUAM	-5002	
User authentication method is unknown
afpBadVersNum	-5003	
Workstation is using an AFP version that the server doesn’t recognize
afpBitmapErr	-5004	
Bitmap contained bits undefined for call
afpCantMove	-5005	
Move destination is offspring of source or root was specified
afpDenyConflict	-5006	
Requested user permission not possible
afpDirNotEmpty	-5007	
Cannot delete non-empty directory
afpDiskFull	-5008	
Insufficient free space on volume for operation
afpEofError	-5009	
Read beyond logical end-of-file
afpFileBusy	-5010	
Cannot delete an open file
afpFlatVol	-5011	
Cannot create directory on specified volume
afpItemNotFound	-5012	
Unknown user name/ user ID or missing comment / APPL entry
afpLockErr	-5013	
Some or all of requested range is locked by another user
afpMiscErr	-5014	
Unexpected error encountered during execution
afpNoMoreLocks	-5015	
No more ranges can be locked
afpNoServer	-5016	
Server is not responding
afpObjectExists	-5017	
Specified destination file or directory already exists
afpObjectNotFound	-5018	
Specified file or directory does not exist
afpParmErr	-5019	
A specified parameter was out of allowable range
afpRangeNotLocked	-5020	
Specified range was not locked
afpRangeOverlap	-5021	
Part of range is already locked
afpSessClosed	-5022	
Session closed
afpUserNotAuth	-5023	
User authentication failed (usually, password is not correct)
afpCallNotSupported	-5024	
Unsupported AFP call was made
afpObjectTypeErr	-5025	
A directory exists with that name

Directory not found

Folder locking not supported by volume

Object was a file, not a directory
afpTooManyFilesOpen	-5026	
Maximum open file coun reached
afpServerGoingDown	-5027	
Server is shutting down
afpCantRename	-5028	
AFPRename cannot rename volume
afpDirNotFound	-5029	
Unknown directory specified
afpIconTypeError	-5030	
Icon size specified is different from existing icon size
afpVolLocked	-5031	
Volume is read-only
afpObjectLocked	-5032	
Object is M/R/D/W inhibited
afpContainsSharedErr	-5033	
The directory contains a share point
afpIDNotFound	-5034	
File ID not found
afpIDExists	-5035	
File ID already exists
afpDiffVolErr	-5036	
afpCatalogChanged	-5037	
Catalog has changed and search cannot be resumed
afpSameObjectErr	-5038	
Source and destination files are the same
afpBadIDErr	-5039	
File ID not found
afpPwdSameErr	-5040	
Someone tried to change their password to the same password on a mandatory password change
afpPwdTooShortErr	-5041	
The password being set is too short: there is a minimum length that must be met or exceeded
afpPwdExpiredErr	-5042	
Password has expired on server
afpInsideSharedErr	-5043	
The directory is inside a shared directory
afpInsideTrashErr	-5044	
The folder being shared is inside the trash folder OR the shared folder is being moved into the trash folder
afpPwdNeedsChangeErr	-5045	
The password needs to be changed
afpPwdPolicyErr	-5046	
Password does not conform to server’s password policy
afpAlreadyLoggedInErr	-5047	
User has been authenticated but is already logged in from another machine (and that's not allowed on this server)
afpCallNotAllowed	-5048	
afpBadDirIDType	-5060	
Not a fixed directory ID volume
afpCantMountMoreSrvre	-5061	
Maximum number of volumes has been mounted
afpAlreadyMounted	-5062	
Volume already mounted
afpSameNodeErr	-5063	
Attempt to log on to a server running on the same machine*/
enum {
dirFulErr	=-33	,
dskFulErr	=-34	,
nsvErr	=-35	,
ioErr	=-36	,
bdNamErr=	-37	,
fnOpnErr	=-38	,
eofErr	=-39	,
posErr	=-40	,
mFulErr	=-41	,
tmfoErr	=-42	,
fnfErr	=-43	,
wPrErr	=-44	,
fLckdErr	=-45	,
vLckdErr	=-46	,
fBsyErr	=-47	,
dupFNErr	=-48	,
opWrErr	=-49	,
//paramErr	=-50	,
rfNumErr	=-51	,
gfpErr	=-52	,
volOffLinErr	=-53	,
permErr	=-54	,
volOnLinErr	=-55	,
nsDrvErr	=-56	,
noMacDskErr	=-57	,
extFSErr	=-58	,
fsRnErr	=-59	,
badMDBErr=	-60	,
wrPermErr=	-61	,
lastDskErr	=-64	,
noDriveErr=	-64	,
firstDskErr	=-84	,
dirNFErr	=-120,	
tmwdoErr	=-121,	
badMovErr=	-122	,
wrgVolTypErr=	-123	,
volGoneErr	=-124,	
fsDSIntErr	=-127	,
fsmFFSNotFoundErr	=-431	,
fsmBusyFFSErr	=-432	,
fsmBadFFSNameErr=	-433	,
fsmBadFSDLenErr	=-434	,
fsmDuplicateFSIDErr	=-435	,
fsmBadFSDVersionErr=	-436	,
fsmNoAlternateStackErr=	-437	,
fsmUnknownFSMMessageErr	=-438	,
driverHardwareGoneErr	=-503	,
fidNotFound	=-1300	,
fidExists	=-1301	,
notAFileErr	=-1302	,
diffVolErr	=-1303	,
catChangedErr=	-1304	,
sameFileErr	=-1306	,
badFidErr	=-1307	,
notARemountErr	=-1308	,
fileBoundsErr	=-1309	,
fsDataTooBigErr	=-1310	,
volVMBusyErr	=-1311	,
badFCBErr	=-1327	,
errFSUnknownCall	=-1400	,
errFSBadFSRef	=-1401	,
errFSBadForkName	=-1402	,
errFSBadBuffer	=-1403	,
errFSBadForkRef=	-1404	,
errFSBadInfoBitmap	=-1405	,
errFSMissingCatInfo	=-1406	,
errFSNotAFolder	=-1407	,
errFSForkNotFound	=-1409	,
errFSNameTooLong	=-1410	,
errFSMissingName	=-1411	,
errFSBadPosMode	=-1412	,
errFSBadAllocFlags	=-1413	,
errFSNoMoreItems	=-1417	,
errFSBadItemCount	=-1418	,
errFSBadSearchParams	=-1419	,
errFSRefsDifferent	=-1420	,
errFSForkExists	=-1421	,
errFSBadIteratorFlags	=-1422	,
errFSIteratorNotFound	=-1423	,
errFSIteratorNotSupported=	-1424	,
errFSQuotaExceeded	=-1425	,
afpAccessDenied	=-5000	,
afpAuthContinue	=-5001	,
afpBadUAM	=-5002	,
afpBadVersNum	=-5003	,
afpBitmapErr	=-5004	,
afpCantMove	=-5005	,
afpDenyConflict=	-5006	,
afpDirNotEmpty	=-5007	,
afpDiskFull	=-5008	,
afpEofError	=-5009	,
afpFileBusy	=-5010	,
afpFlatVol	=-5011	,
afpItemNotFound	=-5012	,
afpLockErr	=-5013	,
afpMiscErr	=-5014	,
afpNoMoreLocks=	-5015	,
afpNoServer	=-5016	,
afpObjectExists=	-5017,	
afpObjectNotFound	=-5018	,
afpParmErr	=-5019	,
afpRangeNotLocked	=-5020	,
afpRangeOverlap	=-5021	,
afpSessClosed	=-5022	,
afpUserNotAuth	=-5023	,
afpCallNotSupported	=-5024	,
afpObjectTypeErr	=-5025	,
afpTooManyFilesOpen=	-5026,	
afpServerGoingDown=	-5027,	
afpCantRename	=-5028	,
afpDirNotFound=	-5029	,
afpIconTypeError=	-5030	,
afpVolLocked	=-5031	,
afpObjectLocked	=-5032	,
afpContainsSharedErr=	-5033,	
afpIDNotFound	=-5034	,
afpIDExists	=-5035	,
afpDiffVolErr	=-5036	,
afpCatalogChanged=	-5037	,
afpSameObjectErr=	-5038	,
afpBadIDErr	=-5039	,
afpPwdSameErr	=-5040	,
afpPwdTooShortErr	=-5041	,
afpPwdExpiredErr	=-5042	,
afpInsideSharedErr	=-5043	,
afpInsideTrashErr	=-5044	,
afpPwdNeedsChangeErr=	-5045	,
afpPwdPolicyErr	=-5046	,
afpAlreadyLoggedInErr	=-5047	,
afpCallNotAllowed=	-5048	,
afpBadDirIDType=	-5060	,
afpCantMountMoreSrvre	=-5061	,
afpAlreadyMounted	=-5062	,
afpSameNodeErr	=-5063	
};





/* sound manager RESULT CODES
noErr	
0	
No error

notEnoughHardwareErr	
-201	
Insufficient hardware available

resProblem	
-204	
Problem loading the resource

badChannel	
-205	
Channel is corrupt or unusable

badFormat	
-206	
Resource is corrupt or unusable 

SEE ALSO*/
enum {
notEnoughHardwareErr	=-201	,
resProblem	=-204	,
badChannel	=-205	,
badFormat	=-206	
};
/*Window Manager Result Codes

The most common result codes returned by Window Manager are listed below.Result Code	Value	Description
noErr	0	
No error
paramErr	-50	
Invalid value passed in a parameter. Your application passed an invalid parameter for dialog options.
memFullErr	-108	
Not enough memory

Not enough room in heap zone.

Not enough memory to speak
resNotFound	-192	
Unable to read resource

Resource not found
errInvalidWindowPtr	-5600	
Invalid window pointer
errUnsupportedWindowAttributesForClass	-5601	
Attribute bits are inappropriate for the specified window class
errWindowDoesNotHaveProxy	-5602	
No proxy attached to window
errInvalidWindowProperty	-5603	
'appl' creator code not allowed
errWindowPropertyNotFound	-5604	
Specified property does not exist
errUnrecognizedWindowClass	-5605	
Unknown window class
errCorruptWindowDescription	-5606	
Incorrect size or version supplied in the BasicWindowDescription structure
errUserWantsToDragWindow	-5607	
Entire window is being dragged, not proxy icon
errWindowsAlreadyInitialized	-5608	
Called InitFloatingWindows twice, or called InitWindows and then InitFloatingWindows
errFloatingWindowsNotInitialized	-5609	
Called HideFloatingWindows or ShowFloatingWindows without calling InitFloatingWindows*/
enum {
paramErr=	-50	,
memFullErr=	-108	,
resNotFound	=-192,	
errInvalidWindowPtr=	-5600	,
errUnsupportedWindowAttributesForClass=	-5601	,
errWindowDoesNotHaveProxy	=-5602	,
errInvalidWindowProperty	=-5603	,
errWindowPropertyNotFound	=-5604	,
errUnrecognizedWindowClass	=-5605	,
errCorruptWindowDescription	=-5606	,
errUserWantsToDragWindow	=-5607	,
errWindowsAlreadyInitialized	=-5608	,
errFloatingWindowsNotInitialized	=-5609	
};

/*OpenScripting Result Codes

The most common result codes returned by Open Scripting Architecture are listed in Table 1-1. Open Scripting Architecture may also return the result codes noErr (0), and badComponentInstance (-2147450879).Result Code	Value	Description
errOSACantCoerce	-1700	
A value can't be coerced to the desired type.
OSAMissingParameter	-1701	
A parameter is missing for a function invocation.
errOSACorruptData	-1702	
Some data could not be read.
errOSATypeError	-1703	
Same as errAEWrongDataType; wrong descriptor type.
OSAMessageNotUnderstood	-1708	
A message was sent to an object that didn't handle it.
OSAUndefinedHandler	-1717	
A function to be returned doesn't exist.
OSAIllegalIndex	-1719	
An index was out of range. Specialization of errOSACantAccess.
OSAIllegalRange	-1720	
The specified range is illegal. Specialization of errOSACantAccess.
OSAParameterMismatch	-1721	
The wrong number of parameters were passed to the function, or a parameter pattern cannot be matched.
OSAIllegalAccess	-1723	
A container can not have the requested object.
errOSACantAccess	-1728	
An object is not found in a container.
errOSARecordingIsAlreadyOn	-1732	
Recording is already on.

Available only in version 1.0.1 or greater.
errOSASystemError	-1750	
Scripting component error.
errOSAInvalidID	-1751	
Invalid script id.
errOSABadStorageType	-1752	
Script doesn’t seem to belong to AppleScript.
errOSAScriptError	-1753	
Script error.
errOSABadSelector	-1754	
Invalid selector given.
errOSASourceNotAvailable	-1756	
Invalid access.
errOSANoSuchDialect	-1757	
Source not available.
errOSADataFormatObsolete	-1758	
No such dialect.
errOSADataFormatTooNew	-1759	
Data couldn’t be read because its format is obsolete.
errOSAComponentMismatch	-1761	
Parameters are from two different components.
errOSACantOpenComponent	-1762	
Can't connect to system with that ID.
errOSAGeneralError	-2700	
No actual error code is to be returned.
errOSADivideByZero	-2701	
An attempt to divide by zero was made.
errOSANumericOverflow	-2702	
An integer or real value is too large to be represented.
errOSACantLaunch	-2703	
An application can't be launched, or when it is, remote and program linking is not enabled.
errOSAAppNotHighLevelEventAware	-2704	
An application can't respond to AppleEvents.
errOSACorruptTerminology	-2705	
An application's terminology resource is not readable.
errOSAStackOverflow	-2706	
The runtime stack overflowed.
errOSAInternalTableOverflow	-2707	
A runtime internal data structure overflowed.
errOSADataBlockTooLarge	-2708	
An intrinsic limitation is exceeded for the size of a value or data structure.
errOSACantGetTerminology	-2709	
Can’t get the event dictionary.
errOSACantCreate	-2710	
Can't make class <class identifier>.
OSASyntaxError	-2740	
A syntax error occured.
OSASyntaxTypeError	-2741	
Another form of syntax was expected.
OSATokenTooLong	-2742	
A name or number is too long to be parsed.
OSADuplicateParameter	-2750	
A formal parameter, local variable, or instance variable is specified more than once.
OSADuplicateProperty	-2751	
A formal parameter, local variable, or instance variable is specified more than once.
OSADuplicateHandler	-2752	
More than one handler is defined with the same name in a scope where the language doesn't allow it.
OSAUndefinedVariable	-2753	
A variable is accessed that has no value.
OSAInconsistentDeclarations	-2754	
A variable is declared inconsistently in the same scope, such as both local and global.
OSAControlFlowError	-2755	
An illegal control flow occurs in an application. For example, there is no catcher for the throw, or there was a non-lexical loop exit.
OSAIllegalAssign	-10003	
An object can never be set in a container
errOSACantAssign	-10006	
An object cannot be set in a container.*/
enum {
badComponentInstance  =-2147450879,
errOSACantCoerce	=-1700	,
OSAMissingParameter=	-1701,	
errOSACorruptData	=-1702	,
errOSATypeError	=-1703	,
OSAMessageNotUnderstood	=-1708,
OSAUndefinedHandler	= -1717	,
OSAIllegalIndex	=-1719	,
OSAIllegalRange	=-1720	,
OSAParameterMismatch	=-1721,	
OSAIllegalAccess	=-1723	,
errOSACantAccess	=-1728	,
errOSARecordingIsAlreadyOn	=-1732	,
errOSASystemError	=-1750	,
errOSAInvalidID	=-1751	,
errOSABadStorageType	=-1752	,
errOSAScriptError	=-1753	,
errOSABadSelector	=-1754	,
errOSASourceNotAvailable	=-1756	,
errOSANoSuchDialect	=-1757	,
errOSADataFormatObsolete=	-1758,	
errOSADataFormatTooNew=	-1759,	
errOSAComponentMismatch=	-1761,	
errOSACantOpenComponent=	-1762,	
errOSAGeneralError	=-2700	,
errOSADivideByZero=	-2701,	
errOSANumericOverflow	=-2702,	
errOSACantLaunch	=-2703	,
errOSAAppNotHighLevelEventAware=	-2704	,
errOSACorruptTerminology=	-2705	,
errOSAStackOverflow	=-2706	,
errOSAInternalTableOverflow	=-2707	,
errOSADataBlockTooLarge=	-2708	,
errOSACantGetTerminology=	-2709	,
errOSACantCreate	=-2710	,
OSASyntaxError	=-2740	,
OSASyntaxTypeError=	-2741,	
OSATokenTooLong	=-2742	,
OSADuplicateParameter=	-2750,	
OSADuplicateProperty=	-2751,
OSADuplicateHandler=	-2752,	
OSAUndefinedVariable=	-2753,	
OSAInconsistentDeclarations=	-2754	,
OSAControlFlowError=	-2755	,
OSAIllegalAssign	=-10003,
errOSACantAssign	=-10006
};

/*Return Value,

A result code. See “Window Manager Result Codes”. If you receive the error errUserWantsToDragWindow (–5607), your application should respond by calling the Window Manager function DragWindow. Errors are also returned from the Drag Manager, including userCanceledErr (–128).*/
enum {
 userCanceledErr  = -128

};
/*CarbonCore header file MacErrors.h.

For result codes for the AEBuild-related functions, see ??AEBuild Error Codes??.Result Code	Value	Description
noPortErr	-903	
Client hasn??t set 'SIZE' resource to indicate awareness of high-level events
destPortErr	-906	
Server hasn??t set 'SIZE' resource to indicate awareness of high-level events, or else is not present
sessClosedErr	-917	
The kAEDontReconnect flag in the sendMode parameter was set and the server quit, then restarted
errAECoercionFail	-1700	
Data could not be coerced to the requested descriptor type
errAEDescNotFound	-1701	
Descriptor was not found
errAECorruptData	-1702	
Data in an Apple event could not be read
errAEWrongDataType	-1703	
Wrong descriptor type
errAENotAEDesc	-1704	
Not a valid descriptor
errAEBadListItem	-1705	
Operation involving a list item failed
errAENewerVersion	-1706	
Need a newer version of the Apple Event Manager
errAENotAppleEvent	-1707	
The event is not in AppleEvent format.
errAEEventNotHandled	-1708	
Event wasn??t handled by an Apple event handler
errAEReplyNotValid	-1709	
AEResetTimer was passed an invalid repl
errAEUnknownSendMode	-1710	
Invalid sending mode was passed
errAEWaitCanceled	-1711	
User canceled out of wait loop for reply or receipt
errAETimeout	-1712	
Apple event timed out
errAENoUserInteraction	-1713	
No user interaction allowed
errAENotASpecialFunction	-1714	
Wrong keyword for a special function
errAEParamMissed	-1715	
A required parameter was not accessed.
errAEUnknownAddressType	-1716	
Unknown Apple event address type
errAEHandlerNotFound	-1717	
No handler found for an Apple event
errAEReplyNotArrived	-1718	
Reply has not yet arrived
errAEIllegalIndex	-1719	
Not a valid list index
errAEImpossibleRange	-1720	
The range is not valid because it is impossible for a range to include the first and last objects that were specified; an example is a range in which the offset of the first object is greater than the offset of the last object
errAEWrongNumberArgs	-1721	
The number of operands provided for the kAENOT logical operator is not 1
errAEAccessorNotFound	-1723	
There is no object accessor function for the specified object class and container type
errAENoSuchLogical	-1725	
The logical operator in a logical descriptor is not kAEAND, kAEOR, or kAENOT
errAEBadTestKey	-1726	
The descriptor in a test key is neither a comparison descriptor nor a logical descriptor
errAENotAnObjectSpec	??1727	
The objSpecifier parameter of AEResolve is not an object specifier
errAENoSuchObject	-1728	
Runtime resolution of an object failed.
errAENegativeCount	-1729	
An object-counting function returned a negative result
errAEEmptyListContainer	-1730	
The container for an Apple event object is specified by an empty list
errAEUnknownObjectType	-1731	
The object type isn??t recognized
errAERecordingIsAlreadyOn	-1732	
Recording is already on
errAEReceiveTerminate	-1733	
Break out of all levels of AEReceive to the topmost (1.1 or greater)
errAEReceiveEscapeCurrent	-1734	
Break out of lowest level only of AEReceive (1.1 or greater)
errAEEventFiltered	-1735	
Event has been filtered and should not be propagated (1.1 or greater)
errAEDuplicateHandler	-1736	
Attempt to install handler in table for identical class and ID (1.1 or greater)
errAEStreamBadNesting	-1737	
Nesting violation while streaming
errAEStreamAlreadyConverted	-1738	
Attempt to convert a stream that has already been converted
errAEDescIsNull	-1739	
Attempt to perform an invalid operation on a null descriptor
errAEBuildSyntaxError	-1740	
AEBuildDesc and related functions detected a syntax error
errAEBufferTooSmall	-1741	
Buffer for AEFlattenDesc too small
errASCantConsiderAndIgnore	-2720	
Can??t both consider and ignore <attribute>.
errASCantCompareMoreThan32k	-2721	
Can??t perform operation on text longer than 32K bytes.
errASTerminologyNestingTooDeep	-2760	
Tell statements are nested too deeply.
errASIllegalFormalParameter	-2761	
<name> is illegal as a formal parameter.
errASParameterNotForEvent	-2762	
<name> is not a parameter name for the event <event>.
errASNoResultReturned	-2763	
No result was returned for some argument of this expression. 
errAEEventFailed	-10000	
Apple event handler failed.
errAETypeError	-10001	
A descriptor type mismatch occurred.
errAEBadKeyForm	-10002	
Invalid key form.
errAENotModifiable	-10003	
Can't set <object or data> to <object or data>. Access not allowed.
errAEPrivilegeError	-10004	
A privilege violation occurred.
errAEReadDenied	-10005	
The read operation was not allowed.
errAEWriteDenied	-10006	
Can't set <object or data> to <object or data>. 
errAEIndexTooLarge	-10007	
The index of the event is too large to be valid.
errAENotAnElement	-10008	
The specified object is a property, not an element.
errAECantSupplyType	-10009	
Can??t supply the requested descriptor type for the data.
errAECantHandleClass	-10010	
The Apple event handler can??t handle objects of this class.
errAEInTransaction	-10011	
Couldn??t handle this command because it wasn??t part of the current transaction.
errAENoSuchTransaction	-10012	
The transaction to which this command belonged isn??t a valid transaction.
errAENoUserSelection	-10013	
There is no user selection.
errAENotASingleObject	-10014	
Handler only handles single objects.
errAECantUndo	-10015	
Can??t undo the previous Apple event or user action.
errAENotAnEnumMember	-10023	
Enumerated value in SetData is not allowed for this property
errAECantPutThatThere	-10024	
In make new, duplicate, etc. class can't be an element of container
errAEPropertiesClash	-10025	
Illegal combination of properties settings for SetData, make new, or duplicate
MacErrors.h*/
enum{
noPortErr	 = -903,
destPortErr=-906,
sessClosedErr=-917,
errAECoercionFail=	-1700,
errAEDescNotFound	=-1701	,
errAECorruptData	=-1702	,
errAEWrongDataType=	-1703,	
errAENotAEDesc	=-1704	,
errAEBadListItem	=-1705	,
errAENewerVersion	=-1706	,
errAENotAppleEvent	=-1707	,
errAEEventNotHandled	=-1708,	
errAEReplyNotValid	=-1709	,
errAEUnknownSendMode=	-1710,	
errAEWaitCanceled	=-1711	,
errAETimeout	=-1712	,
errAENoUserInteraction	=-1713	,
errAENotASpecialFunction=	-1714,	
errAEParamMissed	=-1715	,
errAEUnknownAddressType=	-1716	,
errAEHandlerNotFound=	-1717	,
errAEReplyNotArrived=	-1718	,
errAEIllegalIndex	       =-1719,
errAEImpossibleRange=	-1720,	
errAEWrongNumberArgs	=-1721,
errAEAccessorNotFound	=-1723,
errAENoSuchLogical	=-1725     ,
errAEBadTestKey             =-1726   ,
errAENotAnObjectSpec    =  -1727  ,
errAENoSuchObject         = -1728	,
errAENegativeCount	=-1729	,
errAEEmptyListContainer=	-1730,	
errAEUnknownObjectType=	-1731	,
errAERecordingIsAlreadyOn=	-1732	,
errAEReceiveTerminate	=-1733	,
errAEReceiveEscapeCurrent=	-1734,	
errAEEventFiltered	=-1735	,
errAEDuplicateHandler=	-1736,	
errAEStreamBadNesting	=-1737	,
errAEStreamAlreadyConverted	=-1738,	
errAEDescIsNull	=-1739	,
errAEBuildSyntaxError=	-1740,	
errAEBufferTooSmall	=-1741	,
errASCantConsiderAndIgnore=	-2720,	
errASCantCompareMoreThan32k=	-2721	,
errASTerminologyNestingTooDeep=	-2760	,
errASIllegalFormalParameter	=-2761	,
errASParameterNotForEvent	=-2762	,
errASNoResultReturned	=-2763	,
errAEEventFailed	=-10000	,
errAETypeError	=-10001	,
errAEBadKeyForm	=-10002	,
errAENotModifiable	=-10003	,
errAEPrivilegeError	=-10004	,
errAEReadDenied	=-10005	,
errAEWriteDenied	=-10006	,
errAEIndexTooLarge=	-10007,	
errAENotAnElement	=-10008	,
errAECantSupplyType=	-10009	,
errAECantHandleClass=	-10010	,
errAEInTransaction	=-10011	,
errAENoSuchTransaction=	-10012	,
errAENoUserSelection=	-10013	,
errAENotASingleObject=	-10014	,
errAECantUndo	=-10015	,
errAENotAnEnumMember	=-10023	,
errAECantPutThatThere	=-10024	,
errAEPropertiesClash	=-10025	
};


#ifdef __cplusplus
}
#endif

#endif