#ifndef CFDATA_H
#define CFDATA_H

#include <CoreFoundation/CFBase.h>

#if defined(__cplusplus)
extern "C" {
#endif


 #include <ETC/CoreFoundation/CFData.h>

/*CFDataRef

A reference to an immutable CFData object.

typedef const struct __CFData *CFDataRef;
Availability
Available in Mac OS X v10.0 and later.*/
typedef const struct __CFData *CFDataRef;


/*CFDataGetBytes

Copies the byte contents of a CFData object to an external buffer.

void CFDataGetBytes (
   CFDataRef theData,
   CFRange range,
   UInt8 *buffer
);
Parameters
theData

The CFData object to examine. 
range

The range of bytes in theData to get. To get all of the contents, pass CFRangeMake(0,CFDataGetLength(theData)). 
buffer

A pointer to the byte buffer of length range.length that is allocated on the stack or heap. On return, the buffer contains the requested range of bytes. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
void CFDataGetBytes (
   CFDataRef theData,
   CFRange range,
   UInt8 *buffer
);

/*CFDataGetLength

Returns the number of bytes contained by a CFData object.

CFIndex CFDataGetLength (
   CFDataRef theData
);
Parameters
theData

The CFData object to examine. 
Return Value

An index that specifies the number of bytes in theData. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFIndex CFDataGetLength (
   CFDataRef theData
);

/*CFDataCreate

Creates an immutable CFData object using data copied from a specified byte buffer.

CFDataRef CFDataCreate (
   CFAllocatorRef allocator,
   const UInt8 *bytes,
   CFIndex length
);
Parameters
allocator

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator.
bytes

A pointer to the byte buffer that contains the raw data to be copied into theData. 
length

The number of bytes in the buffer (bytes). 
Return Value

A new CFData object, or NULL if there was a problem creating the object. Ownership follows the Create Rule.
Discussion

You must supply a count of the bytes in the buffer. This function always copies the bytes in the provided buffer into internal storage. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFDataRef CFDataCreate (
   CFAllocatorRef allocator,
   const UInt8 *bytes,
   CFIndex length
);


#ifdef __cplusplus
}
#endif
#endif