/**
    Core Foundation Emulation Library
    ---------------------------------

    A source-compatible emulation of the CoreFoundation framework based
    upon the GNUstep Base Library.

    Copyright (C) 2007 Christopher Armstrong 

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef CFSTRING_H
#define CFSTRING_H

#ifndef CFBASE_H
#include <CoreFoundation/CFBase.h>
#endif

#ifndef CFDATA_H
#include <CoreFoundation/CFData.h>
#endif

#ifndef CFARRAY_H
#include <CoreFoundation/CFArray.h>
#endif

#ifndef CFDICTIONARY_H
#include <CoreFoundation/CFDictionary.h>
#endif

#ifndef CFCHARACTERSET_H
#include <CoreFoundation/CFCharacterSet.h>
#endif

typedef UInt32 CFStringEncoding;

/* CFString Constructors */

CFStringRef CFStringCreateCopy(
  CFAllocatorRef alloc,
  CFStringRef aString
  );

CFStringRef CFStringCreateWithBytes(
  CFAllocatorRef alloc,
  const UInt8 *bytes,
  CFIndex count,
  CFStringEncoding encoding,
  Boolean externalRep
  );

CFStringRef CFStringCreateWithCharacters(
  CFAllocatorRef alloc,
  const UniChar *chars,
  CFIndex count
  );

CFStringRef CFStringCreateWithCharactersNoCopy(
  CFAllocatorRef alloc,
  const UniChar *chars,
  CFIndex numchars,
  CFAllocatorRef contentsDeallocator
  );

CFStringRef CFStringCreateWithCString(
  CFAllocatorRef alloc,
  const char *cstr,
  CFStringEncoding encoding
  );


CFStringRef CFSTR(
  const char *cStr
  );

CFStringRef CFStringCreateByCombiningStrings(
  CFAllocatorRef alloc,
  CFArrayRef theArray,
  CFStringRef separatorString
  );

/* Show a string */
void CFShow(
  CFTypeRef obj
  );

/* CFData Interaction */
CFDataRef CFStringCreateExternalRepresentation(
  CFAllocatorRef alloc, 
  CFStringRef aString,
  CFStringEncoding encoding,
  UInt8 lossyBytei
  );

/* Create an array of strings by separation using a sub string */
CFArrayRef CFStringCreateArrayBySeparatingStrings(
  CFAllocatorRef alloc,
  CFStringRef theString,
  CFStringRef separator
  );

/* String searching functions */
CFArrayRef CFStringCreateArrayWithFindResults(
  CFAllocatorRef alloc,
  CFStringRef aString,
  CFStringRef searchString,
  CFRange searchRange,
  CFOptionFlags compareOptions
  );

CFRange CFStringFind(
  CFStringRef aString,
  CFStringRef searchString,
  CFOptionFlags compareOptions
  );

Boolean CFStringFindCharacterFromSet(
  CFStringRef aString,
  CFCharacterSetRef theSet,
  CFRange range,
  CFOptionFlags searchOptions,
  CFRange *result
  );


/* Enumerations */
typedef enum {
  kCFCompareCaseInsensitive = 1,
  kCFCompareBackwards = 4,
  kCFCompareAnchored = 8,
  kCFCompareNonliteral = 16,
  kCFCompareLocalized = 32,
  kCFCompareNumerically = 64
  } CFStringCompareFlags;

#endif
