#ifndef HIVIEW_H
#define HIVIEW_H

#ifndef CONTROLS_H
#include <HIToolbox/Controls.h>
#endif

#ifndef CARBONEVENTS_H
#include <HIToolbox/CarbonEvents.h>
#endif

#include <HYS/HIToolbox/HIView.h>

#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*HIViewID

Defines the HIView ID.

typedef ControlID HIViewID;
Availability
Available in Mac OS X v10.2 and later.*/
typedef ControlID HIViewID;

/*Standard View Constants

Specify IDs of views that are commonly used. 

   
const HIViewID kHIViewWindowContentID;
const HIViewID kHIViewWindowGrowBoxID;
const HIViewID kHIViewMenuContentID;
Constants
kHIViewWindowContentID

The standard view ID for the content view of a window.

Available in Mac OS X v10.2 and later.
kHIViewWindowGrowBoxID

The standard view ID for the grow box view of a window. Not all windows have grow boxes, so you might not find this view if you look for it.

Available in Mac OS X v10.2 and later.
kHIViewMenuContentID

The standard view ID for the content view of a menu. The Menu Manager assigns this view ID to all menu content views.

Available in Mac OS X v10.3 and later.*/
const HIViewID kHIViewWindowContentID;
const HIViewID kHIViewWindowGrowBoxID;
const HIViewID kHIViewMenuContentID;

/*HILayoutInfoVersion Constant

Specify version 0 of the HILayoutInfo structure

enum {
   kHILayoutInfoVersionZero = 0
};
Constants
kHILayoutInfoVersionZero

The version of the HILayoutInfo structure is 0.

Available in Mac OS X v10.3 and later.*/
enum {
   kHILayoutInfoVersionZero = 0
};

/*HIViewRef

Define an HIView reference.

typedef ControlRef HIViewRef;
Availability
Available in Mac OS X v10.2 and later.*/
typedef ControlRef HIViewRef;

/*HIPositionKind Constants

Specify position constants used by the HIView layout engine.

enum {
   kHILayoutPositionNone = 0,
   kHILayoutPositionCenter = 1,
   kHILayoutPositionMin = 2,
   kHILayoutPositionMax = 3,
   kHILayoutPositionLeft = kHILayoutPositionMin,
   kHILayoutPositionRight = kHILayoutPositionMax,
   kHILayoutPositionTop = kHILayoutPositionMin,
   kHILayoutPositionBottom = kHILayoutPositionMax
};
typedef UInt16 HIPositionKind;
Constants
kHILayoutPositionNone

No positioning is to occur.

Available in Mac OS X v10.3 and later.
kHILayoutPositionCenter

Bind to the center.

Available in Mac OS X v10.3 and later.
kHILayoutPositionMin

Bind to the minimum of the axis.

Available in Mac OS X v10.3 and later.
kHILayoutPositionMax

Bind to the maximum of the axis.

Available in Mac OS X v10.3 and later.
kHILayoutPositionLeft

Synonym for kHILayoutPositionMin.

Available in Mac OS X v10.3 and later.
kHILayoutPositionRight

Synonym for kHILayoutPositionMax.

Available in Mac OS X v10.3 and later.
kHILayoutPositionTop

Synonym for kHILayoutPositiondMin.

Available in Mac OS X v10.3 and later.
kHILayoutPositionBottom

Synonym for kHILayoutPositionMax.

Available in Mac OS X v10.3 and later.*/
enum {
   kHILayoutPositionNone = 0,
   kHILayoutPositionCenter = 1,
   kHILayoutPositionMin = 2,
   kHILayoutPositionMax = 3,
   kHILayoutPositionLeft = kHILayoutPositionMin,
   kHILayoutPositionRight = kHILayoutPositionMax,
   kHILayoutPositionTop = kHILayoutPositionMin,
   kHILayoutPositionBottom = kHILayoutPositionMax
};
typedef UInt16 HIPositionKind;

/*HIAxisPosition

An axial position description for an HIView.

struct HIAxisPosition {
   HIViewRef toView;
   HIPositionKind kind;
   float offset;
};
Fields
toView

An HIViewRef to the view relative to which a view positioned. This field can be NULL, which indicates that the axis is positioned relative to its parent’s view.
kind

The type of positioning. For possible values, see HIPositionKind Constants.
offset

After the position kind has been applied, the origin component that corresponds to the positioning axis is offset by this value. For example, left aligned + 10.*/
struct HIAxisPosition {
   HIViewRef toView;
   HIPositionKind kind;
   float offset;
};
typedef struct HIAxisPosition HIAxisPosition;

/*HIPositioning

A positioning description for an HIView.

struct HIPositioning {
   HIAxisPosition x;
   HIAxisPosition y;
};
Fields
x

The X axis.
y

The Y axis.*/

struct HIPositioning {
   HIAxisPosition x;
   HIAxisPosition y;
};
typedef struct HIPositioning HIPositioning ;

/*HIScaleKind Constant

Specify a constant that indicates the scale is determined from the axis size.

enum {
   kHILayoutScaleAbsolute = 0
};
typedef UInt16 HIScaleKind;
Constants
kHILayoutScaleAbsolute

Indicates that the scale is determined from the axis size.

Available in Mac OS X v10.3 and later.
Discussion

This constant is used in conjunction with the HIView layout engine.*/
enum {
   kHILayoutScaleAbsolute = 0
};
typedef UInt16 HIScaleKind;


/*HIAxisScale

Represents a scale description for an axis of a view. 

struct HIAxisScale {
   HIViewRef toView;
   HIScaleKind kind;
   float ratio;
};
Fields
toView

An HIViewRef to the view to which this axis is scaled. This field can be NULL, which indicates that the axis is scaled relative to its parent’s view.
kind

The type of scaling. Currently, this field must be kHILayoutScaleAbsolute.
ratio

A value that indicates how much to scale the view. Zero indicates no scaling. A value of one indicates that the view is to always have the same axial size.*/
struct HIAxisScale {
   HIViewRef toView;
   HIScaleKind kind;
   float ratio;
};
typedef struct HIAxisScale HIAxisScale;

/*HIViewID

Defines the HIView ID.

typedef ControlID HIViewID;
Availability
Available in Mac OS X v10.2 and later.*/
typedef ControlID HIViewID;



/*HILayout Binding Kind Constants

Specify binding constants used by the HIView layout engine.

enum {
kHILayoutBindNone = 0,
kHILayoutBindMin = 1,
kHILayoutBindMax= 2,
kHILayoutBindLeft = kHILayoutBindMin,
kHILayoutBindRight = kHILayoutBindMax,
kHILayoutBindTop = kHILayoutBindMin,
kHILayoutBindBottom = kHILayoutBindMax
};
typedef UInt16 HIBindingKind;
Constants
kHILayoutBindNone

No binding is to occur.

Available in Mac OS X v10.3 and later.
kHILayoutBindMin

Bind to the minimum of the axis.

Available in Mac OS X v10.3 and later.
kHILayoutBindMax

Bind to the maximum of the axis.

Available in Mac OS X v10.3 and later.
kHILayoutBindLeft

Synonym for kHILayoutBindMin.

Available in Mac OS X v10.3 and later.
kHILayoutBindRight

Synonym for kHILayoutBindMax.

Available in Mac OS X v10.3 and later.
kHILayoutBindTop

Synonym for kHILayoutBindMin.

Available in Mac OS X v10.3 and later.
kHILayoutBindBottom

Synonym for kHILayoutBindMax.

Available in Mac OS X v10.3 and later.
Discussion

Mac OS X v10.3 provides a layout engine for HIViews that allows applications to specify the layout relationships between multiple views. When necessary, the layout engine automatically repositions and resizes views that have layout information. For more information on how to use the layout engine, see HIViewSetLayoutInfo.

Horizontal and vertical bindings are very similar in application, but along different axes, so the binding kinds have been abstracted to minimum and maximum. Synonyms are provided for convenience, and you are encouraged to use them.
Availability
Available in Mac OS X v10.3 and later.*/
enum {
kHILayoutBindNone = 0,
kHILayoutBindMin = 1,
kHILayoutBindMax= 2,
kHILayoutBindLeft = kHILayoutBindMin,
kHILayoutBindRight = kHILayoutBindMax,
kHILayoutBindTop = kHILayoutBindMin,
kHILayoutBindBottom = kHILayoutBindMax
};
typedef UInt16 HIBindingKind;

/*HIScaling

A set of scaling descriptions for the axes of a view.

struct HIScaling {
   HIAxisScale x;
   HIAxisScale y;
};
Fields
x

The horizontal scaling for a view.
x

The vertical scaling for a view.*/
struct HIScaling {
   HIAxisScale x;
   HIAxisScale y;
};
typedef struct HIScaling  HIScaling ;

/*HISideBinding

Structure for storing the binding for the side of a view. 

struct HISideBinding {
   HIViewRef toView;
   HIBindingKind kind;
   float offset;
};
Fields
toView

An HIViewRef to the view to which this side is bound. This field can be NULL, which indicates that the side is bound to its parent view.
kind

The bind kind. For possible values, see HILayout Binding Kind Constants.
offset

Reserved; must be set to zero.
Discussion

The layout engine can automatically reposition and resize views for which relationships have been set up. (Call HIViewSetLayoutInfo to establish these relationships.) A side binding is entirely related to the change of the parent’s position or size but only as the size affects the maximum edge position. A side binding doesn’t mean “move to where my relative’s side is” but rather “move as my relative’s side has moved.”*/
struct HISideBinding {
   HIViewRef toView;
   HIBindingKind kind;
   float offset;
};

typedef  struct HISideBinding  HISideBinding ;

/*HIBinding

Represents a set of top, left, bottom, and right bindings for an view. 

struct HIBinding {
   HISideBinding top;
   HISideBinding left;
   HISideBinding bottom;
   HISideBinding right;
};
Fields
top

The top side bindings.
left

The left side bindings.
bottom

The bottom side bindings.
right

The right side bindings.
Discussion

These constants are used in conjunction with the HIView layout engine.*/
struct HIBinding {
   HISideBinding top;
   HISideBinding left;
   HISideBinding bottom;
   HISideBinding right;
};
typedef struct HIBinding HIBinding;

/*HILayoutInfo

Structure that stores the layout of an HIView.

struct HILayoutInfo {
   UInt32 version;
   HIBinding binding;
   HIScaling scale;
   HIPositioning position;
};
Fields
version

The version of this structure. The current version is kHILayoutInfoVersionZero.
binding

An HIBinding structure describing the bindings to apply to the sides of an HIView.
scale

An HIScaling structure describing the axial scaling to apply to an HIView.
position

An HIPositioning structure describing the positioning to apply to an HIView.
Discussion

This structure is provided as a parameter to HIViewGetLayoutInfo and HIViewSetLayoutInfo.*/
struct HILayoutInfo {
   UInt32 version;
   HIBinding binding;
   HIScaling scale;
   HIPositioning position;
};
typedef struct HILayoutInfo  HILayoutInfo ;


/*HIViewFindByID

Obtains a view by its ID. 

OSStatus HIViewFindByID (
   HIViewRef inStartView,
   HIViewID inID,
   HIViewRef * outControl
);
Parameters
inStartView

The view to start searching at. 
inID

The ID of the view you are looking for. 
outControl

Receives the control if found. 
Return Value

An operating system result code.
Discussion

Allows you to find a particular view by its ID. The HIViewID type used by this function is identical to the ControlID type used by the Control Manager.
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus HIViewFindByID (
   HIViewRef inStartView,
   HIViewID inID,
   HIViewRef * outControl
);

/*HIViewGetRoot

Obtains the root view for a window. 

HIViewRef HIViewGetRoot (
   WindowRef inWindow
);
Parameters
inWindow

The window to get the root for.
Return Value

The root view for the window, or NULL if an invalid window is passed.
Discussion

Note that the root view is not the same as the Control Manager root control.
Availability
Available in Mac OS X v10.2 and later.*/

HIViewRef HIViewGetRoot (
   WindowRef inWindow
);

/*HIViewGetBounds

Obtains the local bounds of a view. 

OSStatus HIViewGetBounds (
   HIViewRef inView,
   HIRect* outRect
);
Parameters
inView

The view whose local bounds are to be obtained.
outRect

The local bounds of the view.
Return Value

An operating system result code.
Discussion

The local bounds are the coordinate system that is completely view-relative. A view’s top left coordinate starts out at 0, 0. Most operations use local coordinates. Note, however, that the frame is used to move a view, not local coordinates.
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus HIViewGetBounds (
   HIViewRef inView,
   HIRect* outRect
);

/*HIViewSetNeedsDisplay

Marks a view as needing or not needing to be redrawn.

OSStatus HIViewSetNeedsDisplay (
   HIViewRef inView,
   Boolean inNeedsDisplay
);
Parameters
inView

The view to mark as dirty (needing to be redrawn) or clean (not needing to be redrawn).
inNeedsDisplay

A Boolean whose value is true to mark the view as dirty or false to mark it as clean.
Return Value

An operating system result code.
Discussion

If the view is not visible or is obscured completely by other views, no action is taken.
Availability
Available in Mac OS X v10.2 and later.*/

OSStatus HIViewSetNeedsDisplay (
   HIViewRef inView,
   Boolean inNeedsDisplay
);

/*HIViewAddSubview

Adds a subview to the given parent view.

OSStatus HIViewAddSubview (
   HIViewRef inParent,
   HIViewRef inNewChild
);
Parameters
inParent

The view that will receive the new subview.
inNewChild

The subview being added.
Return Value

An operating system result code. The result code errNeedsCompositedWindow is returned if you try to embed into the content view in a non-compositing window; you can only embed into the content view in a compositing window.
Discussion

The new subview is added to the front of the list of subviews (that is, it is made topmost). The subview being added is not retained by the new parent view. Do not release the view after adding it, or it will cease to exist. All views in a window are released automatically when the window is destroyed.
Availability
Available in Mac OS X v10.2 and later.*/

OSStatus HIViewAddSubview (
   HIViewRef inParent,
   HIViewRef inNewChild
);

/*HIViewSetLayoutInfo

Sets the layout information of an HIView. 

OSStatus HIViewSetLayoutInfo (
   HIViewRef inView,
   HILayoutInfo * inLayoutInfo
);
Parameters
inView

The view whose layout information is to be set.
inLayoutInfo

A pointer to an HILayoutInfo structure containing the layout values that are to be set.
Return Value

An operating system result code.
Discussion

Layouts are used to automatically change the size and positioning of a view when another view changes size or position. Layout changes only take effect in two cases:
When HIViewApplyLayout is called after the view’s layout has been set by calling HIViewSetLayoutInfo. The HIViewApplyLayout function is most useful when first applying a scaling or positioning layout to a view in order to set up the view’s initial position and size relative to the view referenced in the layout.
When the related view changes its size or position.

A layout allows a view’s size or position to be modified in three ways: side binding, axial scaling, and axial positioning. In the following examples, View A initially has a left side of 100 and a right side of 150, and is placed inside a parent view that has a width of 275.
Bindings — Setting up a binding relationship between two views specifies that one edge of a view is to change by an amount equal to the change in an edge of another view. If View A has a right-side binding to its parent’s maximum (or right) side, when the parent’s right side changes, View A’s right side changes by the same amount. If the parent view resizes to be 325 units wide (50 units wider than before), View A is resized so that its left side changes to 150 units and its right side changes to 200, which is 50 units more to the right than before. You can think of bindings as a way to maintain distance. An edge bound to another view’s edge always maintains its offset from that related edge. In other view systems, this concept is often referred to as “springs and rods.” Note that a binding does not cause one side of the view to exactly align with the side of another view; a binding merely causes one side of the view to change by the same amount as another view changes. To align one edge of a view to another view’s edge, use positioning. Bindings depend on changes in size or position of the related view. As a result, calling HIViewApplyLayout does not activate side bindings, as no changes have occurred. Bindings are implemented using the HIBinding structure and one HISideBinding structure per view edge.
Scaling — Setting up a scaling relationship between two views specifies that the axial size (that is, the width or height) of a view is to be a specified ratio of the size of another view when that other view moves or resizes. If View A has an x-axis scaling for its parent view with a ratio of 0.8, when the parent view’s width changes, View A’s width changes to be the parent’s width multiplied by 0.8. If the parent view resizes to be 325 units wide, View A resizes so that its left side stays at 100 and its right side changes to 360 (100 + 325 * 0.8). Note that when a scaling layout is first set up on a view with HIViewSetLayoutInfo, no scaling is applied to the view because scaling only occurs when the related view resizes. If scaling is required at initial setup, call HIViewSetLayoutInfo and then HIViewApplyLayout. Scaling is implemented using the HIScaling structure and one HIAxisScale structure per view axis.
Positioning — Setting up a positioning relationship between two views specifies that the axial position (i.e., vertical or horizontal) of a view is to change so that the view aligns with the minimum, maximum, or center of another view when that other view resizes. If View A has an x-axis position with its parent view with center positioning specified, when the parent view changes size, View A moves so that it is centered horizontally relative to its parent. If the parent view resizes to be 300 units wide, View A repositions so that its left side is at 125 and its right side is at 175, centered in the parent view. Positioning is implemented using the HIPositioning structure and one HIAxisPosition per view axis.

The HIView layout engine applies transformations to a view sequentially. First, bindings are applied. Then scaling is applied, which could override some of the previously applied bindings. Then positioning is applied, which could also override some of the previously applied bindings. The bindings are applied recursively to a container’s subviews, which requires care on your part to avoid infinite recursion, especially when applying inter-relational bindings. For example, if View A’s x axis is scaled relative to View B and View B’s x-axis is scaled to View A, your application could hang when the layouts are applied because View A would affect View B, which would affect View A, and so on.

For more information on using the layout engine, see HIView Programming Guide.
Availability
Available in Mac OS X v10.3 and later.*/
OSStatus HIViewSetLayoutInfo (
   HIViewRef inView,
   HILayoutInfo * inLayoutInfo
);

/*HIViewSetVisible

Hides or shows a view. 

OSStatus HIViewSetVisible (
   HIViewRef inView,
   Boolean inVisible
);
Parameters
inView

The view to hide or show.
inVisible

A Boolean value that indicates whether you want to hide the view (false) or show the view (true).
Return Value

An operating system result code.
Discussion

Marks the area the view will occupy or previously occupied as needing to be redrawn later. 
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus HIViewSetVisible (
   HIViewRef inView,
   Boolean inVisible
);

/*HIViewGetLastSubview

Returns the last subview in a parent view.

HIViewRef HIViewGetLastSubview (
   HIViewRef inView
);
Parameters
inView

The view whose subview you are fetching.
Return Value

An HIView reference, or NULL if this view has no subviews or is invalid.
Discussion

Returns the last subview of a container. The last subview is the bottommost subview in z-order.
Availability
Available in Mac OS X v10.2 and later.*/
HIViewRef HIViewGetLastSubview (
   HIViewRef inView
);

/*HIViewGetPreviousView

Returns the view above the specified view.

HIViewRef HIViewGetPreviousView (
   HIViewRef inView
);
Parameters
inView

The view to use as reference.
Return Value

An HIView reference, or NULL if this view has no view in front of it or is invalid.
Discussion

Returns the view before the specified view, in z-order.
Availability
Available in Mac OS X v10.2 and later.*/
HIViewRef HIViewGetPreviousView (
   HIViewRef inView
);

#ifdef __cplusplus
}
#endif

#endif