#ifndef MACTEXTEDITOR_H
#define MACTEXTEDITOR_H


#ifndef APPLICATIONSERVICES_H
#include <ApplicationServices/ApplicationServices.h>
#endif

#ifndef DRAG_H
#include <HIToolbox/Drag.h>
#endif

#ifndef MACWINDOWS_H
#include <HIToolbox/MacWindows.h>
#endif

#ifndef EVENTS_H
#include <HIToolbox/Events.h>
#endif

#ifndef CARBONEVENTS_H
#include <HIToolbox/CarbonEvents.h>
#endif

#ifndef HIVIEW_H
#include <HIToolbox/HIView.h>
#endif



#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*Supported Data Types

Specifies the type of data being requested from or passed to an MLTE function.

typedef OSType TXNDataType;
enum {
   kTXNTextData = 'TEXT',
   kTXNPictureData = 'PICT',
   kTXNMovieData = 'moov',
   kTXNSoundData = 'snd ',
   kTXNUnicodeTextData = 'utxt'
};
Constants
kTXNTextData

Text data.

Available in Mac OS X v10.0 and later.
kTXNPictureData

Graphics (PICT) data.

Available in Mac OS X v10.0 and later.
kTXNMovieData

Movie or sound data.

Available in Mac OS X v10.0 and later.
kTXNSoundData

Sound data.

Available in Mac OS X v10.0 and later.
kTXNUnicodeTextData

Unicode text data.

Available in Mac OS X v10.0 and later.
Discussion

Used in the TXNGetDataEncoded function.*/
typedef OSType TXNDataType;
enum {
   kTXNTextData = 'TEXT',
   kTXNPictureData = 'PICT',
   kTXNMovieData = 'moov',
   kTXNSoundData = 'snd ',
   kTXNUnicodeTextData = 'utxt'
};

/*Data Offsets

Specifies offsets to use when manipulating data in a text object. Offsets in MLTE are always character offsets.

typedef UInt32 TXNOffset;
enum {
   kTXNUseCurrentSelection = 0xFFFFFFFF,
   kTXNStartOffset = 0,
   kTXNEndOffset = 0x7FFFFFFF
};
Constants
kTXNUseCurrentSelection

Use the current selection.

Available in Mac OS X v10.0 and later.
kTXNStartOffset

The first offset of the text in a text object.

Available in Mac OS X v10.0 and later.
kTXNEndOffset

The last offset of the text in a text object.

Available in Mac OS X v10.0 and later.
Discussion

These constants can be passed and returned in functions that have the parameter of type TXNOffset.*/
typedef UInt32 TXNOffset;
enum {
   kTXNUseCurrentSelection = 0xFFFFFFFF,
   kTXNStartOffset = 0,
   kTXNEndOffset = 0x7FFFFFFF
};

/*TXNObject

Contains private variables and functions necessary to represent text and handle text formatting at a document level. 

typedef struct OpaqueTXNObject * TXNObject;
Discussion

You obtain a structure of type TXNObject from the TXNNewObject function. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OpaqueTXNObject * TXNObject;

/*TXNRevert

Reverts to the last saved version of a document. 

OSStatus TXNRevert (
   TXNObject iTXNObject
);
Parameters
iTXNObject

The text object for the active document. 
Return Value

A result code. See “MLTE Result Codes”.
Discussion

You can use the TXNRevert function with files that contain only text as well as files that were created using MLTE. If the file was not previously saved, the document reverts to an empty document. To revert to data that is embedded in a private file type, use the TXNSetSelection function to select all of the current data and then use the TXNSetDataFromFile function to read in the old data. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNRevert (
   TXNObject iTXNObject
);

/*TXNPageSetup

Displays the Page Setup dialog for the current default printer and manages changes, such as reformatting the text, in response to page layout changes.

OSStatus TXNPageSetup (
   TXNObject iTXNObject
);
Parameters
iTXNObject

The text object for the active document. 
Return Value

A result code. See “MLTE Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNPageSetup (
   TXNObject iTXNObject
);

/*TXNPrint

Prints the document so it is formatted to fit the page size selected for the printer. 

OSStatus TXNPrint (
   TXNObject iTXNObject
);
Parameters
iTXNObject

The text object that identifies the document you want to print. 
Return Value

A result code. See “MLTE Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNPrint (
   TXNObject iTXNObject
);

/*TXNGetDataEncoded

Copies the text in a specified range, and if necessary, translates the text to match your application’s preferred encoding. 

OSStatus TXNGetDataEncoded (
   TXNObject iTXNObject,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset,
   Handle * oDataHandle,
   TXNDataType iEncoding
);
Parameters
iTXNObject

The text object that contains the data you want to copy.
iStartOffset

The absolute offset from which data copying should begin. You can use the TXNGetSelection function to get the absolute offsets of the current selection. 
iEndOffset

The absolute offset at which data copying should end. You can use the TXNGetSelection function to get the absolute offsets of the current selection.
oDataHandle

A pointer to a handle. On return, a handle to the requested data. TXNGetDataEncoded allocates the handle as necessary. Your application must dispose of the handle. If there is no text in the range specified, the returned handle is NULL, and the function returns noErr.
encoding

The type of data to be encoded. See Supported Data Types for a full description of possible values. You should specify either the kTXNTextData or kTXNUnicodeTextData constant. If the iEncoding parameter specifies an encoding different from that used to store the text data internally, the Conversion Manager translates the data to the specified type (text or Unicode). If the iEncoding parameter is not recognized, the data is returned in the current encoding. On systems that do not use ATSUI version 1.1 or later, the current encoding is the Mac OS encoding. Otherwise, the current encoding is Unicode. 
Return Value

A result code. See “MLTE Result Codes”.
Discussion

Offsets in MLTE are always character offsets. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNGetDataEncoded (
   TXNObject iTXNObject,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset,
   Handle * oDataHandle,
   TXNDataType iEncoding
);

/*HITextViewGetTXNObject

Obtains the text object associated with an HITextView.

TXNObject HITextViewGetTXNObject(
   HIViewRef inTextView)
);
Parameters
inTextView

The HITextView associated with the text object you want to retrieve.
Return Value

Returns the text object associated with the given view.
Discussion

You can supply the extracted text object as a parameter to many of the MLTE functions that take a text object as a parameter. However, not all MLTE functions that take a text object can operate on an MLTE object that comes from an HITextView. In general, you cannot use MLTE functions that may alter the geometry of the object or explicitly invoke drawing. If you do, the function returns the result code kTXNDisabledFunctionalityErr. See HITextViewCreate for a list of the functions that return an error if you pass a text object that comes from an HITextView.
Availability
Available in Mac OS X v10.3 and later.
Declared In
MacTextEditor.h*/
TXNObject HITextViewGetTXNObject(
   HIViewRef inTextView);

/*TXNSetData

Replaces a range of data (text, graphics, and so forth).

OSStatus TXNSetData (
   TXNObject iTXNObject,
   TXNDataType iDataType,
   const void * iDataPtr,
   ByteCount iDataSize,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset
);
Parameters
iTXNObject

The text object that identifies the document in which you want to replace data.
iDataType

The type of the replacement data. See Supported Data Types for a description of possible values. 
iDataPtr

A pointer to the data that will replace the data that is in the range specified by the iStartOffset and iEndOffset parameters.
iDataSize

The size of the data (in bytes) to which iDataPtr points.
iStartOffset

The beginning of the range of data to replace. You can use the TXNGetSelection function to get the absolute offsets of the current selection. 
iEndOffset

The end of the range to replace. You can use the TXNGetSelection function to get the absolute offsets of the current selection. If you want to insert text, the ending and starting offsets should be the same value.
Return Value

A result code. See “MLTE Result Codes”.
Discussion

If you have a text object that has word wrap disabled, and you want to avoid horizontal scrolling, you can try the following. After you call the function TXNSetData, call TXNSetSelection with the value of the ending offset set to what it was before you called TXNSetData. Then, call the function TXNShowSelection to scroll the text back into view.

Offsets in MLTE are always character offsets. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNSetData (
   TXNObject iTXNObject,
   TXNDataType iDataType,
   const void * iDataPtr,
   ByteCount iDataSize,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset
);

/*TXNSetDataFromCFURLRef

Replaces a range of data with the contents of a file. (Deprecated in Mac OS X v10.4. Use TXNReadFromCFURL instead.)

Not recommended.

OSStatus TXNSetDataFromCFURLRef (
   TXNObject   iTXNObject,
   CFURLRef    iURL,
   TXNOffset   iStartOffset,
   TXNOffset   iEndOffset
);
Parameters
iTXNObject

The text object that identifies the document in which you want to replace data. You can either call the function TXNCreateObject to allocate a text object or you can call the function HITextViewGetTXNObject to obtain the text object associated with an HITextView. 
iURL

A reference to the Core Foundation URL that specifies the file which contains the data you want to add to the object. 
iStartOffset

The starting position at which to insert the file into the document. If you want to replace the current selection, set the iStartOffset parameter to kTXNCurrentSelection. If you want to replace the entire document, set the iStartOffset parameter to 0. Offsets in MLTE are always character offsets.
iEndOffset

The ending position of the range being replaced by the file. You can use the TXNGetSelection function to get the absolute offsets of the current selection. Offsets in MLTE are always character offsets.
Return Value

A result code. See “MLTE Result Codes”.
Discussion

Your application must open the file and set the iStartOffset parameter to the appropriate value before you call the TXNSetDataFromCFURLRef function. If you want to embed MLTE data within private data or other MLTE data, you must set the file position to the appropriate position.

In the (now deprecated) function TXNNewObject your could pass a file reference and MLTE supported functionality to revert back to the original file reference. When you call the function TXNSetDataFromURLRef, MLTE saves the CFURLRef. If you change the contents of the text object and then call the function TXNRevert, the document reverts to the contents specified by the saved CFURLRef.
Availability
Available in Mac OS X v10.3 and later.
Deprecated in Mac OS X v10.4.
Declared In
MacTextEditor.h*/
OSStatus TXNSetDataFromCFURLRef (
   TXNObject   iTXNObject,
   CFURLRef    iURL,
   TXNOffset   iStartOffset,
   TXNOffset   iEndOffset
);

/*TXNSetSelection

Specifies the selection range or the position of the insertion point. 

OSStatus TXNSetSelection (
   TXNObject iTXNObject,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset
);
Parameters
iTXNObject

The text object that identifies the document for which you want to set the selection range or insertion point position. 
iStartOffset

The new starting offset. Offset values are character offsets. 
iEndOffset

The new ending offset. Offset values are character offsets.
Return Value

A result code. See “MLTE Result Codes”.
Discussion

You can use the TXNSetSelection function to highlight an initial default value in a document, such as a data-entry form, or to position the insertion point at the start of the field where you want the user to enter a value. To position the insertion point, specify the same value for the iStartOffset and iEndOffset parameters. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNSetSelection (
   TXNObject iTXNObject,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset
);

/*TXNShowSelection

Scrolls the current selection into view.

void TXNShowSelection (
   TXNObject iTXNObject,
   Boolean iShowEnd
);
Parameters
iTXNObject

The text object for the current text area. 
iShowEnd

A Boolean value. If you set this to true, the end of the selection is scrolled into view. Otherwise, the beginning of the selection is scrolled into view. 
Discussion

You can use this to scroll text into view after you have called the TXNFind function and the matching text is not in the current view of the text object. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
void TXNShowSelection (
   TXNObject iTXNObject,
   Boolean iShowEnd
);

#ifdef __cplusplus
}
#endif
#endif