//inc
#ifndef IMAGECOMPRESSION_H
#define IMAGECOMPRESSION_H

#ifndef CARBON_H
#include <Carbon/Carbon.h>
#endif


#include <OpenGL/OpenGL.h>
#include <QuartzCore/CoreVideo.h>

#include <HYS/QuickTime/ImageCompression.h>
#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*Component Property IDs and Flags

Constants that contain the flags and IDs of component properties.

uppCallComponentGetComponentPropertyInfoProcInfo = 0x0003FFF0
uppCallComponentGetComponentPropertyProcInfo = 0x0003FFF0
uppCallComponentSetComponentPropertyProcInfo = 0x0000FFF0
uppCallComponentAddComponentPropertyListenerProcInfo = 0x0000FFF0
uppCallComponentRemoveComponentPropertyListenerProcInfo = 0x0000FFF0
kCallComponentExecuteWiredActionSelect     = -9
kComponentPropertyFlagCanSetLater = (1L << 0)
kComponentPropertyFlagCanSetNow = (1L << 1)
kComponentPropertyFlagCanGetNow = (1L << 3)
kComponentPropertyFlagHasExtendedInfo = (1L << 4)
kComponentPropertyFlagValueMustBeReleased = (1L << 5)
kComponentPropertyFlagValueIsCFTypeRef = (1L << 6)
kComponentPropertyFlagGetBufferMustBeInitialized = (1L << 7)
kQTComponentPropertyListenerCollectionContextVersion = 1
kQTGetComponentPropertyInfoSelect          = -11
kQTGetComponentPropertySelect              = -12
kQTSetComponentPropertySelect              = -13
kQTAddComponentPropertyListenerSelect      = -14
kQTRemoveComponentPropertyListenerSelect   = -15*/
enum {
uppCallComponentGetComponentPropertyInfoProcInfo = 0x0003FFF0,
uppCallComponentGetComponentPropertyProcInfo = 0x0003FFF0,
uppCallComponentSetComponentPropertyProcInfo = 0x0000FFF0,
uppCallComponentAddComponentPropertyListenerProcInfo = 0x0000FFF0,
uppCallComponentRemoveComponentPropertyListenerProcInfo = 0x0000FFF0,
kCallComponentExecuteWiredActionSelect     = -9,
kComponentPropertyFlagCanSetLater = (1L << 0),
kComponentPropertyFlagCanSetNow = (1L << 1),
kComponentPropertyFlagCanGetNow = (1L << 3),
kComponentPropertyFlagHasExtendedInfo = (1L << 4),
kComponentPropertyFlagValueMustBeReleased = (1L << 5),
kComponentPropertyFlagValueIsCFTypeRef = (1L << 6),
kComponentPropertyFlagGetBufferMustBeInitialized = (1L << 7),
kQTComponentPropertyListenerCollectionContextVersion = 1,
kQTGetComponentPropertyInfoSelect          = -11,
kQTGetComponentPropertySelect              = -12,
kQTSetComponentPropertySelect              = -13,
kQTAddComponentPropertyListenerSelect      = -14,
kQTRemoveComponentPropertyListenerSelect   = -15,
};

/*QTSetComponentProperty Values

Constants passed to QTSetComponentProperty.

enum {
   kComponentPropertyCacheFlagNotPersistent = (1L << 0),
   // property metadata should not be saved in persistent cache
   kComponentPropertyCacheFlagIsDynamic = (1L << 1) //property metadata should not cached at all
};
enum {
   kComponentPropertyClassPropertyInfo = 'pnfo',
   // property info class 
   // property info property IDs 
   kComponentPropertyInfoList    = 'list',
   //array of ComponentPropertyInfo (CFData),
   //one for each property 
   kComponentPropertyCacheSeed   = 'seed',
   // property cache seed value 
   kComponentPropertyCacheFlags  = 'flgs',
   // see kComponentPropertyCache flags 
   kComponentPropertyExtendedInfo = 'meta' // CFDictionary with extended property information
};
Constants
kComponentPropertyCacheFlagNotPersistent

Property metadata should not be saved in persistent cache. 

Available in Mac OS X v10.3 and later.
kComponentPropertyCacheFlagIsDynamic

Property metadata should not be cached at all. 

Available in Mac OS X v10.3 and later.
kComponentPropertyClassPropertyInfo

A QTComponentPropertyInfo structure that defines a property information class. Also 'pnfo'.

Available in Mac OS X v10.3 and later.
kComponentPropertyInfoList

An array of QTComponentPropertyInfo structures, one for each property. Also 'list'.

Available in Mac OS X v10.3 and later.
kComponentPropertyCacheSeed

A component property cache seed value. Also 'seed'.

Available in Mac OS X v10.3 and later.
kComponentPropertyCacheFlags

One of the following two flags: Also 'flgs'.

Available in Mac OS X v10.3 and later.*/
enum {
   kComponentPropertyCacheFlagNotPersistent = (1L << 0),
   // property metadata should not be saved in persistent cache
   kComponentPropertyCacheFlagIsDynamic = (1L << 1) //property metadata should not cached at all
};
enum {
   kComponentPropertyClassPropertyInfo = 'pnfo',
   // property info class 
   // property info property IDs 
   kComponentPropertyInfoList    = 'list',
   //array of ComponentPropertyInfo (CFData),
   //one for each property 
   kComponentPropertyCacheSeed   = 'seed',
   // property cache seed value 
   kComponentPropertyCacheFlags  = 'flgs',
   // see kComponentPropertyCache flags 
   kComponentPropertyExtendedInfo = 'meta' // CFDictionary with extended property information
};

/*VDSetCompression Values

Constants passed to VDSetCompression.

enum {
   codecLosslessQuality          = 0x00000400,
   codecMaxQuality               = 0x000003FF,
   codecMinQuality               = 0x00000000,
   codecLowQuality               = 0x00000100,
   codecNormalQuality            = 0x00000200,
   codecHighQuality              = 0x00000300
};
Constants
codecLosslessQuality

Lossless compression or decompression. This special value is valid only for components that can support lossless compression or decompression. 

Available in Mac OS X v10.0 and later.
codecMaxQuality

The maximum standard value. 

Available in Mac OS X v10.0 and later.
codecMinQuality

The minimum valid value. 

Available in Mac OS X v10.0 and later.
codecLowQuality

Low-quality image reproduction. This value should correspond to the lowest image quality that still results in acceptable display characteristics. 

Available in Mac OS X v10.0 and later.
codecNormalQuality

Image reproduction of normal quality. 

Available in Mac OS X v10.0 and later.*/
enum {
   codecLosslessQuality          = 0x00000400,
   codecMaxQuality               = 0x000003FF,
   codecMinQuality               = 0x00000000,
   codecLowQuality               = 0x00000100,
   codecNormalQuality            = 0x00000200,
   codecHighQuality              = 0x00000300
};

/*CodecQ

Abst_CodecQ

typedef unsigned long CodecQ;
Availability
Available in Mac OS X v10.0 and later.*/
typedef unsigned long CodecQ;

/*QTGetComponentProperty

Returns the value of a specific component property.

ComponentResult QTGetComponentProperty (
   ComponentInstance         inComponent,
   ComponentPropertyClass    inPropClass,
   ComponentPropertyID       inPropID,
   ByteCount                 inPropValueSize,
   ComponentValuePtr         outPropValueAddress,
   ByteCount                 *outPropValueSizeUsed );
Parameters
inComponent

A component instance, which you can get by calling OpenComponent or OpenDefaultComponent.
inPropClass

A value (see below) of type OSType that specifies a property class: kComponentPropertyClassPropertyInfo ('pnfo') A QTComponentPropertyInfo structure that defines a property information class. kComponentPropertyInfoList ('list') An array of QTComponentPropertyInfo structures, one for each property. kComponentPropertyCacheSeed ('seed') A component property cache seed value. kComponentPropertyExtendedInfo ('meta') A CFDictionary with extended property information. kComponentPropertyCacheFlags ('flgs') One of the following two flags: kComponentPropertyCacheFlagNotPersistent Property metadata should not be saved in persistent cache. kComponentPropertyCacheFlagIsDynamic Property metadata should not be cached at all. See these constants: 
kComponentPropertyClassPropertyInfo
kComponentPropertyInfoList
kComponentPropertyCacheSeed
kComponentPropertyExtendedInfo
kComponentPropertyCacheFlags
kComponentPropertyCacheFlagNotPersistent
kComponentPropertyCacheFlagIsDynamic
inPropID

A value of type OSType that specifies a property ID.
inPropValueSize

The size of the buffer allocated to hold the property value.
outPropValueAddress

A pointer to the buffer allocated to hold the property value.
outPropValueSizeUsed

On return, the actual size of the value written to the buffer.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
ComponentResult QTGetComponentProperty (
   ComponentInstance         inComponent,
   ComponentPropertyClass    inPropClass,
   ComponentPropertyID       inPropID,
   ByteCount                 inPropValueSize,
   ComponentValuePtr         outPropValueAddress,
   ByteCount                 *outPropValueSizeUsed );

/*QTGetComponentPropertyInfo

Returns information about the properties of a component.

ComponentResult QTGetComponentPropertyInfo (
   ComponentInstance         inComponent,
   ComponentPropertyClass    inPropClass,
   ComponentPropertyID       inPropID,
   ComponentValueType        *outPropType,
   ByteCount                 *outPropValueSize,
   UInt32                    *outPropertyFlags );
Parameters
inComponent

A component instance, which you can get by calling OpenComponent or OpenDefaultComponent.
inPropClass

A value (see below) of type OSType that specifies a property class: kComponentPropertyClassPropertyInfo ('pnfo') A QTComponentPropertyInfo structure that defines a property information class. kComponentPropertyInfoList ('list') An array of QTComponentPropertyInfo structures, one for each property. kComponentPropertyCacheSeed ('seed') A component property cache seed value. kComponentPropertyExtendedInfo ('meta') A CFDictionary with extended property information. kComponentPropertyCacheFlags ('flgs') One of the following two flags: kComponentPropertyCacheFlagNotPersistent Property metadata should not be saved in persistent cache. kComponentPropertyCacheFlagIsDynamic Property metadata should not be cached at all. See these constants: 
kComponentPropertyClassPropertyInfo
kComponentPropertyInfoList
kComponentPropertyCacheSeed
kComponentPropertyExtendedInfo
kComponentPropertyCacheFlags
kComponentPropertyCacheFlagNotPersistent
kComponentPropertyCacheFlagIsDynamic
inPropID

A value of type OSType that specifies a property ID.
outPropType

A pointer to memory allocated to hold the property type on return. This pointer may be NULL.
outPropValueSize

A pointer to memory allocated to hold the size of the property value on return. This pointer may be NULL.
outPropertyFlags

A pointer to memory allocated to hold property flags on return.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
ComponentResult QTGetComponentPropertyInfo (
   ComponentInstance         inComponent,
   ComponentPropertyClass    inPropClass,
   ComponentPropertyID       inPropID,
   ComponentValueType        *outPropType,
   ByteCount                 *outPropValueSize,
   UInt32                    *outPropertyFlags );

/*QTSetComponentProperty

Sets the value of a specific component property.

ComponentResult QTSetComponentProperty (
   ComponentInstance         inComponent,
   ComponentPropertyClass    inPropClass,
   ComponentPropertyID       inPropID,
   ByteCount                 inPropValueSize,
   ConstComponentValuePtr    inPropValueAddress );
Parameters
inComponent

A component instance, which you can get by calling OpenComponent or OpenDefaultComponent.
inPropClass

A value of type OSType that specifies a property class: kComponentPropertyClassPropertyInfo ('pnfo') A QTComponentPropertyInfo structure that defines a property information class. kComponentPropertyInfoList ('list') An array of QTComponentPropertyInfo structures, one for each property. kComponentPropertyCacheSeed ('seed') A component property cache seed value. kComponentPropertyExtendedInfo ('meta') A CFDictionary with extended property information. kComponentPropertyCacheFlags ('flgs') One of the following two flags: kComponentPropertyCacheFlagNotPersistent Property metadata should not be saved in persistent cache. kComponentPropertyCacheFlagIsDynamic Property metadata should not be cached at all. See these constants: 
kComponentPropertyClassPropertyInfo
kComponentPropertyInfoList
kComponentPropertyCacheSeed
kComponentPropertyExtendedInfo
kComponentPropertyCacheFlags
kComponentPropertyCacheFlagNotPersistent
kComponentPropertyCacheFlagIsDynamic
inPropID

A value of type OSType that specifies a property ID.
inPropValueSize

The size of the buffer allocated to hold the property value.
outPropValueAddress

A pointer to the buffer allocated to hold the property value.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
ComponentResult QTSetComponentProperty (
   ComponentInstance         inComponent,
   ComponentPropertyClass    inPropClass,
   ComponentPropertyID       inPropID,
   ByteCount                 inPropValueSize,
   ConstComponentValuePtr    inPropValueAddress );

/*QTOpenGLTextureContextCreate
OSStatus QTOpenGLTextureContextCreate (
   CFAllocatorRef               allocator,
   CGLContextObj                cglContext,
   CGLPixelFormatObj            cglPixelFormat,
   CFDictionaryRef              attributes,
   QTOpenGLTextureContextRef    *newTextureContext );
Creates a new OpenGL texture context for a specified OpenGL context and pixel format.

OSStatus QTOpenGLTextureContextCreate (
   CFAllocatorRef               allocator,
   CGLContextObj                cglContext,
   CGLPixelFormatObj            cglPixelFormat,
   CFDictionaryRef              attributes,
   QTOpenGLTextureContextRef    *newTextureContext );
Parameters
allocator

The allocator used to create the texture context.
cglContext

A pointer to an opaque CGLPContextObj structure representing the OpenGL context used to create textures. You can create this structure using CGLCreateContext.
cglPixelFormat

The pixel format object that specifies buffer types and other attributes of the new context.
attributes

A dictionary of attributes.
newTextureContext

A pointer to a variable to receive the new OpenGL texture context.
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
OSStatus QTOpenGLTextureContextCreate (
   CFAllocatorRef               allocator,
   CGLContextObj                cglContext,
   CGLPixelFormatObj            cglPixelFormat,
   CFDictionaryRef              attributes,
   QTOpenGLTextureContextRef    *newTextureContext );

/*QTVisualContextSetAttribute

Sets a visual context attribute.

OSStatus QTVisualContextSetAttribute (
   QTVisualContextRef visualContext,
   CFStringRef attributeKey,
   CFTypeRef attributeValue );
Parameters
visualContext

The visual context.
attributeKey

Identifier of attribute to set
attributeValue

The value of the attribute to set, or NULL to remove a value. 
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
OSStatus QTVisualContextSetAttribute (
   QTVisualContextRef visualContext,
   CFStringRef attributeKey,
   CFTypeRef attributeValue );

/*QTVisualContextRelease

Releases a visual context object.

void QTVisualContextRelease (
   QTVisualContextRef visualContext
);
Parameters
visualContext

A reference to a visual context object. If you pass NULL, nothing happens.
Discussion

When the retain count decreases to zero, the visual context is disposed.
Version Notes

Introduced in QuickTime 7 for Mac OS X and in QuickTime 7.1 for Windows.
Availability
Carbon status: Supported C interface file: ImageCompression.h
Declared In
ImageCompression.h*/
void QTVisualContextRelease (
   QTVisualContextRef visualContext
);

/*QTVisualContextCopyImageForTime

Retrieves an image buffer from the visual context, indexed by the provided time.

OSStatus QTVisualContextCopyImageForTime (
   QTVisualContextRef visualContext,
   CFAllocatorRef allocator,
   const CVTimeStamp *timeStamp,
   CVImageBufferRef *newImage
);
Parameters
visualContext

The visual context.
allocator

Allocator used to create new CVImageBufferRef.
timeStamp

Time in question. Pass NULL to request the image at the current time.
newImage

Points to variable to receive the new image.
Return Value

An error code. Returns noErr if there is no error.
Discussion

You should not request image buffers further ahead of the current time than the read-ahead time specified with the kQTVisualContextExpectedReadAheadKey attribute. You may skip images by passing later times, but you may not pass an earlier time than passed to a previous call to this function.
Version Notes

Introduced in QuickTime 7 for Mac OS X and in QuickTime 7.1 for Windows.
Availability
Carbon status: Supported C interface file: ImageCompression.h
Declared In
ImageCompression.h*/
OSStatus QTVisualContextCopyImageForTime (
   QTVisualContextRef visualContext,
   CFAllocatorRef allocator,
   const CVTimeStamp *timeStamp,
   CVImageBufferRef *newImage
);

/*QTVisualContextTask

Enables the visual context to release internally held resources for later use.

void QTVisualContextTask (
   QTVisualContextRef visualContext
);
Parameters
visualContext

The visual context.
Discussion

For optimal resource management, this function should be called in every rendering pass. It should be called after old images have been released, new images have been used and all rendering has been flushed to the screen. The call is not mandatory.
Version Notes

Introduced in QuickTime 7
Availability
Carbon status: Supported C interface file: ImageCompression.h
Declared In
ImageCompression.h*/

void QTVisualContextTask (
   QTVisualContextRef visualContext
);

/*QTVisualContextIsNewImageAvailable

Queries whether a new image is available for a given time.

Boolean QTVisualContextIsNewImageAvailable (
   QTVisualContextRef visualContext,
   const CVTimeStamp *timeStamp
);
Parameters
visualContext

The visual context.
timeStamp

Time in question.
Return Value

A Boolean.
Discussion

This function returns TRUE if there is a image available for the specified time that is different from the last image retrieved from QTVisualContextCopyImageForTime.
Version Notes

Introduced in QuickTime 7 for Mac OS X and in QuickTime 7.1 for Windows.
Availability
Carbon status: Supported C interface file: ImageCompression.h
Declared In
ImageCompression.h*/

Boolean QTVisualContextIsNewImageAvailable (
   QTVisualContextRef visualContext,
   const CVTimeStamp *timeStamp
);

/*QTAddComponentPropertyListener

Installs a callback to monitor a component property.

ComponentResult QTAddComponentPropertyListener (
   ComponentInstance                 inComponent,
   ComponentPropertyClass            inPropClass,
   ComponentPropertyID               inPropID,
   QTComponentPropertyListenerUPP    inDispatchProc,
   void                              *inUserData );
Parameters
inComponent

A component instance, which you can get by calling OpenComponent or OpenDefaultComponent.
inPropClass

A value (see below) of type OSType that specifies a property class: kComponentPropertyClassPropertyInfo ('pnfo') A QTComponentPropertyInfo structure that defines a property information class. kComponentPropertyInfoList ('list') An array of QTComponentPropertyInfo structures, one for each property. kComponentPropertyCacheSeed ('seed') A component property cache seed value. kComponentPropertyExtendedInfo ('meta') A CFDictionary with extended property information. kComponentPropertyCacheFlags ('flgs') One of the following two flags: kComponentPropertyCacheFlagNotPersistent Property metadata should not be saved in persistent cache. kComponentPropertyCacheFlagIsDynamic Property metadata should not be cached at all. See these constants: 
kComponentPropertyClassPropertyInfo
kComponentPropertyInfoList
kComponentPropertyCacheSeed
kComponentPropertyExtendedInfo
kComponentPropertyCacheFlags
kComponentPropertyCacheFlagNotPersistent
kComponentPropertyCacheFlagIsDynamic
inPropID

A value of type OSType that specifies a property ID.
inDispatchProc

A Universal Procedure Pointer to a QTComponentPropertyListenerProc callback.
inUserData

A pointer to user data that will be passed to the callback. You may pass NULL in this parameter.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
ComponentResult QTAddComponentPropertyListener (
   ComponentInstance                 inComponent,
   ComponentPropertyClass            inPropClass,
   ComponentPropertyID               inPropID,
   QTComponentPropertyListenerUPP    inDispatchProc,
   void                              *inUserData );

#ifdef __cplusplus
}
#endif

#endif 
