//inc
#ifndef QUICKTIMECOMPONENTS_H
#define  QUICKTIMECOMPONENTS_H

#ifndef CARBON_H
#include <Carbon/Carbon.h>
#endif

#ifndef IMAGECOMPRESSION_H
#include <QuickTime/ImageCompression.h>
#endif

#ifndef  MOVIES_H
#include <QuickTime/Movies.h>
#endif

#ifndef QUICKTIMEMUSIC_H
#include <QuickTime/QuickTimeMusic.h>
#endif


#include <HYS/QuickTime/QuickTimeComponents.h>
#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*SeqGrabComponent

Represents a type used by the Sequence Grabber API.

typedef ComponentInstance SeqGrabComponent;
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
typedef ComponentInstance SeqGrabComponent;

/*SGAudioCallbackStruct

Used to call an SGAudioCallbackProc.

struct SGAudioCallbackStruct {
   SGAudioCallback    inputProc;
   void               *inputProcRefCon;
};
Fields
inputProc

An SGAudioCallbackProc.
inputProcRefCon

A reference constant. Use this parameter to point to a data structure containing any information your callback needs.
Version Notes

Introduced in QuickTime 7.
Availability
Carbon status: Supported; C interface file: Movies.h*/
struct SGAudioCallbackStruct {
   SGAudioCallback    inputProc;
   void               *inputProcRefCon;
};
typedef  struct SGAudioCallbackStruct SGAudioCallbackStruct;


/*Dictionary Keys

The dictionary keys listed in this section are used with c ertain of the property IDs listed in “SGAudio Component Property IDs”. They may be used to parse CF dictionaries returned by kQTSGAudioPropertyID_DeviceListWithAttributes and kQTSGAudioPropertyID_DeviceAttributes IDs for SGAudioMediaType channels.
kQTAudioDeviceAttribute_DeviceUIDKey = 'uid '

A CFStringRef containing a unique identifier for a device.
kQTAudioDeviceAttribute_DeviceNameKey = 'name'

A CFStringRef containing a device’s printable name, suitable for the user interface.
kQTAudioDeviceAttribute_DeviceManufacturerKey = 'manu'

A CFStringRef containing a device manufacturer’s printable name, suitable for the user interface.
kQTAudioDeviceAttribute_DeviceTransportTypeKey = 'tran'

A CFNumberRef that wraps an OSType; for example, '1394' for fw. See the file IOAudioTypes.h.
kQTAudioDeviceAttribute_DeviceAliveKey = 'aliv'

A CFBooleanRef value that is TRUE if the device is present.
kQTAudioDeviceAttribute_DeviceCanRecordKey = 'rec ' [last char = space]

A CFBooleanRef value that is TRUE if the device can be used for recording (some devices can only play back).
kQTAudioDeviceAttribute_DeviceCanPreviewKey = 'prev'

A CFBooleanRef value that is TRUE if the device can be used to preview a grabbed sequence.
kQTAudioDeviceAttribute_DeviceHoggedKey = 'hogg'

A CFNumberRef that wraps the unique process ID that is hogging the device, or –1 if the device is currently not being hogged. The process ID comes from a call to getpid.
kQTAudioDeviceAttribute_DeviceInUseKey = 'used'

A CFBooleanRef value that is TRUE if the device is performing I/O in any process.
kQTAudioDeviceAttribute_DeviceSupportsHardwarePlaythruKey = 'hard'

A CFBooleanRef value that is TRUE if the device supports hardware playthrough of inputs to outputs.
kQTAudioDeviceAttribute_DefaultInputDeviceKey = 'dIn ' [last char = space]

A CFBooleanRef value that’s TRUE if the device is the user-selected default input in an audio MIDI setup.
kQTAudioDeviceAttribute_DefaultOutputDeviceKey = 'dOut'

A CFBooleanRef value that’s TRUE if the device is the user-selected default output in an audio MIDI setup.
kQTAudioDeviceAttribute_DefaultSystemOutputDeviceKey = 'sOut'

A CFBooleanRef value that’s TRUE if the device is the user-selected device where system alerts play.
kQTAudioDeviceAttribute_IsCoreAudioDeviceKey = 'hal!'

A CFBooleanRef value that’s TRUE if the device is a Core Audio device.*/
enum {
kQTAudioDeviceAttribute_DeviceUIDKey = 'uid ' ,
kQTAudioDeviceAttribute_DeviceNameKey = 'name' ,
kQTAudioDeviceAttribute_DeviceManufacturerKey = 'manu' ,
kQTAudioDeviceAttribute_DeviceTransportTypeKey = 'tran',
kQTAudioDeviceAttribute_DeviceAliveKey = 'aliv',
kQTAudioDeviceAttribute_DeviceCanRecordKey = 'rec ' ,
kQTAudioDeviceAttribute_DeviceCanPreviewKey = 'prev',
kQTAudioDeviceAttribute_DeviceHoggedKey = 'hogg',
kQTAudioDeviceAttribute_DeviceInUseKey = 'used',
kQTAudioDeviceAttribute_DeviceSupportsHardwarePlaythruKey = 'hard',
kQTAudioDeviceAttribute_DefaultInputDeviceKey = 'dIn ' ,
kQTAudioDeviceAttribute_DefaultOutputDeviceKey = 'dOut',
kQTAudioDeviceAttribute_DefaultSystemOutputDeviceKey = 'sOut',
kQTAudioDeviceAttribute_IsCoreAudioDeviceKey = 'hal!'
};

/*SGAudio Component Property IDs

This section lists the property IDs for SGAudioMediaType channels. Besides the IDs defined below, SGAudioMediaType channels respond to kComponentPropertyInfoList and kComponentPropertyClassPropertyInfo selectors, which return CFDataRef structures containing arrays of ComponentPropertyInfo structures as defined in the file ImageCompression.h.
kQTSGAudioPropertyID_DeviceListWithAttributes = '#dva'

Used with kQTPropertyClass_SGAudio in read and listen modes to get an array of CFDictionaryRef structures. Each dictionary represents the attributes of one audio device. See Dictionary Keys for a list of supported dictionary keys. If the device list changes (for example, if a device is hotplugged or unplugged), listeners of this property will be notified. The caller is responsible for calling CFRelease to release the resulting CFArray.
kQTSGAudioPropertyID_DeviceAttributes = 'deva'

Used with kQTPropertyClass_SGAudioRecordDevice and kQTPropertyClass_SGAudioPreviewDevice in read only mode to get a CFDictionaryRef structure representing the attributes of a specified audio device (record or preview). See Dictionary Keys for a list of supported dictionary keys. Not all keys are guaranteed to be present for a given device. The caller is responsible for calling CFRelease to release the resulting CFDictionary.
kQTSGAudioPropertyID_DeviceUID = 'uid ' [last character is space]

Used with kQTPropertyClass_SGAudioRecordDevice and kQTPropertyClass_SGAudioPreviewDevice in read and write modes to get a CFString with an audio device’s unique ID for the current recording or preview or set the current recording or preview device to a specified audio device’s unique ID. You can obtain a list of devices on the user’s system with kQTSGAudioPropertyID_DeviceListWithAttributes. The caller is responsible for calling CFRelease to release the resulting CFString.
kQTSGAudioPropertyID_ChannelLayout = 'clay'

Used with kQTPropertyClass_SGAudioRecordDevice, kQTPropertyClass_SGAudio, and kQTPropertyClass_SGAudioPreviewDevice in read and write modes to get or set an AudioChannelLayout structure representing the spatial or discrete channel layout. If used with kQTPropertyClass_SGAudio, the AudioChannelLayout refers to the channels in the resulting QuickTime movie sound track. If used with kQTPropertyClass_SGAudioRecordDevice, the AudioChannelLayout refers to the input channels on the record device. If used with kQTPropertyClass_SGAudioPreviewDevice, the AudioChannelLayout refers to the preview device’s output channels. AudioChannelLayout is a variable size structure, so before calling QTGetComponentProperty you should call QTGetComponentPropertyInfo to discover the size of the block of memory you must allocate to hold the result.
kQTSGAudioPropertyID_MagicCookie = 'kuki'

Used with kQTPropertyClass_SGAudio in read and write modes to access opaque data structures representing get or set compressor-specific out-of-band settings. This property is applicable only to compressed formats that use a cookie, such as AAC and AMR.
kQTSGAudioPropertyID_ChannelMap = 'cmap'

Used with kQTPropertyClass_SGAudioRecordDevice in read and write modes to access a C-style array of SInt32 structures that let a client enable or disable channels on a recording device, as well as reorder them or duplicate them to several output channels. This property need not be set if a client wishes to capture all channels from the record device; this is the default behavior. Each element in the SInt32 array represents one output bus (into the SGAudioChannel) from the record device. The value of each element is the zero-based source channel on the input device that should feed the specified output. Channel-disabling example: if you wish to capture just the 1st, 3rd, and 5th channels from a 6-channel input device, your channel map should be SInt32 map[3] = { 0, 2, 4 }. Channel-reordering example: if you wish to capture both channels from a stereo input device, but you know the left and right channels are reversed in the data source, set your channel map to SInt32 map[2] = { 1, 0 }. Channel-duplication example: if you wish to duplicate the second source channel into 4 outputs, set your channel map to SInt32 map[4] = { 1, 1, 1, 1 }. Empty channel example: if you need to produce a conformant stream of audio (such as a 6-channel stream to send to an external 5.1 AC3 encoder), but you have audio only for the L, R, and C channels (on record device channels 0, 1, and 2), you may set your channel map to SInt32 map[6] = { 0, 1, 2, -1, -1, -1 }. The last 3 channels will be filled with silence.
kQTSGAudioPropertyID_StreamFormat = 'frmt'

Used with kQTPropertyClass_SGAudioRecordDevice, kQTPropertyClass_SGAudio, and kQTPropertyClass_SGAudioPreviewDevice in read and write modes to access AudioStreamBasicDescription structures that let you get or set the format of the audio as it will be written to the destination QuickTime movie track. When used with kQTPropertyClass_SGAudioRecordDevice, this property ID gets and sets the format of audio as it is physically recorded on the device. The format must be one of the formats passed in kQTSGAudioPropertyID_StreamFormatList. The mChannelsPerFrame of the StreamFormat read from the record device will not reflect channels that have been enabled or disabled with the ChannelMap property.
kQTSGAudioPropertyID_StreamFormatList = '#frm'

Used with kQTPropertyClass_SGAudioRecordDevice and kQTPropertyClass_SGAudioPreviewDevice in read-only mode to get an array of AudioStreamBasicDescription structures that describe valid combinations of settings supported by the physical device in its current configuration (sample rate, bit depth, number of channels).
kQTSGAudioPropertyID_InputSelection = 'inpt'

Used with kQTPropertyClass_SGAudioRecordDevice in read and write modes to get an OSType value that lets you change the current input selection in devices that allow switching between data sources, such as analog, adat, sdi, aes/ebu, and spdif. When the input selection changes, the StreamFormat of the device may change as well; in particular, the number of channels may change.
kQTSGAudioPropertyID_InputListWithAttributes = '#inp'

Used with kQTPropertyClass_SGAudioRecordDevice in read-only mode to get a CFArrayRef structure that represents the list of available input sources for a given device. A CFArrayRef of CFDictionaryRef values is returned, where each one represents the attributes of one input. See “Dictionary Keys” for a list of valid keys. The caller is responsible for calling CFRelease to release the returned array.
kQTSGAudioPropertyID_OutputSelection = 'otpt'

Used with kQTPropertyClass_SGAudioPreviewDevice in read and write modes to get an OSType value that lets you change the current output selection in devices that allow switching between output destinations, such as analog, adat, sdi, aes/ebu, and spdif. When the output selection changes, the StreamFormat of the device may change as well; in particular, the number of channels may change.
kQTSGAudioPropertyID_OutputListWithAttributes = '#otp'

Used with kQTPropertyClass_SGAudioPreviewDevice in read-only mode to get a CFArrayRef structure that represents the list of available output destinations for a given device. A CFArrayRef of CFDictionaryRef values is returned, where each one represents the attributes of one output. See “Dictionary Keys” for a list of valid keys. The caller is responsible for calling CFRelease to release the returned array.
kQTSGAudioPropertyID_SoundDescription = 'snds'

Used with kQTPropertyClass_SGAudio in read and write modes to get a SoundDescriptionHandle value for the sound description that describes the data written to a QuickTime movie track. A QTGetComponentProperty call allocates the SoundDescriptionHandle for you. The caller should declare the SoundDescriptionHandle and set it to NULL, then pass its address to QTGetComponentProperty. The caller must call DisposeHandle to dispose of the resulting SoundDescriptionHandle when done with it.
kQTSGAudioPropertyID_LevelMetersEnabled = 'lmet'

Used with kQTPropertyClass_SGAudioRecordDevice, kQTPropertyClass_SGAudio, and kQTPropertyClass_SGAudioPreviewDevice in read and write modes to access a Boolean value that controls metering. When used with kQTPropertyClass_SGAudioRecordDevice or kQTPropertyClass_SGAudioPreviewDevice, this property ID turns device level metering on or off. When used with kQTPropertyClass_SGAudio, it turns output level metering on or off. When level meters are enabled, you can use kQTSGAudioPropertyID_AveragePowerLevels to get instantaneous levels, or kQTSGAudioPropertyID_PeakHoldLevels to get peak-hold style meters, which are better for clipping detection. Level meters should be enabled only if you intend to poll for levels, because they place an added load on the CPU when enabled.
kQTSGAudioPropertyID_PeakHoldLevels = 'phlv'

Used with kQTPropertyClass_SGAudioRecordDevice, kQTPropertyClass_SGAudio, and kQTPropertyClass_SGAudioPreviewDevice in read-only mode to get a C-style array of Float32 values representing in dB the peak hold levels for each channel on a device or output. This property ID may be used only when level meters are enabled (by using kQTSGAudioPropertyID_LevelMetersEnabled). Poll for peak hold levels as often as you would like, to update the user interface or look for clipping. The number of elements in the Float32 array will be equal to the number of input channels on your record device for kQTPropertyClass_SGAudioRecordDevice, or the number of elements in your kQTSGAudioPropertyID_ChannelMap, if you've set one. It will be equal to the number of output channels on your preview device for kQTPropertyClass_SGAudioPreviewDevice and equal to the number of channels in your kQTSGAudioPropertyID_StreamFormat (format.mChannelsPerFrame) for kQTPropertyClass_SGAudio. If no channel mixdown is being performed between record device and output formats, then the kQTSGAudioPropertyID_PeakHoldLevels values for kQTPropertyClass_SGAudioRecordDevice and kQTPropertyClass_SGAudio will be equivalent. If you have requested hardware playthrough, level metering will be unavailable.
kQTSGAudioPropertyID_AveragePowerLevels = 'aplv'

Used with kQTPropertyClass_SGAudioRecordDevice, kQTPropertyClass_SGAudio, and kQTPropertyClass_SGAudioPreviewDevice in read-only mode to get a C-style array of Float32 values representing in dB the average power levels for each channel on a device or output. This property ID may be used only when level meters are enabled (by using kQTSGAudioPropertyID_LevelMetersEnabled). Poll for average power levels as often as you would like, to update the user interface. The number of elements in the Float32 array will be equal to the number of input channels on your record device for kQTPropertyClass_SGAudioRecordDevice, or the number of elements in your kQTSGAudioPropertyID_ChannelMap, if you've set one. It will be equal to the number of output channels on your preview device for kQTPropertyClass_SGAudioPreviewDevice and equal to the number of channels in your kQTSGAudioPropertyID_StreamFormat (format.mChannelsPerFrame) for kQTPropertyClass_SGAudio. If no channel mixdown is being performed between record device and output formats, then the kQTSGAudioPropertyID_AveragePowerLevels values for kQTPropertyClass_SGAudioRecordDevice and kQTPropertyClass_SGAudio will be equivalent. If you have requested hardware playthrough, level metering will be unavailable.
kQTSGAudioPropertyID_Settings = 'setu'

Used with kQTPropertyClass_SGAudio in read and write modes to access UserData values. This property takes supersedes the SGGet/SetChannelSettings calls. An SGAudioMediaType channel accepts old-style 'soun' SGChannel settings in a QTSetComponentProperty call, but always produces new-style settings in a QTGetComponentProperty call.
kQTSGAudioPropertyID_MasterGain = 'mgan'

Used with kQTPropertyClass_SGAudioRecordDevice, kQTPropertyClass_SGAudio, and kQTPropertyClass_SGAudioPreviewDevice in read and write modes to access a Float32 value that represents the master gain on a physical recording device with 0.0 = minimum volume and 1.0 = the maximum volume of the device. With kQTPropertyClass_SGAudioPreviewDevice, this property gets or sets the master gain on the physical previewing device with 0.0 = minimum volume and 1.0 = the maximum volume of the device. With kQTPropertyClass_SGAudio, this property gets or sets the master gain (volume) of the recorded audio data in software (pre-mixdown) with minimum = 0.0, maximum = unbounded. Normally you wouldn't set the volume greater than 1.0, but if the source sound level provided by the device is too low, you may set a gain greater than 1.0 to boost the gain. Some devices cannot respond to this property setting.
kQTSGAudioPropertyID_PerChannelGain = 'cgan'

Used with kQTPropertyClass_SGAudioRecordDevice, kQTPropertyClass_SGAudio, and kQTPropertyClass_SGAudioPreviewDevice in read and write modes to access a C-style array of Float32 value that represents the gain of each channel on a physical recording device. The number of channels in the array for kQTPropertyClass_SGAudioRecordDevice and kQTPropertyClass_SGAudioPreviewDevice is equal to the total number of channels on the device, which can be discovered using kQTSGAudioPropertyID_StreamFormat. The number and order of channels in the array for the kQTPropertyClass_SGAudio class must correspond to the valence of channels on the output (which is affected by a channel map, if you've set one). With kQTPropertyClass_SGAudio, this property gets and sets the gain (volume) of each channel of recorded audio data in software. Levels set on the record device or preview device must be in the range minimum = 0.0, maximum = 1.0. Levels set in software may be set to values greater than 1.0 in order to boost low signals. The caller may specify that a particular channel gain level should be left alone by setting the value to –1.0. For instance, to set the gain of channels 1, 2, and 3 to 0.5 on a 6 channel device, pass the following array values in a SetProperty call: { 0.5, 0.5, 0.5, -1., -1., -1. }.
kQTSGAudioPropertyID_HardwarePlaythruEnabled = 'hard'

Used with kQTPropertyClass_SGAudioRecordDevice in read and write modes to access a Boolean value representing the state of hardware playthrough during seqGrabPreview or seqGrabPlayDuringRecord operations. Setting this value will have no effect if the record device and preview device are not the same. Some devices do not support hardware playthrough; devices report whether or not they support this feature through the kQTSGAudioPropertyID_DeviceListWithAttributes property.
kQTSGAudioPropertyID_ChunkSize = 'chnk'

Used with kQTPropertyClass_SGAudio in read and write modes to access a Float32 value representing the number of seconds of audio that the SGAudioChannel should buffer before writing.
kComponentPropertyInfoList = 'list'

Used with kComponentPropertyClassPropertyInfo in read-only mode as defined in the file ImageCompression.h.
kQTSGAudioPropertyID_DeviceAlive = 'aliv'

Used with kQTPropertyClass_SGAudioRecordDevice and kQTPropertyClass_SGAudioPreviewDevice in read and listen modes to get a Boolean value telling whether or not a device is alive. If the device is hot unplugged, listeners of this property will be notified. If a record or preview operation is in progress it will be stopped, but it is left to the client to select a new device.
kQTSGAudioPropertyID_DeviceHogged = 'hogg'

Used with kQTPropertyClass_SGAudioRecordDevice and kQTPropertyClass_SGAudioPreviewDevice in read, write, and listen modes to get a Boolean value telling whether a device has become hogged or unhogged by another process. If so, listeners of this property will be notified. SGAudioMediaType channel does not hog devices, but a client that has reason to gain exclusive access to a device may set this property to TRUE.
kQTSGAudioPropertyID_DeviceInUse = 'used'

Used with kQTPropertyClass_SGAudioRecordDevice and kQTPropertyClass_SGAudioPreviewDevice in read and listen modes to get a Boolean value that tells whether a device is in use. If the device starts to be used (for instance, when another process starts performing I/O with it), listeners of this property will be notified.
kQTSGAudioPropertyID_MixerCoefficients = 'mixc'

Used with kQTPropertyClass_SGAudio in read and write modes to access a C-style array of Float32 values representing a set of coefficients for mixdown. If you wish to perform a custom mixdown from the incoming record device channel valence (discoverable using a combination of kQTPropertyClass_SGAudioRecordDevice, kQTSGAudioPropertyID_StreamFormat, kQTPropertyClass_SGAudioRecordDevice, and kQTSGAudioPropertyID_ChannelMap) to a different output number of channels (using kQTPropertyClass_SGAudio and kQTSGAudioPropertyID_StreamFormat), you may specify your own set of mixer coefficients which will be set as volume values at each crosspoint in SGAudioMediaType’s internal matrix mixer. The value you pass is a two-dimensional array of Float32 values where the first dimension (rows) is the input channel and the second dimension (columns) is the output channel. Each Float32 value contains one gain level to apply.
kQTSGAudioPropertyID_PreMixCallback = '_mxc'

Used with kQTPropertyClass_SGAudio in read and write modes to access a pre-mix SGAudioCallbackStruct. If you wish to receive a callback when new audio samples become available from a recording device (before they've been mixed down), set this property using an SGAudioCallbackStruct containing a pointer to your SGAudioCallback function and a reference constant (RefCon). If you have previously registered a callback and no longer wish to receive it, call QTSetComponentProperty again, this time passing NULL for your inputProc and 0 for your inputRefCon.
kQTSGAudioPropertyID_PreMixCallbackFormat = '_mcf'

Used with kQTPropertyClass_SGAudio in read-only mode to get an AudioStreamBasicDescription structure representing the format of the audio that will be received by your pre-mix SGAudioCallback function. Note that the format may not be available until you've called SGPrepare.
kQTSGAudioPropertyID_PostMixCallback = 'mx_c'

Used with kQTPropertyClass_SGAudio in read and write modes to access a post-mix SGAudioCallbackStruct. If you wish to receive a callback after audio samples have been mixed (the first step after they are received from a recording device by SGAudioMediaType channel), set this property ID using an SGAudioCallbackStruct containing a pointer to your SGAudioCallback function and a reference constant (RefCon). If you have previously registered a callback and no longer wish to receive it, call QTSetComponentProperty again, this time passing NULL for your inputProc and 0 for your inputRefCon.
kQTSGAudioPropertyID_PostMixCallbackFormat = 'm_cf'

Used with kQTPropertyClass_SGAudio in read-only mode to get an AudioStreamBasicDescription structure representing the format of the audio that will be received by your post-mix SGAudioCallback function. Note that the format may not be available until you've called SGPrepare.
kQTSGAudioPropertyID_PreConversionCallback = '_cvc'

Used with kQTPropertyClass_SGAudio in read and write modes to access a pre-conversion SGAudioCallbackStruct. If you wish to receive a callback just before audio samples are about to be sent through an audio converter (for format conversion or compression), set this property ID using an SGAudioCallbackStruct containing a pointer to your SGAudioCallback function and a reference constant (RefCon). If you have previously registered a callback and no longer wish to receive it, call QTSetComponentProperty again, this time passing NULL for your inputProc and 0 for your inputRefCon.
kQTSGAudioPropertyID_PreConversionCallbackFormat = '_ccf'

Used with kQTPropertyClass_SGAudio in read-only mode to get an AudioStreamBasicDescription structure representing the format of the audio that will be received by your pre-conversion SGAudioCallback function. Note that the format may not be available until you've called SGPrepare.
kQTSGAudioPropertyID_PostConversionCallback = 'cv_c'

Used with kQTPropertyClass_SGAudio in read and write modes to access a post-conversion SGAudioCallbackStruct. If you wish to receive a callback right after audio samples have been sent through an audio converter (for format conversion or compression), set this property ID using an SGAudioCallbackStruct containing a pointer to your SGAudioCallback function and a reference constant (RefCon). If you have previously registered a callback and no longer wish to receive it, call QTSetComponentProperty again, this time passing NULL for your inputProc and 0 for your inputRefCon.
kQTSGAudioPropertyID_PostConversionCallbackFormat = 'c_cf'

Used with kQTPropertyClass_SGAudio in read-only mode to get an AudioStreamBasicDescription structure representing the format of the audio that will be received by your post-conversion SGAudioCallback function. Note that the format may not be available until you've called SGPrepare.*/
enum {
kQTSGAudioPropertyID_DeviceListWithAttributes = '#dva',
kQTSGAudioPropertyID_DeviceAttributes = 'deva',
kQTSGAudioPropertyID_DeviceUID = 'uid ' ,
kQTSGAudioPropertyID_ChannelLayout = 'clay',
kQTSGAudioPropertyID_MagicCookie = 'kuki',
kQTSGAudioPropertyID_ChannelMap = 'cmap',
kQTSGAudioPropertyID_StreamFormat = 'frmt',
kQTSGAudioPropertyID_StreamFormatList = '#frm',
kQTSGAudioPropertyID_InputSelection = 'inpt',
kQTSGAudioPropertyID_InputListWithAttributes = '#inp',
kQTSGAudioPropertyID_OutputSelection = 'otpt',
kQTSGAudioPropertyID_OutputListWithAttributes = '#otp',
kQTSGAudioPropertyID_SoundDescription = 'snds',
kQTSGAudioPropertyID_LevelMetersEnabled = 'lmet',
kQTSGAudioPropertyID_PeakHoldLevels = 'phlv',
kQTSGAudioPropertyID_AveragePowerLevels = 'aplv',
kQTSGAudioPropertyID_Settings = 'setu',
kQTSGAudioPropertyID_MasterGain = 'mgan',
kQTSGAudioPropertyID_PerChannelGain = 'cgan',
kQTSGAudioPropertyID_HardwarePlaythruEnabled = 'hard',
kQTSGAudioPropertyID_ChunkSize = 'chnk',
//kComponentPropertyInfoList = 'list',
kQTSGAudioPropertyID_DeviceAlive = 'aliv',
kQTSGAudioPropertyID_DeviceHogged = 'hogg',
kQTSGAudioPropertyID_DeviceInUse = 'used',
kQTSGAudioPropertyID_MixerCoefficients = 'mixc',
kQTSGAudioPropertyID_PreMixCallback = '_mxc',
kQTSGAudioPropertyID_PreMixCallbackFormat = '_mcf',
kQTSGAudioPropertyID_PostMixCallback = 'mx_c',
kQTSGAudioPropertyID_PostMixCallbackFormat = 'm_cf',
kQTSGAudioPropertyID_PreConversionCallback = '_cvc',
kQTSGAudioPropertyID_PreConversionCallbackFormat = '_ccf',
kQTSGAudioPropertyID_PostConversionCallback = 'cv_c',
kQTSGAudioPropertyID_PostConversionCallbackFormat = 'c_cf'
};

/*SGAudio Component Property Classes

Every SGAudioMediaType channel uses standard QuickTime component property selectors to get, set, and listen to properties. Each component property takes a property class as well as a property ID. SGAudioMediaType channels use the property classes listed in this section.SGAudioMediaType                       = 'audi'
kQTPropertyClass_SGAudio                 = 'audo'
kQTPropertyClass_SGAudioRecordDevice     = 'audr'
kQTPropertyClass_SGAudioPreviewDevice    = 'audp'

'audo'

Used with properties that pertain to the SGChannel as a whole, or to the output of an SGAudioChannel (that is, with the resulting track in a QuickTime movie).
'audr'

Used with properties that pertain specifically to an SGAudioChannel recording device’s physical settings.
'audp'

Used with properties that pertain specifically to an SGAudioChannel preview device’s physical settings.

For the property IDs used with these classes. see “SGAudio Component Property IDs”.*/
enum {
SGAudioMediaType                       = 'audi',
kQTPropertyClass_SGAudio                 = 'audo',
kQTPropertyClass_SGAudioRecordDevice     = 'audr',
kQTPropertyClass_SGAudioPreviewDevice    = 'audp'
};

/*QTComponentPropertyInfo

Stores information for component property functions.

struct ComponentPropertyInfo {
   ComponentPropertyClass    propClass;
   ComponentPropertyID       propID;
   ComponentValueType        propType;
   ByteCount                 propSize;
   UInt32                    propFlags;
};
Fields
propClass

A value of type OSType that specifies a property class:
kComponentPropertyClassPropertyInfo ('pnfo')

A QTComponentPropertyInfo structure that defines a property information class.
kComponentPropertyInfoList ('list')

An array of QTComponentPropertyInfo structures, one for each property.
kComponentPropertyCacheSeed ('seed')

A component property cache seed value.
kComponentPropertyExtendedInfo ('meta')

A CFDictionary with extended property information.
kComponentPropertyCacheFlags ('flgs')

One of the following two flags:
kComponentPropertyCacheFlagNotPersistent

Property metadata should not be saved in persistent cache.
kComponentPropertyCacheFlagIsDynamic

Property metadata should not be cached at all.
propID

A value of type OSType that specifies a property ID.
propType

The type of the property.
propSize

The size of the property in bytes.
propFlags

Component property flags.
Version Notes

Introduced in QuickTime 6.4.
Availability
Carbon status: Supported; C interface file: QuickTimeComponents.h
Platform Considerations

Associated functions: QTAddComponentPropertyListener, QTComponentPropertyListenerCollectionAddListener, QTComponentPropertyListenerCollectionHasListenersForProperty, QTComponentPropertyListenerCollectionNotifyListeners, QTComponentPropertyListenerCollectionRemoveListener, QTGetComponentProperty, QTGetComponentPropertyInfo, QTRemoveComponentPropertyListener, QTSetComponentProperty, QTComponentPropertyListenerFilterProc, QTComponentPropertyListenerProc*/
struct ComponentPropertyInfo {
   ComponentPropertyClass    propClass;
   ComponentPropertyID       propID;
   ComponentValueType        propType;
   ByteCount                 propSize;
   UInt32                    propFlags;
};

typedef  struct ComponentPropertyInfo ComponentPropertyInfo ;

/*SeqGrabComponent

Represents a type used by the Sequence Grabber API.

typedef ComponentInstance SeqGrabComponent;
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
typedef ComponentInstance SeqGrabComponent;

/*seqGrabAppendToFile

Constants grouped with seqGrabAppendToFile.

enum {
   seqGrabToDisk                 = 1,
   seqGrabToMemory               = 2,
   seqGrabDontUseTempMemory      = 4,
   seqGrabAppendToFile           = 8,
   seqGrabDontAddMovieResource   = 16,
   seqGrabDontMakeMovie          = 32,
   seqGrabPreExtendFile          = 64,
   seqGrabDataProcIsInterruptSafe = 128,
   seqGrabDataProcDoesOverlappingReads = 256,
   seqGrabDontPreAllocateFileSize = 512  /* Don't set the size of the file before capture unless the file has been pre-extended */
//};
//Declared In
//QuickTimeComponents.h*/

enum {
   seqGrabToDisk                 = 1,
   seqGrabToMemory               = 2,
   seqGrabDontUseTempMemory      = 4,
   seqGrabAppendToFile           = 8,
   seqGrabDontAddMovieResource   = 16,
   seqGrabDontMakeMovie          = 32,
   seqGrabPreExtendFile          = 64,
   seqGrabDataProcIsInterruptSafe = 128,
   seqGrabDataProcDoesOverlappingReads = 256,
   seqGrabDontPreAllocateFileSize = 512  /* Don't set the size of the file before capture unless the file has been pre-extended */
};
/*Two new usage flags have also been defined so that your application can indicate to the sequence grabber (and thus the VDIG) that it is not being used in a conventional recording mode.
enum {
    seqGrabRecord               = 1,
    seqGrabPreview              = 2,
    seqGrabPlayDuringRecord     = 4,
    seqGrabLowLatencyCapture    = 8, /* return the freshest frame
                                        possible, for live work
                                        (i.e. videoconferencing,  live
                                        broadcast, live image processing)
                                                                     */
 
   // seqGrabAlwaysUseTimeBase    = 16 /* Tell VDIGs to use TimebaseTime
        //                                always, rather than creating
       //                                 uniform frame durations,  for more
       //                                 accurate live sync with  audio */
//};*

enum {
    seqGrabRecord               = 1,
    seqGrabPreview              = 2,
    seqGrabPlayDuringRecord     = 4,
    seqGrabLowLatencyCapture    = 8, /* return the freshest frame
                                        possible, for live work
                                        (i.e. videoconferencing,  live
                                        broadcast, live image processing)
                                                                     */
 
    seqGrabAlwaysUseTimeBase    = 16 /* Tell VDIGs to use TimebaseTime
                                        always, rather than creating
                                        uniform frame durations,  for more
                                        accurate live sync with  audio */
};
typedef unsigned long SeqGrabUsageEnum;

/*SGChannel

Represents a type used by the Sequence Grabber API.

typedef ComponentInstance SGChannel;
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
typedef ComponentInstance SGChannel;

/*SeqGrabComponent

Represents a type used by the Sequence Grabber API.

typedef ComponentInstance SeqGrabComponent;
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
typedef ComponentInstance SeqGrabComponent;

/*Component Identifiers

Identify the types of components.

clockComponentType                 ='clok'
compressorComponentType            ='imco'
CreateFilePreviewComponentType     ='pmak'
DataHandlerType                    ='dhlr'
decompressorComponentType          ='imdc'
MediaHandlerType                   ='mhlr'
MovieControllerComponentType       ='play'
MovieExportType                    ='spit'
MovieImportType                    ='eat '
SeqGrabChannelType                 ='sgch'
SeqGrabComponentType               ='barg'
SeqGrabCompressionPanelType        ='cmpr'
SeqGrabPanelType                   ='sgpn'
SeqGrabSourcePanelType             ='sour'
ShowFilePreviewComponentType       ='pnot'
StandardCompressionSubType         ='imag'
StandardCompressionSubTypeSound    ='soun'
StandardCompressionType            ='scdi'
systemMicrosecondClock             ='micr'
systemMillisecondClock             ='mill'
systemSecondClock                  ='seco'
systemTickClock                    ='tick'
videoDigitizerComponentType        ='vdig'
Discussion

All components of the same type or subtype provide the same kinds of services and support a common application programming interface. Codecs have their own set of types.*/
enum {
clockComponentType                 ='clok',
compressorComponentType            ='imco',
CreateFilePreviewComponentType     ='pmak',
DataHandlerType                    = 'dhlr',
decompressorComponentType          ='imdc',
MediaHandlerType                   ='mhlr',
MovieControllerComponentType       ='play',
MovieExportType                    ='spit',
MovieImportType                    ='eat ',
SeqGrabChannelType                 ='sgch',
SeqGrabComponentType               ='barg',
SeqGrabCompressionPanelType        ='cmpr',
SeqGrabPanelType                   ='sgpn',
SeqGrabSourcePanelType             ='sour',
ShowFilePreviewComponentType       ='pnot',
StandardCompressionSubType         ='imag',
StandardCompressionSubTypeSound    ='soun',
StandardCompressionType            ='scdi',
systemMicrosecondClock             ='micr',
systemMillisecondClock             ='mill',
systemSecondClock                  ='seco',
systemTickClock                    ='tick',
videoDigitizerComponentType        ='vdig'
};

/*SCAudioFillBuffer

Used is used to pull compressed frames from the StdAudio component in kQTSCAudioPropertyID_BasicDescription format.

ComponentResult SCAudioFillBuffer (
   ComponentInstance ci,
   SCAudioInputDataProc inInputDataProc,
   void *inInputDataProcRefCon,
   UInt32 *ioOutputDataPacketSize,
   AudioBufferList *outOutputData,
   AudioStreamPacketDescription *outPacketDescription
);
Parameters
ci

The clients connection to a StdAudio Compression component.
inInputDataProc

The proc address of the function that will be called to supply data in the kQTSCAudioPropertyID_InputBasicDescription format to SCAudio.
inInputDataProcRefCon

The client refcon that will be passed to the user-provided SCAudioInputDataProc function.
ioOutputDataPacketSize

On input, the number of desired packets. On output, the actual number of packets delivered (can be fewer than the input desired packets).
outOutputData

An AudioBufferList providing sufficiently large buffers to hold the requested number of packets.
outPacketDescription

An array of AudioStreamPacketDescriptions. If the requested output format requires external framing information??that is, a VBR format such as AAC?? allocate and pass an array of packet descriptions as large as the number of packets you are requesting.
Discussion

SCAudioFillBuffer preserves the same style API as the Core Audio AudioConverterFillComplexBuffer API, which is part of the AudioToolbox framework and resides in AudioConverter.h. 

This function has the same parameters as AudioConverterFillComplexBuffer, but internally it has an audio converter, a matrix mixer, and another audio converter. It is based on a pull model: You pull on the audio converter for some output, and specify the buffer in which you want to put it. You have already configured the format that it is going to return to you. You also provide it with an input proc and it will call back that input proc and specify however many samples of audio you have. For example, if you want five packets of AAC audio coming out the back end, and at the front end you happen to have PCM de-interleaved, the routine will ask you for the samples. The difference is you can now have different numbers of channels going in or out. For example, at the same time you are doing the compression from PCM to AAC, you can also go from 5.1 to stereo.

SCAudioFillBuffer is used to pull compressed frames from the StdAudio component in kQTSCAudioPropertyID_BasicDescription format. The StdAudio component can perform any combination of decompression/mixing/compression, combining the facilities of Core Audio AudioConverters and Matrix Mixer AudioUnits. The behavior of the SCAudioFillBuffer call (signalling end of data, and so on) is identical to the AudioConverter's AudioConverterFillComplexBuffer API.

One important difference between the AudioConverter and SCAudio component is that the SCAudio compression APIs can do mixing as well as n -> n channels conversion. If you want to compress, decompress, or transcode audio using the SCAudioFillBuffer interface, you configure the StandardCompressionSubTypeAudio component with the desired input and output formats (or use the SCRequestImageSettings API to present a dialog and let a user select an output format), then you call SCAudioFillBuffer, providing an SCAudioInputDataProc callback, which is called for audio in the specified source format.
Version Notes

Introduced in QuickTime 7.1 for Windows and QuickTime 7 for Mac OS X. 
Availability
Carbon status: Supported C interface file: QuickTimeComponents.h
Declared In
QuickTimeComponents.h*/
ComponentResult SCAudioFillBuffer (
   ComponentInstance ci,
   SCAudioInputDataProc inInputDataProc,
   void *inInputDataProcRefCon,
   UInt32 *ioOutputDataPacketSize,
   AudioBufferList *outOutputData,
   AudioStreamPacketDescription *outPacketDescription
);

/*SCRequestImageSettings

Displays the standard image dialog box to the user and shows default settings you have established.

ComponentResult SCRequestImageSettings (
   ComponentInstance    ci );
Parameters
ci

Identifies your application's connection to a standard image-compression dialog component. You obtain this identifier from OpenDefaultComponent.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Use this function to retrieve the user's preferences for compressing a single image; use SCRequestSequenceSettings when you are working with an image sequence. Both functions manipulate the compression settings that the component stores for you.

The component derives the current settings when you may supply an image to the component from which it can derive default settings. If you have not set any defaults, but you do supply a test image for the dialog, the component examines the test image and derives appropriate default values based upon its characteristics. If you have not set any defaults and do not supply a test image, the component uses its own default values.
Special Considerations

You may modify the settings by using SCSetInfo. You may customize the dialog boxes by specifying a modal-dialog hook function or a custom button. You may use the custom button to invoke an ancillary dialog box that is specific to your application.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SCRequestImageSettings (
   ComponentInstance    ci );

/*SGNewChannel

Creates a sequence grabber channel and assigns a channel component to the channel.

ComponentResult SGNewChannel (
   SeqGrabComponent    s,
   OSType              channelType,
   SGChannel           *ref );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
channelType

The type of channel to open (see below). This value corresponds to the component subtype value of the channel component. See these constants: 
VideoMediaType
SoundMediaType
ref

A pointer to the frameChannel field in the SeqGrabFrameInfo structure that is to receive a reference to the channel that is added to the sequence grabber component. If the sequence grabber component successfully locates and connects to an appropriate channel component, the sequence grabber component returns a reference to the channel component into this field.
Return Value

See Error Codes. If the sequence grabber component cannot open a connection, it sets the result code to a nonzero value. It returns noErr if there is no error.
Discussion

The channel component is responsible for providing digitized data to the sequence grabber component. You specify the type of channel component to be added to the sequence grabber component, as shown in the following sample code:// SGNewChannel coding example
// See "Discovering QuickTime," page 263
void MakeMyGrabChannels (SeqGrabComponent    seqGrab,
                            SGChannel        *sgchanVideo,
                            SGChannel        *sgchanSound,
                            const Rect       *rect,
                            Boolean          bWillRecord)
{
    OSErr           nErr;
    long            lUsage;
    // figure out the usage
    lUsage =seqGrabPreview;                // always previewing
    if (bWillRecord)
        lUsage |=seqGrabRecord;            // sometimes recording
    // create a video channel
    nErr =SGNewChannel(seqGrab, VideoMediaType, sgchanVideo);
    if (nErr ==noErr) {
        // set boundaries for new video channel
        nErr =SGSetChannelBounds(*sgchanVideo, rect);
        // set usage for new video channel
        if (nErr ==noErr)
            nErr =SGSetChannelUsage(*sgchanVideo, lUsage |
                                        seqGrabPlayDuringRecord);
        if (nErr !=noErr) {
            // clean up on failure
            SGDisposeChannel(seqGrab, *sgchanVideo);
            *sgchanVideo =NIL;
        }
    }
    // create a sound channel
    nErr =SGNewChannel(seqGrab, SoundMediaType, sgchanSound);
    if (nErr ==noErr) {
        // set usage of new sound channel
        nErr =SGSetChannelUsage(*sgchanSound, lUsage);
        if (nErr !=noErr) {
            // clean up on failure
            SGDisposeChannel(seqGrab, *sgchanSound);
            *sgchanSound =NIL;
        }
    }
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGNewChannel (
   SeqGrabComponent    s,
   OSType              channelType,
   SGChannel           *ref );

/*SGGetChannelRefCon

Returns a reference constant that was previously set by SGSetChannelRefCon.

ComponentResult SGGetChannelRefCon (
   SGChannel    c,
   long         *refCon );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
refCon

A pointer to the reference constant set by SGSetChannelRefCon, normally used to point to a data structure containing information your sequence grabber channel needs.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 6.
Availability
Available in Mac OS X v10.2 and later.
Declared In
QuickTimeComponents.h&*/

ComponentResult SGGetChannelRefCon (
   SGChannel    c,
   long         *refCon );

/*SGSetChannelRefCon

Sets the value of a reference constant that is passed to your callback functions for channel components.

ComponentResult SGSetChannelRefCon (
   SGChannel    c,
   long         refCon );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
refCon

A reference constant value that your component should pass to the callback functions that have been assigned to this channel. Use this parameter to point to a data structure containing any information your callbacks need.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGSetChannelRefCon (
   SGChannel    c,
   long         refCon );

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

#endif