#import <QuartzCore/CIContext.h>
#import <QuartzCore/CIImage.h>
#import <OpenGL/CGLTypes.h>

#include <HYS/QuartzCore/CIContext.h>
#include <Foundation/NSDate.h>
#include <AppKit/NSGraphicsContext.h>
#include <AppKit/NSGraphics.h>
#include <AppKit/NSResponder.h>
#include <AppKit/NSEvent.h>


@implementation CIContext

/*contextWithCGLContext:pixelFormat:options:

Creates a Core Image context from a CGL context, using the specified options and pixel format object.

+ contextWithCGLContext:(CGLContextObj)ctx pixelFormat:(CGLPixelFormatObj)pf options:(NSDictionary *)dict
Parameters
ctx

A CGL context (CGLContextObj) obtain by calling the CGL function CGLCreateContext. 
pf

A CGL pixel format object (CGLPixelFormatObj) created by calling the CGL function CGLChoosePixelFormat. This argument must be the same pixel format object used to create the CGL context. The pixel format object must be valid for the lifetime of the Core Image context. Don’t release the pixel format object until after you release the Core Image context. 
options

A dictionary that contains color space information. You can provide the keys kCIContextOutputColorSpace or kCIContextWorkingColorSpace along with a CGColorSpaceRef for each color space.
Discussion

After calling this method, Core Image draws content into the drawable object attached to the CGL context. A CGL context is an Mac OS X OpenGL context. For more information, see OpenGL Programming Guide for Mac OS X.

For best results, follow these guidelines when you use Core Image to render into an OpenGL context:
Ensure that the a single unit in the coordinate space of the OpenGL context represents a single pixel in the output device.
The Core Image coordinate space has the origin in the bottom left corner of the screen. You should configure the OpenGL context in the same way.
The OpenGL context blending state is respected by Core Image. If the image you want to render contains translucent pixels, it’s best to enable blending using a blend function with the parameters GL_ONE, GL_ONE_MINUS_SRC_ALPHA, as shown in the following code example.

Some typical initialization code for a view with width W and height H is:    glViewport (0, 0, W, H);
    glMatrixMode (GL_PROJECTION);
    glLoadIdentity ();
    glOrtho (0, W, 0, H, -1, 1);
    glMatrixMode (GL_MODELVIEW);
    glLoadIdentity ();
    glBlendFunc (GL_ONE, GL_ONE_MINUS_SRC_ALPHA);
    glEnable (GL_BLEND);

Availability
Mac OS X v10.4 and later.*/
+ contextWithCGLContext:(CGLContextObj)ctx pixelFormat:(CGLPixelFormatObj)pf options:(NSDictionary *)dict{
//TODO
}

/*drawImage:inRect:fromRect:

Renders a region of an image to a rectangle in the context destination.

- (void)drawImage:(CIImage *)im inRect:(CGRect)dest fromRect:(CGRect)src
Parameters
im

A CIImage object.
dest

The rectangle in the context destination to draw into.
src

The region of the image to draw.
Discussion

You can call this method to force evaluation of the result after you apply a filter using one of the apply methods.
Availability
Mac OS X v10.4 and later.*/
- (void)drawImage:(CIImage *)im inRect:(CGRect)dest fromRect:(CGRect)src{
//TODO
}


/*createCGImage:fromRect:

Creates a Quartz 2D image from a region of a CIImage object.

- (CGImageRef)createCGImage:(CIImage *)im fromRect:(CGRect)r
Parameters
im

A CIImage object.
r

The region of the image to render.
Return Value

A Quartz 2D (CGImageRef) image. You are responsible for releasing the returned image when you no longer need it.
Discussion

Renders a region of an image into a temporary buffer using the context, then creates and returns a Quartz 2D image with the results.
Availability
Mac OS X v10.4 and later.*/
- (CGImageRef)createCGImage:(CIImage *)im fromRect:(CGRect)r{
//TODO
}

@end