#ifndef FILES_H
#define FILES_H


#ifndef MACTYPES_H
#include <CarbonCore/MacTypes.h>
#endif

#ifndef MIXEDMODE_H
#include <CarbonCore/MixedMode.h>
#endif

#ifndef OSUTILS_H
#include <CarbonCore/OSUtils.h>
#endif

#ifndef TEXTCOMMON_H
#include <CarbonCore/TextCommon.h>
#endif

#ifndef UTCUTILS_H
#include <CarbonCore/UTCUtils.h>
#endif



#ifndef FINDER_H
#include <CarbonCore/Finder.h>
#endif


#ifndef CFURL_H
#include <CoreFoundation/CFURL.h>
#endif

#ifndef CFRUNLOOP_H
#include <CoreFoundation/CFRunLoop.h>
#endif


#include <sys/types.h>

#include <AvailabilityMacros.h>

#include <HYS/CarbonCore/Files.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif


/*FSCatalogInfoBitmap

Describes which fields of the FSCatalogInfo structure you wish to retrieve or set.

typedef UInt32 FSCatalogInfoBitmap;
Discussion

If the bit corresponding to a particular field is not set in the bitmap, then that field is not changed in the FSCatalogInfo structure if it is an output parameter, and that field is ignored if the FSCatalogInfo structure is an input parameter. See Catalog Information Bitmap Constants for a description of the constants you should use with this data type. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef UInt32 FSCatalogInfoBitmap;

/*FSVolumeRefNum

Identifies a particular mounted volume.

typedef SInt16 FSVolumeRefNum;
Discussion

This data type is the same as the 16-bit volume refnum previously passed in the ioVRefNum fields of a parameter block; this is simply a new type name for the old data type. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef SInt16 FSVolumeRefNum;

/*HFSUniStr255

Used by the File Manager to return Unicode strings.

struct HFSUniStr255 {
   UInt16 length;
   UniChar unicode[255];
};
typedef struct HFSUniStr255 HFSUniStr255;
Fields
length

The number of unicode characters in the string.
unicode

The string, in unicode characters.
Discussion

This data type is a string of up to 255 16-bit Unicode characters, with a preceding 16-bit length (number of characters). Note that only the first length characters have meaningful values; the remaining characters may be set to arbitrary values. A caller should always assume that the entire structure will be modified, even if the actual string length is less than 255. 
Availability
Available in Mac OS X v10.0 and later.*/
struct HFSUniStr255 {
   UInt16 length;
   UniChar unicode[255];
};
typedef struct HFSUniStr255 HFSUniStr255;

/*FSSpec

Specifies the name and location of a file or directory.

struct FSSpec {
   short vRefNum;
   long parID;
   StrFileName name;
};
typedef struct FSSpec FSSpec;
typedef FSSpec * FSSpecPtr;
Fields
vRefNum

The volume reference number of the volume containing the specified file or directory.
parID

The parent directory ID of the specified file or directory (the directory ID of the directory containing the given file or directory).
name

The name of the specified file or directory. In Carbon, this name must be a leaf name; the name cannot contain a semicolon.
Discussion

The FSSpec structure can describe only a file or a directory, not a volume. A volume can be identified by its root directory, although the system software never uses an FSSpec structure to describe a volume. The directory ID of the root’s parent directory is fsRtParID. The name of the root directory is the same as the name of the volume.

If you need to convert a file specification into an FSSpec structure, call the function FSMakeFSSpec . Do not fill in the fields of an FSSpec structure yourself. 
Availability
Available in Mac OS X v10.0 and later.*/
struct FSSpec {
   short vRefNum;
   long parID;
   StrFileName name;
};
typedef struct FSSpec FSSpec;
typedef FSSpec * FSSpecPtr;


/*FSCatalogInfo

Holds basic information about a file or directory.

struct FSCatalogInfo {
   UInt16 nodeFlags;
   FSVolumeRefNum volume;
   UInt32 parentDirID;
   UInt32 nodeID;
   UInt8 sharingFlags;
   UInt8 userPrivileges;
   UInt8 reserved1;
   UInt8 reserved2;
   UTCDateTime createDate;
   UTCDateTime contentModDate;
   UTCDateTime attributeModDate;
   UTCDateTime accessDate;
   UTCDateTime backupDate;
   UInt32 permissions[4];
   UInt8 finderInfo[16];
   UInt8 extFinderInfo[16];
   UInt64 dataLogicalSize;
   UInt64 dataPhysicalSize;
   UInt64 rsrcLogicalSize;
   UInt64 rsrcPhysicalSize;
   UInt32 valence;
   TextEncoding textEncodingHint;
};
typedef struct FSCatalogInfo FSCatalogInfo;
typedef FSCatalogInfo * FSCatalogInfoPtr;
Fields
nodeFlags

Node flags. This field has two defined bits that indicate whether an object is a file or folder, and whether a file is locked (constants kFSNodeIsDirectoryMask and kFSNodeLockedMask). See Catalog Information Node Flags for the values you can use here.
volume

The object's volume reference. 
parentDirID

The ID of the directory that contains the given object. The root directory of a volume always has ID fsRtDirID (2); the parent of the root directory is ID fsRtParID (1). Note that there is no object with ID fsRtParID; this is merely used when the File Manager is asked for the parent of the root directory.
nodeID

The file or directory ID.
sharingFlags

The object’s sharing flags. See Catalog Information Sharing Flags for the meaning of the bits defined for this field.
userPrivileges

The user's effective AFP privileges (same as ioACUser in the old HFileInfo and DirInfo structures). See User Privileges Constants.
reserved1

Reserved.
reserved2

Reserved.
createDate

The date and time of the creation of the object. Note that file systems other than AFP, HFS and HFS Plus do not generally support creation dates. For file systems which do not support creation dates, FSGetCatalogInfo, PBGetCatalogInfoSync, and PBGetCatalogInfoAsync return 0 in this field. 
contentModDate

The date and time that the data or resource fork was last modified.
attributeModDate

The date and time that an attribute of the object (such as a fork other than the data or resource fork) was last modified.
accessDate

The date and time that the object was last accessed. The Mac OS 9 File Manager does not automatically update the accessDate field; it exists primarily for use by other operating systems (notably Mac OS X).
backupDate

The date and time of the object’s last backup. This field is not updated by the File Manager a backup utility may use this field if it wishes. Note that file systems other than AFP, HFS and HFS Plus do not generally support backup dates. For file systems which do not support backup dates, FSGetCatalogInfo, PBGetCatalogInfoSync, and PBGetCatalogInfoAsync return 0 in this field.
permissions

User and group permission information. The Mac OS 8 and 9 File Manager does not use or enforce this permission information. It could be used by a file server program or other operating system (primarily Mac OS X). In Mac OS X, this array contains the file system permissions of the returned item. To use this information, coerce the parameter to a FSPermissionInfo structure.
finderInfo

Basic Finder information for the object. This information is available in the catalog information, instead of in a named fork, for historical reasons. The File Manager does not interpret the contents of these fields. To use this information, coerce the parameter to a FileInfo or FolderInfo structure.
extFinderInfo

Extended Finder information for the object. This information is available in the catalog information, instead of in a named fork, for historical reasons. The File Manager does not interpret the contents of these fields. To use this information, coerce the parameter to an ExtendedFileInfo or ExtendedFolderInfo structure.
dataLogicalSize

The size of the data fork in bytes (the fork’s logical size). The information in this field is only valid for files do not rely upon the value returned in this field for folders.
dataPhysicalSize

The amount of disk space, in bytes, occupied by the data fork (the fork’s physical size). The information in this field is only valid for files do not rely upon the value returned in this field for folders.
rsrcLogicalSize

The size of the resource fork (the fork’s logical size). The information in this field is only valid for files do not rely upon the value returned in this field for folders.
rsrcPhysicalSize

The amount of disk space occupied by the resource fork (the fork’s physical size). The information in this field is only valid for files do not rely upon the value returned in this field for folders.
valence

For folders only, the number of items (files plus directories) contained within the directory. For files, it is set to zero. Many volume formats do not store a field containing a directory’s valence. For those volume formats, this field is very expensive to compute. Think carefully before you ask the File Manager to return this field.
textEncodingHint

The textEncodingHint field is used in conjunction with the Unicode filename of the object. It is an optional hint that can be used by the volume format when converting the Unicode to some other encoding. For example, HFS Plus stores this value and uses it when converting the name to a Mac OS encoding, such as when the name is returned by PBGetCatInfoSync or PBGetCatInfoAsync. As another example, HFS volumes use this value to convert the Unicode name to a Mac OS encoded name stored on disk. If the entire Unicode name can be converted to a single Mac OS encoding, then that encoding should be used as the textEncodingHint; otherwise, a text encoding corresponding to the first characters of the name will probably provide the best user experience. 

If a textEncodingHint is not supplied when a file or directory is created or renamed, the volume format will use a default value. This default value may not be the best possible choice for the given filename. Whenever possible, a client should supply a textEncodingHint.

Discussion

The FSCatalogInfoBitmap type is used to indicate which fields of the FSCatalogInfo should be set or retrieved. If the bit corresponding to a particular field is not set, then that field is not changed if the FSCatalogInfo is an output parameter, and that field is ignored if the FSCatalogInfo is an input parameter. 
Availability
Available in Mac OS X v10.0 and later.*/
struct FSCatalogInfo {
   UInt16 nodeFlags;
   FSVolumeRefNum volume;
   UInt32 parentDirID;
   UInt32 nodeID;
   UInt8 sharingFlags;
   UInt8 userPrivileges;
   UInt8 reserved1;
   UInt8 reserved2;
   UTCDateTime createDate;
   UTCDateTime contentModDate;
   UTCDateTime attributeModDate;
   UTCDateTime accessDate;
   UTCDateTime backupDate;
   UInt32 permissions[4];
   UInt8 finderInfo[16];
   UInt8 extFinderInfo[16];
   UInt64 dataLogicalSize;
   UInt64 dataPhysicalSize;
   UInt64 rsrcLogicalSize;
   UInt64 rsrcPhysicalSize;
   UInt32 valence;
   TextEncoding textEncodingHint;
};
typedef struct FSCatalogInfo FSCatalogInfo;
typedef FSCatalogInfo * FSCatalogInfoPtr;


/*FSRef

Identifies a directory or file, including a volume’s root directory.

struct FSRef {
   UInt8 hidden[80];
};
typedef struct FSRef FSRef;
typedef FSRef * FSRefPtr;
Discussion

This data type’s purpose is similar to an FSSpec except that an FSRef is completely opaque. An FSRef contains whatever information is needed to find the given object; the internal structure of an FSRef is likely to vary based on the volume format, and may vary based on the particular object being identified.

The client of the File Manager cannot examine the contents of an FSRef to extract information about the parent directory or the object’s name. Similarly, an FSRef cannot be constructed directly by the client; the FSRef must be constructed and returned via the File Manager. There is no need to call the File Manager to dispose an FSRef.

To determine the volume, parent directory and name associated with an FSRef, or to get an equivalent FSSpec, use the FSGetCatalogInfo call. 
Availability
Available in Mac OS X v10.0 and later.*/

struct FSRef {
   UInt8 hidden[80];
};
typedef struct FSRef FSRef;
typedef FSRef * FSRefPtr;


/*IOCompletionProcPtr

Defines a pointer to a completion function. Your completion function is executed by the File Manager after the completion of an asynchronous File Manager function call.

typedef void (*IOCompletionProcPtr) (
   ParmBlkPtr paramBlock
);

If you name your function MyIOCompletionProc, you would declare it like this:

void MyIOCompletionProc (
   ParmBlkPtr paramBlock
);IOCompletionProcPtr

Defines a pointer to a completion function. Your completion function is executed by the File Manager after the completion of an asynchronous File Manager function call.

typedef void (*IOCompletionProcPtr) (
   ParmBlkPtr paramBlock
);

If you name your function MyIOCompletionProc, you would declare it like this:

void MyIOCompletionProc (
   ParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the parameter block that was passed to the asynchronous File Manager function.
Return Value
Discussion

When you execute an asynchronous File Manager function (an Async function), you can specify a completion routine by passing the routine’s address in the ioCompletion field of the parameter block passed to the function. Because you requested asynchronous execution, the File Manager places an I/O request in the file I/O queue and returns control to your application—possibly even before the actual I/O operation is completed. The File Manager takes requests from the queue one at a time and processes them meanwhile, your application is free to do other processing.

A function executed asynchronously returns control to your application with the result code noErr as soon as the call is placed in the file I/O queue. This result code does not indicate that the call has successfully completed, but simply indicates that the call was successfully placed in the queue. To determine when the call is actually completed, you can inspect the ioResult field of the parameter block. This field is set to a positive number when the call is made and set to the actual result code when the call is completed. If you specify a completion routine, it is executed after the result code is placed in ioResult.

The File Manager, when the File Sharing or AppleShare file server is active, will execute requests in arbitrary order. That means that if there is a request that depends on the completion of a previous request, it is an error for your program to issue the second request until the completion of the first request. For example, issuing a write request and then issuing a read request for the same data isn't guaranteed to read back what was written unless the read request isn't made until after the write request completes.

Request order can also change if a call results in a disk switch dialog to bring an offline volume back online. 
Special Considerations

Because a completion routine is executed at interrupt time, it should not allocate, move, or purge memory (either directly or indirectly) and should not depend on the validity of handles to unlocked blocks.

If your completion routine uses application global variables, it must also ensure that register A5 contains the address of the boundary between your application global variables and your application parameters.
Parameters
paramBlock

A pointer to the parameter block that was passed to the asynchronous File Manager function.
Return Value
Discussion

When you execute an asynchronous File Manager function (an Async function), you can specify a completion routine by passing the routine’s address in the ioCompletion field of the parameter block passed to the function. Because you requested asynchronous execution, the File Manager places an I/O request in the file I/O queue and returns control to your application—possibly even before the actual I/O operation is completed. The File Manager takes requests from the queue one at a time and processes them meanwhile, your application is free to do other processing.

A function executed asynchronously returns control to your application with the result code noErr as soon as the call is placed in the file I/O queue. This result code does not indicate that the call has successfully completed, but simply indicates that the call was successfully placed in the queue. To determine when the call is actually completed, you can inspect the ioResult field of the parameter block. This field is set to a positive number when the call is made and set to the actual result code when the call is completed. If you specify a completion routine, it is executed after the result code is placed in ioResult.

The File Manager, when the File Sharing or AppleShare file server is active, will execute requests in arbitrary order. That means that if there is a request that depends on the completion of a previous request, it is an error for your program to issue the second request until the completion of the first request. For example, issuing a write request and then issuing a read request for the same data isn't guaranteed to read back what was written unless the read request isn't made until after the write request completes.

Request order can also change if a call results in a disk switch dialog to bring an offline volume back online. 
Special Considerations

Because a completion routine is executed at interrupt time, it should not allocate, move, or purge memory (either directly or indirectly) and should not depend on the validity of handles to unlocked blocks.

If your completion routine uses application global variables, it must also ensure that register A5 contains the address of the boundary between your application global variables and your application parameters.*/
typedef void (*IOCompletionProcPtr) (
   ParmBlkPtr paramBlock
);


/*IOCompletionUPP

A universal procedure pointer to an application-defined completion function.

typedef IOCompletionProcPtr IOCompletionUPP;
Discussion

See IOCompletionProcPtr.*/
typedef IOCompletionProcPtr IOCompletionUPP;

/*FSRefParam

Defines a parameter block used by low-level HFS Plus functions.

struct FSRefParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   ConstStringPtr ioNamePtr;
   short ioVRefNum;
   SInt16 reserved1;
   UInt8 reserved2;
   UInt8 reserved3;
   const FSRef * ref;
   FSCatalogInfoBitmap whichInfo;
   FSCatalogInfo * catInfo;
   UniCharCount nameLength;
   const UniChar * name;
   long ioDirID;
   FSSpec * spec;
   FSRef * parentRef;
   FSRef * newRef;
   TextEncoding textEncodingHint;
   HFSUniStr255 * outName;
};
typedef struct FSRefParam FSRefParam;
typedef FSRefParam * FSRefParamPtr;
Fields
qLink

A pointer to the next entry in the file I/O queue. (This field is used internally by the File Manager to keep track of asynchronous calls awaiting execution. 
qType

The queue type. This field is used internally by the File Manager.
ioTrap

The trap number of the function that was called. This field is used internally by the File Manager.
ioCmdAddr

The address of the function that was called. This field is used internally by the File Manager.
ioCompletion

A universal procedure pointer to a completion routine to be executed at the end of an asynchronous call. It should be 0 for asynchronous calls with no completion routine and is automatically set to 0 for all synchronous calls. See IOCompletionProcPtr for information about completion routines.
ioResult

The result code of the function. For synchronous calls, this field is the same as the result code of the function call itself. To determine when an asynchronous call has actually been completed, your application can poll this field it’s set to a positive number when the call is made and receives the actual result code when the call is completed.
ioNamePtr

A pointer to a pathname. Whenever a function description specifies that ioNamePtr is used—whether for input, output, or both—you should set this field to point to storage for a Str255 value (if you’re using a pathname) or to NULL (if you’re not).
ioVRefNum

A volume reference number, or 0 for the default volume.
reserved1

Reserved.
reserved2

Reserved.
reserved3

Reserved.
ref

The FSRef describing the file or directory which is the target of the call. 
whichInfo

An FSCatalogInfoBitmap which describes the fields of the catalog information structure passed in the catInfo field which are to be retrieved or set.
catInfo

A catalog inforFSRefParam

Defines a parameter block used by low-level HFS Plus functions.

struct FSRefParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   ConstStringPtr ioNamePtr;
   short ioVRefNum;
   SInt16 reserved1;
   UInt8 reserved2;
   UInt8 reserved3;
   const FSRef * ref;
   FSCatalogInfoBitmap whichInfo;
   FSCatalogInfo * catInfo;
   UniCharCount nameLength;
   const UniChar * name;
   long ioDirID;
   FSSpec * spec;
   FSRef * parentRef;
   FSRef * newRef;
   TextEncoding textEncodingHint;
   HFSUniStr255 * outName;
};
typedef struct FSRefParam FSRefParam;
typedef FSRefParam * FSRefParamPtr;
Fields
qLink

A pointer to the next entry in the file I/O queue. (This field is used internally by the File Manager to keep track of asynchronous calls awaiting execution. 
qType

The queue type. This field is used internally by the File Manager.
ioTrap

The trap number of the function that was called. This field is used internally by the File Manager.
ioCmdAddr

The address of the function that was called. This field is used internally by the File Manager.
ioCompletion

A universal procedure pointer to a completion routine to be executed at the end of an asynchronous call. It should be 0 for asynchronous calls with no completion routine and is automatically set to 0 for all synchronous calls. See IOCompletionProcPtr for information about completion routines.
ioResult

The result code of the function. For synchronous calls, this field is the same as the result code of the function call itself. To determine when an asynchronous call has actually been completed, your application can poll this field it’s set to a positive number when the call is made and receives the actual result code when the call is completed.
ioNamePtr

A pointer to a pathname. Whenever a function description specifies that ioNamePtr is used—whether for input, output, or both—you should set this field to point to storage for a Str255 value (if you’re using a pathname) or to NULL (if you’re not).
ioVRefNum

A volume reference number, or 0 for the default volume.
reserved1

Reserved.
reserved2

Reserved.
reserved3

Reserved.
ref

The FSRef describing the file or directory which is the target of the call. 
whichInfo

An FSCatalogInfoBitmap which describes the fields of the catalog information structure passed in the catInfo field which are to be retrieved or set.
catInfo

A catalog information structure containing information about the specified file or directory. 
nameLength

The length of the file or directory’s name, for the PBCreateSync, PBCreateAsync, PBRenameSync, and PBRenameAsync functions.
name

A pointer to the file or directory’s Unicode name, for the PBCreateSync, PBCreateAsync, PBRenameSync, and PBRenameAsync functions.
ioDirID

The directory ID of the specified file or directory’s parent directory.
spec

The target or source FSRef. 
parentRef

The secondary or destination FSRef. (Or the ref of the directory to move another file or directory to). 
newRef

The output FSRef (ie, a new FSRef ).
textEncodingHint

A text encoding hint for the file or directory’s Unicode name, used by the PBMakeFSRefSync, PBMakeFSRefAsync, PBRenameSync, and PBRenameAsync functions. 
outName

On output, a pointer to the Unicode name of the file or directory, used by the PBGetCatalogInfoSync and PBGetCatalogInfoAsync functions.
Availability
Available in Mac OS X v10.0 and later.mation structure containing information about the specified file or directory. 
nameLength

The length of the file or directory’s name, for the PBCreateSync, PBCreateAsync, PBRenameSync, and PBRenameAsync functions.
name

A pointer to the file or directory’s Unicode name, for the PBCreateSync, PBCreateAsync, PBRenameSync, and PBRenameAsync functions.
ioDirID

The directory ID of the specified file or directory’s parent directory.
spec

The target or source FSRef. 
parentRef

The secondary or destination FSRef. (Or the ref of the directory to move another file or directory to). 
newRef

The output FSRef (ie, a new FSRef ).
textEncodingHint

A text encoding hint for the file or directory’s Unicode name, used by the PBMakeFSRefSync, PBMakeFSRefAsync, PBRenameSync, and PBRenameAsync functions. 
outName

On output, a pointer to the Unicode name of the file or directory, used by the PBGetCatalogInfoSync and PBGetCatalogInfoAsync functions.
Availability
Available in Mac OS X v10.0 and later.*/
struct FSRefParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   ConstStringPtr ioNamePtr;
   short ioVRefNum;
   SInt16 reserved1;
   UInt8 reserved2;
   UInt8 reserved3;
   const FSRef * ref;
   FSCatalogInfoBitmap whichInfo;
   FSCatalogInfo * catInfo;
   UniCharCount nameLength;
   const UniChar * name;
   long ioDirID;
   FSSpec * spec;
   FSRef * parentRef;
   FSRef * newRef;
   TextEncoding textEncodingHint;
   HFSUniStr255 * outName;
};
typedef struct FSRefParam FSRefParam;
typedef FSRefParam * FSRefParamPtr;


/*Root Directory Constants

Specify the directory IDs of the root directory of a volume and its parent.

enum {
   fsRtParID = 1,
   fsRtDirID = 2
};
Constants
fsRtParID

Represents the directory ID of the root directory’s parent directory. The root directory has no parent this constant is used when specifying the root directory to functions which require the parent directory ID to identify directories. 

Available in Mac OS X v10.0 and later.
fsRtDirID

Represents the directory ID of the volume’s root directory.

Available in Mac OS X v10.0 and later.*/
enum {
   fsRtParID = 1,
   fsRtDirID = 2
};

/*File Attribute Constants

Define file and directory attributes returned by the PBGetCatInfoSync and PBGetCatInfoAsync functions.

enum {
   kioFlAttribLockedBit = 0,
   kioFlAttribLockedMask = 0x01,
   kioFlAttribResOpenBit = 2,
   kioFlAttribResOpenMask = 0x04,
   kioFlAttribDataOpenBit = 3,
   kioFlAttribDataOpenMask = 0x08,
   kioFlAttribDirBit = 4,
   kioFlAttribDirMask = 0x10,
   ioDirFlg = 4,
   ioDirMask = 0x10,
   kioFlAttribCopyProtBit = 6,
   kioFlAttribCopyProtMask = 0x40,
   kioFlAttribFileOpenBit = 7,
   kioFlAttribFileOpenMask = 0x80,
   kioFlAttribInSharedBit = 2,
   kioFlAttribInSharedMask = 0x04,
   kioFlAttribMountedBit = 3,
   kioFlAttribMountedMask = 0x08,
   kioFlAttribSharePointBit = 5,
   kioFlAttribSharePointMask = 0x20
};
Constants
kioFlAttribLockedBit

Indicates that the file or directory is locked. Use the functions PBHSetFLockSync and PBHSetFLockAsync to lock a file or directory. Use the functions PBHRstFLockSync and PBHRstFLockAsync to unlock a file or directory.

Available in Mac OS X v10.0 and later.
kioFlAttribLockedMask

Tests if the file or directory is locked.

Available in Mac OS X v10.0 and later.
kioFlAttribResOpenBit

Indicates that the resource fork is open. On Mac OS X, this bit is not set if the resource fork of the file has been opened by a process other than the process making the call to PBHGetCatInfo or PBHGetFInfo.

Available in Mac OS X v10.0 and later.
kioFlAttribResOpenMask

Tests if the resource fork is open.

Available in Mac OS X v10.0 and later.
kioFlAttribDataOpenBit

Indicates that the data fork is open. On Mac OS X, this bit is not set if the data fork of the file has been opened by a process other than the process making the call to PBHGetCatInfo or PBHGetFInfo.

Available in Mac OS X v10.0 and later.
kioFlAttribDataOpenMask

Tests if the data fork is open.

Available in Mac OS X v10.0 and later.
kioFlAttribDirBit

Indicates that this is a directory, not a file. This bit is always clear for files, and is always set for directories.

Available in Mac OS X v10.0 and later.
kioFlAttribDirMask

Tests if this is a directory.

Available in Mac OS X v10.0 and later.
ioDirFlg

Indicates that this is a directory; this is the old name of the kioFlAttribDirBit.

Available in Mac OS X v10.0 and later.
ioDirMask

Tests if this is a directory; this is the old name of the kioFlAttribDirMask.

Available in Mac OS X v10.0 and later.
kioFlAttribCopyProtBit

Indicates that the file is “copy-protected” by the AppleShare server.

Available in Mac OS X v10.0 and later.
kioFlAttribCopyProtMask

Tests if the file is “copy-protected” by the AppleShare server.

Available in Mac OS X v10.0 and later.
kioFlAttribFileOpenBit

Indicates that the file is open. This bit is set if either the data or the resource fork are open. On Mac OS X, this bit is not set if the file has been opened by a process other than the process making the call to PBHGetCatInfo or PBHGetFInfo.

Available in Mac OS X v10.0 and later.
kioFlAttribFileOpenMask

Tests if the file is open. The file is open if either the data or the resource fork are open. 

Available in Mac OS X v10.0 and later.
kioFlAttribInSharedBit

Indicates that the directory is within a shared area of the directory hierarchy.

Available in Mac OS X v10.0 and later.
kioFlAttribInSharedMask

Tests if the directory is within a shared area of the directory hierarchy.

Available in Mac OS X v10.0 and later.
kioFlAttribMountedBit

Indicates that the directory is a share point that is mounted by a user.

Available in Mac OS X v10.0 and later.
kioFlAttribMountedMask

Tests if the directory is a share point that is mounted by a user.

Available in Mac OS X v10.0 and later.
kioFlAttribSharePointBit

Indicates that the directory is a share point.

Available in Mac OS X v10.0 and later.
kioFlAttribSharePointMask

Tests if the directory is a share point.

Available in Mac OS X v10.0 and later.
Discussion

These constants are used in the ioFlAttrib fields of the HFileInfo and DirInfo structures returned by the functions PBGetCatInfoSync and PBGetCatInfoAsync .*/
enum {
   kioFlAttribLockedBit = 0,
   kioFlAttribLockedMask = 0x01,
   kioFlAttribResOpenBit = 2,
   kioFlAttribResOpenMask = 0x04,
   kioFlAttribDataOpenBit = 3,
   kioFlAttribDataOpenMask = 0x08,
   kioFlAttribDirBit = 4,
   kioFlAttribDirMask = 0x10,
   ioDirFlg = 4,
   ioDirMask = 0x10,
   kioFlAttribCopyProtBit = 6,
   kioFlAttribCopyProtMask = 0x40,
   kioFlAttribFileOpenBit = 7,
   kioFlAttribFileOpenMask = 0x80,
   kioFlAttribInSharedBit = 2,
   kioFlAttribInSharedMask = 0x04,
   kioFlAttribMountedBit = 3,
   kioFlAttribMountedMask = 0x08,
   kioFlAttribSharePointBit = 5,
   kioFlAttribSharePointMask = 0x20
};



/*IOCompletionProcPtr

Defines a pointer to a completion function. Your completion function is executed by the File Manager after the completion of an asynchronous File Manager function call.

typedef void (*IOCompletionProcPtr) (
   ParmBlkPtr paramBlock
);

If you name your function MyIOCompletionProc, you would declare it like this:

void MyIOCompletionProc (
   ParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the parameter block that was passed to the asynchronous File Manager function.
Return Value
Discussion

When you execute an asynchronous File Manager function (an Async function), you can specify a completion routine by passing the routine’s address in the ioCompletion field of the parameter block passed to the function. Because you requested asynchronous execution, the File Manager places an I/O request in the file I/O queue and returns control to your application—possibly even before the actual I/O operation is completed. The File Manager takes requests from the queue one at a time and processes them meanwhile, your application is free to do other processing.

A function executed asynchronously returns control to your application with the result code noErr as soon as the call is placed in the file I/O queue. This result code does not indicate that the call has successfully completed, but simply indicates that the call was successfully placed in the queue. To determine when the call is actually completed, you can inspect the ioResult field of the parameter block. This field is set to a positive number when the call is made and set to the actual result code when the call is completed. If you specify a completion routine, it is executed after the result code is placed in ioResult.

The File Manager, when the File Sharing or AppleShare file server is active, will execute requests in arbitrary order. That means that if there is a request that depends on the completion of a previous request, it is an error for your program to issue the second request until the completion of the first request. For example, issuing a write request and then issuing a read request for the same data isn't guaranteed to read back what was written unless the read request isn't made until after the write request completes.

Request order can also change if a call results in a disk switch dialog to bring an offline volume back online. 
Special Considerations

Because a completion routine is executed at interrupt time, it should not allocate, move, or purge memory (either directly or indirectly) and should not depend on the validity of handles to unlocked blocks.

If your completion routine uses application global variables, it must also ensure that register A5 contains the address of the boundary between your application global variables and your application parameters.*/
typedef void (*IOCompletionProcPtr) (
   ParmBlkPtr paramBlock
);

/*IOCompletionUPP

A universal procedure pointer to an application-defined completion function.

typedef IOCompletionProcPtr IOCompletionUPP;
Discussion

See IOCompletionProcPtr.*/
typedef IOCompletionProcPtr IOCompletionUPP;

/*IOCompletionUPP

A universal procedure pointer to an application-defined completion function.

typedef IOCompletionProcPtr IOCompletionUPP;
Discussion

See IOCompletionProcPtr.*/
typedef IOCompletionProcPtr IOCompletionUPP;


/*ObjParam

Defines a parameter block used by low-level HFS user and group information functions.

struct ObjParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   short filler7;
   short ioObjType;
   StringPtr ioObjNamePtr;
   long ioObjID;
};
typedef struct ObjParam ObjParam;
typedef ObjParam * ObjParamPtr;
Fields
qLink

A pointer to the next entry in the file I/O queue. (This field is used internally by the File Manager to keep track of asynchronous calls awaiting execution. 
qType

The queue type. This field is used internally by the File Manager.
ioTrap

The trap number of the function that was called. This field is used internally by the File Manager.
ioCmdAddr

The address of the function that was called. This field is used internally by the File Manager.
ioCompletion

A universal procedure pointer to a completion routine to be executed at the end of an asynchronous call. It should be 0 for asynchronous calls with no completion routine and is automatically set to 0 for all synchronous calls. See IOCompletionProcPtr for information about completion routines.
ioResult

The result code of the function. For synchronous calls, this field is the same as the result code of the function call itself. To determine when an asynchronous call has actually been completed, your application can poll this field it’s set to a positive number when the call is made and receives the actual result code when the call is completed.
ioNamePtr

A pointer to a pathname. Whenever a function description specifies that ioNamePtr is used—whether for input, output, or both—it’s very important that you set this field to point to storage for a Str255 value (if you’re using a pathname) or to NULL (if you’re not).
ioVRefNum

A volume reference number, 0 for the default volume, or a drive number.
filler7

Reserved.
ioObjType

A function code. The values passed in this field are determined by the function to which you pass this parameter block.
ioObjNamePtr

A pointer to the returned creator/group name.
ioObjID

The creator/group ID.
Availability
Available in Mac OS X v10.0 and later.*/
struct ObjParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   short filler7;
   short ioObjType;
   StringPtr ioObjNamePtr;
   long ioObjID;
};
typedef struct ObjParam ObjParam;
typedef ObjParam * ObjParamPtr;


/*AccessParam

Defines a parameter block used by low-level HFS file and directory access rights manipulation functions.

struct AccessParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   short filler3;
   short ioDenyModes;
   short filler4;
   SInt8 filler5;
   SInt8 ioACUser;
   long filler6;
   long ioACOwnerID;
   long ioACGroupID;
   long ioACAccess;
   long ioDirID;
};
typedef struct AccessParam AccessParam;
typedef AccessParam * AccessParamPtr;
Fields
qLink

A pointer to the next entry in the file I/O queue. (This field is used internally by the File Manager to keep track of asynchronous calls awaiting execution. 
qType

The queue type. This field is used internally by the File Manager.
ioTrap

The trap number of the function that was called. This field is used internally by the File Manager.
ioCmdAddr

The address of the function that was called. This field is used internally by the File Manager.
ioCompletion

A universal procedure pointer to a completion routine to be executed at the end of an asynchronous call. It should be 0 for asynchronous calls with no completion routine and is automatically set to 0 for all synchronous calls. See IOCompletionProcPtr for information about completion routines.
ioResult

The result code of the function. For synchronous calls, this field is the same as the result code of the function call itself. To determine when an asynchronous call has actually been completed, your application can poll this field it’s set to a positive number when the call is made and receives the actual result code when the call is completed.
ioNamePtr

A pointer to a pathname. Whenever a function description specifies that ioNamePtr is used—whether for input, output, or both—it’s very important that you set this field to point to storage for a Str255 value (if you’re using a pathname) or to NULL (if you’re not).
ioVRefNum

A volume reference number, 0 for the default volume, or a drive number.
filler3

Reserved.
ioDenyModes

Access mode information.
filler4

Reserved.
filler5

Reserved.
ioACUser

The user’s access rights for the specified directory.
filler6

Reserved.
ioACOwnerID

The owner ID.
ioACGroupID

The group ID.
ioACAccess

The directory access privileges.
ioDirID
Availability
Available in Mac OS X v10.0 and later.*/
struct AccessParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   short filler3;
   short ioDenyModes;
   short filler4;
   SInt8 filler5;
   SInt8 ioACUser;
   long filler6;
   long ioACOwnerID;
   long ioACGroupID;
   long ioACAccess;
   long ioDirID;
};
typedef struct AccessParam AccessParam;
typedef AccessParam * AccessParamPtr;

/*HFileParam

Defines a parameter block used by low-level HFS functions for file creation, deletion, and information retrieval.

struct HFileParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   short ioFRefNum;
   SInt8 ioFVersNum;
   SInt8 filler1;
   short ioFDirIndex;
   SInt8 ioFlAttrib;
   SInt8 ioFlVersNum;
   FInfo ioFlFndrInfo;
   long ioDirID;
   unsigned short ioFlStBlk;
   long ioFlLgLen;
   long ioFlPyLen;
   unsigned short ioFlRStBlk;
   long ioFlRLgLen;
   long ioFlRPyLen;
   unsigned long ioFlCrDat;
   unsigned long ioFlMdDat;
};
typedef struct HFileParam HFileParam;
typedef HFileParam * HFileParamPtr;
Fields
qLink

A pointer to the next entry in the file I/O queue. (This field is used internally by the File Manager to keep track of asynchronous calls awaiting execution. 
qType

The queue type. This field is used internally by the File Manager.
ioTrap

The trap number of the function that was called. This field is used internally by the File Manager.
ioCmdAddr

The address of the function that was called. This field is used internally by the File Manager.
ioCompletion

A universal procedure pointer to a completion routine to be executed at the end of an asynchronous call. It should be 0 for asynchronous calls with no completion routine and is automatically set to 0 for all synchronous calls. See IOCompletionProcPtr for information about completion routines.
ioResult

The result code of the function. For synchronous calls, this field is the same as the result code of the function call itself. To determine when an asynchronous call has actually been completed, your application can poll this field it’s set to a positive number when the call is made and receives the actual result code when the call is completed.
ioNamePtr

A pointer to a pathname. Whenever a function description specifies that ioNamePtr is used—whether for input, output, or both—it’s very important that you set this field to point to storage for a Str255 value (if you’re using a pathname) or to NULL (if you’re not).
ioVRefNum

A volume reference number, 0 for the default volume, or a drive number.
ioFRefNum

The file reference number of an open file.
ioFVersNum

A file version number. This field is no longer used. File version numbers are an artifact of the obsolete MFS, and are not supported on HFS volumes. You should always set this field to 0.
filler1

Reserved.
ioFDirIndex

A directory index for use with the PBHGetFInfoSync and PBHGetFInfoAsync functions.
ioFlAttrib

File attributes. See File Attribute Constants for the meaning of the bits in this field.
ioFlVersNum

A file version number. This feature is no longer supported, and you must always set this field to 0.
ioFlFndrInfo

Information used by the Finder. 
ioDirID

A directory ID.
ioFlStBlk

The first allocation block of the data fork. This field contains 0 if the file’s data fork is empty.
ioFlLgLen

The logical length (logical end-of-file) of the data fork.
ioFlPyLen

The physical length (physical end-of-file) of the data fork.
ioFlRStBlk

The first allocation block of the resource fork. This field contains 0 if the file’s resource fork is empty.
ioFlRLgLen

The logical length (logical end-of-file) of the resource fork.
ioFlRPyLen

The physical length (physical end-of-file) of the resource fork.
ioFlCrDat

The date and time of the file’s creation, specified in seconds since midnight, January 1, 1904.
ioFlMdDat

The date and time of the last modification to the file, specified in seconds since midnight, January 1, 1904.
Availability
Available in Mac OS X v10.0 and later.*/
struct HFileParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   short ioFRefNum;
   SInt8 ioFVersNum;
   SInt8 filler1;
   short ioFDirIndex;
   SInt8 ioFlAttrib;
   SInt8 ioFlVersNum;
   FInfo ioFlFndrInfo;
   long ioDirID;
   unsigned short ioFlStBlk;
   long ioFlLgLen;
   long ioFlPyLen;
   unsigned short ioFlRStBlk;
   long ioFlRLgLen;
   long ioFlRPyLen;
   unsigned long ioFlCrDat;
   unsigned long ioFlMdDat;
};
typedef struct HFileParam HFileParam;
typedef HFileParam * HFileParamPtr;

/*HVolumeParam

Defines a parameter block used by low-level HFS volume manipulation functions.

struct HVolumeParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   long filler2;
   short ioVolIndex;
   unsigned long ioVCrDate;
   unsigned long ioVLsMod;
   short ioVAtrb;
   unsigned short ioVNmFls;
   unsigned short ioVBitMap;
   unsigned short ioAllocPtr;
   unsigned short ioVNmAlBlks;
   unsigned long ioVAlBlkSiz;
   unsigned long ioVClpSiz;
   unsigned short ioAlBlSt;
   unsigned long ioVNxtCNID;
   unsigned short ioVFrBlk;
   unsigned short ioVSigWord;
   short ioVDrvInfo;
   short ioVDRefNum;
   short ioVFSID;
   unsigned long ioVBkUp;
   short ioVSeqNum;
   unsigned long ioVWrCnt;
   unsigned long ioVFilCnt;
   unsigned long ioVDirCnt;
   long ioVFndrInfo[8];
};
typedef struct HVolumeParam HVolumeParam;
typedef HVolumeParam * HVolumeParamPtr;
Fields
qLink

A pointer to the next entry in the file I/O queue. (This field is used internally by the File Manager to keep track of asynchronous calls awaiting execution. 
qType

The queue type. This field is used internally by the File Manager.
ioTrap

The trap number of the function that was called. This field is used internally by the File Manager.
ioCmdAddr

The address of the function that was called. This field is used internally by the File Manager.
ioCompletion

A universal procedure pointer to a completion routine to be executed at the end of an asynchronous call. It should be 0 for asynchronous calls with no completion routine and is automatically set to 0 for all synchronous calls. See IOCompletionProcPtr for information about completion routines.
ioResult

The result code of the function. For synchronous calls, this field is the same as the result code of the function call itself. To determine when an asynchronous call has actually been completed, your application can poll this field it’s set to a positive number when the call is made and receives the actual result code when the call is completed.
ioNamePtr

A pointer to a pathname. Whenever a function description specifies that ioNamePtr is used—whether for input, output, or both—it’s very important that you set this field to point to storage for a Str255 value (if you’re using a pathname) or to NULL (if you’re not).
ioVRefNum

A volume reference number, 0 for the default volume, or a drive number.
filler2

Reserved.
ioVolIndex

A volume index for use with the PBHGetVInfoSync and PBHGetVInfoAsync functions.
ioVCrDate

The date and time of the volume’s initialization.
ioVLsMod

The date and time the volume information was last modified. (This field is not changed when information is written to a file and does not necessarily indicate when the volume was flushed.
ioVAtrb

The volume attributes. See Volume Information Attribute Constants for the meanings of the bits in this field.
ioVNmFls

The number of files in the root directory of the volume. For performance reasons, the Carbon File Manager does not return the number of files in this field; instead, it sets ioVNmFls to 0.

To determine the number of files in the root directory of a volume in Carbon, call PBGetCatInfoAsync or PBGetCatInfoSync for the root directory. The number of files in the root directory is returned in the ioDrNmFls field.
ioVBitMap

The first block of the volume bitmap.
ioAllocPtr

The block at which the next new file starts. Used internally.
ioVNmAlBlks

The number of allocation blocks.
ioVAlBlkSiz

The size of allocation blocks.
ioVClpSiz

The clump size.
ioAlBlSt

The first block in the volume map.
ioVNxtCNID

The next unused catalog node ID.
ioVFrBlk

The number of unused allocation blocks.
ioVSigWord

A signature word identifying the type of volume it’s $D2D7 for MFS volumes and $4244 for volumes that support HFS calls.
ioVDrvInfo

The drive number of the drive containing the volume.
ioVDRefNum

For online volumes, the reference number of the I/O driver for the drive identified by the ioVDrvInfo field.
ioVFSID

The file-system identifier. It indicates which file system is servicing the volume it’s zero for File Manager volumes and nonzero for volumes handled by an external file system.
ioVBkUp

The date and time the volume was last backed up; this is 0 if the volume has never been backed up.
ioVSeqNum

Used internally.
ioVWrCnt

The volume write count.
ioVFilCnt

The total number of files on the volume.
ioVDirCnt

The total number of directories (not including the root directory) on the volume.
ioVFndrInfo

Information used by the Finder.
Availability
Available in Mac OS X v10.0 and later.*/
struct HVolumeParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   long filler2;
   short ioVolIndex;
   unsigned long ioVCrDate;
   unsigned long ioVLsMod;
   short ioVAtrb;
   unsigned short ioVNmFls;
   unsigned short ioVBitMap;
   unsigned short ioAllocPtr;
   unsigned short ioVNmAlBlks;
   unsigned long ioVAlBlkSiz;
   unsigned long ioVClpSiz;
   unsigned short ioAlBlSt;
   unsigned long ioVNxtCNID;
   unsigned short ioVFrBlk;
   unsigned short ioVSigWord;
   short ioVDrvInfo;
   short ioVDRefNum;
   short ioVFSID;
   unsigned long ioVBkUp;
   short ioVSeqNum;
   unsigned long ioVWrCnt;
   unsigned long ioVFilCnt;
   unsigned long ioVDirCnt;
   long ioVFndrInfo[8];
};
typedef struct HVolumeParam HVolumeParam;

/*FIDParam

Defines a parameter block used by low-level HFS file ID functions.

struct FIDParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   long filler14;
   StringPtr ioDestNamePtr;
   long filler15;
   long ioDestDirID;
   long filler16;
   long filler17;
   long ioSrcDirID;
   short filler18;
   long ioFileID;
};
typedef struct FIDParam FIDParam;
typedef FIDParam * FIDParamPtr;
Fields
qLink

A pointer to the next entry in the file I/O queue. (This field is used internally by the File Manager to keep track of asynchronous calls awaiting execution. 
qType

The queue type. This field is used internally by the File Manager.
ioTrap

The trap number of the function that was called. This field is used internally by the File Manager.
ioCmdAddr

The address of the function that was called. This field is used internally by the File Manager.
ioCompletion

A universal procedure pointer to a completion routine to be executed at the end of an asynchronous call. It should be 0 for asynchronous calls with no completion routine and is automatically set to 0 for all synchronous calls. See IOCompletionProcPtr for information about completion routines.
ioResult

The result code of the function. For synchronous calls, this field is the same as the result code of the function call itself. To determine when an asynchronous call has actually been completed, your application can poll this field it’s set to a positive number when the call is made and receives the actual result code when the call is completed.
ioNamePtr

A pointer to a pathname. Whenever a function description specifies that ioNamePtr is used—whether for input, output, or both—it’s very important that you set this field to point to storage for a Str255 value (if you’re using a pathname) or to NULL (if you’re not).
ioVRefNum

A volume reference number, 0 for the default volume, or a drive number.
filler14

Reserved.
ioDestNamePtr

A pointer to the name of the destination file.
filler15

Reserved.
ioDestDirID

The parent directory ID of the destination file.
filler16

Reserved.
filler17

Reserved.
ioSrcDirID

The parent directory ID of the source file.
filler18

Reserved.
ioFileID

The file ID.
Availability
Available in Mac OS X v10.0 and later.*/
struct FIDParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   long filler14;
   StringPtr ioDestNamePtr;
   long filler15;
   long ioDestDirID;
   long filler16;
   long filler17;
   long ioSrcDirID;
   short filler18;
   long ioFileID;
};
typedef struct FIDParam FIDParam;
typedef FIDParam * FIDParamPtr;

/*DirInfo

Defines a structure which holds catalog information about a directory.

struct DirInfo {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   short ioFRefNum;
   SInt8 ioFVersNum;
   SInt8 filler1;
   short ioFDirIndex;
   SInt8 ioFlAttrib;
   SInt8 ioACUser;
   DInfo ioDrUsrWds;
   long ioDrDirID;
   unsigned short ioDrNmFls;
   short filler3[9];
   unsigned long ioDrCrDat;
   unsigned long ioDrMdDat;
   unsigned long ioDrBkDat;
   DXInfo ioDrFndrInfo;
   long ioDrParID;
};
typedef struct DirInfo DirInfo;
Fields
qLink

A pointer to the next entry in the file I/O queue. (This field is used internally by the File Manager to keep track of asynchronous calls awaiting execution. 
qType

The queue type. This field is used internally by the File Manager.
ioTrap

The trap number of the function that was called. This field is used internally by the File Manager.
ioCmdAddr

The address of the function that was called. This field is used internally by the File Manager.
ioCompletion

A universal procedure pointer to a completion routine to be executed at the end of an asynchronous call. It should be 0 for asynchronous calls with no completion routine and is automatically set to 0 for all synchronous calls. See IOCompletionProcPtr for information about completion routines.
ioResult

The result code of the function. For synchronous calls, this field is the same as the result code of the function call itself. To determine when an asynchronous call has actually been completed, your application can poll this field it’s set to a positive number when the call is made and receives the actual result code when the call is completed.
ioNamePtr

A pointer to a pathname. Whenever a function description specifies that ioNamePtr is used—whether for input, output, or both—it’s very important that you set this field to point to storage for a Str255 value (if you’re using a pathname) or to NULL (if you’re not).
ioVRefNum

A volume reference number, 0 for the default volume, or a drive number.
ioFRefNum

The file reference number of an open file.
ioFVersNum

A file version number. This field is no longer used. File version numbers are an artifact of the obsolete MFS, and are not supported on HFS volumes. You should always set this field to 0.
filler1

Reserved.
ioFDirIndex

A file and directory index. If this field contains a positive number, PBGetCatInfoSync and PBGetCatInfoAsync return information about the file or directory having that directory index in the directory specified by the ioVRefNum field. (If ioVRefNum contains a volume reference number, the specified directory is that volume’s root directory.) 

If this field contains 0, PBGetCatInfoSync and PBGetCatInfoAsync return information about the file or directory whose name is specified in the ioNamePtr field and that is located in the directory specified by the ioVRefNum field. (Once again, if ioVRefNum contains a volume reference number, the specified directory is that volume’s root directory.)

If this field contains a negative number, PBGetCatInfoSync and PBGetCatInfoAsync ignore the ioNamePtr field and returns information about the directory specified in the ioDirID field. If both ioDirID and ioVRefNum are set to 0, PBGetCatInfoSync and PBGetCatInfoAsync return information about the current default directory.
ioFlAttrib

File or directory attributes. See File Attribute Constants for the meaning of the bits in this field.
ioACUser

The user’s access rights for the specified directory. See User Privileges Constants for the meaning of the bits in this field.
ioDrUsrWds

Information used by the Finder. 
ioDrDirID

A directory ID. On input to PBGetCatInfoSync and PBGetCatInfoAsync , this field contains a directory ID, which is used only if the value of the ioFDirIndex field is negative. On output, this field contains the directory ID of the specified directory.
ioDrNmFls

The number of files in the directory.
filler3

Reserved.
ioDrCrDat

The date and time of the directory’s creation, in seconds since midnight, January 1, 1904. However, on Mac OS X, if you set the creation date to a date between January 1, 1904 and January 1, 1970, it will be clipped to January 1, 1970, and that is the value which will be returned if you later try to retrieve the creation date. 

Note that file systems other than AFP, HFS and HFS Plus do not generally support creation dates.
ioDrMdDat

The date and time of the last modification to the directory, in seconds since midnight, January 1, 1904. However, on Mac OS X, if you set the modification date to a date between January 1, 1904 and January 1, 1970, it will be clipped to January 1, 1970.
ioDrBkDat

The date and time that the directory was last backed up, in seconds since midnight, January 1, 1904. However, on Mac OS X, if you set the backup date to a date between January 1, 1904 and January 1, 1970, it will be clipped to January 1, 1970. 

Note that file systems other than AFP, HFS and HFS Plus do not generally support backup dates.
ioDrFndrInfo

Additional information used by the Finder. 
ioDrParID

The directory ID of the specified directory’s parent directory.
refCon
Availability
Available in Mac OS X v10.0 and later.*/
struct DirInfo {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   short ioFRefNum;
   SInt8 ioFVersNum;
   SInt8 filler1;
   short ioFDirIndex;
   SInt8 ioFlAttrib;
   SInt8 ioACUser;
   DInfo ioDrUsrWds;
   long ioDrDirID;
   unsigned short ioDrNmFls;
   short filler3[9];
   unsigned long ioDrCrDat;
   unsigned long ioDrMdDat;
   unsigned long ioDrBkDat;
   DXInfo ioDrFndrInfo;
   long ioDrParID;
};
typedef struct DirInfo DirInfo;

/*CatPositionRec

Defines a catalog position structure, which maintains the current position of a catalog search between calls to PBCatSearchSync or PBCatSearchAsync.

struct CatPositionRec {
   long initialize;
   short priv[6];
};
typedef struct CatPositionRec CatPositionRec;
Fields
initialize

The starting point of the catalog search. To start searching at the beginning of a catalog, specify 0 in this field. To resume a previous search, pass the value returned by the previous call to PBCatSearchSync or PBCatSearchAsync.
priv

An array of integers that is used internally by PBCatSearchSync and PBCatSearchAsync.
Discussion

When you call the PBCatSearchSync or PBCatSearchAsync function to search a volume’s catalog file, you can specify, in the ioCatPosition field of the parameter block passed to PBCatSearchSync and PBCatSearchAsync, a catalog position structure. If a catalog search consumes more time than is allowed by the ioSearchTime field, PBCatSearchSync and PBCatSearchAsync store a directory-location index in that structure; when you call PBCatSearchSync or PBCatSearchAsync again, it uses that structure to resume searching where it left off. 
Availability
Available in Mac OS X v10.0 and later.*/
struct CatPositionRec {
   long initialize;
   short priv[6];
};
typedef struct CatPositionRec CatPositionRec;

/*HFileInfo

Defines a structure which holds catalog information about a file.

struct HFileInfo {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   short ioFRefNum;
   SInt8 ioFVersNum;
   SInt8 filler1;
   short ioFDirIndex;
   SInt8 ioFlAttrib;
   SInt8 ioACUser;
   FInfo ioFlFndrInfo;
   long ioDirID;
   unsigned short ioFlStBlk;
   long ioFlLgLen;
   long ioFlPyLen;
   unsigned short ioFlRStBlk;
   long ioFlRLgLen;
   long ioFlRPyLen;
   unsigned long ioFlCrDat;
   unsigned long ioFlMdDat;
   unsigned long ioFlBkDat;
   FXInfo ioFlXFndrInfo;
   long ioFlParID;
   long ioFlClpSiz;
};
typedef struct HFileInfo HFileInfo;
Fields
qLink

A pointer to the next entry in the file I/O queue. (This field is used internally by the File Manager to keep track of asynchronous calls awaiting execution. 
qType

The queue type. This field is used internally by the File Manager.
ioTrap

The trap number of the function that was called. This field is used internally by the File Manager.
ioCmdAddr

The address of the function that was called. This field is used internally by the File Manager.
ioCompletion

A universal procedure pointer to a completion routine to be executed at the end of an asynchronous call. It should be 0 for asynchronous calls with no completion routine and is automatically set to 0 for all synchronous calls. See IOCompletionProcPtr for information about completion routines.
ioResult

The result code of the function. For synchronous calls, this field is the same as the result code of the function call itself. To determine when an asynchronous call has actually been completed, your application can poll this field it’s set to a positive number when the call is made and receives the actual result code when the call is completed.
ioNamePtr

A pointer to a pathname. Whenever a function description specifies that ioNamePtr is used—whether for input, output, or both—it’s very important that you set this field to point to storage for a Str255 value (if you’re using a pathname) or to NULL (if you’re not).
ioVRefNum

A volume reference number, 0 for the default volume, or a drive number.
ioFRefNum

The file reference number of an open file.
ioFVersNum

A file version number. This field is no longer used. File version numbers are an artifact of the obsolete MFS, and are not supported on HFS volumes. You should always set this field to 0.
filler1

Reserved.
ioFDirIndex

A file and directory index. If this field contains a positive number, PBGetCatInfoSync and PBGetCatInfoAsync return information about the file or directory having that directory index in the directory specified by the ioVRefNum field. (If ioVRefNum contains a volume reference number, the specified directory is that volume’s root directory.) 

If this field contains 0, PBGetCatInfoSync or PBGetCatInfoAsync returns information about the file or directory whose name is specified in the ioNamePtr field and that is located in the directory specified by the ioVRefNum field. (Once again, if ioVRefNum contains a volume reference number, the specified directory is that volume’s root directory.)

If this field contains a negative number, PBGetCatInfoSync or PBGetCatInfoAsync ignores the ioNamePtr field and returns information about the directory specified in the ioDirID field. If both ioDirID and ioVRefNum are set to 0, PBGetCatInfoSync or PBGetCatInfoAsync returns information about the current default directory.
ioFlAttrib

File or directory attributes. See File Attribute Constants for the meaning of the bits in this field.
ioACUser

The user’s access rights for the specified directory. See User Privileges Constants for the meaning of the bits in this field.
ioFlFndrInfo

Finder information. 
ioDirID

A directory ID or file ID. On input to PBGetCatInfoSync or PBGetCatInfoAsync , this field contains a directory ID (which is used only if the ioFDirIndex field is negative). On output, this field contains the file ID of the specified file.
ioFlStBlk

The first allocation block of the data fork. This field contains 0 if the file’s data fork is empty.
ioFlLgLen

The logical length (logical end-of-file) of the data fork.
ioFlPyLen

The physical length (physical end-of-file) of the data fork.
ioFlRStBlk

The first allocation block of the resource fork.
ioFlRLgLen

The logical length (logical end-of-file) of the resource fork.
ioFlRPyLen

The physical length (physical end-of-file) of the resource fork.
ioFlCrDat

The date and time of the file’s creation, in seconds since midnight, January 1, 1904. However, on Mac OS X, if you set the creation date to a date between January 1, 1904 and January 1, 1970, it will be clipped to January 1, 1970, and that is the value which will be returned if you later try to retrieve the creation date. 

Note that file systems other than AFP, HFS and HFS Plus do not generally support creation dates.
ioFlMdDat

The date and time of the last modification to the file, in seconds since midnight, January 1, 1904. However, on Mac OS X, if you set the modification date to a date between January 1, 1904 and January 1, 1970, it will be clipped to January 1, 1970.
ioFlBkDat

The date and time that the file was last backed up, in seconds since midnight, January 1, 1904. However, on Mac OS X, if you set the backup date to a date between January 1, 1904 and January 1, 1970, it will be clipped to January 1, 1970. 

Note that file systems other than AFP, HFS and HFS Plus do not generally support backup dates.
ioFlXFndrInfo

Additional Finder information. 
ioFlParID

The directory ID of the file’s parent directory.
ioFlClpSiz

The clump size to be used when writing the file if it’s 0, the volume’s clump size is used when the file is opened.
Availability
Available in Mac OS X v10.0 and later.*/
struct HFileInfo {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   short ioFRefNum;
   SInt8 ioFVersNum;
   SInt8 filler1;
   short ioFDirIndex;
   SInt8 ioFlAttrib;
   SInt8 ioACUser;
   FInfo ioFlFndrInfo;
   long ioDirID;
   unsigned short ioFlStBlk;
   long ioFlLgLen;
   long ioFlPyLen;
   unsigned short ioFlRStBlk;
   long ioFlRLgLen;
   long ioFlRPyLen;
   unsigned long ioFlCrDat;
   unsigned long ioFlMdDat;
   unsigned long ioFlBkDat;
   FXInfo ioFlXFndrInfo;
   long ioFlParID;
   long ioFlClpSiz;
};
typedef struct HFileInfo HFileInfo;

/*ForeignPrivParam

Defines a parameter block used by low-level HFS foreign privileges functions.

struct ForeignPrivParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   long ioFiller21;
   long ioFiller22;
   Ptr ioForeignPrivBuffer;
   long ioForeignPrivActCount;
   long ioForeignPrivReqCount;
   long ioFiller23;
   long ioForeignPrivDirID;
   long ioForeignPrivInfo1;
   long ioForeignPrivInfo2;
   long ioForeignPrivInfo3;
   long ioForeignPrivInfo4;
};
typedef struct ForeignPrivParam ForeignPrivParam;
typedef ForeignPrivParam * ForeignPrivParamPtr;
Fields
qLink

A pointer to the next entry in the file I/O queue. (This field is used internally by the File Manager to keep track of asynchronous calls awaiting execution. 
qType

The queue type. This field is used internally by the File Manager.
ioTrap

The trap number of the function that was called. This field is used internally by the File Manager.
ioCmdAddr

The address of the function that was called. This field is used internally by the File Manager.
ioCompletion

A universal procedure pointer to a completion routine to be executed at the end of an asynchronous call. It should be 0 for asynchrForeignPrivParam

Defines a parameter block used by low-level HFS foreign privileges functions.

struct ForeignPrivParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   long ioFiller21;
   long ioFiller22;
   Ptr ioForeignPrivBuffer;
   long ioForeignPrivActCount;
   long ioForeignPrivReqCount;
   long ioFiller23;
   long ioForeignPrivDirID;
   long ioForeignPrivInfo1;
   long ioForeignPrivInfo2;
   long ioForeignPrivInfo3;
   long ioForeignPrivInfo4;
};
typedef struct ForeignPrivParam ForeignPrivParam;
typedef ForeignPrivParam * ForeignPrivParamPtr;
Fields
qLink

A pointer to the next entry in the file I/O queue. (This field is used internally by the File Manager to keep track of asynchronous calls awaiting execution. 
qType

The queue type. This field is used internally by the File Manager.
ioTrap

The trap number of the function that was called. This field is used internally by the File Manager.
ioCmdAddr

The address of the function that was called. This field is used internally by the File Manager.
ioCompletion

A universal procedure pointer to a completion routine to be executed at the end of an asynchronous call. It should be 0 for asynchronous calls with no completion routine and is automatically set to 0 for all synchronous calls. See IOCompletionProcPtr for information about completion routines.
ioResult

The result code of the function. For synchronous calls, this field is the same as the result code of the function call itself. To determine when an asynchronous call has actually been completed, your application can poll this field it’s set to a positive number when the call is made and receives the actual result code when the call is completed.
ioNamePtr

A pointer to a pathname. Whenever a function description specifies that ioNamePtr is used—whether for input, output, or both—it’s very important that you set this field to point to storage for a Str255 value (if you’re using a pathname) or to NULL (if you’re not).
ioVRefNum

A volume reference number, 0 for the default volume, or a drive number.
ioFiller21

Reserved.
ioFiller22

Reserved.
ioForeignPrivBuffer

A pointer to a buffer containing access-control information about the foreign file system.
ioForeignPrivActCount

The size of the buffer pointed to by the ioForeignPrivBuffer field.
ioForeignPrivReqCount

The amount of the buffer pointed to by the ioForeignPrivBuffer field that was actually used to hold data.
ioFiller23

Reserved.
ioForeignPrivDirID

The parent directory ID of the foreign file or directory.
ioForeignPrivInfo1

A long word that may contain privileges data.
ioForeignPrivInfo2

A long word that may contain privileges data.
ioForeignPrivInfo3

A long word that may contain privileges data.
ioForeignPrivInfo4

A long word that may contain privileges data.
Availability
Available in Mac OS X v10.0 and later.onous calls with no completion routine and is automatically set to 0 for all synchronous calls. See IOCompletionProcPtr for information about completion routines.
ioResult

The result code of the function. For synchronous calls, this field is the same as the result code of the function call itself. To determine when an asynchronous call has actually been completed, your application can poll this field it’s set to a positive number when the call is made and receives the actual result code when the call is completed.
ioNamePtr

A pointer to a pathname. Whenever a function description specifies that ioNamePtr is used—whether for input, output, or both—it’s very important that you set this field to point to storage for a Str255 value (if you’re using a pathname) or to NULL (if you’re not).
ioVRefNum

A volume reference number, 0 for the default volume, or a drive number.
ioFiller21

Reserved.
ioFiller22

Reserved.
ioForeignPrivBuffer

A pointer to a buffer containing access-control information about the foreign file system.
ioForeignPrivActCount

The size of the buffer pointed to by the ioForeignPrivBuffer field.
ioForeignPrivReqCount

The amount of the buffer pointed to by the ioForeignPrivBuffer field that was actually used to hold data.
ioFiller23

Reserved.
ioForeignPrivDirID

The parent directory ID of the foreign file or directory.
ioForeignPrivInfo1

A long word that may contain privileges data.
ioForeignPrivInfo2

A long word that may contain privileges data.
ioForeignPrivInfo3

A long word that may contain privileges data.
ioForeignPrivInfo4

A long word that may contain privileges data.
Availability
Available in Mac OS X v10.0 and later.*/

struct ForeignPrivParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   long ioFiller21;
   long ioFiller22;
   Ptr ioForeignPrivBuffer;
   long ioForeignPrivActCount;
   long ioForeignPrivReqCount;
   long ioFiller23;
   long ioForeignPrivDirID;
   long ioForeignPrivInfo1;
   long ioForeignPrivInfo2;
   long ioForeignPrivInfo3;
   long ioForeignPrivInfo4;
};
typedef struct ForeignPrivParam ForeignPrivParam;
typedef ForeignPrivParam * ForeignPrivParamPtr;

/*CInfoPBRec

Defines a catalog information parameter block for file and directory information.

union CInfoPBRec {
   HFileInfo hFileInfo;
   DirInfo dirInfo;
};
typedef union CInfoPBRec CInfoPBRec;
typedef CInfoPBRec * CInfoPBPtr;
Fields
hFileInfo
dirInfo
Availability
Available in Mac OS X v10.0 and later.*/
union CInfoPBRec {
   HFileInfo hFileInfo;
   DirInfo dirInfo;
};
typedef union CInfoPBRec CInfoPBRec;
typedef CInfoPBRec * CInfoPBPtr;


/*CSParam

Defines a parameter block used by low-level HFS catalog search functions.

struct CSParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   FSSpecPtr ioMatchPtr;
   long ioReqMatchCount;
   long ioActMatchCount;
   long ioSearchBits;
   CInfoPBPtr ioSearchInfo1;
   CInfoPBPtr ioSearchInfo2;
   long ioSearchTime;
   CatPositionRec ioCatPosition;
   Ptr ioOptBuffer;
   long ioOptBufSize;
};
typedef struct CSParam CSParam;
typedef CSParam * CSParamPtr;
Fields
qLink

A pointer to the next entry in the file I/O queue. (This field is used internally by the File Manager to keep track of asynchronous calls awaiting execution. 
qType

The queue type. This field is used internally by the File Manager.
ioTrap

The trap number of the function that was called. This field is used internally by the File Manager.
ioCmdAddr

The address of the function that was called. This field is used internally by the File Manager.
ioCompletion

A universal procedure pointer to a completion routine to be executed at the end of an asynchronous call. It should be 0 for asynchronous calls with no completion routine and is automatically set to 0 for all synchronous calls. See IOCompletionProcPtr for information about completion routines.
ioResult

The result code of the function. For synchronous calls, this field is the same as the result code of the function call itself. To determine when an asynchronous call has actually been completed, your application can poll this field it’s set to a positive number when the call is made and receives the actual result code when the call is completed.
ioNamePtr

A pointer to a pathname. Whenever a function description specifies that ioNamePtr is used—whether for input, output, or both—it’s very important that you set this field to point to storage for a Str255 value (if you’re using a pathname) or to NULL (if you’re not).
ioVRefNum

A volume reference number, 0 for the default volume, or a drive number.
ioMatchPtr

A pointer to an array of FSSpec structures in which the file and directory names that match the selection criteria are returned. The array must be large enough to hold the largest possible number of FSSpec structures, as determined by the ioReqMatchCount field.
ioReqMatchCount

The maximum number of matches to return. This number should be the number of FSSpec structures that will fit in the memory pointed to by the ioMatchPtr field. You can use this field to avoid a possible excess of matches for criteria that prove to be too general (or to limit the length of a search if the ioSearchTime field isn’t used).
ioActMatchCount

The number of actual matches found.
ioSearchBits

The fields of the parameter blocks in the ioSearchInfo1 and ioSearchInfo2 fields that are relevant to the search. See Catalog Search Bits for more information.
ioSearchInfo1

A pointer to a CInfoPBRec parameter block that contains the search information. For values that match by mask and value (Finder information, for example), set the bits in the structure passed in the ioSearchInfo2 field, and set the matching values in this structure. For values that match against a range (such as dates), set the lower bounds for the range in this struture.
ioSearchInfo2

A pointer to a second CSParam

Defines a parameter block used by low-level HFS catalog search functions.

struct CSParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   FSSpecPtr ioMatchPtr;
   long ioReqMatchCount;
   long ioActMatchCount;
   long ioSearchBits;
   CInfoPBPtr ioSearchInfo1;
   CInfoPBPtr ioSearchInfo2;
   long ioSearchTime;
   CatPositionRec ioCatPosition;
   Ptr ioOptBuffer;
   long ioOptBufSize;
};
typedef struct CSParam CSParam;
typedef CSParam * CSParamPtr;
Fields
qLink

A pointer to the next entry in the file I/O queue. (This field is used internally by the File Manager to keep track of asynchronous calls awaiting execution. 
qType

The queue type. This field is used internally by the File Manager.
ioTrap

The trap number of the function that was called. This field is used internally by the File Manager.
ioCmdAddr

The address of the function that was called. This field is used internally by the File Manager.
ioCompletion

A universal procedure pointer to a completion routine to be executed at the end of an asynchronous call. It should be 0 for asynchronous calls with no completion routine and is automatically set to 0 for all synchronous calls. See IOCompletionProcPtr for information about completion routines.
ioResult

The result code of the function. For synchronous calls, this field is the same as the result code of the function call itself. To determine when an asynchronous call has actually been completed, your application can poll this field it’s set to a positive number when the call is made and receives the actual result code when the call is completed.
ioNamePtr

A pointer to a pathname. Whenever a function description specifies that ioNamePtr is used—whether for input, output, or both—it’s very important that you set this field to point to storage for a Str255 value (if you’re using a pathname) or to NULL (if you’re not).
ioVRefNum

A volume reference number, 0 for the default volume, or a drive number.
ioMatchPtr

A pointer to an array of FSSpec structures in which the file and directory names that match the selection criteria are returned. The array must be large enough to hold the largest possible number of FSSpec structures, as determined by the ioReqMatchCount field.
ioReqMatchCount

The maximum number of matches to return. This number should be the number of FSSpec structures that will fit in the memory pointed to by the ioMatchPtr field. You can use this field to avoid a possible excess of matches for criteria that prove to be too general (or to limit the length of a search if the ioSearchTime field isn’t used).
ioActMatchCount

The number of actual matches found.
ioSearchBits

The fields of the parameter blocks in the ioSearchInfo1 and ioSearchInfo2 fields that are relevant to the search. See Catalog Search Bits for more information.
ioSearchInfo1

A pointer to a CInfoPBRec parameter block that contains the search information. For values that match by mask and value (Finder information, for example), set the bits in the structure passed in the ioSearchInfo2 field, and set the matching values in this structure. For values that match against a range (such as dates), set the lower bounds for the range in this struture.
ioSearchInfo2

A pointer to a second CInfoPBRec parameter block that contains the search information. For values that match by mask and value (Finder information, for example), set the bits in this structure, and set the matching values in the structure passed in the ioSearchInfo1 field. For values that match against a range (such as dates), set the upper bounds for the range in this struture.
ioSearchTime

A time limit on a search, in Time Manager format. Use this field to limit the run time of a single call to PBCatSearchSync or PBCatSearchAsync. A value of 0 imposes no time limit. If the value of this field is positive, it is interpreted as milliseconds. If the value of this field is negative, it is interpreted as negated microseconds.
ioCatPosition

A position in the catalog where searching should begin. Use this field to keep an index into the catalog when breaking down the PBCatSearchSync or PBCatSearchAsync search into a number of smaller searches. This field is valid whenever PBCatSearchSync or PBCatSearchAsync exits because it either spends the maximum time allowed by ioSearchTime or finds the maximum number of matches allowed by ioReqMatchCount.

To start at the beginning of the catalog, set the initialize field of ioCatPosition to 0. Before exiting after an interrupted search, PBCatSearchSync or PBCatSearchAsync sets that field to the next catalog entry to be searched.

To resume where the previous call stopped, pass the entire CatPositionRec structure returned by the previous call as input to the next.
ioOptBuffer

A pointer to an optional read buffer. The ioOptBuffer and ioOptBufSize fields let you specify a part of memory as a read buffer, increasing search speed.
ioOptBufSize

The size of the buffer pointed to by ioOptBuffer. Buffer size effectiveness varies with models and configurations, but a 16 KB buffer is likely to be optimal. The size should be at least 1024 bytes and should be an integral multiple of 512 bytes.
Availability
Available in Mac OS X v10.0 and later.CInfoPBRec parameter block that contains the search information. For values that match by mask and value (Finder information, for example), set the bits in this structure, and set the matching values in the structure passed in the ioSearchInfo1 field. For values that match against a range (such as dates), set the upper bounds for the range in this struture.
ioSearchTime

A time limit on a search, in Time Manager format. Use this field to limit the run time of a single call to PBCatSearchSync or PBCatSearchAsync. A value of 0 imposes no time limit. If the value of this field is positive, it is interpreted as milliseconds. If the value of this field is negative, it is interpreted as negated microseconds.
ioCatPosition

A position in the catalog where searching should begin. Use this field to keep an index into the catalog when breaking down the PBCatSearchSync or PBCatSearchAsync search into a number of smaller searches. This field is valid whenever PBCatSearchSync or PBCatSearchAsync exits because it either spends the maximum time allowed by ioSearchTime or finds the maximum number of matches allowed by ioReqMatchCount.

To start at the beginning of the catalog, set the initialize field of ioCatPosition to 0. Before exiting after an interrupted search, PBCatSearchSync or PBCatSearchAsync sets that field to the next catalog entry to be searched.

To resume where the previous call stopped, pass the entire CatPositionRec structure returned by the previous call as input to the next.
ioOptBuffer

A pointer to an optional read buffer. The ioOptBuffer and ioOptBufSize fields let you specify a part of memory as a read buffer, increasing search speed.
ioOptBufSize

The size of the buffer pointed to by ioOptBuffer. Buffer size effectiveness varies with models and configurations, but a 16 KB buffer is likely to be optimal. The size should be at least 1024 bytes and should be an integral multiple of 512 bytes.
Availability
Available in Mac OS X v10.0 and later.*/

struct CSParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   FSSpecPtr ioMatchPtr;
   long ioReqMatchCount;
   long ioActMatchCount;
   long ioSearchBits;
   CInfoPBPtr ioSearchInfo1;
   CInfoPBPtr ioSearchInfo2;
   long ioSearchTime;
   CatPositionRec ioCatPosition;
   Ptr ioOptBuffer;
   long ioOptBufSize;
};
typedef struct CSParam CSParam;
typedef CSParam * CSParamPtr;

/*WDParam

Defines a parameter block used by low-level HFS working directory functions.

struct WDParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   short ioWDCreated;
   short ioWDIndex;
   long ioWDProcID;
   short ioWDVRefNum;
   short filler10;
   long filler11;
   long filler12;
   long filler13;
   long ioWDDirID;
};
typedef struct WDParam WDParam;
typedef WDParam * WDParamPtr;
Fields
qLink

A pointer to the next entry in the file I/O queue. (This field is used internally by the File Manager to keep track of asynchronous calls awaiting execution. 
qType

The queue type. This field is used internally by the File Manager.
ioTrap

The trap number of the function that was called. This field is used internally by the File Manager.
ioCmdAddr

The address of the function that was called. This field is used internally by the File Manager.
ioCompletion

A universal procedure pointer to a completion routine to be executed at the end of an asynchronous call. It should be 0 for asynchronous calls with no completion routine and is automatically set to 0 for all synchronous calls. See IOCompletionProcPtr for information about completion routines.
ioResult

The result code of the function. For synchronous calls, this field is the same as the result code of the function call itself. To determine when an asynchronous call has actually been completed, your application can poll this field it’s set to a positive number when the call is made and receives the actual result code when the call is completed.
ioNamePtr

A pointer to a pathname. Whenever a function description specifies that ioNamePtr is used—whether for input, output, or both—it’s very important that you set this field to point to storage for a Str255 value (if you’re using a pathname) or to NULL (if you’re not).
ioVRefNum

A volume reference number, 0 for the default volume, or a drive number.
filler9

An index to working directories.
ioWDIndex

The working directory user identifier.
ioWDProcID

The volume reference number for the working directory.
ioWDVRefNum

Reserved.
filler10

Reserved.
filler11

Reserved.
filler12

Reserved.
filler13

The working directory’s directory ID.
ioWDDirID

The working directory’s directory ID.
Availability
Available in Mac OS X v10.0 and later.*/
struct WDParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   short ioWDCreated;
   short ioWDIndex;
   long ioWDProcID;
   short ioWDVRefNum;
   short filler10;
   long filler11;
   long filler12;
   long filler13;
   long ioWDDirID;
};
typedef struct WDParam WDParam;
typedef WDParam * WDParamPtr;


/*HIOParam

Defines a parameter block used by low-level HFS I/O functions.

struct HIOParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   short ioRefNum;
   SInt8 ioVersNum;
   SInt8 ioPermssn;
   Ptr ioMisc;
   Ptr ioBuffer;
   long ioReqCount;
   long ioActCount;
   short ioPosMode;
   long ioPosOffset;
};
typedef struct HIOParam HIOParam;
typedef HIOParam * HIOParamPtr;
Fields
qLink

A pointer to the next entry in the file I/O queue. (This field is used internally by the File Manager to keep track of asynchronous calls awaiting execution. 
qType

The queue type. This field is used internally by the File Manager.
ioTrap

The trap number of the function that was called. This field is used internally by the File Manager.
ioCmdAddr

The address of the function that was called. This field is used internally by the File Manager.
ioCompletion

A universal procedure pointer to a completion routine to be executed at the end of an asynchronous call. It should be 0 for asynchronous calls with no completion routine and is automatically set to 0 for all synchronous calls. See IOCompletionProcPtr for information about completion routines.
ioResult

The result code of the function. For synchronous calls, this field is the same as the result code of the function call itself. To determine when an asynchronous call has actually been completed, your application can poll this field it’s set to a positive number when the call is made and receives the actual result code when the call is completed.
ioNamePtr

A pointer to a pathname. Whenever a function description specifies that ioNamePtr is used—whether for input, output, or both—it’s very important that you set this field to point to storage for a Str255 value (if you’re using a pathname) or to NULL (if you’re not).
ioVRefNum

A volume reference number, 0 for the default volume, or a drive number.
ioRefNum

The file reference number of an open file.
ioVersNum

A version number. This field is no longer used and you should always set it to 0.
ioPermssn

The access mode. See File Access Permission Constants.
ioMisc

Depending on the function called, this field contains either a logical end-of-file, a new version number, a pointer to an access path buffer, or a pointer to a new pathname. Because ioMisc is of type Ptr, you’ll need to perform type coercion to interpret the value of ioMisc correctly when it contains an end-of-file (a LongInt value) or version number (a SignedByte value).
ioBuffer

A pointer to a data buffer into which data is written by PBReadSync and PBReadAsync calls, and from which data is read by PBWriteSync and PBWriteAsync calls.
ioReqCount

The requested number of bytes to be read, written, or allocated.
ioActCount

The number of bytes actually read, written, or allocated.
ioPosMode

The positioning mode (base location) for setting the mark. Bits 0 and 1 of this field indicate how to position the mark; you can use the constants described in Position Mode Constants to set or test their value.

You can also use the constants described in Cache Constants to indicate whether or not to cache the data.
ioPosOffset

The offset to be used in conjunction with the base location specified in the ioPosMode field.
Availability
Available in Mac OS X v10.0 and later.*/
struct HIOParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   short ioRefNum;
   SInt8 ioVersNum;
   SInt8 ioPermssn;
   Ptr ioMisc;
   Ptr ioBuffer;
   long ioReqCount;
   long ioActCount;
   short ioPosMode;
   long ioPosOffset;
};
typedef struct HIOParam HIOParam;
typedef HIOParam * HIOParamPtr;

/*CopyParam

Defines a parameter block used by low-level HFS file copying functions.

struct CopyParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   short ioDstVRefNum;
   short filler8;
   StringPtr ioNewName;
   StringPtr ioCopyName;
   long ioNewDirID;
   long filler14;
   long filler15;
   long ioDirID;
};
typedef struct CopyParam CopyParam;
typedef CopyParam * CopyParamPtr;
Fields
qLink

A pointer to the next entry in the file I/O queue. (This field is used internally by the File Manager to keep track of asynchronous calls awaiting execution. 
qType

The queue type. This field is used internally by the File Manager.
ioTrap

The trap number of the function that was called. This field is used internally by the File Manager.
ioCmdAddr

The address of the function that was called. This field is used internally by the File Manager.
ioCompletion

A universal procedure pointer to a completion routine to be executed at the end of an asynchronous call. It should be 0 for asynchronous calls with no completion routine and is automatically set to 0 for all synchronous calls. See IOCompletionProcPtr for information about completion routines.
ioResult

The result code of the function. For synchronous calls, this field is the same as the result code of the function call itself. To determine when an asynchronous call has actually been completed, your application can poll this field it’s set to a positive number when the call is made and receives the actual result code when the call is completed.
ioNamePtr

A pointer to a pathname. Whenever a function description specifies that ioNamePtr is used—whether for input, output, or both—it’s very important that you set this field to point to storage for a Str255 value (if you’re using a pathname) or to NULL (if you’re not).
ioVRefNum

A volume reference number, 0 for the default volume, or a drive number.
ioDstVRefNum

A volume reference number for the destination volume.
filler8

Reserved.
ioNewName

A pointer to the destination pathname.
ioCopyName

A pointer to an optional name.
ioNewDirID

A destination directory ID.
filler14

Reserved.
filler15

Reserved.
ioDirID

A directory ID.
Availability
Available in Mac OS X v10.0 and later.*/
struct CopyParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   short ioDstVRefNum;
   short filler8;
   StringPtr ioNewName;
   StringPtr ioCopyName;
   long ioNewDirID;
   long filler14;
   long filler15;
   long ioDirID;
};
typedef struct CopyParam CopyParam;
typedef CopyParam * CopyParamPtr;


/*HParamBlockRec

Describes the HFS parameter block.

union HParamBlockRec {
   HIOParam ioParam;
   HFileParam fileParam;
   HVolumeParam volumeParam;
   AccessParam accessParam;
   ObjParam objParam;
   CopyParam copyParam;
   WDParam wdParam;
   FIDParam fidParam;
   CSParam csParam;
   ForeignPrivParam foreignPrivParam;
};
typedef union HParamBlockRec HParamBlockRec;
typedef HParamBlockRec * HParmBlkPtr;
Fields
ioParam

A parameter block used by low-level HFS I/O functions. See HIOParam. 
fileParam

A parameter block used by low-level HFS functions for file creation, deletion, and information retrieval. See HFileParam. 
volumeParam

A parameter block used by low-level HFS volume manipulation functions. See HVolumeParam. 
accessParam

A parameter block used by low-level HFS file and directory access rights manipulation functions. See AccessParam. 
objParam

A parameter block used by low-level HFS user and group information functions. See ObjParam. 
copyParam

A parameter block used by low-level HFS file copying functions. See CopyParam. 
wdParam

A parameter block used by low-level HFS working directory functions. See WDParam. 
fidParam

A parameter block used by low-level HFS file ID functions. See FIDParam. 
csParam

A parameter block used by low-level HFS catalog search functions. See CSParam. 
foreignPrivParam

A parameter block used by low-level HFS foreign privileges functions. See ForeignPrivParam. 
Availability
Available in Mac OS X v10.0 and later.*/
union HParamBlockRec {
   HIOParam ioParam;
   HFileParam fileParam;
   HVolumeParam volumeParam;
   AccessParam accessParam;
   ObjParam objParam;
   CopyParam copyParam;
   WDParam wdParam;
   FIDParam fidParam;
   CSParam csParam;
   ForeignPrivParam foreignPrivParam;
};
typedef union HParamBlockRec HParamBlockRec;
typedef HParamBlockRec * HParmBlkPtr;

/*GetVolParmsInfoBuffer

Defines a volume attributes buffer, used by the PBHGetVolParmsSync and PBHGetVolParmAsync functions to return volume information.

struct GetVolParmsInfoBuffer {
   short vMVersion;
   long vMAttrib;
   Handle vMLocalHand;
   long vMServerAdr;
   long vMVolumeGrade;
   short vMForeignPrivID;
   long vMExtendedAttributes;
   void * vMDeviceID;
   UniCharCount vMMaxNameLength;
};
typedef struct GetVolParmsInfoBuffer GetVolParmsInfoBuffer;
Fields
vMVersion

The version number of the attributes buffer structure. Currently this field returns 1, 2, 3 or 4. Version 3 is introduced to support the HFS Plus APIs.
vMAttrib

A 32-bit quantity that encodes information about the volume attributes. See Volume Attribute Constants for the meaning of the bits in this field.
vMLocalHand

A handle to private data for shared volumes. On creation of the VCB (right after mounting), this field is a handle to a 2-byte block of memory. The Finder uses this for its local window list storage, allocating and deallocating memory as needed. It is disposed of when the volume is unmounted. Your application should treat this field as reserved.
vMServerAdr

For AppleTalk server volumes, this field contains the internet address of an AppleTalk server volume. Your application can inspect thiGetVolParmsInfoBuffer

Defines a volume attributes buffer, used by the PBHGetVolParmsSync and PBHGetVolParmAsync functions to return volume information.

struct GetVolParmsInfoBuffer {
   short vMVersion;
   long vMAttrib;
   Handle vMLocalHand;
   long vMServerAdr;
   long vMVolumeGrade;
   short vMForeignPrivID;
   long vMExtendedAttributes;
   void * vMDeviceID;
   UniCharCount vMMaxNameLength;
};
typedef struct GetVolParmsInfoBuffer GetVolParmsInfoBuffer;
Fields
vMVersion

The version number of the attributes buffer structure. Currently this field returns 1, 2, 3 or 4. Version 3 is introduced to support the HFS Plus APIs.
vMAttrib

A 32-bit quantity that encodes information about the volume attributes. See Volume Attribute Constants for the meaning of the bits in this field.
vMLocalHand

A handle to private data for shared volumes. On creation of the VCB (right after mounting), this field is a handle to a 2-byte block of memory. The Finder uses this for its local window list storage, allocating and deallocating memory as needed. It is disposed of when the volume is unmounted. Your application should treat this field as reserved.
vMServerAdr

For AppleTalk server volumes, this field contains the internet address of an AppleTalk server volume. Your application can inspect this field to tell which volumes belong to which server; the value of this field is 0 if the volume does not have a server.
vMVolumeGrade

The relative speed rating of the volume. The scale used to determine these values is currently uncalibrated. In general, lower values indicate faster speeds. A value of 0 indicates that the volume’s speed is unrated. The buffer version returned in the vMVersion field must be greater than 1 for this field to be meaningful.
vMForeignPrivID

An integer representing the privilege model supported by the volume. Currently two values are defined for this field: 0 represents a standard HFS or HFS Plus volume that might or might not support the AFP privilege model; fsUnixPriv represents a volume that supports the A/UX privilege model. The buffer version returned in the vMVersion field must be greater than 1 for this field to be meaningful.
vMExtendedAttributes

Contains bits that describe a volume’s extended attributes. For this field to be meaningful, the vMVersion must be greater than 2. See Extended Volume Attributes for the meaning of the bits in this field.
vMDeviceID

A device name identifying the device in /dev that corresponds to the volume. You can use this string to build a POSIX path to the device for use with IOKit APIs.
vMMaxNameLength
Discussion

Volumes that implement the HFS Plus APIs must use version 3 (or newer) of the GetVolParmsInfoBuffer. Volumes that don’t implement the HFS Plus APIs may still implement version 3 of the GetVolParmsInfoBuffer. If the version of the GetVolParmsInfoBuffer is 2 or less, or the bSupportsHFSPlusAPIs bit is clear (zero), then the volume does not implement the HFS Plus APIs, and they are being emulated for that volume by the File Manager itself.

If a volume does not implement the HFS Plus APIs, and supports version 2 or earlier of the GetVolParmsInfoBuffer, it cannot itself describe whether it supports the FSCatalogSearch or FSExchangeObjects calls. The compatibility layer will implement the FSCatalogSearch call if the volume supports the PBCatSearch call (i.e. the bHasCatSearch bit of vMAttrib is set). The compatibility layer will implement the FSExchangeObjects call if the volume supports PBExchangeFiles (i.e. the bHasFileIDs bit of vMAttrib is set). 
Availability
Available in Mac OS X v10.0 and later.s field to tell which volumes belong to which server; the value of this field is 0 if the volume does not have a server.
vMVolumeGrade

The relative speed rating of the volume. The scale used to determine these values is currently uncalibrated. In general, lower values indicate faster speeds. A value of 0 indicates that the volume’s speed is unrated. The buffer version returned in the vMVersion field must be greater than 1 for this field to be meaningful.
vMForeignPrivID

An integer representing the privilege model supported by the volume. Currently two values are defined for this field: 0 represents a standard HFS or HFS Plus volume that might or might not support the AFP privilege model; fsUnixPriv represents a volume that supports the A/UX privilege model. The buffer version returned in the vMVersion field must be greater than 1 for this field to be meaningful.
vMExtendedAttributes

Contains bits that describe a volume’s extended attributes. For this field to be meaningful, the vMVersion must be greater than 2. See Extended Volume Attributes for the meaning of the bits in this field.
vMDeviceID

A device name identifying the device in /dev that corresponds to the volume. You can use this string to build a POSIX path to the device for use with IOKit APIs.
vMMaxNameLength
Discussion

Volumes that implement the HFS Plus APIs must use version 3 (or newer) of the GetVolParmsInfoBuffer. Volumes that don’t implement the HFS Plus APIs may still implement version 3 of the GetVolParmsInfoBuffer. If the version of the GetVolParmsInfoBuffer is 2 or less, or the bSupportsHFSPlusAPIs bit is clear (zero), then the volume does not implement the HFS Plus APIs, and they are being emulated for that volume by the File Manager itself.

If a volume does not implement the HFS Plus APIs, and supports version 2 or earlier of the GetVolParmsInfoBuffer, it cannot itself describe whether it supports the FSCatalogSearch or FSExchangeObjects calls. The compatibility layer will implement the FSCatalogSearch call if the volume supports the PBCatSearch call (i.e. the bHasCatSearch bit of vMAttrib is set). The compatibility layer will implement the FSExchangeObjects call if the volume supports PBExchangeFiles (i.e. the bHasFileIDs bit of vMAttrib is set). 
Availability
Available in Mac OS X v10.0 and later.*/
struct GetVolParmsInfoBuffer {
   short vMVersion;
   long vMAttrib;
   Handle vMLocalHand;
   long vMServerAdr;
   long vMVolumeGrade;
   short vMForeignPrivID;
   long vMExtendedAttributes;
   void * vMDeviceID;
   UniCharCount vMMaxNameLength;
};
typedef struct GetVolParmsInfoBuffer GetVolParmsInfoBuffer;

/*Volume Information Bitmap Constants

Indicate what volume information to set or retrieve.

enum {
   kFSVolInfoNone = 0x0000,
   kFSVolInfoCreateDate = 0x0001,
   kFSVolInfoModDate = 0x0002,
   kFSVolInfoBackupDate = 0x0004,
   kFSVolInfoCheckedDate = 0x0008,
   kFSVolInfoFileCount = 0x0010,
   kFSVolInfoDirCount = 0x0020,
   kFSVolInfoSizes = 0x0040,
   kFSVolInfoBlocks = 0x0080,
   kFSVolInfoNextAlloc = 0x0100,
   kFSVolInfoRsrcClump = 0x0200,
   kFSVolInfoDataClump = 0x0400,
   kFSVolInfoNextID = 0x0800,
   kFSVolInfoFinderInfo = 0x1000,
   kFSVolInfoFlags = 0x2000,
   kFSVolInfoFSInfo = 0x4000,
   kFSVolInfoDriveInfo = 0x8000,
   kFSVolInfoGettableInfo = 0xFFFF,
   kFSVolInfoSettableInfo = 0x3004
};
Constants
kFSVolInfoNone

No volume information.

Available in Mac OS X v10.0 and later.
kFSVolInfoCreateDate

Retrieve the creation date of the volume.

Available in Mac OS X v10.0 and later.
kFSVolInfoModDate

Retrieve the date of the volume’s last modification.

Available in Mac OS X v10.0 and later.
kFSVolInfoBackupDate

Retrieve or set the date of the volume’s last backup.

Available in Mac OS X v10.0 and later.
kFSVolInfoCheckedDate

Retrieve the date that the volume was last checked for consistency.

Available in Mac OS X v10.0 and later.
kFSVolInfoFileCount

Retrieve the number of files on the volume.

Available in Mac OS X v10.0 and later.
kFSVolInfoDirCount

Retrieve the number of directories on the volume.

Available in Mac OS X v10.0 and later.
kFSVolInfoSizes

Retrieve the total number of bytes on the volume and the number of unused bytes on the volume (in the totalBytes and freeBytes fields).

Available in Mac OS X v10.0 and later.
kFSVolInfoBlocks

Retrieve the block information: the block size, the number of total blocks on the volume, and the number of free blocks on the volume. 

Available in Mac OS X v10.0 and later.
kFSVolInfoNextAlloc

Retrieve the address at which to start the next allocation.

Available in Mac OS X v10.0 and later.
kFSVolInfoRsrcClump

Retrieve the resource fork clump size.

Available in Mac OS X v10.0 and later.
kFSVolInfoDataClump

Retrieve the data fork clump size.

Available in Mac OS X v10.0 and later.
kFSVolInfoNextID

Retrieve the next available catalog node ID.

Available in Mac OS X v10.0 and later.
kFSVolInfoFinderInfo

Retrieve or set the volume’s Finder information.

Available in Mac OS X v10.0 and later.
kFSVolInfoFlags

Retrieve or set the volume’s flags. See Volume Information Flags for more information on the volume’s flags.

Available in Mac OS X v10.0 and later.
kFSVolInfoFSInfo

Retrieve the filesystem ID and signature.

Available in Mac OS X v10.0 and later.
kFSVolInfoDriveInfo

Retrieve the drive information: the drive number and driver reference number.

Available in Mac OS X v10.0 and later.
kFSVolInfoGettableInfo

Retrieve all of the gettable information.

Available in Mac OS X v10.0 and later.
kFSVolInfoSettableInfo

Set all of the settable information. Currently, this is the backup date, Finder information, and flags.

Available in Mac OS X v10.0 and later.
Discussion

These constants are used with the FSVolumeInfoBitmap data type to indicate what volume information to set or retrieve with the functions FSSetVolumeInfo and FSGetVolumeInfo , and their corresponding parameter block calls*/
enum {
   kFSVolInfoNone = 0x0000,
   kFSVolInfoCreateDate = 0x0001,
   kFSVolInfoModDate = 0x0002,
   kFSVolInfoBackupDate = 0x0004,
   kFSVolInfoCheckedDate = 0x0008,
   kFSVolInfoFileCount = 0x0010,
   kFSVolInfoDirCount = 0x0020,
   kFSVolInfoSizes = 0x0040,
   kFSVolInfoBlocks = 0x0080,
   kFSVolInfoNextAlloc = 0x0100,
   kFSVolInfoRsrcClump = 0x0200,
   kFSVolInfoDataClump = 0x0400,
   kFSVolInfoNextID = 0x0800,
   kFSVolInfoFinderInfo = 0x1000,
   kFSVolInfoFlags = 0x2000,
   kFSVolInfoFSInfo = 0x4000,
   kFSVolInfoDriveInfo = 0x8000,
   kFSVolInfoGettableInfo = 0xFFFF,
   kFSVolInfoSettableInfo = 0x3004
};


/*FSVolumeInfoBitmap

Describes which fields of the FSVolumeInfo structure you wish to retrieve or set.

typedef UInt32 FSVolumeInfoBitmap;
Discussion

If the bit corresponding to a particular field is not set in the bitmap, then that field is not changed in the FSVolumeInfo structure if it is an output parameter, and that field is ignored if the FSVolumeInfo structure is an input parameter. See Volume Information Bitmap Constants for a description of the constants you should use with this data type. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef UInt32 FSVolumeInfoBitmap;

/*FSVolumeInfo

Used when getting or setting information about a volume.

struct FSVolumeInfo {
   UTCDateTime createDate;
   UTCDateTime modifyDate;
   UTCDateTime backupDate;
   UTCDateTime checkedDate;
   UInt32 fileCount;
   UInt32 folderCount;
   UInt64 totalBytes;
   UInt64 freeBytes;
   UInt32 blockSize;
   UInt32 totalBlocks;
   UInt32 freeBlocks;
   UInt32 nextAllocation;
   UInt32 rsrcClumpSize;
   UInt32 dataClumpSize;
   UInt32 nextCatalogID;
   UInt8 finderInfo[32];
   UInt16 flags;
   UInt16 filesystemID;
   UInt16 signature;
   UInt16 driveNumber;
   short driverRefNum;
};
typedef struct FSVolumeInfo FSVolumeInfo;
typedef FSVolumeInfo * FSVolumeInfoPtr;
Fields
createDate

The date and time the volume was created. A value of 0 means that the volume creation date is unknown. 
modifyDate

The last time when the volume was modified in any way. A value of 0 means “never” or “unknown.
backupDate

Indicates when the volume was last backed up. This field is for use by backup utilities. A value of 0 means “never” or “unknown.
checkedDate

The last date and time that the volume was checked for consistency. A value of 0 means “never” or “unknown.
fileCount

The total number of files on the volume, or 0 if unknown.
folderCount

The total number of folders on the volume, or 0 if unknown. Note that no root directory counts.
totalBytes

The size of the volume in bytes.
freeBytes

The number of bytes of free space on the volume.
blockSize

The size of an allocation block, in bytes. This field is only appropriate for volume formats (such as HFS and HFS Plus) that allocate space in fixed-size pieces; other volume formats may not have a similar concept, and may set this field to zero.
totalBlocks

The total number of allocation blocks on the volume. This field is only appropriate for volume formats (such as HFS and HFS Plus) that allocate space in fixed-size pieces; other volume formats may not have a similar concept, and may set this field to zero.
freeBlocks

The number of unused allocation blocks on the volume. This field is only appropriate for volume formats (such as HFS and HFS Plus) that allocate space in fixed-size pieces; other volume formats may not have a similar concept, and may set this field to zero.
nextAllocation

A hint for where to start searching for free space during an allocation. This field is only appropriate for volume formats (such as HFS and HFS Plus) that allocate space in fixed-size pieces; other volume formats may not have a similar concept, and may set this field to zero.
rsrcClumpSize

Default resource fork clump size. When a fork is automatically grown as it is written, the File Manager attempts to allocate space that is a multiple of the clump size. This field is zero for volume formats that don’t support the notion of a clump size.
dataClumpSize

Default data fork clump size. When a fork is automatically grown as it is written, the File Manager attempts to allocate space that is a multiple of the clump size. This field is zero for volume formats that don’t support the notion of a clump size.
nextCatalogID

The next unused catalog node ID. Some volume formats (such as HFS and HFS Plus) use a monotonically increasing number for the catalog node ID (i.e. File ID or Directory ID) of newly created files and directories. For those volume formats, the nextCatalogID is the next file/directory ID that will be assigned. For other volume formats, this field will be zero.
finderInfo

Information used by Finder, such as the Directory ID of the System Folder. Some volume formats do not support Finder information for a volume and will set this field to all zeroes.
flags

This field contains bit flags holding informaiton about the volume. See Volume Information Flags for the attribute constants you can use here.
filesystemID

Identifies the filesystem implementation that is handling the volume; this is zero for HFS and HFS Plus volumes.
signature

This field is used to distinguish between volume formats supported by a single filesystem implementation.
driveNumber

The drive number for the drive (drive queue element) associated with the volume. Mac OS X does not support drive numbers; in Mac OS X, the File Manager always returns a value of 1 in this field.
driverRefNum

The driver reference number for the drive (drive queue element) associated with the volume.
Discussion

This structure contains information about a volume as a whole information about a volume’s root directory would use the FSCatalogInfo structure. 
Availability
Available in Mac OS X v10.0 and later.*/
struct FSVolumeInfo {
   UTCDateTime createDate;
   UTCDateTime modifyDate;
   UTCDateTime backupDate;
   UTCDateTime checkedDate;
   UInt32 fileCount;
   UInt32 folderCount;
   UInt64 totalBytes;
   UInt64 freeBytes;
   UInt32 blockSize;
   UInt32 totalBlocks;
   UInt32 freeBlocks;
   UInt32 nextAllocation;
   UInt32 rsrcClumpSize;
   UInt32 dataClumpSize;
   UInt32 nextCatalogID;
   UInt8 finderInfo[32];
   UInt16 flags;
   UInt16 filesystemID;
   UInt16 signature;
   UInt16 driveNumber;
   short driverRefNum;
};
typedef struct FSVolumeInfo FSVolumeInfo;

/*File Access Permission Constants

Specify the type of read and write access to a file or fork.

enum {
   fsCurPerm = 0x00,
   fsRdPerm = 0x01,
   fsWrPerm = 0x02,
   fsRdWrPerm = 0x03,
   fsRdWrShPerm = 0x04,
   fsRdDenyPerm = 0x10,
   fsWrDenyPerm = 0x20
};
Constants
fsCurPerm

Requests whatever permissions are currently allowed. If write access in unavailable (because the file is locked or the file is already open with write permission), then read permission is granted. Otherwise read/write permission is granted.

Available in Mac OS X v10.0 and later.
fsRdPerm

Requests permission to read the file.

Available in Mac OS X v10.0 and later.
fsWrPerm

Requests permission to write to the file. If write permission is granted, no other access paths are granted write permission. Note, however, that the File Manager does not support write-only access to a file. Thus, fsWrPerm is synonymous with fsRdWrPerm.

Available in Mac OS X v10.0 and later.
fsRdWrPerm

Requests exclusive read and write permission. If exclusive read/ write permission is granted, no other users are granted permission to write to the file. Other users may, however, be granted permission to read the file.

Available in Mac OS X v10.0 and later.
fsRdWrShPerm

Requests shared read and write permission. Shared read and write permission allows mutiple access paths for reading and writing. This is safe only if there is some way of locking portions of the file before writing to them. On volumes that support range locking, you can use the functions PBLockRangeSync and PBUnlockRangeSync to lock and unlock ranges of bytes within a file. Applications running in Mac OS X version 10.4 or later should use the functions FSLockRange and FSUnlockRange for this purpose. 

Available in Mac OS X v10.0 and later.
fsRdDenyPerm

Requests that any other paths be prevented from having read access. A path cannot be opened if you request read permission (with the fsRdPerm constant) but some other path has requested deny-read access. Similarly, the path cannot be opened if you request deny-read permission, but some other path already has read access. This constant is used with the PBHOpenDenySync and PBHOpenRFDenySync functions. 

Available in Mac OS X v10.0 and later.
fsWrDenyPerm

Requests that any other paths be prevented from having write access. A path cannot be opened if you request write permission (with the fsWrPerm constant) but some other path has requested deny-write access. Similarly, the path cannot be opened if you request deny-write permission, but some other path already has write access. This constant is used with the PBHOpenDenySync and PBHOpenRFDenySync functions.

Available in Mac OS X v10.0 and later.
Discussion

Use these constants to request a type of access to a file or fork, or to deny a type of access to a file or fork to other paths that may request access.

Note that it is possible, in Mac OS 8 and 9, to open a file residing on read-only media with write access. In Mac OS X, however, you cannot open a file with write access on read-only media; the attempt to open the file fails with a wrPermErr error.*/
enum {
   fsCurPerm = 0x00,
   fsRdPerm = 0x01,
   fsWrPerm = 0x02,
   fsRdWrPerm = 0x03,
   fsRdWrShPerm = 0x04,
   fsRdDenyPerm = 0x10,
   fsWrDenyPerm = 0x20
};

/*Position Mode Constants

Together with an offset, specify a position within a fork.

enum {
   fsAtMark = 0,
   fsFromStart = 1,
   fsFromLEOF = 2,
   fsFromMark = 3
};
Constants
fsAtMark

The starting point is the access path’s current position. The offset is ignored.

Available in Mac OS X v10.0 and later.
fsFromStart

The starting point is offset bytes from the start of the fork. The offset must be non-negative.

Available in Mac OS X v10.0 and later.
fsFromLEOF

The starting point is offset bytes from the logical end of the fork. The offset must not be positive.

Available in Mac OS X v10.0 and later.
fsFromMark

The starting point is offset bytes from the access path’s current position. The offset may be positive or negative.

Available in Mac OS X v10.0 and later.
Discussion

These constants are used in the ioPosMode and positionMode fields and parameters of the HFS and HFS Plus file access functions. These functions include those for reading from and writing to files or forks, changing the current position within a file or fork, changing the size of a file or fork, and allocating space to a file or fork.

For the FSReadFork and FSWriteFork calls, you may also add either of the pleaseCacheMask or noCacheMask constants to hint whether the data should be cached or not. See Cache Constants.*/
enum {
   fsAtMark = 0,
   fsFromStart = 1,
   fsFromLEOF = 2,
   fsFromMark = 3
};

/*Catalog Information Bitmap Constants

Specify what file or fork information to get or set.

enum {
   kFSCatInfoNone = 0x00000000,
   kFSCatInfoTextEncoding = 0x00000001,
   kFSCatInfoNodeFlags = 0x00000002,
   kFSCatInfoVolume = 0x00000004,
   kFSCatInfoParentDirID = 0x00000008,
   kFSCatInfoNodeID = 0x00000010,
   kFSCatInfoCreateDate = 0x00000020,
   kFSCatInfoContentMod = 0x00000040,
   kFSCatInfoAttrMod = 0x00000080,
   kFSCatInfoAccessDate = 0x00000100,
   kFSCatInfoBackupDate = 0x00000200,
   kFSCatInfoPermissions = 0x00000400,
   kFSCatInfoFinderInfo = 0x00000800,
   kFSCatInfoFinderXInfo = 0x00001000,
   kFSCatInfoValence = 0x00002000,
   kFSCatInfoDataSizes = 0x00004000,
   kFSCatInfoRsrcSizes = 0x00008000,
   kFSCatInfoSharingFlags = 0x00010000,
   kFSCatInfoUserPrivs = 0x00020000,
   kFSCatInfoUserAccess = 0x00080000,
   kFSCatInfoSetOwnership = 0x00100000,
   kFSCatInfoAllDates = 0x000003E0,
   kFSCatInfoGettableInfo = 0x0003FFFF,
   kFSCatInfoSettableInfo = 0x00001FE3,
   kFSCatInfoReserved = 0xFFFC0000
};
Constants
kFSCatInfoNone

No catalog information.

Available in Mac OS X v10.0 and later.
kFSCatInfoTextEncoding

Retrieve or set the text encoding hint, in the textEncodingHint field.

Available in Mac OS X v10.0 and later.
kFSCatInfoNodeFlags

Retrieve or set the catalog node flags. Currently, you can only set bits 0 and 4. See Catalog Information Node Flags for more information on these flags.

Available in Mac OS X v10.0 and later.
kFSCatInfoVolume

Retrieve the volume reference number of the volume on which the file or directory resides.

Available in Mac OS X v10.0 and later.
kFSCatInfoParentDirID

Retrieve the parent directory ID.

Available in Mac OS X v10.0 and later.
kFSCatInfoNodeID

Retrieve the file or directory ID.

Available in Mac OS X v10.0 and later.
kFSCatInfoCreateDate

Retrieve or set the creation date.

Available in Mac OS X v10.0 and later.
kFSCatInfoContentMod

Retrieve or set the date that the resource or data fork was last modified.

Available in Mac OS X v10.0 and later.
kFSCatInfoAttrMod

Retrieve or set the date that an attribute or named fork was last modified.

Available in Mac OS X v10.0 and later.
kFSCatInfoAccessDate

Retrieve or set the date that the fork or file was last accessed.

Available in Mac OS X v10.0 and later.
kFSCatInfoBackupDate

Retrieve or set the date that the fork or file was last backed up.

Available in Mac OS X v10.0 and later.
kFSCatInfoPermissions

Retrieve or set the file or fork’s permissions.

Available in Mac OS X v10.0 and later.
kFSCatInfoFinderInfo

Retrieve or set the file or fork’s Finder information.

Available in Mac OS X v10.0 and later.
kFSCatInfoFinderXInfo

Retrieve or set the file or fork’s extended Finder information.

Available in Mac OS X v10.0 and later.
kFSCatInfoValence

For folders only, retrieve the valence of the folder. For files, this is zero.

Available in Mac OS X v10.0 and later.
kFSCatInfoDataSizes

Retrieve the logical and physical size of the data fork.

Available in Mac OS X v10.0 and later.
kFSCatInfoRsrcSizes

Retrieve the logical and physical size of the resource fork.

Available in Mac OS X v10.0 and later.
kFSCatInfoSharingFlags

Retrieve the fork or file’s sharing flags: kioFlAttribMountedBit, kioFlAttribSharePointBit. See File Attribute Constants for more information on these bits.

Available in Mac OS X v10.0 and later.
kFSCatInfoUserPrivs

Retrieve the file’s user privileges.

Available in Mac OS X v10.0 and later.
kFSCatInfoUserAccess

Available in Mac OS X v10.1 and later.
kFSCatInfoSetOwnership

Attempt to set the file’s user and group (UID and GID). If the File Manager cannot set the the user or group ID, the call fails. (Mac OS X only).

Available in Mac OS X v10.3 and later.
kFSCatInfoAllDates

Retrieve or set all of the date information for the fork or file: creation date, modification dates, access date, backup date, etc.

Available in Mac OS X v10.0 and later.
kFSCatInfoGettableInfo

Retrieve all gettable data.

Available in Mac OS X v10.0 and later.
kFSCatInfoSettableInfo

Set all settable data. This includes the flags, dates, permissions, Finder info, and text encoding hint.

Available in Mac OS X v10.0 and later.
kFSCatInfoReserved

Represents bits that are currently reserved.

Available in Mac OS X v10.0 and later.
Discussion

These constants are used in the FSCatalogInfoBitmap type to specify what file or fork information to get or set. If used with the FSGetCatalogInfo or FSGetCatalogInfoBulk functions, these constants tell the File Manager which fields to return information in. If used with the FSSetCatalogInfo function, these constants tell the File Manager which fields you’ve filled out with values that it should use to change the fork or file’s catalog information.*/
enum {
   kFSCatInfoNone = 0x00000000,
   kFSCatInfoTextEncoding = 0x00000001,
   kFSCatInfoNodeFlags = 0x00000002,
   kFSCatInfoVolume = 0x00000004,
   kFSCatInfoParentDirID = 0x00000008,
   kFSCatInfoNodeID = 0x00000010,
   kFSCatInfoCreateDate = 0x00000020,
   kFSCatInfoContentMod = 0x00000040,
   kFSCatInfoAttrMod = 0x00000080,
   kFSCatInfoAccessDate = 0x00000100,
   kFSCatInfoBackupDate = 0x00000200,
   kFSCatInfoPermissions = 0x00000400,
   kFSCatInfoFinderInfo = 0x00000800,
   kFSCatInfoFinderXInfo = 0x00001000,
   kFSCatInfoValence = 0x00002000,
   kFSCatInfoDataSizes = 0x00004000,
   kFSCatInfoRsrcSizes = 0x00008000,
   kFSCatInfoSharingFlags = 0x00010000,
   kFSCatInfoUserPrivs = 0x00020000,
   kFSCatInfoUserAccess = 0x00080000,
   kFSCatInfoSetOwnership = 0x00100000,
   kFSCatInfoAllDates = 0x000003E0,
   kFSCatInfoGettableInfo = 0x0003FFFF,
   kFSCatInfoSettableInfo = 0x00001FE3,
   kFSCatInfoReserved = 0xFFFC0000
};


/*FSCatalogInfoBitmap

Describes which fields of the FSCatalogInfo structure you wish to retrieve or set.

typedef UInt32 FSCatalogInfoBitmap;
Discussion

If the bit corresponding to a particular field is not set in the bitmap, then that field is not changed in the FSCatalogInfo structure if it is an output parameter, and that field is ignored if the FSCatalogInfo structure is an input parameter. See Catalog Information Bitmap Constants for a description of the constants you should use with this data type. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef UInt32 FSCatalogInfoBitmap;

/*FSVolumeRefNum

Identifies a particular mounted volume.

typedef SInt16 FSVolumeRefNum;
Discussion

This data type is the same as the 16-bit volume refnum previously passed in the ioVRefNum fields of a parameter block; this is simply a new type name for the old data type. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef SInt16 FSVolumeRefNum;


/*FSIterator

Refers to a position within the catalog, used when iterating over files and folders in a directory.

typedef struct OpaqueFSIterator * FSIterator;
Discussion

This data type is like a file reference number because it maintains state internally to the File Manager and must be explicitly opened and closed.

An FSIterator is returned by FSOpenIterator and is passed as input to FSGetCatalogInfoBulk , FSCatalogSearch and FSCloseIterator. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OpaqueFSIterator * FSIterator;

/*Iterator Flags

Indicate whether an iterator iterates over subtrees or just the immediate children of the container.

enum {
   kFSIterateFlat = 0,
   kFSIterateSubtree = 1,
   kFSIterateDelete = 2,
   kFSIterateReserved = 0xFFFFFFFC
};
typedef OptionBits FSIteratorFlags;
Constants
kFSIterateFlat

Iterate over the immediate children of the container only. 

Available in Mac OS X v10.0 and later.
kFSIterateSubtree

Iterate over the entire subtree rooted at the container.

Available in Mac OS X v10.0 and later.
kFSIterateDelete

Available in Mac OS X v10.0 and later.
kFSIterateReserved

Available in Mac OS X v10.0 and later.*/
enum {
   kFSIterateFlat = 0,
   kFSIterateSubtree = 1,
   kFSIterateDelete = 2,
   kFSIterateReserved = 0xFFFFFFFC
};
typedef OptionBits FSIteratorFlags;

/*FSOpenIterator

Creates a catalog iterator that can be used to iterate over the contents of a directory or volume.

OSErr FSOpenIterator (
   const FSRef * container,
   FSIteratorFlags iteratorFlags,
   FSIterator * iterator
);
Parameters
container

A pointer to an FSRef for the directory to iterate. The set of items to iterate over can either be the objects directly contained in the directory, or all items directly or indirectly contained in the directory (in which case, the specified directory is the root of the subtree to iterate). See FSRef for a description of the FSRef data type.
iteratorFlags

A set of flags which controls whether the iterator iterates over subtrees or just the immediate children of the container. See Iterator Flags for a description of the flags defined for this parameter.

Iteration over subtrees which do not originate at the root directory of a volume are not currently supported, and passing the kFSIterateSubtree flag in this parameter returns errFSBadIteratorFlags. To determine whether subtree iterators are supported, check that the bSupportsSubtreeIterators bit returned by PBHGetVolParmsSync or PBHGetVolParmsAsync is set.
iterator

On return, a pointer to the new FSIterator. You can pass this iterator to the FSGetCatalogInfoBulk or FSCatalogSearch functions and their parameter block-based counterparts.

The iterator is automatically initialized so that the next use of the iterator returns the first item. The order that items are returned in is volume format dependent and may be different for two different iterators created with the same container and flags.

See FSIterator for a description of the FSIterator data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

Catalog iterators must be closed when you are done using them, whether or not you have iterated over all the items. Iterators are automatically closed upon process termination, just like open files. However, you should use the FSCloseIterator function, or one of the related parameter block functions, PBCloseIteratorSync and PBCloseIteratorAsync , to close an iterator to free up any system resources allocated to the iterator.

Before calling this function, you should check that it is present, by calling the Gestalt function. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSOpenIterator (
   const FSRef * container,
   FSIteratorFlags iteratorFlags,
   FSIterator * iterator
);

/*FSGetCatalogInfoBulk

Returns information about one or more objects from a catalog iterator. This function can return information about multiple objects in a single call.

OSErr FSGetCatalogInfoBulk (
   FSIterator iterator,
   ItemCount maximumObjects,
   ItemCount * actualObjects,
   Boolean * containerChanged,
   FSCatalogInfoBitmap whichInfo,
   FSCatalogInfo * catalogInfos,
   FSRef * refs,
   FSSpec * specs,
   HFSUniStr255 * names
);
Parameters
iterator

The iterator to use. You can obtain a catalog iterator with the function FSOpenIterator, or with one of the related parameter block calls, PBOpenIteratorSync and PBOpenIteratorAsync. Currently, the iterator must be created with the kFSIterateFlat option. See FSIterator for a description of the FSIterator data type.
maximumObjects

The maximum number of items to return for this call. 
actualObjects

On return, a pointer to the actual number of items found for this call.
containerChanged

On return, a pointer to a value indicating whether or not the container’s contents have changed since the previous FSGetCatalogInfoBulk call. If true, the contents have changed. Objects may still be returned, even though the container has changed. If so, note that if the container has changed, then the total set of items returned may be incorrect: some items may be returned multiple times, and some items may not be returned at all.

This parameter is optional if you don’t want this information returned, pass a NULL pointer. 

On versions of Mac OS X prior to 10.2, this parameter is unset. On Mac OS X version 10.2, this parameter is always set to false. To find out whether the container has changed since the last call to FSGetCatalogInfoBulk, check the modification date of the container.
whichInfo

A bitmap specifying the catalog information fields to return for each item. If you don’t wish any catalog information returned, pass the constant kFSCatInfoNone in this parameter. For a description of the bits in this parameter, see Catalog Information Bitmap Constants.
catalogInfos

A pointer to an array of catalog information structures; one for each returned item. On input, the catalogInfos parameter should point to an array of maximumObjects catalog information structures.

This parameter is optional; if you do not wish any catalog information returned, pass NULL here.

refs

A pointer to an array of FSRef structures; one for each returned item. On input, this parameter should to point to an array of maximumObjectsFSRef structures. 

This parameter is optional; if you do not wish any FSRef structures returned, pass NULL here.
specs

A pointer to an array of FSSpec structures; one for each returned item. On input, this parameter should to point to an array of maximumObjectsFSSpec structures. 

This parameter is optional; if you do not wish any FSSpec structures returned, pass NULL here.
names

A pointer to an array of names; one for each returned item. If you want the Unicode name for each item found, set this parameter to point to an array of maximumObjectsHFSUniStr255 structures. Otherwise, set it to NULL. 
Return Value

A result code. See “File Manager Result Codes”. When all of the iterator’s objects have been returned, the call will return errFSNoMoreItems.
Discussion

The FSGetCatalogInfoBulk call may complete and return noErr with fewer than maximumObjects items returned. This may be due to various reasons related to the internal implementation. In this case, you may continue to make FSGetCatalogInfoBulk calls using the same iterator.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSGetCatalogInfoBulk (
   FSIterator iterator,
   ItemCount maximumObjects,
   ItemCount * actualObjects,
   Boolean * containerChanged,
   FSCatalogInfoBitmap whichInfo,
   FSCatalogInfo * catalogInfos,
   FSRef * refs,
   FSSpec * specs,
   HFSUniStr255 * names
);

/*FSMakeFSRefUnicode

Constructs an FSRef for a file or directory, given a parent directory and a Unicode name. 

OSErr FSMakeFSRefUnicode (
   const FSRef * parentRef,
   UniCharCount nameLength,
   const UniChar * name,
   TextEncoding textEncodingHint,
   FSRef * newRef
);
Parameters
parentRef

A pointer to the FSRef of the parent directory of the file or directory for which to create a new FSRef. See FSRef for a description of the FSRef data type.
nameLength

The length of the file or directory name. 
name

A pointer to the Unicode name for the file or directory. The name must be a leaf name; partial or full pathnames are not allowed. If you have a partial or full pathname in Unicode, you will have to parse it yourself and make multiple calls to FSMakeFSRefUnicode. 
textEncodingHint

The suggested text encoding to use when converting the Unicode name of the file or directory to some other encoding. If you pass the constant kTextEncodingUnknown, the File Manager will use a default value. 
newRef

On return, if the function returns a result of noErr, a pointer to the new FSRef.
Return Value

A result code. See “File Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSMakeFSRefUnicode (
   const FSRef * parentRef,
   UniCharCount nameLength,
   const UniChar * name,
   TextEncoding textEncodingHint,
   FSRef * newRef
);

/*FSCloseIterator

Closes a catalog iterator. 

OSErr FSCloseIterator (
   FSIterator iterator
);
Parameters
iterator

The catalog iterator to be closed. FSCloseIterator releases memory and other system resources used by the iterator, making the iterator invalid. See FSIterator for a description of the FSIterator data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

This function releases memory and other system resources used by the iterator. The iterator becomes invalid. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSCloseIterator (
   FSIterator iterator
);

/*FSCloseFork

Closes an open fork.

OSErr FSCloseFork (
   SInt16 forkRefNum
);
Parameters
forkRefNum

The reference number of the fork to close. After the call to this function, the reference number in this parameter is invalid. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The FSCloseFork function causes all data written to the fork to be written to disk, in the same manner as the FSFlushFork function, before it closes the fork. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSCloseFork (
   SInt16 forkRefNum
);

/*FSReadFork

Reads data from an open fork.

OSErr FSReadFork (
   SInt16 forkRefNum,
   UInt16 positionMode,
   SInt64 positionOffset,
   ByteCount requestCount,
   void * buffer,
   ByteCount * actualCount
);
Parameters
forkRefNum

The reference number of the fork to read from. You should have previously opened this fork using the FSOpenFork call, or one of the corresponding parameter block calls, PBOpenForkSync and PBOpenForkAsync. 
positionMode

A constant specifying the base location within the fork for the start of the read. See Position Mode Constants for a description of the constants which you can use to specify the base location.

The caller can also use this parameter to hint to the File Manager whether the data being read should or should not be cached. Caching reads appropriately can be important in ensuring that your program access files efficiently. 

If you add the forceReadMask constant to the value you pass in this parameter, this tells the File Manager to force the data to be read directly from the disk. This is different from adding the noCacheMask constant since forceReadMask tells the File Manager to flush the appropriate part of the cache first, then ignore any data already in the cache. However, data that is read may be placed in the cache for future reads. The forceReadMask constant is also passed to the device driver, indicating that the driver should avoid reading from any device caches.

See Cache Constants for further description of the constants that you can use to indicate your preference for caching the read.

positionOffset

The offset from the base location for the start of the read. 
requestCount

The number of bytes to read. 
buffer

A pointer to the buffer where the data will be returned. 
actualCount

On return, a pointer to the number of bytes actually read. The value pointed to by the actualCount parameter should be equal to the value in the requestCount parameter unless there was an error during the read operation.

This parameter is optional; if you don’t want this information returned, set actualCount to NULL.
Return Value

A result code. See “File Manager Result Codes”. If there are fewer than requestCount bytes from the specified position to the logical end-of-file, then all of those bytes are read, and eofErr is returned.
Discussion

FSReadFork reads data starting at the position specified by the positionMode and positionOffset parameters. The function reads up to requestCount bytes into the buffer pointed to by the buffer parameter and sets the fork’s current position to the byte immediately after the last byte read (that is, the initial position plus actualCount).

To verify that data previously written has been correctly transferred to disk, read it back in using the forceReadMask constant in the positionMode parameter and compare it with the data you previously wrote.

When reading data from a fork, it is important to pay attention to that way that your program accesses the fork, because this can have a significant performance impact. For best results, you should use an I/O size of at least 4KB and block align your read requests. On Mac OS X, you should align your requests to 4KB boundaries; on the traditional Mac OS, byte-alignments beyond 512-bytes are irrelevant, but 4KB aligned requests will perform well on current and future versions. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSReadFork (
   SInt16 forkRefNum,
   UInt16 positionMode,
   SInt64 positionOffset,
   ByteCount requestCount,
   void * buffer,
   ByteCount * actualCount
);

/*FSOpenFork

Opens any fork of a file or directory for streaming access.

OSErr FSOpenFork (
   const FSRef * ref,
   UniCharCount forkNameLength,
   const UniChar * forkName,
   SInt8 permissions,
   SInt16 * forkRefNum
);
Parameters
ref

A pointer to an FSRef specifying the file or directory owning the fork to open. See FSRef for a description of the FSRef data type.
forkNameLength

The length of the fork name in Unicode characters. 
forkName

A pointer to the Unicode name of the fork to open. You can obtain the string constants for the data fork and resource fork names using the FSGetDataForkName and FSGetResourceForkName functions. All volume formats should support data and resource forks; other named forks may be supported by some volume formats. 
permissions

A constant indicating the type of access which you wish to have to the fork via the returned fork reference. This parameter is the same as the permission parameter passed to the FSpOpenDF and FSpOpenRF functions. For a description of the types of access which you can request, see File Access Permission Constants. 
forkRefNum

On return, a pointer to the fork reference number for accessing the open fork. 
Return Value

A result code. See “File Manager Result Codes”. On some file systems, FSOpenFork will return the error eofErr if you try to open the resource fork of a file for which no resource fork exists with read-only access.
Discussion

When you use this function to open a file on a local volume and pass in a permissions value of fsCurPerm, fsWrPerm, or fsRdWrPerm , Mac OS X does not guarantee exclusive file access. Before making any assumptions about the underlying file access, you should always check to see whether the Supports Exclusive Locks feature is available. If this feature is not available, your application cannot know whether another application has access to the same file. For more information, see ADC Technical Note TN2037. 

To access named forks or forks larger than 2GB, you must use the FSOpenFork function or one of the corresponding parameter block calls: PBOpenForkSync and PBOpenForkAsync. To determine if the FSOpenFork function is present, call the Gestalt function. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSOpenFork (
   const FSRef * ref,
   UniCharCount forkNameLength,
   const UniChar * forkName,
   SInt8 permissions,
   SInt16 * forkRefNum
);

/*FSGetCatalogInfo

Returns catalog information about a file or directory. You can use this function to map an FSRef to an FSSpec.

OSErr FSGetCatalogInfo (
   const FSRef * ref,
   FSCatalogInfoBitmap whichInfo,
   FSCatalogInfo * catalogInfo,
   HFSUniStr255 * outName,
   FSSpec * fsSpec,
   FSRef * parentRef
);
Parameters
ref

A pointer to an FSRef specifying the file or directory for which to retrieve information. See FSRef for a description of the FSRef data type. 
whichInfo

A bitmap specifying the catalog information fields to return. If you don’t want any catalog information, set whichInfo to the constant kFSCatInfoNone. See Catalog Information Bitmap Constants for a description of the bits in this parameter.
catalogInfo

On return, a pointer to a catalog information structure containing the information about the file or directory. Only the information specified in the whichInfo parameter is returned. If you don’t want any catalog information, pass NULL here. See FSCatalogInfo for a description of the FSCatalogInfo data type.
outName

On return, a pointer to the Unicode name of the file or directory is returned here. This parameter is optional; if you do not wish the name returned, pass NULL here. See HFSUniStr255 for a description of the HFSUniStr255 data type.
fsSpec

On return, a pointer to the FSSpec for the file or directory. This parameter is optional; if you do not wish the FSSpec returned, pass NULL here. See FSSpec for a description of the FSSpec data type.
parentRef

On return, a pointer to the FSRef for the object's parent directory. This parameter is optional; if you do not wish the parent directory returned, pass NULL here.

If the object specified in the ref parameter is a volume’s root directory, then the FSRef returned here will not be a valid FSRef, since the root directory has no parent object.
Return Value

A result code. See “File Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSGetCatalogInfo (
   const FSRef * ref,
   FSCatalogInfoBitmap whichInfo,
   FSCatalogInfo * catalogInfo,
   HFSUniStr255 * outName,
   FSSpec * fsSpec,
   FSRef * parentRef
);

/*FSPathMakeRef

Converts a path into an FSRef structure.

OSStatus FSPathMakeRef (
   const UInt8 * path,
   FSRef * ref,
   Boolean * isDirectory
);
Parameters
path

The path for which to return an FSRef. This path can be used by POSIX-style calls. 
ref

On return, a pointer to the FSRef. 
isDirectory

A Boolean value indicating whether the object at specified by the given path is a directory. This parameter is optional and can be NULL. 
Return Value

A result code. See “File Manager Result Codes”.
Special Considerations

This function, though available through Carbon on Mac OS 8 and 9, is only implemented on Mac OS X.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/

OSStatus FSPathMakeRef (
   const UInt8 * path,
   FSRef * ref,
   Boolean * isDirectory
);

/*FSGetVolumeInfo

Returns information about a volume.

OSErr FSGetVolumeInfo (
   FSVolumeRefNum volume,
   ItemCount volumeIndex,
   FSVolumeRefNum * actualVolume,
   FSVolumeInfoBitmap whichInfo,
   FSVolumeInfo * info,
   HFSUniStr255 * volumeName,
   FSRef * rootDirectory
);
Parameters
volume

If you wish to obtain information on a particular volume, pass that volume’s reference number here. If you wish to index through the list of mounted volumes, pass the constant kFSInvalidVolumeRefNum in this parameter. See FSVolumeRefNum for a description of the FSVolumeRefNum data type.
volumeIndex

The index of the desired volume, or 0 to use the volume reference number in the volume parameter. 
actualVolume

On return, a pointer to the volume reference number of the volume. This is useful when indexing over all mounted volumes. If you don’t want this information (if, for instance, you supplied a particular volume reference number in the volume) parameter, set actualVolume to NULL.
whichInfo

A bitmap specifying which volume information fields to get and return in the info parameter. If you don’t want information about the volume returned in the info parameter, set whichInfo to kFSVolInfoNone. See Volume Information Bitmap Constants for a description of the bits in this parameter.
info

On return, a pointer to the volume information. If you don’t want this output, set this parameter to NULL. See FSVolumeInfo for a description of the FSVolumeInfo data type.
volumeName

On return, a pointer to the Unicode name of the volume. If you do not wish the name returned, pass NULL. See HFSUniStr255 for a description of the HFSUniStr255 data type.
rootDirectory

On return, a pointer to the FSRef for the volume’s root directory. If you do not wish the root directory returned, pass NULL. See FSRef for a description of the FSRef data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

You can specify a particular volume or index through the list of mounted volumes. To get information on a particular volume, pass the volume reference number of the desired volume in the volume parameter and set the volumeIndex parameter to zero. To index through the list of mounted volumes, pass kFSInvalidVolumeRefNum in the volume parameter and set volumeIndex to the index, starting at 1 with the first call to FSGetVolumeInfo.

When indexing through the list of mounted volumes, you may encounter an error with a particular volume. The terminating error code for full traversal of this list is nsvErr. In order to completely traverse the entire list, you may have to bump the index count when encountering other errors (for example, ioErr).

To get information about the root directory of a volume, use the FSGetCatalogInfo function, or one of the corresponding parameter block calls, PBGetCatalogInfoSync and PBGetCatalogInfoAsync. 
Special Considerations

After an operation that changes the amount of free space on the volume—such as deleting a file—there may be a delay before a call to FSGetVolumeInfo returns the updated amount. This is because the File Manager caches and periodically updates file system information, to reduce the number of calls made to retrieve the information from the file system. Currently, the File Manager updates its information every 15 seconds. This primarily affects NFS volumes. DOS, SMB, UFS and WebDAV volumes were also affected by this in previous versions of Mac OS X, but behave correctly in Mac OS X version 10.3 and later.
Availability
Available in Mac OS X v10.0 and later.*/
OSErr FSGetVolumeInfo (
   FSVolumeRefNum volume,
   ItemCount volumeIndex,
   FSVolumeRefNum * actualVolume,
   FSVolumeInfoBitmap whichInfo,
   FSVolumeInfo * info,
   HFSUniStr255 * volumeName,
   FSRef * rootDirectory
);

/*PBHGetVolParmsSync

Returns information about the characteristics of a volume.

OSErr PBHGetVolParmsSync (
   HParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the HIOParam variant of the basic HFS parameter block. See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to the volume’s name. You can use a either a name or a volume specification to specify the volume. If you use a volume specification to specify the volume, you should set the ioNamePtr field to NULL. 
ioVRefNum 

On input, a volume specification. You can use a either a name or a volume specification to specify the volume. A volume specification can be a volume reference number, drive number, or 0 for the default volume. 
ioBuffer 

On input, a pointer to a GetVolParmsInfoBuffer record; you must allocate this memory to hold the returned attributes. On return, the PBHGetVolParmsSync function places the attributes information in the bufferVolumes that implement the HFS Plus APIs must use version 3 (or newer) of the GetVolParmsInfoBuffer structure. If the version of the GetVolParmsInfoBuffer is 2 or less, or the bSupportsHFSPlusAPIs bit is clear, then the volume does not implement the HFS Plus APIs and they are being emulated for that volume by the File Manager. 
ioReqCount 

On input, the size, in bytes, of the buffer area pointed to in the ioBuffer field. 
ioActCount 

On output, the size of the data actually returned. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr PBHGetVolParmsSync (
   HParmBlkPtr paramBlock
);

/*FSMakeFSSpec

Creates an FSSpec structure describing a file or directory. (Deprecated in Mac OS X v10.4. Use FSMakeFSRefUnicode instead.)

OSErr FSMakeFSSpec (
   short vRefNum,
   long dirID,
   ConstStr255Param fileName,
   FSSpec * spec
);
Parameters
vRefNum

A volume specification for the volume containing the file or directory. This parameter can contain a volume reference number, a drive number, or 0 to specify the default volume. 
dirID

The parent directory ID of the target object. If the directory is sufficiently specified in the fileName parameter, the dirID parameter can be set to 0. If the fileName parameter contains an empty string, FSMakeFSSpec creates an FSSpec structure for the directory specified by the dirID parameter. 
fileName

A full or partial pathname. If the fileName parameter specifies a full pathname, FSMakeFSSpec ignores both the vRefNum and dirID parameters. A partial pathname might identify only the final target, or it might include one or more parent directory names. If fileName specifies a partial pathname, then vRefNum, dirID, or both must be valid. 
spec

A pointer to a file system specification to be filled in by FSMakeFSSpec. The FSMakeFSSpec function fills in the fields of the file system specification using the information contained in the other three parameters. If your application receives any result code other than noErr or fnfErr, all fields of the resulting FSSpec structure are set to 0. 

The file system specification structure that you pass in this parameter should not share storage space with the input pathname; the name field may be initialized to the empty string before the pathname has been processed. For example, fileName should not refer to the name field of the output file system specification.

Return Value

A result code. See “File Manager Result Codes”.
Discussion

You should call FSMakeFSSpec, or one of the corresponding parameter block functions, PBMakeFSSpecSync and PBMakeFSSpecAsync , whenever you want to create an FSSpec structure. You should not create an FSSpec by filling in the fields of the structure yourself.

If the specified volume is mounted and the specified parent directory exists, but the target file or directory doesn’t exist in that location, FSMakeFSSpec fills in the structure and then returns fnfErr instead of noErr. The structure is valid, but it describes a target that doesn’t exist. You can use the structure for other operations, such as creating a file with the FSpCreate function. 
Carbon Porting Notes

Non-Carbon applications can also specify a working directory reference number in the vRefNum parameter. However, because working directories are not supported in Carbon, you cannot specify a working directory reference number if you wish your application to be Carbon-compatible.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr FSMakeFSSpec (
   short vRefNum,
   long dirID,
   ConstStr255Param fileName,
   FSSpec * spec
);

/*PBGetCatInfoSync

Returns catalog information about a file or directory. (Deprecated in Mac OS X v10.4. Use PBGetCatalogInfoSync instead.)

OSErr PBGetCatInfoSync (
   CInfoPBPtr paramBlock
);
Parameters
paramBlock

A pointer to an HFS catalog information parameter block. See CInfoPBRec for a description of the CInfoPBRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The PBGetCatInfoSync function returns information about a file or directory, depending on the values you specify in the ioFDirIndex, ioNamePtr, ioVRefNum, and ioDirID or ioDrDirID fields. If you need to determine whether the information returned is for a file or a directory, you can test bit 4 of the ioFlAttrib field; if that bit is set, the information returned describes a directory.

The PBGetCatInfoSync function selects a file or directory according to these rules:
If the value of ioFDirIndex is positive, ioNamePtr is not used as an input parameter and PBGetCatInfoSync returns information about the file or directory whose directory index is ioFDirIndex in the directory specified by ioDirID (or ioDrDirID) on the volume specified by ioVRefNum (this will be the root directory if ioVRefNum is a volume reference number or a drive number and ioDirID is 0). If ioNamePtr is not NULL, then it must point to a Str31 buffer where the file or directory name will be returned. 
If the value of ioFDirIndex is 0, PBGetCatInfoSync returns information about the file or directory specified by ioNamePtr in the directory specified by ioDirID (or ioDrDirID) on the volume specified by ioVRefNum (again, this will be the root directory if ioVRefNum is a volume reference number or a drive number and ioDirID is 0). 
If the value of ioFDirIndex is negative, PBGetCatInfoSync ignores the ioNamePtr field and returns information about the directory specified in the ioDrDirID field. If ioNamePtr is not NULL, then it must point to a Str31 buffer where the directory name will be returned. 

With files, PBGetCatInfoSync is similar to PBHGetFInfoSync but returns some additional information. If the object is a file, the relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to a pathname. On output, the name of the file is returned in this field, if the file is open. If you do not want the name of the file returned, pass NULL in this field. 
ioVRefNum 

On input, a volume reference number, drive number, or 0 for the default volume. 
ioFRefNum 

On output, a file reference number. If the file is open, the reference number of the first access path found is returned here. 
ioFDirIndex 

On input, a directory index. 
ioFlAttrib 

On output, the file attributes. See File Attribute Constants for the meaning of the file attributes. 
ioFlFndrInfo 

On output, information used by the Finder. 
ioDirID 

On input, a directory ID. On output, the file ID. You might need to save the value of ioDirID before calling PBGetCatInfoSync if you make subsequent calls with the same parameter block. 
ioFlStBlk 

On output, the first allocation block of the data fork. 
ioFlLgLen 

On output, the logical size (the logical end-of-file) of the data fork, in bytes. 
ioFlPyLen 

On output, the physical size (the physical end-of-file) of the data fork, in bytes. 
ioFlRStBlk 

On output, the first allocation block of the resource fork. 
ioFlRLgLen 

On output, the logical size of the resource fork, in bytes. 
ioFlRPyLen 

On output, the physical size of the resource fork, in bytes. 
ioFlCrDat 

On output, the date and time of the file’s creation. Note that file systems other than AFP, HFS and HFS Plus do not generally support creation dates. For file systems which do not support creation dates, the File Manager sets the ioFlCrDat field to 0. 
ioFlMdDat 

On output, the date and time of the file’s last modification. 
ioFlBkDat 

On output, the date and time of the file’s last backup. Note that file systems other than AFP, HFS and HFS Plus do not generally support backup dates. For file systems which do not support backup dates, the File Manager sets the ioFlBkDat field to 0. 
ioFlXFndrInfo 

On output, additional information used by the Finder. 
ioFlParID 

On output, the directory ID of the file’s parent directory. 
ioFlClpSiz 

On output, the file’s clump size. 

You can also use PBGetCatInfoSync to determine whether a file has a file ID reference. The value of the file ID is returned in the ioDirID field. Because that parameter could also represent a directory ID, call PBResolveFileIDRefSync to see if the value is a real file ID. If you want to determine whether a file ID reference exists for a file and create one if it doesn’t, use PBCreateFileIDRefSync , which will either create a file ID or return fidExists.

If the object is a directory, the relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to a pathname. On output, a pointer to the directory’s name. 
ioVRefNum 

On input, a volume reference number, drive number, or 0 for the default volume. 
ioFDirIndex 

On input, a directory index. 
ioFlAttrib 

On output, the directory attributes. See File Attribute Constants for the meaning of the bits in this field.The bits in this field for directories are read-only. You cannot alter directory attributes by setting these bits using the functions PBSetCatInfoSync or PBSetCatInfoAsync. Instead, you can call the PBHSetFLockSync and PBHRstFLockSync functions to lock and unlock a directory, and the PBShareSync and PBUnshareSync functions to enable and disable file sharing on local directories. 
ioACUser 

On output, the directory access rights. The PBGetCatInfoSync function returns the information in this field only for shared volumes. As a result, you should set this field to 0 before calling PBGetCatInfoSync. PBGetCatInfoSync does not return the blank access privileges bit in this field; to determine whether a directory has blank access privileges, use the PBHGetDirAccessSync function. See User Privileges Constants for a description of the constants that may be returned here. 
ioDrUsrWds 

On output, information used by the Finder. 
ioDrDirID 

On input, if you wish to obtain information about a specific directory, that directory’s ID. Otherwise, if the object returned is a directory, this field contains the directory ID on output. 
ioDrNmFls 

On output, the number of files in the directory. 
ioDrCrDat 

On output, the date and time of the directory’s creation. Note that file systems other than AFP, HFS and HFS Plus do not generally support creation dates. For file systems which do not support creation dates, the File Manager sets the ioDrCrDat field to 0.
ioDrMdDat 

On output, the date and time of the directory’s last modification. 
ioDrBkDat 

On output, the date and time of the directory’s last backup. Note that file systems other than AFP, HFS and HFS Plus do not generally support backup dates. For file systems which do not support backup dates, the File Manager sets the ioDrBkDat field to 0.
ioDrFndrInfo 

On output, additional information used by the Finder. 
ioDrParID 

On output, the directory ID of the directory’s parent directory. 

To get information on a file or directory with named forks, or on a file larger than 2GB, use one of the FSGetCatalogInfo , PBGetCatalogInfoSync , or PBGetCatalogInfoAsync functions. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBGetCatInfoSync (
   CInfoPBPtr paramBlock
);

/*FSpOpenDF

Opens the data fork of a file. (Deprecated in Mac OS X v10.4. Use FSOpenFork instead.)

OSErr FSpOpenDF (
   const FSSpec * spec,
   SInt8 permission,
   short * refNum
);
Parameters
spec

A pointer to an FSSpec structure specifying the file whose data fork is to be opened. See FSSpec for a description of the FSSpec data type.
permission

A constant indicating the type of access with which to open the file’s data fork. In most cases, you can simply set the permission parameter to fsCurPerm. Some applications request fsRdWrPerm, to ensure that they can both read from and write to a file. For a description of the types of access that you can request, see File Access Permission Constants. 
refNum

On return, a pointer to the file reference number for accessing the open data fork. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

Before calling this function, you should call the Gestalt function to check that the function is available. If FSpOpenDF is not available, you can use the function HOpenDF instead.

Note that if you wish to access named forks other than the data and resource forks, or forks larger than 2GB, you will need to use the FSOpenFork function, or one of its corresponding parameter block calls, PBOpenForkSync and PBOpenForkAsync. If you try to open a fork larger than 2GB with the FSpOpenDF function, you will receive an error message. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr FSpOpenDF (
   const FSSpec * spec,
   SInt8 permission,
   short * refNum
);

/*GetEOF

Determines the current logical size of an open file. (Deprecated in Mac OS X v10.4. Use FSGetForkSize instead.)

OSErr GetEOF (
   short refNum,
   long * logEOF
);
Parameters
refNum

The file reference number of an open file. 
logEOF

On return, a pointer to the logical size (the logical end-of-file) of the given file. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

To determine the size of a named fork other than the data or resource forks, or of a fork larger than 2 GB, use the FSGetForkSize function, or one of the corresponding parameter block functions, PBGetForkSizeSync and PBGetForkSizeAsync. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr GetEOF (
   short refNum,
   long * logEOF
);

/*FSRead

Reads any number of bytes from an open file. (Deprecated in Mac OS X v10.4. Use FSReadFork instead.)

OSErr FSRead (
   short refNum,
   long * count,
   void * buffPtr
);
Parameters
refNum

The file reference number of the open file from which to read. 
count

On input, a pointer to the number of bytes to read; on output, a pointer to the number of bytes actually read. 
buffPtr

A pointer to the data buffer into which the data will be read. This buffer is allocated by your application and must be at least as large as the count parameter. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

Because the read operation begins at the current mark, you might want to set the mark first by calling the SetFPos function. If you try to read past the logical end-of-file, FSRead reads in all the data up to the end-of-file, moves the mark to the end-of-file, and returns eofErr as its function result. Otherwise, FSRead moves the file mark to the byte following the last byte read and returns noErr.

The low-level functions PBReadSync and PBReadAsync let you set the mark without having to call SetFPos. Furthermore, if you want to read data in newline mode, you must use PBReadSync or PBReadAsync instead of FSRead. For a description of the PBReadSync and PBReadAsync functions, see the Device Manager Reference .

If you wish to read from named forks other than the data or resource forks, or from files larger than 2GB, you must use the FSReadFork function, or one of its corresponding parameter block calls, PBReadForkSync and PBReadForkAsync. If you attempt to use FSRead to read from a file larger than 2GB, you will receive an error message. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr FSRead (
   short refNum,
   long * count,
   void * buffPtr
);

/*FSClose

Closes an open file. (Deprecated in Mac OS X v10.4. Use FSCloseFork instead.)

OSErr FSClose (
   short refNum
);
Parameters
refNum

The file reference number of the open file. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The FSClose function removes the access path for the specified file and writes the contents of the volume buffer to the volume.

The FSClose function calls the PBFlushFileSync function internally to write the file’s bytes onto the volume. To ensure that the file’s catalog entry is updated, you should call FlushVol after you call FSClose. 
Special Considerations

Make sure that you do not call FSClose with a file reference number of a file that has already been closed. Attempting to close the same file twice may result in loss of data on a volume.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/

OSErr FSClose (
   short refNum
);

/*FSRefMakePath

Converts an FSRef into a path.

OSStatus FSRefMakePath (
   const FSRef * ref,
   UInt8 * path,
   UInt32 maxPathSize
);
Parameters
ref

The FSRef to convert into a path. 
path

On return, a pointer to the path. This path can be used by POSIX-style calls. 
pathSize

The size of the path. 
Return Value

A result code. See “File Manager Result Codes”.
Special Considerations

This function, though available through Carbon on Mac OS 8 and 9, is only implemented on Mac OS X.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSStatus FSRefMakePath (
   const FSRef * ref,
   UInt8 * path,
   UInt32 maxPathSize
);

/*FSGetDataForkName

Returns a Unicode string constant for the name of the data fork.

OSErr FSGetDataForkName (
   HFSUniStr255 * dataForkName
);
Parameters
dataForkName

On input, a pointer to an HFSUniStr255 structure. On return, this structure contains the Unicode name of the data fork. Currently, this is the empty string. See HFSUniStr255 for a description of the HFSUniStr255 data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

There is no parameter block-based form of this call since it is not dispatched to individual volume formats, and does not require any I/O. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSGetDataForkName (
   HFSUniStr255 * dataForkName
);

/*FSGetForkSize

Returns the size of an open fork. 

OSErr FSGetForkSize (
   SInt16 forkRefNum,
   SInt64 * forkSize
);
Parameters
forkRefNum

The reference number of the open fork. You can obtain this fork reference number with the FSOpenFork function, or one of the corresponding parameter block calls, PBOpenForkSync and PBOpenForkAsync. 
forkSize

On return, a pointer to the logical size (the logical end-of-file) of the fork, in bytes. The size returned is the total number of bytes that can be read from the fork; the amount of space actually allocated on the volume (the physical size) will probably be larger. 
Return Value

A result code. See “File Manager Result Codes”.
Special Considerations

To determine whether the FSGetForkSize function is present, call the Gestalt function. If FSGetForkSize is present, but is not directly supported by a volume, the File Manager will call PBGetEOFSync; however, you will not be able to determine the size of a fork other than the data or resource fork, or of a fork larger than 2 GB. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSGetForkSize (
   SInt16 forkRefNum,
   SInt64 * forkSize
);

/*FSEjectVolumeSync

Ejects a volume.

OSStatus FSEjectVolumeSync (
   FSVolumeRefNum vRefNum,
   OptionBits flags,
   pid_t * dissenter
);
Parameters
vRefNum

The volume reference number of the volume to eject. 
flags

Options for future use.
dissenter

On return, a pointer to the pid of the process which denied the unmount if the eject is denied.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

This function ejects the volume specified by the vRefNum parameter. If the volume cannot be ejected the pid of the process which denied the unmount will be returned in the dissenter parameter. This function returns after the eject is complete. Ejecting a volume will result in the unmounting of other volumes on the same device.
Availability
Available in Mac OS X v10.2 and later.
Declared In
Files.h*/
OSStatus FSEjectVolumeSync (
   FSVolumeRefNum vRefNum,
   OptionBits flags,
   pid_t * dissenter
);

/*PBMakeFSRefSync

Creates an FSRef for a file or directory, given an FSSpec.

OSErr PBMakeFSRefSync (
   FSRefParam * paramBlock
);
Parameters
paramBlock

A pointer to a file system reference parameter block. See FSRefParam for a description of the FSRefParam data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

For the parameter block based calls, the fields of the source FSSpec are passed as separate parameters (in the ioNamePtr, ioVRefNum, and ioDirID fields). This allows the call to be dispatched to external file systems the same way as other FSp calls are. 

The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to the name of the file or directory for which you wish to create an FSRef. 
ioVRefNum 

On input, a volume specification for the volume containing the file or directory. This can be a volume reference number, a drive number, or 0 for the default volume. 
ioDirID 

On input, the directory ID of the file or directory’s parent directory. 
newRef 

On input, a pointer to an FSRef structure. On output, this FSRef refers to the specified file or directory. 

To obtain an FSSpec from an FSRef, use the PBGetCatalogInfoSync function. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr PBMakeFSRefSync (
   FSRefParam * paramBlock
);

#ifdef __cplusplus
}
#endif

#endif