#ifndef FIXMATH_H
#define FIXMATH_H

#ifndef MACTYPES_H
#include <CarbonCore/MacTypes.h>
#endif



#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*fixed1


enum {
   fixed1 = 0x00010000,
   fract1 = 0x40000000,
   positiveInfinity = 0x7FFFFFFF,
   negativeInfinity = 0x80000000
};
Constants
fixed1

Available in Mac OS X v10.0 and later.
fract1

Available in Mac OS X v10.0 and later.
positiveInfinity

Available in Mac OS X v10.0 and later.
negativeInfinity

Available in Mac OS X v10.0 and later.*/

enum {
   fixed1 = 0x00010000,
   fract1 = 0x40000000,
   positiveInfinity = 0x7FFFFFFF,
   negativeInfinity = 0x80000000
};

/*X2Fix

Converts an Extended number to a Fixed number.

Fixed X2Fix (
   double x
);
Parameters
x

The Extended number to be converted to a Fixed number. 
Return Value

The best Fixed approximation of the Extended number x. If x is greater than the maximum representable Fixed number, the X2Fix function returns $7FFFFFFF. If x is less than the negative number with the highest absolute value, X2Fix returns $80000000. 
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
FixMath.h*/
Fixed X2Fix (
   double x
);

/*Fix2X

Converts a Fixed number to an Extended number.

double Fix2X (
   Fixed x
);
Parameters
x

The Fixed number to be converted to an Extended number. 
Return Value

The Extended equivalent of the Fixed number x. 
Special Considerations

Fix2X does not move memory; you can call it at interrupt time.
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
FixMath.h*/
double Fix2X (
   Fixed x
);

#ifdef __cplusplus
}
#endif

#endif