#ifndef MULTIPROCESSING_H
#define MULTIPROCESSING_H

#ifndef MACTYPES_H
#include <CarbonCore/MacTypes.h>
#endif



#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*Timer Duration Constants

Specify the maximum time a task should wait for an event to occur. 

enum {
   kDurationImmediate = 0,
   kDurationForever = 0x7FFFFFFF,
   kDurationMillisecond = 1,
   kDurationMicrosecond = -1
};
Constants
kDurationImmediate

The task times out immediately, whether or not the event has occurred. If the event occurred, the return status is noErr. If the event did not occur, the return status is kMPTimeoutErr (assuming no other errors occurred). 

Available in Mac OS X v10.0 and later.
kDurationForever

The task waits forever. The blocking call waits until either the event occurs, or until the object being waited upon (such as a message queue) is deleted.

Available in Mac OS X v10.0 and later.
kDurationMillisecond

The task waits one millisecond before timing out. 

Available in Mac OS X v10.0 and later.
kDurationMicrosecond

The task waits one microsecond before timing out. 

Available in Mac OS X v10.0 and later.
Discussion

You can use these constants in conjunction with other values to indicate specific wait intervals. For example, to wait 1 second, you can pass kDurationMillisecond * 1000. 
Version Notes

Introduced with Multiprocessing Services 2.0.*/
enum {
   kDurationImmediate = 0,
   kDurationForever = 0x7FFFFFFF,
   kDurationMillisecond = 1,
   kDurationMicrosecond = -1
};

/*MPSemaphoreID

Represents a semaphore ID, which Multiprocessing Services uses to manipulate semaphores.

typedef struct OpaqueMPSemaphoreID * MPSemaphoreID;
Discussion

You obtain a semaphore ID by calling the function MPCreateSemaphore. 
Version Notes

Introduced with Multiprocessing Services 1.0. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OpaqueMPSemaphoreID * MPSemaphoreID;

/*MPSemaphoreCount

Represents a semaphore count. 

typedef ItemCount MPSemaphoreCount;
Discussion
Version Notes

Introduced with Multiprocessing Services 1.0. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef ItemCount MPSemaphoreCount;

/*MPCreateSemaphore

Creates a semaphore.

OSStatus MPCreateSemaphore (
   MPSemaphoreCount maximumValue,
   MPSemaphoreCount initialValue,
   MPSemaphoreID * semaphore
);
Parameters
maximumValue

The maximum allowed value of the semaphore. 
initialValue

The initial value of the semaphore.
semaphore

On return, semaphore contains the ID of the newly–created semaphore. 
Return Value

A result code. See "Multiprocessing Services Result Codes".
Discussion

If you want to create a binary semaphore, you can call the macro MPCreateBinarySemaphore (MPSemaphoreID *semaphore) instead, which simply calls MPCreateSemaphore with both maximumValue and initialValue set to 1.

Also see the function MPDeleteSemaphore. 
Version Notes

Introduced with Multiprocessing Services 1.0. 
Availability
Available in CarbonLib 1.0 and later when MultiprocessingLib 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Multiprocessing.h*/
OSStatus MPCreateSemaphore (
   MPSemaphoreCount maximumValue,
   MPSemaphoreCount initialValue,
   MPSemaphoreID * semaphore
);

/*MPSignalSemaphore

Signals a semaphore. 

OSStatus MPSignalSemaphore (
   MPSemaphoreID semaphore
);
Parameters
semaphore

The ID of the semaphore you want to signal. 
Return Value

A result code. See "Multiprocessing Services Result Codes". If the value of the semaphore was already at the maximum, MPSignalSemaphore returns kInsufficientResourcesErr.
Discussion

If tasks are waiting on the semaphore, the oldest (first queued) task is unblocked so that the corresponding MPWaitOnSemaphore call for that task completes. Otherwise, if the value of the semaphore is not already equal to its maximum value, it is incremented by one.

Note that you can call this function from an interrupt handler. 
Version Notes

Introduced with Multiprocessing Services 1.0. 
Availability
Available in CarbonLib 1.0 and later when MultiprocessingLib 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Multiprocessing.h*/
OSStatus MPSignalSemaphore (
   MPSemaphoreID semaphore
);

/*MPWaitOnSemaphore

Waits on a semaphore

OSStatus MPWaitOnSemaphore (
   MPSemaphoreID semaphore,
   Duration timeout
);
Parameters
semaphore

The ID of the semaphore you want to wait on. 
timeout

The maximum time the function should wait before timing out. See Timer Duration Constants for a list of constants you can use to specify the wait interval. 
Return Value

A result code. See "Multiprocessing Services Result Codes".
Discussion

If the value of the semaphore is greater than zero, the value is decremented and the function returns with noErr. Otherwise, the task is blocked awaiting a signal until the specified timeout is exceeded.

If you call this function from a cooperative task, you should specify only kDurationImmediate for the timeout length; other waits will cause the task to block. 

Also see the function MPSignalSemaphore. 
Version Notes

Introduced with Multiprocessing Services 1.0. 
Availability
Available in CarbonLib 1.0 and later when MultiprocessingLib 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Multiprocessing.h*/
OSStatus MPWaitOnSemaphore (
   MPSemaphoreID semaphore,
   Duration timeout
);

/*MPDeleteSemaphore

Removes a semaphore. 

OSStatus MPDeleteSemaphore (
   MPSemaphoreID semaphore
);
Parameters
semaphore

The ID of the semaphore you want to remove. 
Return Value

A result code. See "Multiprocessing Services Result Codes".
Discussion

Calling this function unblocks all tasks waiting on the semaphore and the tasks’ respective MPWaitOnSemaphore calls will return with the result code kMPDeletedErr.

Also see the function MPCreateSemaphore. 
Version Notes

Introduced with Multiprocessing Services 1.0. 
Availability
Available in CarbonLib 1.0 and later when MultiprocessingLib 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Multiprocessing.h*/

OSStatus MPDeleteSemaphore (
   MPSemaphoreID semaphore
);

#ifdef __cplusplus
}
#endif

#endif