#ifndef CGDIRECT_DISPLAY_H
#define CGDIRECT_DISPLAY_H

#include <CoreGraphics/CGBase.h>
#include <CoreGraphics/CGGeometry.h>
#include <CoreGraphics/CGError.h>
#include <CoreGraphics/CGContext.h>
#include <CoreFoundation/CoreFoundation.h>
#include <stdint.h>
#include <AvailabilityMacros.h>
#include <mach/boolean.h>

/*CGOpenGLDisplayMask

Defines a bitmask used in OpenGL to specify a set of attached displays.

typedef uint32_t CGOpenGLDisplayMask;
Discussion

In Mac OS X, OpenGL can provide information about the capabilities of the hardware renderers driving a specified set of displays. A 32-bit mask is used to specify the displays—each bit in the mask represents a single display.

To learn how to find the mask bit that corresponds to a given display, see the function CGDisplayIDToOpenGLDisplayMask.
Availability
Available in Mac OS X v10.0 and later.*/
typedef uint32_t CGOpenGLDisplayMask;

/*CGDirectDisplayID

Represents a unique identifier for an attached display.

typedef struct _CGDirectDisplayID * CGDirectDisplayID;
Discussion

In Quartz, the term display refers to a graphics hardware system consisting of a framebuffer, a color correction (gamma) table or color palette, and possibly an attached monitor. If no monitor is attached, a display is characterized as offline.

When a monitor is attached, Quartz assigns a unique display identifier (ID). A display ID can persist across processes and system reboot, and typically remains constant as long as certain display parameters do not change.

When assigning a display ID, Quartz considers the following parameters:
vendor
model
serial number
position in the I/O Kit registry

For information about how to obtain a display ID, see “Finding Displays”.
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct _CGDirectDisplayID * CGDirectDisplayID;

/*CGMainDisplayID

Returns the display ID of the main display. 

CGDirectDisplayID CGMainDisplayID (void);
Return Value

The display ID assigned to the main display. For more information about this data type, see CGDirectDisplayID.
Discussion

The main display is the display with its screen location at (0,0) in global coordinates. In a system without display mirroring, the display with the menu bar is typically the main display.

If mirroring is enabled, and the menu bar appears on more than one display, this function provides a reliable way to find the main display. 

In case of hardware mirroring, the drawable display becomes the main display. In case of software mirroring, the display with the highest resolution and deepest pixel depth typically becomes the main display.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CGDirectDisplay.h*/
CGDirectDisplayID CGMainDisplayID (void);

#endif